#ifndef TRANSLATION_H
#define TRANSLATION_H
#endif

#ifndef HYS_H
#include <OC_Cocoa/hys.h>
#endif


/*FileType

Defines the translation file type of a document.

typedef OSType FileType;
Availability
Available in Mac OS X v10.0 and later.*/
typedef OSType FileType;

/*FileTypeSpec

Defines a descriptor for the source or destination file type used in a translation method.

struct FileTypeSpec {
   FileType format;
   long hint;
   TranslationAttributes flags;
   OSType catInfoType;
   OSType catInfoCreator;
};
typedef struct FileTypeSpec FileTypeSpec;*/
struct FileTypeSpec {
   FileType format;
   long hint;
   TranslationAttributes flags;
   OSType catInfoType;
   OSType catInfoCreator;
};
typedef struct FileTypeSpec FileTypeSpec;

/*FileTranslationSpec

Defines a file translation method supported by the Translation Manager.

struct FileTranslationSpec {
   OSType          componentSignature;
   const void *    translationSystemInfo;
   FileTypeSpec    src;
   FileTypeSpec    dst;
};
typedef struct FileTranslationSpec      FileTranslationSpec;
typedef FileTranslationSpec *           FileTranslationSpecArrayPtr;
typedef FileTranslationSpecArrayPtr *   FileTranslationSpecArrayHandle;
Availability
Available in Mac OS X v10.0 and later.*/
struct FileTranslationSpec {
   OSType          componentSignature;
   const void *    translationSystemInfo;
   FileTypeSpec    src;
   FileTypeSpec    dst;
};
typedef struct FileTranslationSpec      FileTranslationSpec;
typedef FileTranslationSpec *           FileTranslationSpecArrayPtr;
typedef FileTranslationSpecArrayPtr *   FileTranslationSpecArrayHandle;