#ifndef CARBONEVENTCORE_H
#define CARBONEVENTCORE_H
#endif



/*Event Attributes

Define constants for special attributes of an event.

typedef UInt32 EventAttributes;
enum {
   kEventAttributeNone = 0,
   kEventAttributeUserEvent = (1 << 0),
   kEventAttributeMonitored= 1 << 3
};
Constants
kEventAttributeNone

No attributes.

Available in Mac OS X v10.0 and later.
kEventAttributeUserEvent

An event generated in response to a user action. 

Available in Mac OS X v10.0 and later.
kEventAttributeMonitored

An event that was not originally targeted to this process but has been provided to this process because an event handler for this event type has been installed on the event monitoring target. The event dispatcher sends events with this attribute directly to the event monitor target. (Available in Mac OS X v10.3 and later.)

Available in Mac OS X v10.3 and later.
Discussion

You use these attributes only if you are creating your own events.*/
typedef UInt32 EventAttributes;
enum {
   kEventAttributeNone = 0,
   kEventAttributeUserEvent = (1 << 0),
   kEventAttributeMonitored= 1 << 3
};

/*EventHotKeyRef

Represents a registered global hot key. 

typedef struct OpaqueEventHotKeyRef * EventHotKeyRef;
Discussion

You register a hot key using the RegisterEventHotKey function. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueEventHotKeyRef * EventHotKeyRef;

/*Direct Object Parameter

Define the direct object parameter.

enum {
   kEventParamDirectObject = '----'
};
Constants
kEventParamDirectObject

Type varies depending on event.

Available in Mac OS X v10.0 and later.
Discussion

The direct object parameter is usable for a wide variety of events. It defines the object the event acted upon or within. For example, for window events, the direct object parameter returns a reference (that is a WindowRef) to the window in which the event occurred.*/
enum {
   kEventParamDirectObject = '----'
};

/*EventHotKeyID

Represents the ID of a global hot key. 

struct EventHotKeyID {
   OSType signature;
   UInt32 id;
};
typedef struct EventHotKeyID EventHotKeyID;
Discussion

You register a hot key using the RegisterEventHotKey function. 
Availability
Available in Mac OS X v10.0 and later.*/
struct EventHotKeyID {
   OSType signature;
   UInt32 id;
};
typedef struct EventHotKeyID EventHotKeyID;

/*EventParamName

Represents an event parameter constant.

typedef OSType EventParamName;
Discussion

You specify an event parameter name when calling GetEventParameter or SetEventParameter. Parameter names indicate what kind of event parameter you want to set or obtain (such as kEventParamDirectObject). For specific types, see the tables of event parameters and types associated with each class of events (for example, Table 8). 
Availability
Available in Mac OS X v10.0 and later.*/
typedef OSType EventParamName;

/*EventParamType

Represents an event parameter type constant. 

typedef OSType EventParamType;
Discussion

You specify an event parameter type when calling GetEventParameter or SetEventParameter. Event parameter types indicate the data type of the parameter you want to set or obtain (such as typeBoolean). For specific types, see the tables of event parameters and types associated with each class of events (for example, Table 11). 
Availability
Available in Mac OS X v10.0 and later.*/
typedef OSType EventParamType;

/* EventHandlerRef

Represents an installed event handler. 

typedef struct OpaqueEventHandlerRef * EventHandlerRef;
Discussion

You receive an event handler reference when you install your handler using InstallEventHandler. You can use this reference when calling functions such as RemoveEventHandler and AddEventTypesToHandler. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueEventHandlerRef * EventHandlerRef;

/*EventLoopIdleTimerMessage

Represents an idle timer message.

typedef UInt16 EventLoopIdleTimerMessage;
Discussion

Sent to idle timer callback functions to indicate the current idle status. See Idle Timer Event Constants for a list of possible values. 
Availability
Available in Mac OS X v10.2 and later.*/
typedef UInt16 EventLoopIdleTimerMessage;

/*EventTime

Represents a time value in seconds. An absolute EventTime value is seconds since boot time. 

typedef double EventTime;
Availability
Available in Mac OS X v10.0 and later.*/
typedef double EventTime;

/*EventRef

Represents an opaque data structure that identifies individual events.

typedef struct OpaqueEventRef * EventRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueEventRef * EventRef;

/*EventHandlerCallRef

Indicates the next handler in the event handler calling hierarchy. 

typedef struct OpaqueEventHandlerCallRef * EventHandlerCallRef;
Discussion

This structure is passed to your event handler, which can then choose to pass control to the next handler in the calling hierarchy (such as a standard event handler). Doing so is a convenient way to add pre- or post-processing to the standard event handler. See the CallNextEventHandler function for more information.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueEventHandlerCallRef * EventHandlerCallRef;

/*EventHandlerProcPtr

Defines the format of your event handler. 

typedef OSStatus (*EventHandlerProcPtr) (
   EventHandlerCallRef inHandlerCallRef,
   EventRef inEvent,
   void * inUserData
);

If you name your function MyEventHandlerProc, you would declare it like this:

OSStatus MyEventHandlerProc (
   EventHandlerCallRef inHandlerCallRef,
   EventRef inEvent,
   void * inUserData
);
Parameters
inHandlerCallRef

A reference to the current handler call chain. This is passed to your handler so that you can call CallNextEventHandler if you need to. 
inEvent

The event that triggered this call. 
inUserData

The application-specific data you passed in to InstallEventHandler.
Return Value

A result code. See Carbon Event Manager Result Codes. Returning noErr indicates you handled the event. Returning eventNotHandledErr indicates you did not handle the event and perhaps other handlers in the calling chain should take action.
Discussion

Callback to install on an event target.*/
typedef OSStatus (*EventHandlerProcPtr) (
   EventHandlerCallRef inHandlerCallRef,
   EventRef inEvent,
   void * inUserData
);


/*EventLoopRef

Represents an event loop. 

typedef struct OpaqueEventLoopRef * EventLoopRef;
Discussion

The EventLoopRef type represents an event loop, which is the conceptual entity that you run to fetch events from hardware and other sources and also fires timers that might be installed with InstallEventLoopTimer or InstallEventLoopIdleTimer. The term run is a bit of a misnomer, as the event loops goal is to stay as blocked as possible to minimize CPU usage for the current application. The event loop is run implicitly through calls to functions like ReceiveNextEvent, RunApplicationEventLoop, or even the Classic Event Manager function WaitNextEvent. It can also be run explicitly through a call to RunCurrentEventLoop. Each preemptive thread can have an event loop. Cooperative threads share the main threads event loop. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueEventLoopRef * EventLoopRef;

/*EventTimerInterval

Specifies the period of an event timer, in seconds. 

typedef EventTime EventTimerInterval;
Availability
Available in Mac OS X v10.0 and later.*/
typedef EventTime EventTimerInterval;

/*EventLoopTimerRef

Represents an installed event timer. 

typedef struct __EventLoopTimer * EventLoopTimerRef;
Discussion

The EventLoopTimerRef type represents a timer function that is called either once or at regular intervals. See InstallEventLoopTimer and InstallEventLoopIdleTimer for more information about event timers. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct __EventLoopTimer * EventLoopTimerRef;

/*EventLoopIdleTimerProcPtr

Defines the format of your idle timer callback function.

typedef void (*EventLoopIdleTimerProcPtr) (
   EventLoopTimerRef inTimer,
   EventLoopIdleTimerMessage inState,
   void * inUserData
);

If you name your function MyEventLoopTimerProc, you would declare it like this:

void MyEventLoopTimerProc (
   EventLoopTimerRef inTimer,
   EventLoopIdleTimerMessage inState,
   void * inUserData
);
Parameters
inTimer

The timer that fired. 
inState

The state of the idle period. See Idle Timer Event Constants for a list of possible constants you can receive. 
inUserData

The application-specific data you passed into InstallEventLoopIdleTimer.
Discussion

Called when an idle timer fires.*/
typedef void (*EventLoopIdleTimerProcPtr) (
   EventLoopTimerRef inTimer,
   EventLoopIdleTimerMessage inState,
   void * inUserData
);


/*EventLoopIdleTimerUPP

Represents a universal procedure pointer for an idle event timer callback function. 

typedef EventLoopIdleTimerProcPtr EventLoopIdleTimerUPP;*/
typedef EventLoopIdleTimerProcPtr EventLoopIdleTimerUPP;

/*EventTypeSpec

Describes the class and kind of an event.

struct EventTypeSpec {
   UInt32 eventClass;
   UInt32 eventKind;
};
typedef struct EventTypeSpec EventTypeSpec;
Discussion

This structure is used to specify an event. Typically, you pass a static array of EventTypeSpec structures into functions such as InstallEventHandler, as well as functions such as FlushEventsMatchingListFromQueue. 
Availability
Available in Mac OS X v10.0 and later.*/
struct EventTypeSpec {
   UInt32 eventClass;
   UInt32 eventKind;
};
typedef struct EventTypeSpec EventTypeSpec;

/*EventLoopTimerProcPtr

Defines the format of your event loop timer callback function. 

typedef void (*EventLoopTimerProcPtr) (
   EventLoopTimerRef inTimer,
   void * inUserData
);

If you name your function MyEventLoopTimerProc, you would declare it like this:

void MyEventLoopTimerProc (
   EventLoopTimerRef inTimer,
   void * inUserData
);
Parameters
inTimer

The timer that fired. 
inUserData

The data you passed into InstallEventLoopTimer.
Discussion

Called when a timer fires.*/
typedef void (*EventLoopTimerProcPtr) (
   EventLoopTimerRef inTimer,
   void * inUserData
);


/*EventLoopTimerUPP

Represents a universal procedure pointer for an event timer callback function.

typedef EventLoopTimerProcPtr EventLoopTimerUPP;*/
typedef EventLoopTimerProcPtr EventLoopTimerUPP;

/*EventHandlerUPP

Represents a universal procedure pointer for an event handler callback function.

typedef EventHandlerProcPtr EventHandlerUPP;*/
typedef EventHandlerProcPtr EventHandlerUPP;

/*GetMainEventLoop

Obtains a reference to the main event loop.

EventLoopRef GetMainEventLoop ();
Return Value

An event loop reference. 
Discussion

The main loop is the event loop for the main application thread. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventLoopRef GetMainEventLoop ();


/*InstallEventLoopIdleTimer

Installs a timer that fires only when there is no user activity.

OSStatus InstallEventLoopIdleTimer (
   EventLoopRef inEventLoop,
   EventTimerInterval inFireDelay,
   EventTimerInterval inInterval,
   EventLoopIdleTimerUPP inTimerProc,
   void * inTimerData,
   EventLoopTimerRef * outTimer
);
Parameters
inEventLoop

The event loop to add the timer. 
inFireDelay

The delay before first firing this timer, in seconds. In Mac OS X v10.3 and earlier, this delay must be greater than zero. In Mac OS X v10.4 and later, the delay must be greater than or equal to zero. You cannot pass kEventDurationForever.
inInterval

The timer interval, in seconds. Pass 0 or kEventDurationForever for a one-shot timer. 
inTimerProc

The function to call when the timer fires. 
inTimerData

Data to pass to the timer function when called.
outTimer

A reference to the newly installed timer. 
Return Value

A result code. See Carbon Event Manager Result Codes.
Discussion

An idle timer is the same as a standard event timer except that it fires only when no user events are being received. That is, if the system receives no user events for the inFireDelay delay time, the idle timer fires, and will continue to fire at the rate specified by inInterval. If the user begins activity again, the timer stops and resets. For example, you could use an idle timer in a search engine to begin a search 2 seconds after the user stops typing in the search text field. 

The callback function for idle timers takes an additional parameter that tells the callback the user status. See EventLoopIdleTimerProcPtr and Idle Timer Event Constants for more information. 

Be sure to dispose of the timer when you no longer need it by calling RemoveEventLoopTimer. Doing so is especially important if your timer calls code that may no longer exist. For example, if a plugin creates a timer that calls back to it, the timer will attempt to call it even after the plugin is removed. 
Availability
Available in Mac OS X v10.2 and later.
Declared In
CarbonEventsCore.h*/
OSStatus InstallEventLoopIdleTimer (
   EventLoopRef inEventLoop,
   EventTimerInterval inFireDelay,
   EventTimerInterval inInterval,
   EventLoopIdleTimerUPP inTimerProc,
   void * inTimerData,
   EventLoopTimerRef * outTimer
);



/*InstallEventLoopTimer

Installs a timer.

OSStatus InstallEventLoopTimer (
   EventLoopRef inEventLoop,
   EventTimerInterval inFireDelay,
   EventTimerInterval inInterval,
   EventLoopTimerUPP inTimerProc,
   void * inTimerData,
   EventLoopTimerRef * outTimer
);
Parameters
inEventLoop

The event loop to add the timer. 
inFireDelay

The delay before first firing this timer, in seconds. In Mac OS X v10.3 and earlier, the delay must be greater than zero. In Mac OS X v10.4, the delay can be greater than or equal to zero. 

In Mac OS X and CarbonLib 1.5 and later, you may pass kEventDurationForever to stop the timer from firing at all until SetEventLoopTimerNextFireTime is used to start it; in earlier versions of CarbonLib, to achieve the same effect, just pass zero and then immediately call SetEventLoopTimerNextFireTime( timer, (kEventDurationForever ) before returning control to your event loop.
inInterval

The timer interval, in seconds. Pass 0 or (in Mac OS X and CarbonLib 1.5 and later) kEventDurationForever for a one-shot timer. 
inTimerProc

The function to call when the timer fires. 
inTimerData

Data to pass to the timer function when called.
outTimer

A reference to the newly installed timer. 
Return Value

A result code. See Carbon Event Manager Result Codes.
Discussion

Installs a timer onto the event loop specified. The timer can either fire once or repeatedly at a specified interval depending on the parameters passed to this function. It executes at task level and should not be confused with Time Manager tasks or any other interrupt-level callback. This means you can call toolbox functions, allocate memory, and draw without worrying about consequences. When a timer fires, it calls the callback you specified when the timer was installed.

Timers in general have two uses: as a timeout mechanism and as a periodic task. An everyday example of using a timer for a timeout might be a light that goes out if no motion is detected in a room for 5 minutes. For this, you might install a timer which will fire in 5 minutes. If motion is detected, you would reset the timer fire time and let the clock start over. If no motion is detected for the full 5 minutes, the timer will fire and you could power off the light. A periodic timer is one that fires at regular intervals (say every second or so). You might use such a timer to blink the insertion point in your editor, and so on.

One advantage of timers is that you can install the timer right from the code that wants the time. For example, the standard editable text control can install a timer to blink the cursor when its active, meaning that the Control Manager function IdleControls is a no-op for that control and doesnt need to be called. When the control is inactive, it removes its timer and doesnt waste CPU time in that state.

Currently, if you do decide to draw when your timer is called, be sure to save and restore the current port so that calling your timer doesnt inadvertently change the port out from under someone. 

Be sure to dispose of the timer when you no longer need it by calling RemoveEventLoopTimer. Doing so is especially important if your timer calls code that may no longer exist. For example, if a plugin creates a timer that calls back to it, the timer will attempt to call it even after the plugin is removed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/

OSStatus InstallEventLoopTimer (
   EventLoopRef inEventLoop,
   EventTimerInterval inFireDelay,
   EventTimerInterval inInterval,
   EventLoopTimerUPP inTimerProc,
   void * inTimerData,
   EventLoopTimerRef * outTimer
);




/*NewEventLoopTimerUPP

Creates an event loop timer UPP. 

EventLoopTimerUPP NewEventLoopTimerUPP (
   EventLoopTimerProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your event timer callback function. 
Return Value

The UPP for your event timer callback function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventLoopTimerUPP NewEventLoopTimerUPP (
   EventLoopTimerProcPtr userRoutine
);

/*NewEventHandlerUPP

Creates an event handler UPP.

EventHandlerUPP NewEventHandlerUPP (
   EventHandlerProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your event handler. 
Return Value

The UPP for your event handler.
Discussion

When registering your event handler with InstallEventHandler, you must pass a universal procedure pointer (UPP) to your event handler instead of a standard procedure pointer. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventHandlerUPP NewEventHandlerUPP (
   EventHandlerProcPtr userRoutine
);

/*RunApplicationEventLoop

Runs the application event loop.

void RunApplicationEventLoop ();
Discussion

This function is used as the main event loop for a Carbon Event-based application. Once entered, this function waits for events to arrive and dispatches them to your event handlers automatically. 

Note that calling RunApplicationEventLoop also installs the standard application handler, which provides standard handler responses for menu and application events. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
void RunApplicationEventLoop ();

/*similar macro, InstallApplicationEventHandler, needs no parameter to identify the application itself as the target; the call
InstallApplicationEventHandler (handlerUPP,
                                numTypes, typeList,
                                userData, &handlerRef);*/
/*The function for installing an event handler is called InstallEventHandler:
OSStatus InstallEventHandler (EventTargetRef        target,
                              EventHandlerUPP       handlerProc,
                              UInt32                numTypes,
                              const EventTypeSpec*  typeList,
                              void*                 userData,
                              EventHandlerRef*      handlerRef);*/
OSStatus InstallApplicationEventHandler (EventHandlerUPP       handlerUPP,
                              UInt32                numTypes,
                              const EventTypeSpec*  typeList,
                              void*                 userData,
                              EventHandlerRef*      handlerRef);//hys

/*For convenience, The Carbon Event Manager also defines a set of specialized macros, InstallWindowEventHandler, InstallMenuEventHandler, and InstallControlEventHandler, which accept the targeted object as a parameter, obtain the corresponding target reference for you, and pass it to InstallEventHandler. The remaining parameters to these macros are the same as for the InstallEventHandler routine itself. For example, the macro callWindowRef theWindow;
 
InstallWindowEventHandler (theWindow, handlerUPP,
                           numTypes, typeList,
                           userData, &handlerRef);*/
OSStatus InstallWindowEventHandler (void* theWindow,
                              EventHandlerUPP       handlerUPP,
                              UInt32                numTypes,
                              const EventTypeSpec*  typeList,
                              void*                 userData,
                              EventHandlerRef*      handlerRef);//hys

/*Custom Drawing in User Panes

If you have only simple drawing needs, you can attach a kEventControlDraw handler to a user pane control. Conveniently, Interface Builder converts dialog user items to user panes when importing from resources. 

Listing 2-9 shows how you would install a simple, one-event drawing handler onto a user pane.

Listing 2-9  Installing a draw ing handler onto a user paneWindowRef window;
 
HIViewRef       userPane;
// 1
static const HIViewID userPaneID = { 'Moof', 127 };// 1
 
// 2
static const EventTypeSpec myEventTypes =// 2
                        { kEventClassControl, kEventControlDraw };
 
// 3
HIViewFindByID (HIViewGetRoot(window), userPaneID, &userPane);// 3
// 4
InstallControlEventHandler (userPane, myUserDraw, 1, &myEventTypes,// 4
                            userPane, NULL);*/
OSStatus InstallControlEventHandler (void* userPane,
                              EventHandlerUPP       handlerUPP,
                              UInt32                numTypes,
                              const EventTypeSpec*  typeList,
                              void*                 userData,
                              EventHandlerRef*      handlerRef); //hys

/*GetEventClass

Returns the class of an event (for example, window, mouse, or keyboard).

UInt32 GetEventClass (
   EventRef inEvent
);
Parameters
inEvent

The event in question. 
Return Value

The class ID of the event. See Event Class Constants for more details. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
UInt32 GetEventClass (
   EventRef inEvent
);

/* GetEventKind

Returns the event kind for the specified event.

UInt32 GetEventKind (
   EventRef inEvent
);
Parameters
inEvent

The event in question. 
Return Value

The kind of the event. 
Discussion

Event kind values overlap in different event classes. For example, kEventMouseDown and kEventAppActivated both have the same value (1). The combination of class and kind determines a unique event signature.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
UInt32 GetEventKind (
   EventRef inEvent
);

/*GetEventParameter

Obtains a parameter from the specified event. 

OSStatus GetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inDesiredType,
   EventParamType * outActualType,
   UInt32 inBufferSize,
   UInt32 * outActualSize,
   void * outData
);
Parameters
inEvent

The event to get the parameter from. 
inName

The symbolic name of the parameter (for example, kEventParamDirectObject). The Carbon Event Manager defines a number of constants defining possible parameters. 
inDesiredType

The desired type of the parameter (for example, typeWindowRef). The Carbon Event Manager automatically uses AppleEvent coercion handlers to convert the data in the event into the desired type, if possible. The Carbon Event Manager defines a number of constants to indicate possible parameter types. Pass typeWildCard to request that the data be returned in its original format. 
outActualType

The actual type of the parameter (can be NULL if you are not interested in receiving this information).
inBufferSize

The size of the output buffer. 
outActualSize

The actual size of the data, or NULL if you dont want this information.
outData

The pointer to the buffer receiving the parameter data.
Return Value

A result code. See Carbon Event Manager Result Codes. 
Discussion

Events often contain additional useful pieces of data, such as the location of a mouse-down event or the window in which an event occurred. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus GetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inDesiredType,
   EventParamType * outActualType,
   UInt32 inBufferSize,
   UInt32 * outActualSize,
   void * outData
);

/*CreateEvent

Creates an event.

OSStatus CreateEvent (
   CFAllocatorRef inAllocator,
   UInt32 inClassID,
   UInt32 kind,
   EventTime when,
   EventAttributes flags,
   EventRef * outEvent
);
Parameters
inAllocator

A reference to the desired memory allocator to use to allocate memory for the event. Pass NULL to use the default allocator. See the Base Services documentation for a description of the CFAllocatorRef data type.
inClassID

The event class of the event to create.
kind

The event kind of the event to create. 
when

The time the event occurred. Pass 0 to specify the current event time (as returned by the GetCurrentEventTime function). 
flags

The event attributes to set. Currently you can pass kEventAttributeNone or kEventAttributeUserEvent. 
outEvent

On return, a reference to the newly created event. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

You can use this function to create your own custom events or to simulate existing events. If you are creating custom events, you must make sure that the event signature (the combination of event class and event kind) does not conflict with any existing events. 
Declared In
CarbonEventsCore.h*/
OSStatus CreateEvent (
   CFAllocatorRef inAllocator,
   UInt32 inClassID,
   UInt32 kind,
   EventTime when,
   EventAttributes flags,
   EventRef * outEvent
);

/*GetCurrentEventTime

Returns the current time since last system startup, in seconds. 

EventTime GetCurrentEventTime ();
Return Value

EventTime. 
Discussion

Returns the current time since last system startup in seconds. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventTime GetCurrentEventTime ();

/*SetEventParameter

Sets a parameter associated with a particular event. 

OSStatus SetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inType,
   UInt32 inSize,
   const void * inDataPtr
);
Parameters
inEvent

The event to set the data for. 
inName

The symbolic name of the parameter. 
inType

The symbolic type of the parameter. 
inSize

The size of the parameter data. 
inDataPtr

A pointer to the parameter data.
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

When creating events, you may want to specify additional event-related information, such as the mouse location or the window in which the event occurred. To set these you call SetEventParameter, specifying the type and value for the desired parameter. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus SetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inType,
   UInt32 inSize,
   const void * inDataPtr
);

/*ReleaseEvent

Releases, and possibly disposes of, the specified event.

void ReleaseEvent (
   EventRef inEvent
);
Parameters
inEvent

The event to release.
Discussion

This function decrements the reference count of an event. If the reference count reaches 0, the event is disposed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
void ReleaseEvent (
   EventRef inEvent
);

/*SetWindowTitleWithCFString

Sets the window title to the contents of a Core Foundation string. 

OSStatus SetWindowTitleWithCFString (
   WindowRef inWindow,
   CFStringRef inString
);
Parameters
inWindow

The window whose title is to be set.
inString

The title to set. 
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowTitleWithCFString (
   WindowRef inWindow,
   CFStringRef inString
);
