#ifndef COREAUDIO_H
 #include <CoreAudio/CoreAudio.h>
#endif 

#ifndef COREFOUNDATION_H
 #include <CoreFoundation/CoreFoundation.h>
#endif 

typedef unsigned Component;
typedef UInt32 AudioUnitRenderActionFlags; //hys

#define kAudioUnitParameterFlag_Output 1 //hys



/*Constants
Component Types and Subtypes

The following audio units are provided by Apple. The four-character codes identify each of these units with the Component Manager, allowing for you to find and use them.
kAudioUnitType_Output = FOUR_CHAR_CODE('auou')

The component type for all output units.
kAudioUnitSubType_HALOutput = FOUR_CHAR_CODE('ahal')

The component subtype for an output unit that uses a HAL output.
kAudioUnitSubType_DefaultOutput = FOUR_CHAR_CODE('def ')

The component subtype for an output unit that uses the default output, as selected by the user.
kAudioUnitSubType_SystemOutput = FOUR_CHAR_CODE('sys ')

The component subtype for an output unit that uses the system output.
kAudioUnitSubType_GenericOutput = FOUR_CHAR_CODE('genr')

The component subtype for a generic output unit.
kAudioUnitType_MusicDevice = FOUR_CHAR_CODE('aumu')

The component type for a music device unit.
kAudioUnitSubType_DLSSynth = FOUR_CHAR_CODE('dls ')

The component subtype for the DLS synth music device unit
kAudioUnitType_MusicEffect = FOUR_CHAR_CODE('aumf')

The component type for a music effect unit.
kAudioUnitType_FormatConverter = FOUR_CHAR_CODE('aufc')

The component type for a format converter unit.
kAudioUnitSubType_AUConverter = FOUR_CHAR_CODE('conv')

The component subtype for an AUConverter format converter unit.
kAudioUnitSubType_Varispeed = FOUR_CHAR_CODE('vari')

The component subtype for a Varispeed effect unit.
kAudioUnitSubType_Delay = FOUR_CHAR_CODE('dely')

The component subtype for a delay effect unit.
kAudioUnitSubType_LowPassFilter = FOUR_CHAR_CODE('lpas')

The component subtype for a low-pass filter effect unit.
kAudioUnitSubType_HighPassFilter = FOUR_CHAR_CODE('hpas')

The component subtype for a high-pass filter effect unit.
kAudioUnitSubType_BandPassFilter = FOUR_CHAR_CODE('bpas')

The component subtype for a band-pass filter effect unit.
kAudioUnitSubType_HighShelfFilter = FOUR_CHAR_CODE('hshf')

The component subtype for a high-shelf filter effect unit.
kAudioUnitSubType_LowShelfFilter = FOUR_CHAR_CODE('lshf')

The component subtype for a low-shelf filter effect unit.
kAudioUnitSubType_ParametricEQ = FOUR_CHAR_CODE('pmeq')

The component subtype for a parametric equalizer effect unit.
kAudioUnitSubType_GraphicEQ = FOUR_CHAR_CODE('greq')

The component subtype for a graphic equalizer effect unit.
kAudioUnitSubType_PeakLimiter = FOUR_CHAR_CODE('lmtr')

The component subtype for a peak limiter effect unit.
kAudioUnitSubType_DynamicsProcessor = FOUR_CHAR_CODE('dcmp')

The component subtype for a dynamics processor effect unit.
kAudioUnitSubType_MultiBandCompressor = FOUR_CHAR_CODE('mcmp')

The component subtype for multi-band compressor effect unit.
kAudioUnitSubType_MatrixReverb = FOUR_CHAR_CODE('mrev')

The component subtype for a matrix reverb effect unit.
kAudioUnitType_Mixer = FOUR_CHAR_CODE('aumx')

The component type for a mixer unit.
kAudioUnitSubType_StereoMixer = FOUR_CHAR_CODE('smxr')

The component subtype for a stereo mixer unit.
kAudioUnitSubType_3DMixer = FOUR_CHAR_CODE('3dmx')

The component subtype for a three-dimensional mixer unit.
kAudioUnitSubType_MatrixMixer = FOUR_CHAR_CODE('mxmx')

The component subtype for a matrix mixer unit.
kAudioUnitType_Panner = FOUR_CHAR_CODE('aupn')

The component type for a panner unit.
kAudioUnitType_OfflineEffect = FOUR_CHAR_CODE('auol')

The component type fpr an offline effect unit.
kAudioUnitManufacturer_Apple = FOUR_CHAR_CODE('appl')

The component manufacturer type for all units provided by Apple.
Render Action Flags

These flags provide you with information on the status of a render within an audio unit.
kAudioUnitRenderAction_PreRender = (1 << 2)

The audio unit is prepared to render.
kAudioUnitRenderAction_PostRender = (1 << 3)

The audio unit is finished with the current render.
kAudioUnitRenderAction_OutputIsSilence = (1 << 4)

The current output of the render is silence.
kAudioOfflineUnitRenderAction_Preflight = (1 << 5)

The audio unit has not yet rendered.
AudioOfflineUnitRenderAction_Render = (1 << 6)

The audio unit is prepared to render.
kAudioOfflineUnitRenderAction_Complete = (1 << 7)

The audio unit has been used to render.*/
#define kAudioUnitType_Output 'auou'
#define kAudioUnitSubType_HALOutput 'ahal'
#define kAudioUnitSubType_DefaultOutput 'def '
#define kAudioUnitSubType_SystemOutput 'sys '
#define kAudioUnitSubType_GenericOutput 'genr'
#define kAudioUnitType_MusicDevice 'aumu'
#define kAudioUnitSubType_DLSSynth 'dls '
#define kAudioUnitType_MusicEffect 'aumf'
#define kAudioUnitType_FormatConverter 'aufc'
#define kAudioUnitSubType_AUConverter 'conv'
#define kAudioUnitSubType_Varispeed 'vari'
#define kAudioUnitSubType_Delay 'dely'
#define kAudioUnitSubType_LowPassFilter 'lpas'
#define kAudioUnitSubType_HighPassFilter 'hpas'
#define kAudioUnitSubType_BandPassFilter 'bpas'
#define kAudioUnitSubType_HighShelfFilter 'hshf'
#define kAudioUnitSubType_LowShelfFilter 'lshf'
#define kAudioUnitSubType_ParametricEQ 'pmeq'
#define kAudioUnitSubType_GraphicEQ 'greq'
#define kAudioUnitSubType_PeakLimiter 'lmtr'
#define kAudioUnitSubType_DynamicsProcessor 'dcmp'
#define kAudioUnitSubType_MultiBandCompressor 'mcmp'
#define kAudioUnitSubType_MatrixReverb 'mrev'
#define kAudioUnitType_Mixer 'aumx'
#define kAudioUnitSubType_StereoMixer 'smxr'
#define kAudioUnitSubType_3DMixer '3dmx'
#define kAudioUnitSubType_MatrixMixer 'mxmx'
#define kAudioUnitType_Panner 'aupn'
#define kAudioUnitType_OfflineEffect 'auol'
#define kAudioUnitManufacturer_Apple 'appl'

/*Audio Unit Properties

These properties can be queried of any audio unit instance.kAudioUnitProperty_ClassInfo                    = 0
kAudioUnitProperty_MakeConnection               = 1
kAudioUnitProperty_SampleRate                   = 2
kAudioUnitProperty_ParameterList                = 3
kAudioUnitProperty_ParameterInfo                = 4
kAudioUnitProperty_FastDispatch                 = 5
kAudioUnitProperty_CPULoad                      = 6
kAudioUnitProperty_StreamFormat                 = 8
kAudioUnitProperty_SRCAlgorithm                 = 9
kAudioUnitProperty_ReverbRoomType               = 10
kAudioUnitProperty_BusCount                     = 11
kAudioUnitProperty_ElementCount                 = kAudioUnitProperty_BusCount,
kAudioUnitProperty_Latency                      = 12
kAudioUnitProperty_SupportedNumChannels         = 13
kAudioUnitProperty_MaximumFramesPerSlice        = 14
kAudioUnitProperty_SetExternalBuffer            = 15
kAudioUnitProperty_ParameterValueStrings        = 16
kAudioUnitProperty_MIDIControlMapping           = 17
kAudioUnitProperty_GetUIComponentList           = 18
kAudioUnitProperty_AudioChannelLayout           = 19 
kAudioUnitProperty_TailTime                     = 20
kAudioUnitProperty_BypassEffect                 = 21
kAudioUnitProperty_LastRenderError              = 22
kAudioUnitProperty_SetRenderCallback            = 23
kAudioUnitProperty_FactoryPresets               = 24
kAudioUnitProperty_ContextName                  = 25
kAudioUnitProperty_RenderQuality                = 26
kAudioUnitProperty_HostCallbacks                = 27
kAudioUnitProperty_CurrentPreset                = 28
kAudioUnitProperty_InPlaceProcessing            = 29
kAudioUnitProperty_ElementName                  = 30
kAudioUnitProperty_CocoaUI                      = 31
kAudioUnitProperty_SupportedChannelLayoutTags   = 32
kAudioUnitProperty_ParameterValueName           = 33
kAudioUnitProperty_ParameterIDName              = 34
kAudioUnitProperty_ParameterClumpName           = 35
kAudioUnitProperty_PresentPreset                = 36
ProperkAudioUnitProperty_UsesInternalReverb     = 1005  */

#define kAudioUnitProperty_MakeConnection 1
#define kAudioUnitProperty_SampleRate                   2
#define kAudioUnitProperty_ParameterList                 3
#define kAudioUnitProperty_ParameterInfo                 4
#define kAudioUnitProperty_FastDispatch                  5
#define kAudioUnitProperty_CPULoad                       6
#define kAudioUnitProperty_StreamFormat                  8
#define kAudioUnitProperty_SRCAlgorithm                  9
#define kAudioUnitProperty_ReverbRoomType              10
#define kAudioUnitProperty_BusCount                     11
#define kAudioUnitProperty_ElementCount kAudioUnitProperty_BusCount,
#define kAudioUnitProperty_Latency                       12
#define kAudioUnitProperty_SupportedNumChannels          13
#define kAudioUnitProperty_MaximumFramesPerSlice         14
#define kAudioUnitProperty_SetExternalBuffer             15
#define kAudioUnitProperty_ParameterValueStrings         16
#define kAudioUnitProperty_MIDIControlMapping            17
#define kAudioUnitProperty_GetUIComponentList            18
#define kAudioUnitProperty_AudioChannelLayout            19 
#define kAudioUnitProperty_TailTime                      20
#define kAudioUnitProperty_BypassEffect                  21
#define kAudioUnitProperty_LastRenderError               22
#define kAudioUnitProperty_SetRenderCallback             23
#define kAudioUnitProperty_FactoryPresets                24
#define kAudioUnitProperty_ContextName                   25
#define kAudioUnitProperty_RenderQuality                 26
#define kAudioUnitProperty_HostCallbacks                 27
#define kAudioUnitProperty_CurrentPreset                 28
#define kAudioUnitProperty_InPlaceProcessing             29
#define kAudioUnitProperty_ElementName                   30
#define kAudioUnitProperty_CocoaUI                       31
#define kAudioUnitProperty_SupportedChannelLayoutTags    32
#define kAudioUnitProperty_ParameterValueName            33
#define kAudioUnitProperty_ParameterIDName               34
#define kAudioUnitProperty_ParameterClumpName            35
#define kAudioUnitProperty_PresentPreset                 36
#define ProperkAudioUnitProperty_UsesInternalReverb      1005

/*Scope Properties

These properties can be queried of any audio unit instance.kAudioUnitScope_Global  = 0
kAudioUnitScope_Input   = 1
kAudioUnitScope_Output  = 2
kAudioUnitScope_Group   = 3
kAudioUnitScope_Part    = 4*/
#define kAudioUnitScope_Input    1
#define kAudioUnitScope_Output   2
#define kAudioUnitScope_Group    3
#define kAudioUnitScope_Part     4

/*Output Unit Parameters

These parameters are used with Output Units.
kHALOutputParam_Volume = 14*/
#define kHALOutputParam_Volume  14

/*Scope Properties

These properties can be queried of any audio unit instance.kAudioUnitScope_Global  = 0
kAudioUnitScope_Input   = 1
kAudioUnitScope_Output  = 2
kAudioUnitScope_Group   = 3
kAudioUnitScope_Part    = 4*/
#define kAudioUnitScope_Input    1
#define kAudioUnitScope_Output   2
#define kAudioUnitScope_Group    3
#define kAudioUnitScope_Part     4

/*Output Unit Properties

These properties can be queried of any output audio unit instance.
kAudioOutputUnitProperty_CurrentDevice          = 2000
kAudioOutputUnitProperty_IsRunning              = 2001
kAudioOutputUnitProperty_ChannelMap             = 2002
kAudioOutputUnitProperty_EnableIO               = 2003
kAudioOutputUnitProperty_StartTime              = 2004
kAudioOutputUnitProperty_SetInputCallback       = 2005
kAudioOutputUnitProperty_HasIO                  = 2006*/
#define kAudioOutputUnitProperty_CurrentDevice          2000
#define kAudioOutputUnitProperty_IsRunning              2001
#define kAudioOutputUnitProperty_ChannelMap             2002
#define kAudioOutputUnitProperty_EnableIO               2003
#define kAudioOutputUnitProperty_StartTime              2004
#define kAudioOutputUnitProperty_SetInputCallback       2005
#define kAudioOutputUnitProperty_HasIO                  2006

/*Scope Properties

These properties can be queried of any audio unit instance.
kAudioUnitScope_Global  = 0
kAudioUnitScope_Input   = 1
kAudioUnitScope_Output  = 2
kAudioUnitScope_Group   = 3
kAudioUnitScope_Part    = 4*/
#define kAudioUnitScope_Global   0
#define kAudioUnitScope_Input    1
#define kAudioUnitScope_Output   2
#define kAudioUnitScope_Group    3
#define kAudioUnitScope_Part     4

/*AURenderCallback


A callback set by kAudioUnitProperty_SetRenderCallback for performing an audio units render.

typedef CALLBACK_API_C( OSStatus , AURenderCallback )(void *inRefCon,  AudioUnitRenderActionFlags *ioActionFlags, const AudioTimeStamp  *inTimeStamp, UInt32 inBusNumber, UInt32 inNumberFrames, AudioBufferList  *ioData)

OSStatus AURenderCallback(
void *      inRefCon;
AudioUnitRenderActionFlags      * ioActionFlags;
const AudioTimeStamp    *   inTimeStamp;
UInt32       inBusNumber;
UInt32       inNumberFrames;
AudioBufferList*       ioData
)
Parameters
inRefCon

Parameters passed to the callback.
ioActionFlags

Flags for rendering options.
inTimeStamp

The time that the callback is invoked.
inBusNumber

The bun on which data will be supplied.
inNumberFrames

The number of frames to be rendered.
ioData

The audio data to be rendered upon.*/
/*typedef CALLBACK_API_C( OSStatus , AURenderCallback )(void *inRefCon,  AudioUnitRenderActionFlags *ioActionFlags, const AudioTimeStamp  *inTimeStamp, UInt32 inBusNumber, UInt32 inNumberFrames, AudioBufferList  *ioData)

OSStatus AURenderCallback(
void *      inRefCon;
AudioUnitRenderActionFlags      * ioActionFlags;
const AudioTimeStamp    *   inTimeStamp;
UInt32       inBusNumber;
UInt32       inNumberFrames;
AudioBufferList*       ioData
)*/
struct AURenderCallback{
         void *                       inRefCon;
         AudioUnitRenderActionFlags   * ioActionFlags;
         const AudioTimeStamp    *   inTimeStamp;
         UInt32       inBusNumber;
         UInt32       inNumberFrames;
         AudioBufferList*       ioData;
};
typedef struct  AURenderCallback  AURenderCallback;

/* AURenderCallbackStruct

Encapsulates render callback information.

struct AURenderCallbackStruct {
   AURenderCallback    inputProc;
void *              inputProcRefCon; }
Fields
inputProc

The callback function.
inoutProcRefCon

Any arguments that should be passed to the callback.*/
struct AURenderCallbackStruct {
   //AURenderCallback    inputProc
   char    inputProc; //hys
   void *   inputProcRefCon; 
};
typedef struct AURenderCallbackStruct AURenderCallbackStruct;


////////////
/*Types

These basic types are common within the context of audio units.
typedef UInt32 AudioUnit
typedef UInt32 AudioUnitPropertyID
typedef UInt32 AudioUnitParameterID
typedef UInt32 AudioUnitScope
typedef UInt32 AudioUnitElement
typedef UInt32 AUParameterEventType
typedef UInt32 AudioUnitParameterUnit */
typedef UInt32 AudioUnit;
typedef UInt32 AudioUnitPropertyID;
typedef UInt32 AudioUnitParameterID;
typedef UInt32 AudioUnitScope;
typedef UInt32 AudioUnitElement;
typedef UInt32 AUParameterEventType;
typedef UInt32 AudioUnitParameterUnit;

//Data Structures
//struct ComponentDescription {
   //OSType         componentType;          /*type*/
   //OSType         componentSubType;       /*subtype*/
   //OSType         componentManufacturer;  /*manufacturer*/
   //unsigned long  componentFlags;         /*control flags*/
   //unsigned long  componentFlagsMask;     /*mask for control flags */
                                          /* (reserved when registering */
                                          /* a component)*/
//};
//typedef struct ComponentDescription ComponentDescription;

struct ComponentDescription {
   OSType         componentType;          /*type*/
   OSType         componentSubType;       /*subtype*/
   OSType         componentManufacturer;  /*manufacturer*/
   unsigned long  componentFlags;         /*control flags*/
   unsigned long  componentFlagsMask;     /*mask for control flags */
                                          /* (reserved when registering */
                                          /* a component)*/
};
typedef struct ComponentDescription ComponentDescription;
