#ifndef APPLICATIONSERVICES_H
 #define APPLICATIONSERVICES_H
#endif 

#ifndef CGGEOMETRY_H
 #include <CoreGraphics/CGGeometry.h>
#endif

//#ifndef COREFOUNDATION_H
//#include <CoreFoundation/CoreFoundation.h>
//#endif

/* FamRec


Contains format information for a font family resource.

struct FamRec {
   SInt16 ffFlags; 
   SInt16 ffFamID; 
   SInt16 ffFirstChar; 
   SInt16 ffLastChar; 
   SInt16 ffAscent; 
   SInt16 ffDescent; 
   SInt16 ffLeading; 
   SInt16 ffWidMax; 
   SInt32 ffWTabOff; 
   SInt32 ffKernOff; 
   SInt32 ffStylOff; 
   SInt16 ffProperty[9]; 
   SInt16 ffIntl[2]; 
   SInt16 ffVersion;
};
Fields
ffFlags

Flags for family.
ffFamID

Family ID number.
ffFirstChar

ASCII code of first character.
ffLastChar

ASCII code of last character.
ffAscent

Maximum ascent for 1-point font.
ffDescent

Maximum descent for 1-point font.
ffLeading

Maximum leading for 1-point font.
ffWidMax

Maximum glyph width for 1-point font.
ffWTabOff

Offset to family glyph-width table.
ffKernOff

Offset to kerning table.
ffStylOff

Offset to style-mapping table.
ffProperty

Style properties info.
ffIntl

For international use.
ffVersion

Version number.
Discussion

The font family structure, of data type FamRec, describes the format of the font family ('FOND') resource. It is shown here as a guide to the format of the resource. The font family structure is not used directly by any Font Manager functions.*/

struct FamRec {
   SInt16 ffFlags; 
   SInt16 ffFamID; 
   SInt16 ffFirstChar; 
   SInt16 ffLastChar; 
   SInt16 ffAscent; 
   SInt16 ffDescent; 
   SInt16 ffLeading; 
   SInt16 ffWidMax; 
   SInt32 ffWTabOff; 
   SInt32 ffKernOff; 
   SInt32 ffStylOff; 
   SInt16 ffProperty[9]; 
   SInt16 ffIntl[2]; 
   SInt16 ffVersion;
};

typedef struct FamRec FamRec;

/* AsscEntry

Contains the size and style for a specific font.

struct AsscEntry {
   SInt16 fontSize; 
   SInt16 fontStyle; 
   SInt16 fontID;
};
Fields
fontSize

A font point size.
fontStyle

A font style.
fontID

A font Resource ID.
Discussion

The font association entry structure is used in FontAssoc.*/

struct AsscEntry {
   SInt16 fontSize; 
   SInt16 fontStyle; 
   SInt16 fontID;
};
typedef struct AsscEntry AsscEntry;