#ifndef AEDATAMODEL_H
#define AEDATAMODEL_H
#endif

/*AEDisposeDesc

Deallocates the memory used by a descriptor.

OSErr AEDisposeDesc (
   AEDesc * theAEDesc
);
Parameters
theAEDesc

A pointer to the descriptor to deallocate. On return, a null descriptor. If you pass a null descriptor in this parameter, AEDisposeDesc returns noErr. See AEDesc.
Return Value

A result code. See Apple Event Manager Result Codes. As currently implemented, AEDisposeDesc always returns noErr.
Discussion

The AEDisposeDesc function deallocates the memory used by a descriptor. After calling this method, the descriptor becomes an empty descriptor with a type of typeNULL. Because all Apple event structures (except for keyword-specified descriptors) are descriptors, you can use AEDisposeDesc for any of them.

Do not call AEDisposeDesc on a descriptor obtained from another Apple Event Manager function (such as the reply event from a call to AESend) unless that function returns successfully.
Special Considerations

If the AEDesc might contain an OSL token, dispose of it with AEDisposeToken.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEDisposeDesc (
   AEDesc * theAEDesc
);

/*AEGetParamDesc

Gets a copy of the descriptor for a keyword-specified Apple event parameter from an Apple event or an Apple event record (type AERecord); typically used when your application needs to pass the extracted data to another function as a descriptor. 

OSErr AEGetParamDesc (
   const AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType desiredType,
   AEDesc * result
);
Parameters
theAppleEvent

A pointer to the Apple event to get the parameter descriptor from. See AppleEvent.
theAEKeyword

A keyword that specifies the desired Apple event parameter. Some keyword constants are described in “Keyword Parameter Constants”. See AEKeyword.
desiredType

The descriptor type for the desired Apple event parameter. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.

If the requested Apple event parameter is not of the desired type, the Apple Event Manager attempts to coerce it to the desired type. However, if you pass a value of typeWildCard, no coercion is performed, and the descriptor type of the returned descriptor is the same as the descriptor type of the Apple event parameter.

See DescType.
result

A pointer to a descriptor. On successful return, a copy of the descriptor for the specified Apple event parameter, coerced, if necessary, to the descriptor type specified by the desiredType parameter. On error, a null descriptor. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

To get Apple event parameter data for your application to use directly, call AEGetParamPtr. To get a descriptor for an Apple event parameter to pass on to another Apple Event Manager routine, call AEGetParamDesc.

If the actual parameter you are getting with AEGetParamDesc is a record, AEGetParamDesc will only allow you to request it as a typeAERecord, typeAEList, or typeWildcard. For any other type, it will return errAECoercionFail.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

OSErr AEGetParamDesc (
   const AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType desiredType,
   AEDesc * result
);

/*NewAEEventHandlerUPP

Creates a new universal procedure pointer to an event handler function.

AEEventHandlerUPP NewAEEventHandlerUPP (
   AEEventHandlerProcPtr userRoutine
);
Return Value

See AEEventHandlerUPP.
Discussion

See the AEEventHandlerProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

AEEventHandlerUPP NewAEEventHandlerUPP (
   AEEventHandlerProcPtr userRoutine
);

/*AECountItems

Counts the number of descriptors in a descriptor list.

OSErr AECountItems (
   const AEDescList * theAEDescList,
   long * theCount
);
Parameters
theAEDescList

A pointer to the descriptor list to count. See AEDescList.
theCount

A pointer to a count variable. On return, the number of descriptors in the specified descriptor list.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

Your application typically counts the descriptors in a descriptor list when it is extracting data from an Apple event. You can use the functions in “Getting Items From Descriptor Lists” to get an individual item from a descriptor list or to iterate through the items. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AECountItems (
   const AEDescList * theAEDescList,
   long * theCount
);

/*AEGetNthPtr

Gets a copy of the data from a descriptor at a specified position in a descriptor list; typically used when your application needs to work with the extracted data directly.

OSErr AEGetNthPtr (
   const AEDescList * theAEDescList,
   long index,
   DescType desiredType,
   AEKeyword * theAEKeyword,
   DescType * typeCode,
   void * dataPtr,
   Size maximumSize,
   Size * actualSize
);
Parameters
theAEDescList

A pointer to the descriptor list that contains the descriptor. See AEDescList.
index

A one-based positive integer indicating the position in the descriptor list of the descriptor to get the data from. AEGetNthPtr returns an error if you pass zero, a negative number, or a value that is out of range.
desiredType

The desired descriptor type for the copied data. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.

If the descriptor specified by the index parameter is not of the desired type, AEGetNthPtr attempts to coerce the data to this type. If you pass a value of typeWildCard, no coercion is performed, and the descriptor type of the copied data is the same as the descriptor type of the original descriptor.

See DescType.
theAEKeyword

A pointer to a keyword. On return, the keyword for the specified descriptor, if you are getting data from a list of keyword-specified descriptors; otherwise, AEGetNthPtr returns the value typeWildCard. Some keyword constants are described in “Keyword Attribute Constants” and “Keyword Parameter Constants”. See AEKeyword.
typeCode

A pointer to a descriptor type. On return, specifies the descriptor type of the data pointed to by dataPtr. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.
dataPtr

A pointer to a buffer, local variable, or other storage location created and disposed of by your application. The size in bytes must be at least as large as the value you pass in the maximumSize parameter. On return, contains the data from the descriptor at the position in the descriptor list specified by the index parameter.
maximumSize

The maximum length, in bytes, of the expected data. The AEGetNthPtr function will not return more data than you specify in this parameter. 
actualSize

A pointer to a size variable. On return, the length, in bytes, of the data for the specified descriptor. If this value is larger than the value of the maximumSize parameter, the buffer pointed to by dataPtr was not large enough to contain all of the data for the descriptor, though AEGetNthPtr does not write beyond the end of the buffer. If the buffer was too small, you can resize it and call AEGetNthPtr again.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

The AEGetNthPtr function uses a buffer to return the data for a specified descriptor from a specified descriptor list. The function attempts to coerce the descriptor to the descriptor type specified by the desiredType parameter.

Before calling AEGetNthPtr, you can call the AESizeOfNthItem function to determine a size for the dataPtr buffer. However, unless you specify typeWildCard for the desiredType parameter, AESizeOfNthItem may coerce the data, which may cause the size of the data to change. If you are using AEGetNthPtr to iterate through a list of descriptors of the same type with a fixed size, such as a list of descriptors of type typeFSS, you can get the size once, allocate a buffer, and reuse it for each call.

The order of items in an Apple event record may change after an insertion or deletion. In addition, duplicating an Apple event record is not guaranteed to preserve the item order. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEGetNthPtr (
   const AEDescList * theAEDescList,
   long index,
   DescType desiredType,
   AEKeyword * theAEKeyword,
   DescType * typeCode,
   void * dataPtr,
   Size maximumSize,
   Size * actualSize
);

/*AEGetDescData

Gets the data from the specified descriptor.

OSErr AEGetDescData (
   const AEDesc * theAEDesc,
   void * dataPtr,
   Size maximumSize
);
Parameters
theAEDesc

A pointer to the descriptor to get the data from. See AEDesc.
dataPtr

A pointer to a buffer, local variable, or other storage location created and disposed of by your application. The size in bytes should be the same as the value you pass in the maximumSize parameter. On return, contains the data from the descriptor.
maximumSize

The length, in bytes, of the expected descriptor data. The AEGetDescData function will not return more data than you specify in this parameter. You typically determine the maximum size by calling AEGetDescDataSize.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

Your application can call AEGetDescDataSize to get the size, in bytes, of the data in a descriptor, allocate a buffer or variable of that size, then call AEGetDescData to get the data. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

OSErr AEGetDescData (
   const AEDesc * theAEDesc,
   void * dataPtr,
   Size maximumSize
);


/*AECreateDesc

Creates a new descriptor that incorporates the specified data.

OSErr AECreateDesc (
   DescType typeCode,
   const void * dataPtr,
   Size dataSize,
   AEDesc * result
);
Parameters
typeCode

The descriptor type for the new descriptor. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
dataPtr

A pointer to the data for the new descriptor. This data is copied into a newly-allocated block of memory for the descriptor that is created. To minimize copying overhead, consider using AECreateDescFromExternalPtr.
dataSize

The length, in bytes, of the data for the new descriptor.
result

A pointer to a descriptor. On successful return, a descriptor that incorporates the data specified by the dataPtr parameter. On error, a null descriptor. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

While it is possible to create an Apple event descriptor or a descriptor list or a descriptor with the AECreateDesc function (assuming you have access to the raw data for an Apple event, list, or descriptor), you typically create these structured objects with their specific creation routines—AECreateAppleEvent, AECreateList, or AECreateDesc. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AECreateDesc (
   DescType typeCode,
   const void * dataPtr,
   Size dataSize,
   AEDesc * result
);