#ifndef OSA_H
#define OSA_H
#endif

#ifndef COMPONENTS_H
#include <CarbonCore/Components.h>
#endif

#ifndef APPLEEVENTS_H
#include <AE/AppleEvents.h>
#endif

/*keyAETarget

enum {
   keyAETarget = 'targ',
   keySubjectAttr = 'subj',
   keyASReturning = 'Krtn',
   kASAppleScriptSuite = 'ascr',
   kASScriptEditorSuite = 'ToyS',
   kASTypeNamesSuite = 'tpnm',
   typeAETE = 'aete',
   typeAEUT = 'aeut',
   kGetAETE = 'gdte',
   kGetAEUT = 'gdut',
   kUpdateAEUT = 'udut',
   kUpdateAETE = 'udte',
   kCleanUpAEUT = 'cdut',
   kASComment = 'cmnt',
   kASLaunchEvent = 'noop',
   keyScszResource = 'scsz',
   typeScszResource = 'scsz',
   kASSubroutineEvent = 'psbr',
   keyASSubroutineName = 'snam',
   kASPrepositionalSubroutine = 'psbr',
   keyASPositionalArgs = 'parg'
};*/
enum {
   keyAETarget = 'targ',
   keySubjectAttr = 'subj',
   keyASReturning = 'Krtn',
   kASAppleScriptSuite = 'ascr',
   kASScriptEditorSuite = 'ToyS',
   kASTypeNamesSuite = 'tpnm',
   typeAETE = 'aete',
   typeAEUT = 'aeut',
   kGetAETE = 'gdte',
   kGetAEUT = 'gdut',
   kUpdateAEUT = 'udut',
   kUpdateAETE = 'udte',
   kCleanUpAEUT = 'cdut',
   kASComment = 'cmnt',
   kASLaunchEvent = 'noop',
   keyScszResource = 'scsz',
   typeScszResource = 'scsz',
   kASSubroutineEvent = 'psbr',
   keyASSubroutineName = 'snam',
   kASPrepositionalSubroutine = 'psbr',
   keyASPositionalArgs = 'parg'
};
/*kOSAGenericScriptingComponentSubtype

Defines the subtype code for the generic scripting component. 

enum {
   kOSAGenericScriptingComponentSubtype = 'scpt'
};*/
enum {
   kOSAGenericScriptingComponentSubtype = 'scpt'
};

/*kOSAScriptResourceType

Defines the resource type for stored script data.

enum {
   kOSAScriptResourceType = kOSAGenericScriptingComponentSubtype
};
Constants
kOSAScriptResourceType

Resource type for scripts.

Available in Mac OS X v10.0 and later.*/
enum {
   kOSAScriptResourceType = kOSAGenericScriptingComponentSubtype
};

/*typeOSAGenericStorage

Defines the descriptor type for generic storage descriptor records.

enum {
   typeOSAGenericStorage = kOSAScriptResourceType
};
Constants
typeOSAGenericStorage

Default type given to OSAStore, which creates "generic" loadable script data descriptors.

Available in Mac OS X v10.0 and later.*/
enum {
   typeOSAGenericStorage = kOSAScriptResourceType
};

/*Result Codes

The most common result codes returned by Open Scripting Architecture are listed in Table 1-1. Open Scripting Architecture may also return the result codes noErr (0), and badComponentInstance (-2147450879).Result Code	Value	Description
errOSACantCoerce	-1700	
A value can't be coerced to the desired type.
OSAMissingParameter	-1701	
A parameter is missing for a function invocation.
errOSACorruptData	-1702	
Some data could not be read.
errOSATypeError	-1703	
Same as errAEWrongDataType; wrong descriptor type.
OSAMessageNotUnderstood	-1708	
A message was sent to an object that didn't handle it.
OSAUndefinedHandler	-1717	
A function to be returned doesn't exist.
OSAIllegalIndex	-1719	
An index was out of range. Specialization of errOSACantAccess.
OSAIllegalRange	-1720	
The specified range is illegal. Specialization of errOSACantAccess.
OSAParameterMismatch	-1721	
The wrong number of parameters were passed to the function, or a parameter pattern cannot be matched.
OSAIllegalAccess	-1723	
A container can not have the requested object.
errOSACantAccess	-1728	
An object is not found in a container.
errOSARecordingIsAlreadyOn	-1732	
Recording is already on.

Available only in version 1.0.1 or greater.
errOSASystemError	-1750	
Scripting component error.
errOSAInvalidID	-1751	
Invalid script id.
errOSABadStorageType	-1752	
Script doesn’t seem to belong to AppleScript.
errOSAScriptError	-1753	
Script error.
errOSABadSelector	-1754	
Invalid selector given.
errOSASourceNotAvailable	-1756	
Invalid access.
errOSANoSuchDialect	-1757	
Source not available.
errOSADataFormatObsolete	-1758	
No such dialect.
errOSADataFormatTooNew	-1759	
Data couldn’t be read because its format is obsolete.
errOSAComponentMismatch	-1761	
Parameters are from two different components.
errOSACantOpenComponent	-1762	
Can't connect to system with that ID.
errOSAGeneralError	-2700	
No actual error code is to be returned.
errOSADivideByZero	-2701	
An attempt to divide by zero was made.
errOSANumericOverflow	-2702	
An integer or real value is too large to be represented.
errOSACantLaunch	-2703	
An application can't be launched, or when it is, remote and program linking is not enabled.
errOSAAppNotHighLevelEventAware	-2704	
An application can't respond to AppleEvents.
errOSACorruptTerminology	-2705	
An application's terminology resource is not readable.
errOSAStackOverflow	-2706	
The runtime stack overflowed.
errOSAInternalTableOverflow	-2707	
A runtime internal data structure overflowed.
errOSADataBlockTooLarge	-2708	
An intrinsic limitation is exceeded for the size of a value or data structure.
errOSACantGetTerminology	-2709	
Can’t get the event dictionary.
errOSACantCreate	-2710	
Can't make class <class identifier>.
OSASyntaxError	-2740	
A syntax error occured.
OSASyntaxTypeError	-2741	
Another form of syntax was expected.
OSATokenTooLong	-2742	
A name or number is too long to be parsed.
OSADuplicateParameter	-2750	
A formal parameter, local variable, or instance variable is specified more than once.
OSADuplicateProperty	-2751	
A formal parameter, local variable, or instance variable is specified more than once.
OSADuplicateHandler	-2752	
More than one handler is defined with the same name in a scope where the language doesn't allow it.
OSAUndefinedVariable	-2753	
A variable is accessed that has no value.
OSAInconsistentDeclarations	-2754	
A variable is declared inconsistently in the same scope, such as both local and global.
OSAControlFlowError	-2755	
An illegal control flow occurs in an application. For example, there is no catcher for the throw, or there was a non-lexical loop exit.
OSAIllegalAssign	-10003	
An object can never be set in a container
errOSACantAssign	-10006	
An object cannot be set in a container.*/
#define errOSACantCoerce	-1700	
#define  OSAMissingParameter	-1701	
#define  errOSACorruptData	-1702	
#define  errOSATypeError	-1703	
#define  OSAMessageNotUnderstood	-1708	
#define  OSAUndefinedHandler	-1717	
#define  OSAIllegalIndex	-1719	
#define  OSAIllegalRange	-1720	
#define  OSAParameterMismatch	-1721	
#define  OSAIllegalAccess	-1723	
#define  errOSACantAccess	-1728	
#define  errOSARecordingIsAlreadyOn	-1732	
#define errOSASystemError	-1750	
#define  errOSAInvalidID	-1751	
#define  errOSABadStorageType	-1752	
#define  errOSAScriptError	-1753	
#define  errOSABadSelector	-1754	
#define  errOSASourceNotAvailable	-1756	
#define  errOSANoSuchDialect	-1757	
#define  errOSADataFormatObsolete	-1758	
#define  errOSADataFormatTooNew	-1759	
#define  errOSAComponentMismatch	-1761	
#define  errOSACantOpenComponent	-1762	
#define  errOSAGeneralError	-2700	
#define  errOSADivideByZero	-2701	
#define  errOSANumericOverflow	-2702	
#define  errOSACantLaunch	-2703	
#define  errOSAAppNotHighLevelEventAware	-2704	
#define  errOSACorruptTerminology	-2705	
#define  errOSAStackOverflow	-2706	
#define  errOSAInternalTableOverflow	-2707	
#define  errOSADataBlockTooLarge	-2708	
#define  errOSACantGetTerminology	-2709	
#define  errOSACantCreate	-2710	
#define  OSASyntaxError	-2740	
#define  OSASyntaxTypeError	-2741	
#define  OSATokenTooLong	-2742	
#define OSADuplicateParameter	-2750	
#define OSADuplicateProperty	-2751	
#define OSADuplicateHandler	-2752	
#define OSAUndefinedVariable	-2753	
#define OSAInconsistentDeclarations	-2754	
#define OSAControlFlowError	-2755	
#define OSAIllegalAssign	-10003	
#define errOSACantAssign	-10006	

/*Null Mode Flags

Indicate a function’s default mode settings are to be used.

enum {
   kOSANullMode = 0,
   kOSAModeNull = 0
}; */

enum {
   kOSANullMode = 0,
   kOSAModeNull = 0
};
/*kOSANullScript

Defines a null script ID.

enum {
   kOSANullScript = 0
};
Discussion

If the execution of a script does not result in a value, OSAExecute returns the constant kOSANullScript as the script ID. If a client application passes kOSANullScript to the OSAGetSource function instead of a valid script ID, the scripting component should display a null source description (possibly an empty text string). If a client application passes kOSANullScript to OSAStartRecording, the scripting component creates a new compiled script for editing or recording.*/
enum {
   kOSANullScript = 0
};

/*typeAppleScript

Define descriptor types for the AppleScript instance of the Open Scripting Architecture type. 

enum {
   typeAppleScript = 'ascr',
   kAppleScriptSubtype = typeAppleScript,
   typeASStorage = typeAppleScript
};
Constants
kAppleScriptSubtype

Defines the Component Manager subtype for the AppleScript component.

Available in Mac OS X v10.0 and later.
typeASStorage

Defines the AppleScript constant for storage descriptor records.

Available in Mac OS X v10.0 and later.*/
enum {
   typeAppleScript = 'ascr',
   kAppleScriptSubtype = typeAppleScript,
   typeASStorage = typeAppleScript
};

/*kOSAComponentType

Defines the Component Manager type code for components that support the standard scripting component routines.

enum {
   kOSAComponentType = 'osa '
};*/
enum {
   kOSAComponentType = 'osa '
};

/*OSAScriptError Selectors

Define selectors used to retrieve information about script errors from the OSAScriptError function.

enum {
   kOSAErrorNumber = keyErrorNumber
};
enum {
   kOSAErrorMessage = keyErrorString
};
enum {
   kOSAErrorBriefMessage = 'errb'
};
enum {
   kOSAErrorApp = 'erap'
};
enum {
   kOSAErrorPartialResult = 'ptlr'
};
enum {
   kOSAErrorOffendingObject = 'erob'
};
enum {
   kOSAErrorExpectedType = 'errt'
};
enum {
   kOSAErrorRange = 'erng'
};
Constants
kOSAErrorNumber

This selector is used to determine the error number of a script error. These error numbers may be either system error numbers, or error numbers that are scripting component specific. The value of desiredType must be typeShortInteger.

Available in Mac OS X v10.0 and later.
kOSAErrorMessage

This selector is used to determine the full error message associated with the error number. It should include the name of the application which caused the error, as well as the specific error that occurred. This selector is sufficient for simple error reporting (but see kOSAErrorBriefMessage). The value of desiredType must be typeChar or another text descriptor type. 

Available in Mac OS X v10.0 and later.
kOSAErrorBriefMessage

This selector is used to determine a brief error message associated with the error number. This message should not mention the name of the application which caused the error, any partial results or offending object (see kOSAErrorApp, kOSAErrorPartialResult , and kOSAErrorOffendingObject). The value of desiredType must be typeChar or another text descriptor type.

Available in Mac OS X v10.0 and later.
kOSAErrorApp

This selector is used to determine which application actually got the error (if it was the result of an AESend). The value of desiredType must be typeProcessSerialNumber (for the PSN) or a text descriptor type such as typeChar (for the name). 

Available in Mac OS X v10.0 and later.
kOSAErrorPartialResult

This selector is used to determine any partial result returned by an operation. If an AESend call failed, but a partial result was returned, then the partial result may be returned as an AEDesc. The value of desiredType must be typeBest (for the best type) or typeWildCard (for the default type).

Available in Mac OS X v10.0 and later.
kOSAErrorOffendingObject

This selector is used to determine any object which caused the error that may have been indicated by an application. The result is an AEDesc. The value of desiredType must be typeObjectSpecifier, typeBest, or typeWildCard. For some scripting components, including AppleScript, these three values are equivalent.

Available in Mac OS X v10.0 and later.
kOSAErrorRange

This selector is used to determine the source text range (start and end positions) of where the error occurred. The value of desiredType must be typeOSAErrorRange.

Available in Mac OS X v10.0 and later.
kOSAErrorExpectedType

This selector is used to determine the type expected by a coercion operation if a type error occurred.

Available in Mac OS X v10.0 and later.*/
enum {
   kOSAErrorNumber = keyErrorNumber
};
enum {
   kOSAErrorMessage = keyErrorString
};
enum {
   kOSAErrorBriefMessage = 'errb'
};
enum {
   kOSAErrorApp = 'erap'
};
enum {
   kOSAErrorPartialResult = 'ptlr'
};
enum {
   kOSAErrorOffendingObject = 'erob'
};
enum {
   kOSAErrorExpectedType = 'errt'
};
enum {
   kOSAErrorRange = 'erng'
};

/*OSAID

Used by a scripting component to keep track of script data in memory.

typedef unsigned long OSAID;
Discussion

A scripting component assigns a script ID when it creates the associated script data (that is, a compiled script, a script value, a script context, or other kinds of script data supported by a scripting component) or loads it into memory. The scripting routines that create, load, compile, and execute scripts all return script IDs, and your application must pass valid script IDs to the other routines that manipulate scripts. A script ID remains valid until a client application calls OSADispose to reclaim the memory used for the corresponding script data. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef unsigned long OSAID;


/*OSAError

Represents an OSA result code.

typedef ComponentResult OSAError;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ComponentResult OSAError;

/*OSALoad

Loads script data. 

OSAError OSALoad (
   ComponentInstance scriptingComponent,
   const AEDesc * scriptData,
   long modeFlags,
   OSAID * resultingScriptID
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
scriptData

A pointer to the descriptor record containing the script data to be loaded. 
modeFlags

Information used by individual scripting components. To avoid setting any mode ?ags, specify kOSAModeNull. To indicate that only the minimum script data required to run the script should be loaded, pass kOSAModePreventGetSource in this parameter. 
resultingScriptID

On return, a pointer to the script ID for the compiled script. See the OSAID data type.
Return Value

A result code. See Result Codes.
Discussion

The OSALoad function loads script data and returns a script ID. The generic scripting component uses the descriptor record in the scriptData parameter to determine which scripting component should load the script. If the descriptor record is of type typeOSAGenericStorage, the generic scripting component uses the trailer at the end of the script data to identify the scripting component. If the descriptor records type is the subtype value for another scripting component, the generic scripting component uses the descriptor type to identify the scripting component.

If you want the script ID returned by OSALoad to identify only the minimum script data required to run the script and you are sure that you wont need to display the source data to the user, specify the kOSAModePreventGetSource ?ag in the modeFlags parameter.

Scripting components other than the generic scripting component can load script data only if it has been saved in a descriptor record whose descriptor type matches the scripting components subtype. 

Script data may change after it has been loaded?for example, if your application allows the user to edit a scripts source data. To test whether script data has been modi?ed, pass its script ID to OSAGetScriptInfo. If it has changed, you can call OSAStore again to obtain a handle to the modi?ed script data and save it. 
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSALoad (
   ComponentInstance scriptingComponent,
   const AEDesc * scriptData,
   long modeFlags,
   OSAID * resultingScriptID
);

/*OSADispose

Reclaims the memory occupied by script data. 

OSAError OSADispose (
   ComponentInstance scriptingComponent,
   OSAID scriptID
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
scriptID

The script ID for the script data to be disposed of. See the OSAID data type.
Return Value

A result code. See “Result Codes”.
Discussion

The OSADispose function releases the memory assigned to the script data identiﬁed by the scriptID parameter. The script ID passed to the OSADispose function is no longer valid if the function returns successfully. A scripting component can then reuse that script ID for other script data. 

A call to OSADispose returns noErr if the script ID is kOSANullScript, although it does not dispose of anything. 
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSADispose (
   ComponentInstance scriptingComponent,
   OSAID scriptID
);

/*OSADisplay

Converts a script value to text. Your application can then use its own functions to display this text to the user. 

OSAError OSADisplay (
   ComponentInstance scriptingComponent,
   OSAID scriptValueID,
   DescType desiredType,
   long modeFlags,
   AEDesc * resultingText
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
scriptValueID

The script ID for the script value to coerce. See the OSAID data type.
desiredType

The desired text descriptor type, such as typeChar, for the resulting descriptor record. 
modeFlags

Information used by individual scripting components. To avoid setting any mode ﬂags, specify kOSAModeNull. To make the resulting text readable by humans only, so that it can’t be recompiled, specify kOSAModeDisplayForHumans. 
resultingText

A pointer to the resulting descriptor record. 
Return Value

A result code. See “Result Codes”.
Discussion

The OSADisplay function coerces the script value identiﬁed by scriptValueID to a descriptor record of the text type speciﬁed by the desiredType parameter, if possible. Valid types include the standard text descriptor types, plus any special types supported by the scripting component.

Unlike OSAGetSource, OSADisplay can coerce only script values and always produces a descriptor record of a text descriptor type. In addition, if you specify the mode ﬂag kOSAModeDisplayForHumans, the resulting text cannot be recompiled. 

If you want to get a script value in a form that you can display for humans to read, use OSADisplay. If you want the descriptor type of the descriptor record returned in the resultingText parameter to be the same as the descriptor type returned by a scripOSAError OSADisplay (
   ComponentInstance scriptingComponent,
   OSAID scriptValueID,
   DescType desiredType,
   long modeFlags,
   AEDesc * resultingText
);ting component, use OSACoerceToDesc and specify typeWildCard as the desired type.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSADisplay (
   ComponentInstance scriptingComponent,
   OSAID scriptValueID,
   DescType desiredType,
   long modeFlags,
   AEDesc * resultingText
);

/*OSAScriptError

Gets information about errors that occur during script execution. 

OSAError OSAScriptError (
   ComponentInstance scriptingComponent,
   OSType selector,
   DescType desiredType,
   AEDesc * resultingErrorDescription
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
selector

A value that determines what OSAScriptError returns. The value can be one of the constants described in “OSAScriptError Selectors”.
desiredType

The desired descriptor type of the resulting descriptor record. The description that follows explains how this is determined by the value passed in the selector parameter.
resultingErrorDescription

On return, a pointer to the resulting descriptor record. 
Return Value

A result code. See “Result Codes”.
Discussion

Whenever the OSAExecute function returns the error errOSAScriptError, you can use the OSAScriptError function to get more speciﬁc information about the error from the scripting component that encountered it. (This information remains available only until the next call to the same scripting component.) The information returned by OSAScriptError depends on the value passed in the selector parameter, which also determines the descriptor type you should specify in the desiredType parameter.

Every scripting component should support calls to OSAScriptError that pass kOSAErrorNumber, kOSAErrorMessage, or kOSAErrorPartialResult in the selector parameter.

Some scripting components may also support calls that pass other values in the selector parameter, including kOSAErrorRange, which provides start and end positions delimiting the errant expression in the source data. If the value of the selector parameter is kOSAErrorRange, the value of desiredType must be typeOSAErrorRange.

If the value of the selector parameter is kOSAErrorNumber, scripting components may return, in the resultingErrorDescription parameter, one of the general error codes described in “Result Codes”.

If you call OSAScriptError using an instance of the generic scripting component, the generic scripting component uses the same instance of a scripting component that it used for the previous call. 
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSAScriptError (
   ComponentInstance scriptingComponent,
   OSType selector,
   DescType desiredType,
   AEDesc * resultingErrorDescription
);

/*OSAExecuteEvent

Handles an Apple event with the aid of a script context and obtains a script ID for the resulting script value. 

OSAError OSAExecuteEvent (
   ComponentInstance scriptingComponent,
   const AppleEvent * theAppleEvent,
   OSAID contextID,
   long modeFlags,
   OSAID * resultingScriptValueID
);
Parameters
scriptingComponent

A component instance created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
theAppleEvent

A pointer to the Apple event to be handled. 
contextID

The script ID for the script context to be used to handle the Apple event. See the OSAID data type.
modeFlags

Information used by individual scripting components. To avoid setting mode ﬂag values, specify kOSAModeNull. Other possible mode ﬂags are listed in “Mode Flags”. 
resultingScriptValueID

A pointer to the script ID for the resulting script value. 
Return Value

A result code. See “Result Codes”.
Discussion

The OSAExecuteEvent function attempts to use the script context speciﬁed by the contextID parameter to handle the Apple event specified by the theAppleEvent parameter. If the scripting component determines that the script context can’t handle the event (for example, if a script written in AppleScript doesn’t include statements that handle the event), OSAExecuteEvent immediately returns errAEEventNotHandled rather than errOSAScriptError. This causes the Apple Event Manager to look for an appropriate handler in the application’s Apple event dispatch table or elsewhere, using standard Apple event dispatching.

If the scripting component determines that the script context can handle the event, OSAExecuteEvent executes the script context’s handler and returns the resulting script ID. If execution of the script context’s handler for the event generates an error, OSAExecuteEvent returns errOSAScriptError, and you can get more detailed error information by calling the OSAScriptError function. 

If the script context identiﬁed by the contextID parameter speciﬁes that the Apple event should be passed to the application’s default handler for that event (for example, with an AppleScript continue statement), OSAExecuteEvent passes the event to the resume dispatch function currently being used by the scripting component. The resume dispatch function dispatches the event directly to the application’s standard handler for that event (that is, without calling OSAExecuteEvent again). If the contextID parameter is kOSANullScript, the OSAExecuteEvent function passes the event directly to the resume dispatch function. If a call to the resume dispatch function is successful, execution of the script context proceeds from the point at which the resume dispatch function was called. 
Special Considerations

The OSAExecuteEvent function can generate the result code errAEEventNotHandled in at least two ways. If the scripting component determines that a script context doesn’t declare a handler for a particular event, OSAExecuteEvent immediately returns errAEEventNotHandled. If a scripting component calls its resume dispatch function during script execution and the application’s standard handler for the event fails to handle it, OSAExecuteEvent returns errOSAScriptError and a call to OSAScriptError with kOSAErrorNumber in the selector parameter returns errAEEventNotHandled as the resulting error description.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSA.h*/
OSAError OSAExecuteEvent (
   ComponentInstance scriptingComponent,
   const AppleEvent * theAppleEvent,
   OSAID contextID,
   long modeFlags,
   OSAID * resultingScriptValueID
);