#ifndef IOKITLIB_H
#define IOKITLIB_H
#endif

#include <mach/machine/kern_return.h>

#ifndef OC_CFDICTIONARY_H
#include <OC_CoreFoundation/CFDictionary.h>
#endif

#ifndef OC_CFSRRING_H
#include <OC_CoreFoundation/CFString.h>
#endif

#ifndef CFDICTIONARY_H
#include <CoreFoundation/CFDictionary.h>
#endif

#ifndef CFBASE_H
#include <CoreFoundation/CFBase.h>
#endif

#ifndef USB_H
#include <IOKit/usb/USB.h>
#endif

#ifndef IOTYPES_H
#include <IOKit/IOTypes.h>
#endif

#ifndef DISK_H
#include <sys/disk.h>
#endif

#ifndef IOCDTYPES_H
#include <IOKit/storage/IOCDTypes.h>
#endif

#include <mach/port.h>

#define kIOBSDNameKey  "AA"  
#define kSenseDefaultSize 12
/*kIOCDMediaClass


kIOCDMediaClass is the name of the IOCDMedia class.
#define kIOCDMediaClass "IOCDMedia" 
Discussion 

kIOCDMediaClass is the name of the IOCDMedia class.*/
#define kIOCDMediaClass "IOCDMedia"

/* kIOMediaEjectableKey


A property of IOMedia objects.
#define kIOMediaEjectableKey "Ejectable" 
Discussion 

The kIOMediaEjectableKey property has an OSBoolean value and describes whether the media is ejectable from the drive mechanism under software control. Implies IOMediaRemovable is also true.*/
#define kIOMediaEjectableKey "Ejectable" 


/*Object Reference-Counting and Introspection

Functions in the IOKitLib communicate with in-kernel objects using the Mach port transport mechanism to cross the user-kernel boundary. The file IOTypes.h, located in the I/O Kit framework, defines the objects you use with IOKitLib functions to communicate with such in-kernel entities as I/O Registry entries (objects of class IORegistryEntry) or iterators (objects of class IOIterator). Notice in Listing 4-1, however, that IOTypes.h seems to define all these objects in the same way, specifically, as mach_port_t objects (mach_port_t is defined in mach/port.h in the Kernel framework).

Listing 4-1  Object definitions in IOTypes.htypedef mach_port_t io_object_t;
 
typedef io_object_t io_connect_t;
typedef io_object_t io_iterator_t;
typedef io_object_t io_registry_entry_t;
typedef io_object_t io_service_t;
typedef io_object_t io_enumerator_t;


To understand why this is so, recall that a Mach port is the communication transport mechanism an application uses to communicate with the I/O Kit. As far as the kernel is concerned, every time your application communicates with any in-kernel object using one of the object types defined in IOTypes.h, its using the same generic mechanism (namely, a Mach port) to cross the user-kernel boundary. 

From the applications point of view, however, the transport mechanism is unimportant and what matters is the type of object on the other side of the port. The fact that an io_iterator_t object, for example, encapsulates the association of a Mach port with an in-kernel IOIterator object is not as important to the application as the fact that an io_iterator_t object refers to an in-kernel object that knows how to iterate over the I/O Registry.

The io_object_t objects in user space not only refer to the in-kernel objects, they also reflect the in-kernel C++ class hierarchy. Because IOService is a subclass of IORegistryEntry, for example, you can use an io_service_t object with any IOKitLib function that expects an io_registry_entry_t object, such as IORegistryEntryGetPath.

With few exceptions (such as getting the I/O Kit master port to initiate communication with the I/O Kit and reference-counting of the io_object_t objects themselves) you should not concern yourself with the cross-boundary communication mechanism. Rather, you should focus on the specific in-kernel object you are working with, making sure you use each object type appropriately.*/

typedef mach_port_t io_object_t;
 
typedef io_object_t io_connect_t;
typedef io_object_t io_iterator_t;
typedef io_object_t io_registry_entry_t;
typedef io_object_t io_service_t;
typedef io_object_t io_enumerator_t;


/*//////////////////////IOServiceMatching


Creates a matching dictionary that specifies an IOService class match. 
CFMutableDictionaryRef IOServiceMatching( 
    const char *name );  
Parameters
name
The class name, as a const C string. Class matching is successful on IOService objects of this class or any subclass.
Return Value

The matching dictionary created, is returned on success, or zero on failure. The dictionary is commonly passed to IOServiceGetMatchingServices or IOServiceAddMatchingNotification which will consume a reference, otherwise it should be released with CFRelease by the caller. 
Discussion 

A very common matching criteria for an IOService object is based on its class. IOServiceMatching will create a matching dictionary that specifies any IOService object of a class, or its subclasses. The class is specified by C string name.*/
CFMutableDictionaryRef IOServiceMatching( 
    const char *name );  

/*IOServiceGetMatchingServices


Look up registered IOService objects that match a matching dictionary. 
kern_return_t IOServiceGetMatchingServices( 
    mach_port_t masterPort, 
    CFDictionaryRef matching, 
    io_iterator_t *existing );  
Parameters
masterPort
The master port obtained from IOMasterPort. Pass kIOMasterPortDefault to look up the default master port.
matching
A CF dictionary containing matching information, of which one reference is always consumed by this function. (Note that prior to the Tiger release there was a small chance that the dictionary might not be released if there was an error attempting to serialize the dictionary). IOKitLib can construct matching dictionaries for common criteria with helper functions such as IOServiceMatching, IOServiceNameMatching, IOBSDNameMatching, IOOpenFirmwarePathMatching.
existing
An iterator handle is returned on success, and should be released by the caller when the iteration is finished.
Return Value

A kern_return_t error code. 
Discussion 

This is the preferred method of finding IOService objects currently registered by the I/O Kit (that is, objects that have had their registerService methods invoked). To find IOService objects that aren't yet registered, use an iterator as created by IORegistryEntryCreateIterator. IOServiceAddMatchingNotification can also supply this information and install a notification of new IOService objects. The matching information used in the matching dictionary may vary depending on the class of service being looked up.*/

kern_return_t IOServiceGetMatchingServices( 
    mach_port_t masterPort, 
    CFDictionaryRef matching, 
    io_iterator_t *existing );  

/*kIOMasterPortDefault


The default Mach port used to initiate communication with the I/O Kit. 
extern const mach_port_t kIOMasterPortDefault;  
Discussion 

When specifying a master port to I/O Kit functions, the NULL argument indicates "use the default". This is a synonym for NULL, if you'd rather use a named constant.*/
extern const mach_port_t kIOMasterPortDefault;

/*IOIteratorNext


Returns the next object in an iteration. 
io_object_t IOIteratorNext( 
    io_iterator_t iterator );  
Parameters
iterator
An I/O Kit iterator handle.
Return Value

If the iterator handle is valid, the next element in the iteration is returned, otherwise zero is returned. The element should be released by the caller when it is finished. 
Discussion 

This function returns the next object in an iteration, or zero if no more remain or the iterator is invalid.*/
io_object_t IOIteratorNext( 
    io_iterator_t iterator );  

/*IORegistryEntryCreateCFProperty


Creates a CF representation of a registry entry's property. 
CFTypeRef IORegistryEntryCreateCFProperty( 
    io_registry_entry_t entry, 
    CFStringRef key, 
    CFAllocatorRef allocator, 
    IOOptionBits options );  
Parameters
entry
The registry entry handle whose property to copy.
key
A CFString specifying the property name.
allocator
The CF allocator to use when creating the CF container.
options
No options are currently defined.
Return Value

A CF container is created and returned the caller on success. The caller should release with CFRelease. 
Discussion 

This function creates an instantaneous snapshot of a registry entry property, creating a CF container analogue in the caller's task. Not every object available in the kernel is represented as a CF container; currently OSDictionary, OSArray, OSSet, OSSymbol, OSString, OSData, OSNumber, OSBoolean are created as their CF counterparts.*/
CFTypeRef IORegistryEntryCreateCFProperty( 
    io_registry_entry_t entry, 
    CFStringRef key, 
    CFAllocatorRef allocator, 
    IOOptionBits options );  

/*IOObjectRelease


Releases an object handle previously returned by IOKitLib. 
kern_return_t IOObjectRelease( 
    io_object_t object );  
Parameters
object
The I/O Kit object to release.
Return Value

A kern_return_t error code. 
Discussion 

All objects returned by IOKitLib should be released with this function when access to them is no longer needed. Using the object after it has been released may or may not return an error, depending on how many references the task has to the same object in the kernel.*/
kern_return_t IOObjectRelease( 
    io_object_t object );  