#ifndef MENUS_H
#define MENUS_H
#endif

/*Menu Item Attribute Constants

Specify attributes for menu items. 

typedef UInt32 MenuItemAttributes;
enum {
   kMenuItemAttrDisabled = (1 << 0),
   kMenuItemAttrIconDisabled = (1 << 1),
   kMenuItemAttrSubmenuParentChoosable = (1 << 2),
   kMenuItemAttrDynamic = (1 << 3),
   kMenuItemAttrNotPreviousAlternate = (1 << 4),
   kMenuItemAttrHidden = (1 << 5),
   kMenuItemAttrSeparator = (1 << 6),
   kMenuItemAttrSectionHeader = (1 << 7),
   kMenuItemAttrIgnoreMeta = (1 << 8),
   kMenuItemAttrAutoRepeat = (1 << 9),
   kMenuItemAttrUseVirtualKey = (1 << 10),
   kMenuItemAttrCustomDraw = (1 << 11),
   kMenuItemAttrIncludeInCmdKeyMatching = (1 << 12)
   kMenuItemAttrAutoDisable = (1 << 13)
   kMenuItemAttrUpdateSingleItem = (1 << 14)
};
Constants
kMenuItemAttrDisabled

This menu item is disabled.

Available in Mac OS X v10.0 and later.
kMenuItemAttrIconDisabled

This menu item’s icon is disabled. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrSubmenuParentChoosable

The user can select the parent item of a submenu. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrDynamic

This menu item changes dynamically based on the state of the modifier keys. For example, holding down the command key might change the menu item from “Select widget” to “Select all widgets.”

When a menu item has alternate dynamic states, you should group them together sequentially in the menu and assign them the same command key. A collection of menu item alternates is called a dynamic group. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrNotPreviousAlternate

This item is not part of the same dynamic group as the previous item. The Menu Manager determines which menu items belong to a dynamic group by examining the command keys of each item; if a menu item has the same command key as the previous item, the Menu Manager considers it to be part of the same dynamic group. 

However, in some cases you may have sequential items with the same command key (or no command key at all) that should not be considered part of the same dynamic group. To distinguish the separation, you should set this flag for the first menu item in the new group. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrHidden

The menu item is not drawn when displaying the menu. The item is also not included in command-key matching unless the kMenuItemAttrDynamic or kMenuItemIncludeInCmdKeyMatching attribute is set. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrSeparator

The menu item is a separator; any text in the item is ignored. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrSectionHeader

The menu item is a menu section header; this item is disabled and not selectable. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrIgnoreMeta

Ignore the dash (-) metacharacter in this menu item. Dashes at the beginning of a menu item title traditionally signify that the menu item is a separator. However, in some cases you might want to display the dash in the title (for example, if you wanted the menu item to read “-40 degrees F.”)

Available in Mac OS X v10.0 and later.
kMenuItemAttrAutoRepeat

The IsMenuKeyEvent event function recognizes this menu item when it receives an autorepeat keyboard event. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrUseVirtualKey

When MenuEvent and IsMenuKeyEvent compare this menu item’s keyboard equivalent against a keyboard event, they use the item’s virtual keycode equivalent rather than its character code equivalent. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrCustomDraw

This is a custom menu item. Setting this attribute causes custom menu item drawing Carbon events to be sent to your application. Available in CarbonLib 1.4 and Mac OS X v10.1 and later. 

Available in Mac OS X v10.1 and later.
kMenuItemAttrIncludeInCmdKeyMatching

If this attribute is set, functions such as MenuKey, MenuEvent and IsMenuKeyEvent examine this menu item during command key matching. Typically, visible items are examined and hidden items (unless they have the kMenuItemAttrDynamic attribute set) are ignored during command key matching. However, by setting this attribute, you can force hidden items to be included in the matching. Available in CarbonLib 1.6 and Mac OS X v10.2 and later. 

Available in Mac OS X v10.2 and later.
kMenuItemAttrAutoDisable

Disables the menu item if it does not respond to the kEventCommandUpdateStatus event . That is, if no kEventCommandUpdateStatus handler is installed on this item, or if all the handlers installed for the update event return eventNotHandledErr, this item is automatically disabled. This attribute is useful if your application uses the kEventCommandUpdateStatus event to enable menu items; for example you no longer have to install an update status handler on the application target to disable menu items when there are no document windows open. 

Available in Mac OS X v10.3 and later.
kMenuItemAttrUpdateSingleItem

Update only the menu item that matches when searching available command keys. Normally when the Menu Manager does command key matching, it sends a kEventMenuEnableItems event to the menu containing the matching item and then sends a kEventCommandUpdateStatus to each item in the menu. Doing so can be inefficient, since in most cases only the item that matches needs to be updated. By setting this attribute, only the matching item receives the update event and kEventMenuEnableItems is not sent to the menu. If your application enables menu items solely through kEventCommandUpdateStatus event handlers, you should set this attribute for your menu items.

Available in Mac OS X v10.3 and later.
Discussion

Menu item attributes control behavior of individual menu items. They are used with the GetMenuItemAttributes and ChangeMenuItemAttributes APIs.*/
typedef UInt32 MenuItemAttributes;
enum {
   kMenuItemAttrDisabled = (1 << 0),
   kMenuItemAttrIconDisabled = (1 << 1),
   kMenuItemAttrSubmenuParentChoosable = (1 << 2),
   kMenuItemAttrDynamic = (1 << 3),
   kMenuItemAttrNotPreviousAlternate = (1 << 4),
   kMenuItemAttrHidden = (1 << 5),
   kMenuItemAttrSeparator = (1 << 6),
   kMenuItemAttrSectionHeader = (1 << 7),
   kMenuItemAttrIgnoreMeta = (1 << 8),
   kMenuItemAttrAutoRepeat = (1 << 9),
   kMenuItemAttrUseVirtualKey = (1 << 10),
   kMenuItemAttrCustomDraw = (1 << 11),
   kMenuItemAttrIncludeInCmdKeyMatching = (1 << 12),
   kMenuItemAttrAutoDisable = (1 << 13),
   kMenuItemAttrUpdateSingleItem = (1 << 14)
};


/*MenuRef

Defines a menu.

typedef struct OpaqueMenuRef * MenuRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueMenuRef * MenuRef;

/*MenuCommand

Specifies a menu items command ID.

typedef UInt32 MenuCommand;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 MenuCommand;

/*MenuRef

Defines a menu.

typedef struct OpaqueMenuRef * MenuRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueMenuRef * MenuRef;

/*MenuItemIndex

Specifies a particular menu item in a menu.

typedef UInt16 MenuItemIndex;
Discussion

The menu item index is one-based, so item 1 is the first menu item, item 2 is the second, and so on. Some functions allow you to pass an index of zero, which specifies the menu itself. 
Availability
Available in Mac OS X v10.0 and later*/
typedef UInt16 MenuItemIndex;

/*EnableMenuCommand

Enables the menu item with a specified command ID.

void EnableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID
);
Parameters
inMenu

The menu in which to begin searching for the item. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
inCommandID

The command ID of the menu item to be enabled. If more than one item has this command ID, only the first will be enabled. 
Discussion

If you have access to the menu item index, in most cases you should use EnableMenuItem instead, as that function is faster and requires no searching. For example, when receiving a kEventCommandUpdateStatus event, the HICommand structure contains both the menu items command ID and index. If you wanted to enable the menu item, you should call EnableMenuItem.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void EnableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID
);

/*CopyMenuItemTextAsCFString

Returns a CFString containing the text of a menu item.

OSStatus CopyMenuItemTextAsCFString (
   MenuRef inMenu,
   MenuItemIndex inItem,
   CFStringRef * outString
);
Parameters
menu

The menu containing the item. 
item

The item whose text you want to copy. 
outString

On exit, a CFString containing the item's text. The caller must release this string when it is no longer needed. 
Return Value

A result code. See “Menu Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus CopyMenuItemTextAsCFString (
   MenuRef inMenu,
   MenuItemIndex inItem,
   CFStringRef * outString
);

/*DeleteMenuItem

Deletes an item from a menu. 

void DeleteMenuItem (
   MenuRef theMenu,
   short item
);
Parameters
theMenu

The menu from which you want to delete the menu item. 
item

The item number of the menu item to delete. If you specify 0 or a number greater than the last item in the menu, DeleteMenuItem does not delete any item from the menu. 
Discussion

The DeleteMenuItem function deletes a specified menu item from a menu. You should not delete items from an existing menu unless the user expects the menu (such as a menu that lists open documents) to change. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DeleteMenuItem (
   MenuRef theMenu,
   short item
);

/*AppendMenuItemTextWithCFString

Appends a new menu item with text from a CFString.

OSStatus AppendMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID,
   MenuItemIndex * outNewItem
);
Parameters
menu

The menu to which to append the new item. 
inString

The text of the new item. 
inAttributes

The attributes of the new item. 
inCommandID

The command ID of the new item. 
outNewItem

On exit, the index of the new item. May be NULL if the caller does not need this information. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The Menu Manager will make its own copy of the CFString before returning from this function. Modifying the string after calling AppendMenuItemTextWithCFString will have no effect on the menu item's actual text. The caller may release the string after the call.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus AppendMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID,
   MenuItemIndex * outNewItem
);