#ifndef MACTEXTEDITOR_H
#define MACTEXTEDITOR_H
#endif

#ifndef FILES_H
#include <CarbonCore/Files.h>
#endif
#ifndef CFUURL_H
#include <CoreFoundation/CFURL.h>
#endif


#ifndef HIVIEW_H
#include <HIToolbox/HIView.h>
#endif

#ifndef HYS_H
#include <OC_Cocoa/hys.h>
#endif


/*Supported Frame Types

Represents a frame type. (Deprecated. No longer needed.)

typedef UInt32 TXNFrameType;
enum {
   kTXNTextEditStyleFrameType = 1,
   kTXNPageFrameType = 2,
   kTXNMultipleFrameType = 3
};
Constants
kTXNTextEditStyleFrameType

A single rectangle that allows text to scroll if the rectangle fills. Although you can pass this as a parameter to the function TXNNewObject, you should instead use the function TXNCreateObject, which does not require a frame type.

Available in Mac OS X v10.0 and later.
kTXNPageFrameType

A single rectangle with a bottom. That is, text moves to a new page if the frame is full. This constant is not supported in Mac OS X version 10.3 and later. 

Available in Mac OS X v10.0 and later.
kTXNMultipleFrameType

Multiple frames. This constant is not supported in Mac OS X version 10.3 and later. 

Available in Mac OS X v10.0 and later.
Special Considerations

This data type is used only by the TXNNewObject function, which is deprecated.*/
typedef UInt32 TXNFrameType;
enum {
   kTXNTextEditStyleFrameType = 1,
   kTXNPageFrameType = 2,
   kTXNMultipleFrameType = 3
};

/*TXNObject

Contains private variables and functions necessary to represent text and handle text formatting at a document level. 

typedef struct OpaqueTXNObject * TXNObject;
Discussion

You obtain a structure of type TXNObject from the TXNNewObject function. 
Availability
Available in Mac OS X v10.0 and later*/
typedef struct OpaqueTXNObject * TXNObject;

/*Data Offsets

Specifies offsets to use when manipulating data in a text object. Offsets in MLTE are always character offsets.

typedef UInt32 TXNOffset;
enum {
   kTXNUseCurrentSelection = 0xFFFFFFFF,
   kTXNStartOffset = 0,
   kTXNEndOffset = 0x7FFFFFFF
};
Constants
kTXNUseCurrentSelection

Use the current selection.

Available in Mac OS X v10.0 and later.
kTXNStartOffset

The first offset of the text in a text object.

Available in Mac OS X v10.0 and later.
kTXNEndOffset

The last offset of the text in a text object.

Available in Mac OS X v10.0 and later.
Discussion

These constants can be passed and returned in functions that have the parameter of type TXNOffset.*/
typedef UInt32 TXNOffset;
enum {
   kTXNUseCurrentSelection = 0xFFFFFFFF,
   kTXNStartOffset = 0,
   kTXNEndOffset = 0x7FFFFFFF
};



/*Supported Data Types

Specifies the type of data being requested from or passed to an MLTE function.

typedef OSType TXNDataType;
enum {
   kTXNTextData = 'TEXT',
   kTXNPictureData = 'PICT',
   kTXNMovieData = 'moov',
   kTXNSoundData = 'snd ',
   kTXNUnicodeTextData = 'utxt'
};
Constants
kTXNTextData

Text data.

Available in Mac OS X v10.0 and later.
kTXNPictureData

Graphics (PICT) data.

Available in Mac OS X v10.0 and later.
kTXNMovieData

Movie or sound data.

Available in Mac OS X v10.0 and later.
kTXNSoundData

Sound data.

Available in Mac OS X v10.0 and later.
kTXNUnicodeTextData

Unicode text data.

Available in Mac OS X v10.0 and later.
Discussion

Used in the TXNGetDataEncoded function.*/
typedef OSType TXNDataType;
enum {
   kTXNTextData = 'TEXT',
   kTXNPictureData = 'PICT',
   kTXNMovieData = 'moov',
   kTXNSoundData = 'snd ',
   kTXNUnicodeTextData = 'utxt'
};
/*Frame Option Bits

Specify frame options for a text object.

enum {
   kTXNDrawGrowIconBit = 0,
   kTXNShowWindowBit = 1,
   kTXNWantHScrollBarBit = 2,
   kTXNWantVScrollBarBit = 3,
   kTXNNoTSMEverBit = 4,
   kTXNReadOnlyBit = 5,
   kTXNNoKeyboardSyncBit = 6,
   kTXNNoSelectionBit = 7,
   kTXNSaveStylesAsSTYLResourceBit = 8,
   kOutputTextInUnicodeEncodingBit = 9,
   kTXNDoNotInstallDragProcsBit = 10,
   kTXNAlwaysWrapAtViewEdgeBit = 11,
   kTXNDontDrawCaretWhenInactiveBit = 12,
   kTXNDontDrawSelectionWhenInactiveBit = 13,
   kTXNSingleLineOnlyBit = 14,
   kTXNDisableDragAndDropBit = 15,
   kTXNUseQDforImagingBit = 16,
   kTXNMonostyledTextBit = 17
};
Constants
kTXNDrawGrowIconBit

When this bit is set, it indicates the frame will have a size box. The presence of a size box in the lower right corner of an MLTE pane is only useful for resizing an MLTE pane if the MLTE pane occupies the entire window (a full-window MLTE object). In this case your application would look for a mouse-down event in the size box and call the function TXNGrowWindow as appropriate. Note that the size box is not supported as a means of resizing MLTE panes using TXNGrowWindow for MLTE pane objects. 

Passing the kTXNDrawGrowIconMask constant to the function TXNNewObject only causes a size box to be drawn in the lower right corner of the MLTE pane. Passing this constant does not create a size box control in the window. The window will not contain an actual size box control. This means the window will not receive events that indicate a mouse-down event in the grow region. For this to happen, when you create the window that contains the MLTE pane, you must create the window to have a size box.

In summary, although you may pass the constants kTXNDrawGrowIconMask to the function TXNNewObject when you create an MLTE object in a window, this action only causes the visual appearance of a size box in the lower right corner of the MLTE pane. If you want to detect mouse-down events in the size box, you must also provide a size box in the window through the appropriate Window Manager functions or other tools.

Available in Mac OS X v10.0 and later.
kTXNShowWindowBit

When this bit is set, it indicates MLTE should display a window when a text object is created. If this bit is set, your application no longer needs to call the ShowWindow function from the Window Manager; MLTE will do this for you.

Available in Mac OS X v10.0 and later.
kTXNWantHScrollBarBit

When this bit is set, it indicates the frame should have a horizontal scroll bar.

Available in Mac OS X v10.0 and later.
kTXNWantVScrollBarBit

When this bit is set, it indicates the frame should have a vertical scroll bar.

Available in Mac OS X v10.0 and later.
kTXNNoTSMEverBit


When this bit is set, it indicates not to use Text Services Manager. You cannot use this bit when your application accepts Unicode input. (Deprecated. You can no longer set this because in Mac OS X, MLTE always uses the Text Services Manager.)

Available in Mac OS X v10.0 and later.
kTXNReadOnlyBit

When this bit is set, it indicates the text object is read-only. If you set this bit when you call the function TXNNewObject, the text object is put into a state that does not allow user input. However, your application can put data into the text object by calling the function TXNSetData. If you want the text object set into a more restrictive read-only state that does not allow user input or your application to put data into the text object programmatically you need to call the function TXNSetTXNObjectControls, passing the tag kTXNIOPrivilegesTag.

Available in Mac OS X v10.0 and later.
kTXNNoKeyboardSyncBit

When this bit is set, it indicates no keyboard synchronization.

Available in Mac OS X v10.0 and later.
kTXNNoSelectionBit

When this bit is set, it indicates MLTE should not show the insertion point.

Available in Mac OS X v10.0 and later.
kTXNSaveStylesAsSTYLResourceBit

When this bit is set, it indicates text style should be saved as a kTXNMultipleStylesPerTextDocumentResType resource. You can set this to assure compatibility with SimpleText. If you use kTXNMultipleStylesPerTextDocumentResType resources to save style info, your documents can have as many styles as you’d like. However tabs are not saved. If you don’t set this bit, plain text files are saved as kTXNSingleStylePerTextDocumentResType resources, and only the first style in the document is saved. (Your application is expected to apply all style changes to the entire document.) If you save files with a kTXNSingleStylePerTextDocumentResType resource, their output is similar to those output by CodeWarrior, BBEdit, and MPW.

Available in Mac OS X v10.0 and later.
kOutputTextInUnicodeEncodingBit

When this bit is set, it indicates plain text should be saved as Unicode.

Available in Mac OS X v10.0 and later.
kTXNDoNotInstallDragProcsBit

When this bit is set, it indicates you want to call your own drag handlers.

Available in Mac OS X v10.0 and later.
kTXNAlwaysWrapAtViewEdgeBit

When this bit is set, it indicates line wrap at the edge of the view rectangle.

Available in Mac OS X v10.0 and later.
kTXNDontDrawCaretWhenInactiveBit


When this bit is set, it indicates the caret should not be drawn when the object does not have focus. (Deprecated. In Mac OS X v10.4, MLTE never draws the caret when the text object does not have focus.)

Available in Mac OS X v10.0 and later.
kTXNDontDrawSelectionWhenInactiveBit

When this bit is set, it indicates the selection should not be drawn when the object does not have focus.

Available in Mac OS X v10.0 and later.
kTXNSingleLineOnlyBit

When this bit is set, it indicates that the text object will not scroll vertically. Horizontal scrolling will stop when the end of the text is visible, and there will be no limit to the width of the text. In addition, a line break character typed, pasted, or dropped into the text object will be translated into a hyphen (-).

Available in Mac OS X v10.1 and later.
kTXNDisableDragAndDropBit

When this bit is set, it indicates that drag and drop will not be allowed in the text object.

Available in Mac OS X v10.1 and later.
kTXNUseQDforImagingBit


When this bit is set, it indicates that QuickDraw will be used for imaging instead of the Quartz (CoreGraphics) which is the default. Available in Mac OS X only. (Deprecated. You can no longer set the imaging system to use; MLTE always uses Quartz imaging.)

Available in Mac OS X v10.1 and later.
kTXNMonostyledTextBit

When this bit is set, it indicates that the text object will have a single style no matter what kind of changes are made to the object.

Available in Mac OS X v10.2 and later.*/
enum {
   kTXNDrawGrowIconBit = 0,
   kTXNShowWindowBit = 1,
   kTXNWantHScrollBarBit = 2,
   kTXNWantVScrollBarBit = 3,
   kTXNNoTSMEverBit = 4,
   kTXNReadOnlyBit = 5,
   kTXNNoKeyboardSyncBit = 6,
   kTXNNoSelectionBit = 7,
   kTXNSaveStylesAsSTYLResourceBit = 8,
   kOutputTextInUnicodeEncodingBit = 9,
   kTXNDoNotInstallDragProcsBit = 10,
   kTXNAlwaysWrapAtViewEdgeBit = 11,
   kTXNDontDrawCaretWhenInactiveBit = 12,
   kTXNDontDrawSelectionWhenInactiveBit = 13,
   kTXNSingleLineOnlyBit = 14,
   kTXNDisableDragAndDropBit = 15,
   kTXNUseQDforImagingBit = 16,
   kTXNMonostyledTextBit = 17
};

/*TXNFrameID

Represents the text frame to which actions should be applied.

typedef UInt32 TXNFrameID;
Discussion

Used in the functions TXNNewObject, TXNActivate, TXNResizeFrame, TXNSetFrameBounds, TXNDragReceiver, and TXNDragTracker. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 TXNFrameID;

/*Frame Option Masks

Represents information about frame behavior (such as whether there are scroll bars and a size box). 

typedef OptionBits TXNFrameOptions;
enum {
   kTXNDrawGrowIconMask = 1L << kTXNDrawGrowIconBit,
   kTXNShowWindowMask = 1L << kTXNShowWindowBit,
   kTXNWantHScrollBarMask = 1L << kTXNWantHScrollBarBit,
   kTXNWantVScrollBarMask = 1L << kTXNWantVScrollBarBit,
   kTXNNoTSMEverMask = 1L << kTXNNoTSMEverBit,
   kTXNReadOnlyMask = 1L << kTXNReadOnlyBit,
   kTXNNoKeyboardSyncMask = 1L << kTXNNoKeyboardSyncBit,
   kTXNNoSelectionMask = 1L << kTXNNoSelectionBit,
   kTXNSaveStylesAsSTYLResourceMask = 1L <<                 kTXNSaveStylesAsSTYLResourceBit,
   kOutputTextInUnicodeEncodingMask = 1L <<             kOutputTextInUnicodeEncodingBit,
   kTXNDoNotInstallDragProcsMask = 1L << kTXNDoNotInstallDragProcsBit,
   kTXNAlwaysWrapAtViewEdgeMask = 1L << kTXNAlwaysWrapAtViewEdgeBit,
   kTXNDontDrawCaretWhenInactiveMask = 1L <<             kTXNDontDrawCaretWhenInactiveBit,
   kTXNDontDrawSelectionWhenInactiveMask = 1L <<             kTXNDontDrawSelectionWhenInactiveBit,
   kTXNSingleLineOnlyMask = 1L << kTXNSingleLineOnlyBit,
   kTXNDisableDragAndDropMask = 1L << kTXNDisableDragAndDropBit,
   kTXNUseQDforImagingMask = 1L << kTXNUseQDforImagingBit,
   kTXNMonostyledTextMask = 1L << kTXNMonostyledTextBit
};
Constants
kTXNDrawGrowIconMask

Use to set or test for the kTXNDrawGrowIconBit bit.

Available in Mac OS X v10.0 and later.
kTXNShowWindowMask

Use to set or test for the kTXNShowWindowBit bit.

Available in Mac OS X v10.0 and later.
kTXNWantHScrollBarMask

Use to set or test for the kTXNWantHScrollBarBit bit.

Available in Mac OS X v10.0 and later.
kTXNWantVScrollBarMask

Use to set or test for the kTXNWantVScrollBarBit bit.

Available in Mac OS X v10.0 and later.
kTXNNoTSMEverMask


Use to set or test for the kTXNNoTSMEverBit bit. (Deprecated. You can no longer set this because in Mac OS X, MLTE always uses the Text Services Manager.)

Available in Mac OS X v10.0 and later.
kTXNReadOnlyMask

Use to set or test for the kTXNReadOnlyBit bit.

Available in Mac OS X v10.0 and later.
kTXNNoKeyboardSyncMask

Use to set or test for the kTXNNoKeyboardSyncBit bit.

Available in Mac OS X v10.0 and later.
kTXNNoSelectionMask

Use to set or test for the kTXNNoSelectionBit bit.

Available in Mac OS X v10.0 and later.
kTXNSaveStylesAsSTYLResourceMask

Use to set or test for the kTXNXNSaveStylesAsSTYLResourceBit bit.

Available in Mac OS X v10.0 and later.
kOutputTextInUnicodeEncodingMask

Use to set or test for the kOutputTextInUnicodeEncodingBit bit.

Available in Mac OS X v10.0 and later.
kTXNDoNotInstallDragProcsMask

Use to set or test for the kTXNDoNotInstallDragProcsBit bit.

Available in Mac OS X v10.0 and later.
kTXNAlwaysWrapAtViewEdgeMask

Use to set or test for the kTXNAlwaysWrapAtViewEdgeBit bit.

Available in Mac OS X v10.0 and later.
kTXNDontDrawCaretWhenInactiveMask


Use to set or test for the kTXNDontDrawCaretWhenInactiveBit bit. (Deprecated. In Mac OS Xv10.4 and later, MLTE never draws the caret when the text object does not have focus.)

Available in Mac OS X v10.0 and later.
kTXNDontDrawSelectionWhenInactiveMask

Use to set or test for the kTXNDontDrawSelectionWhenInactiveBit bit.

Available in Mac OS X v10.0 and later.
kTXNSingleLineOnlyMask

Use to set or test for the kTXNSingleLineOnlyBit bit.

Available in Mac OS X v10.1 and later.
kTXNDisableDragAndDropMask

Use to set or test for the kTXNDisableDragAndDropBit bit.

Available in Mac OS X v10.1 and later.
kTXNUseQDforImagingMask


Use to set or test for the kTXNUseQDforImagingBit bit. (Deprecated. You can no longer set the imaging system; MLTE always uses Quartz imaging.)

Available in Mac OS X v10.1 and later.
kTXNMonostyledTextMask

Use to set or test for the kTXNMonostyledTextBit bit.

Available in Mac OS X v10.2 and later.
Discussion

See Frame Option Bits.*/
typedef OptionBits TXNFrameOptions;
enum {
   kTXNDrawGrowIconMask = 1L << kTXNDrawGrowIconBit,
   kTXNShowWindowMask = 1L << kTXNShowWindowBit,
   kTXNWantHScrollBarMask = 1L << kTXNWantHScrollBarBit,
   kTXNWantVScrollBarMask = 1L << kTXNWantVScrollBarBit,
   kTXNNoTSMEverMask = 1L << kTXNNoTSMEverBit,
   kTXNReadOnlyMask = 1L << kTXNReadOnlyBit,
   kTXNNoKeyboardSyncMask = 1L << kTXNNoKeyboardSyncBit,
   kTXNNoSelectionMask = 1L << kTXNNoSelectionBit,
   kTXNSaveStylesAsSTYLResourceMask = 1L <<                 kTXNSaveStylesAsSTYLResourceBit,
   kOutputTextInUnicodeEncodingMask = 1L <<             kOutputTextInUnicodeEncodingBit,
   kTXNDoNotInstallDragProcsMask = 1L << kTXNDoNotInstallDragProcsBit,
   kTXNAlwaysWrapAtViewEdgeMask = 1L << kTXNAlwaysWrapAtViewEdgeBit,
   kTXNDontDrawCaretWhenInactiveMask = 1L <<             kTXNDontDrawCaretWhenInactiveBit,
   kTXNDontDrawSelectionWhenInactiveMask = 1L <<             kTXNDontDrawSelectionWhenInactiveBit,
   kTXNSingleLineOnlyMask = 1L << kTXNSingleLineOnlyBit,
   kTXNDisableDragAndDropMask = 1L << kTXNDisableDragAndDropBit,
   kTXNUseQDforImagingMask = 1L << kTXNUseQDforImagingBit,
   kTXNMonostyledTextMask = 1L << kTXNMonostyledTextBit
};



/*TXNObjectRefCon

Contains data specific to your application. (Deprecated. Used only in the TXNNewObject function, which is deprecated.)

typedef void * TXNObjectRefCon;*/
typedef void * TXNObjectRefcon;



/*Supported File Types

Represents a file type.

typedef OSType TXNFileType;
enum {
   kTXNTextensionFile = 'txtn',
   kTXNTextFile = 'TEXT',
   kTXNPictureFile = 'PICT',
   kTXNMovieFile = 'MooV',
   kTXNSoundFile = 'sfil',
   kTXNAIFFFile = 'AIFF',
   kTXNUnicodeTextFile = 'utxt'
};
Constants
kTXNTextensionFile

A file that contains Unicode or Mac OS text. By default, it contains Unicode text. Files are saved in a private format.

Available in Mac OS X v10.0 and later.
kTXNTextFile

A file that contains plain text data. 

Available in Mac OS X v10.0 and later.
kTXNPictureFile

A file that contains graphics data in PICT format.

Available in Mac OS X v10.0 and later.
kTXNMovieFile

A file that contains movie data in 'MooV' format.

Available in Mac OS X v10.0 and later.
kTXNSoundFile

A file that contains sound data in 'sfil' format.

Available in Mac OS X v10.0 and later.
kTXNAIFFFile

A file that contains sound data in 'aiff' format.

Available in Mac OS X v10.0 and later.
kTXNUnicodeTextFile

A file that contains Unicode text data.

Available in Mac OS X v10.0 and later.*/
typedef OSType TXNFileType;
enum {
   kTXNTextensionFile = 'txtn',
   kTXNTextFile = 'TEXT',
   kTXNPictureFile = 'PICT',
   kTXNMovieFile = 'MooV',
   kTXNSoundFile = 'sfil',
   kTXNAIFFFile = 'AIFF',
   kTXNUnicodeTextFile = 'utxt'
};

/*Text Encoding Preferences

Represents how to encode text for your application.

typedef UInt32 TXNPermanentTextEncodingType;
enum {
   kTXNSystemDefaultEncoding = 0,
   kTXNMacOSEncoding = 1,
   kTXNUnicodeEncoding = 2
};
Constants
kTXNSystemDefaultEncoding

Use the encoding that is used internally by MLTE and the system. The preferred encoding is Unicode for a system that has ATSUI.

Available in Mac OS X v10.0 and later.
kTXNMacOSEncoding

Incoming and outgoing text should be in traditional Mac OS script system encodings even if MLTE uses another format internally. MLTE will use the Text Encoding Convertor (TEC) to convert text and offsets to match your application’s preference.

Available in Mac OS X v10.0 and later.
kTXNUnicodeEncoding

Incoming and outgoing text should be in Unicode even on systems that do not have ATSUI. MLTE will use the Text Encoding Convertor (TEC) to convert text and offsets to match the applications preference.

Available in Mac OS X v10.0 and later.
Discussion

These convenience constants can be used in the functions TXNNewObject and TXNSave.*/
typedef UInt32 TXNPermanentTextEncodingType;
enum {
   kTXNSystemDefaultEncoding = 0,
   kTXNMacOSEncoding = 1,
   kTXNUnicodeEncoding = 2
};

/*TXNNewObject

Creates a new MLTE text object which is an opaque structure that handles text formatting at the document level. (Deprecated in Mac OS X v10.3. Use TXNCreateObject instead.)

Not recommended.

OSStatus TXNNewObject (
   const FSSpec *iFileSpec,
   WindowRef iWindow,
   const Rect *iFrame,
   TXNFrameOptions iFrameOptions,
   TXNFrameType iFrameType,
   TXNFileType iFileType,
   TXNPermanentTextEncodingType iPermanentEncoding,
   TXNObject *oTXNObject,
   TXNFrameID *oTXNFrameID,
   TXNObjectRefcon iRefCon
);
Parameters
iFileSpec

A pointer to a variable of type FSSpec. If you pass NULL you start with an empty document. Otherwise, the contents of the file to which iFileSpec points are read into the object. The referenced file must consist entirely of data that MLTE can read ('TEXT', 'RTF ', 'utxt', or 'txtn'). If the referenced file contains your application’s private data and data that MLTE can read, you should call the TXNNewObject function with the iFileSpec parameter set to NULL. Once TXNNewObject creates the text object, your application can read the private data into the text object by calling the TXNSetDataFromFile function. 
iWindow

A reference to the window in which the document will be displayed. This parameter can be NULL. If it is NULL, you must attach a window or graphics port to the text object by using the TXNAttachObjectToWindow function. 
iFrame

A pointer to a variable of type Rect. If you pass NULL, the window’s portRect rectangle is used as the frame. If you do not want to fill the entire window, you use the iFrame parameter to specify the area to fill. 
iFrameOptions

A value that specifies the options you want the frame to support. See Frame Option Masks for a description of possible values. 

If you want to create a read-only document, you need to pass the option kTXNReadOnlyMask. Note that this option puts the text object into a state that does not allow user input. However, your application can put data into the text object by calling the function TXNSetData. If you want the text object set into a more restrictive read-only state that does not allow user input or your application to put data into the text object programmatically, you need to call the function TXNSetTXNObjectControls, passing the tag kTXNIOPrivilegesTag. If you choose to set the text object into this restrictive state, you will get an error if you try to call the function TXNSetData on the text object. (In this case, you can change the text object to a less restrictive state by calling TXNSetTXNObjectControls, passing the tag kTXNNoUserIOTag.)
iFrameType

A value that specifies the frame type of the text object. See Supported Frame Types for a description of possible values. 
iFileType

A value that specifies the file type of the text object. See Supported File Types for a description of possible values. You should specify the primary file type. If you use the kTXNTextensionFile constant, files are saved in a custom format. If you want saved files to be plain text files, you should specify the kTXNTextFile constant, then use the iframeOptions parameter to specify whether the plain text files should be saved with kTXNSingleStylePerTextDocumentResType or kTXNMultipleStylesPerTextDocumentResType resources. 
iPermanentEncoding

A value that specifies the encoding in which the document is saved. See Text Encoding Preferences for a description of possible values. 
oTXNObject

A pointer to a structure of type TXNObject. On return, this points to the opaque text object data structure allocated by the function. You need to pass this object to most MLTE functions. 
oTXNFrameID

On return, a pointer to the unique ID for the text object’s frame. However, in MLTE version 1.1 and earlier, the frame ID is always set to 0. 
iRefCon

A value of type TXNObjectRefcon. You can define how to use this for your application. You can set this to any value and retrieve it later. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

For each document, a new text object is allocated by the TXNNewObject function and returned in the oTXNObject parameter. The object is allocated only if no errors occur, including errors that may occur when reading a file. If there is an error during the allocation process, MLTE frees the text object. 

If you are writing a text editing application, you may want to call the TXNNewObject function when the application launches (a new document will be displayed) and whenever the user selects New from the File menu. 

Many MLTE functions require you to pass a text object; some functions also require the frame ID supplied back to your application in the oTXNFrameID parameter of TXNNewObject.

Because of how MLTE uses Carbon events internally, the window in which the document is displayed must have the standard event handlers installed. You can do this in one of the following ways:
When you create the window, add the attribute kWindowStandardHandlerAttribute to the window. See Inside Mac OS X: Window Manager Reference for more information.
Call the Carbon Event Manager function InstallStandardEventHandler on the window's event target. See Inside Mac OS X: Handling Carbon Events for more information.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
MacTextEditor.h*/
OSStatus TXNNewObject (
   const FSSpec *iFileSpec,
   WindowRef iWindow,
   const Rect *iFrame,
   TXNFrameOptions iFrameOptions,
   TXNFrameType iFrameType,
   TXNFileType iFileType,
   TXNPermanentTextEncodingType iPermanentEncoding,
   TXNObject *oTXNObject,
   TXNFrameID *oTXNFrameID,
   TXNObjectRefcon iRefCon
);

/*TXNRevert

Reverts to the last saved version of a document. 

OSStatus TXNRevert (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the active document. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNRevert function with files that contain only text as well as files that were created using MLTE. If the file was not previously saved, the document reverts to an empty document. To revert to data that is embedded in a private file type, use the TXNSetSelection function to select all of the current data and then use the TXNSetDataFromFile function to read in the old data. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNRevert (
   TXNObject iTXNObject
);

/*TXNPageSetup

Displays the Page Setup dialog for the current default printer and manages changes, such as reformatting the text, in response to page layout changes.

OSStatus TXNPageSetup (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the active document. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPageSetup (
   TXNObject iTXNObject
);

/*TXNPrint

Prints the document so it is formatted to fit the page size selected for the printer. 

OSStatus TXNPrint (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object that identifies the document you want to print. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPrint (
   TXNObject iTXNObject
);

/*TXNGetDataEncoded

Copies the text in a specified range, and if necessary, translates the text to match your application’s preferred encoding. 

OSStatus TXNGetDataEncoded (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   Handle * oDataHandle,
   TXNDataType iEncoding
);
Parameters
iTXNObject

The text object that contains the data you want to copy.
iStartOffset

The absolute offset from which data copying should begin. You can use the TXNGetSelection function to get the absolute offsets of the current selection. 
iEndOffset

The absolute offset at which data copying should end. You can use the TXNGetSelection function to get the absolute offsets of the current selection.
oDataHandle

A pointer to a handle. On return, a handle to the requested data. TXNGetDataEncoded allocates the handle as necessary. Your application must dispose of the handle. If there is no text in the range specified, the returned handle is NULL, and the function returns noErr.
encoding

The type of data to be encoded. See Supported Data Types for a full description of possible values. You should specify either the kTXNTextData or kTXNUnicodeTextData constant. If the iEncoding parameter specifies an encoding different from that used to store the text data internally, the Conversion Manager translates the data to the specified type (text or Unicode). If the iEncoding parameter is not recognized, the data is returned in the current encoding. On systems that do not use ATSUI version 1.1 or later, the current encoding is the Mac OS encoding. Otherwise, the current encoding is Unicode. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNGetDataEncoded (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   Handle * oDataHandle,
   TXNDataType iEncoding
);

/*HITextViewGetTXNObject

Obtains the text object associated with an HITextView.

TXNObject HITextViewGetTXNObject(
   HIViewRef inTextView)
);
Parameters
inTextView

The HITextView associated with the text object you want to retrieve.
Return Value

Returns the text object associated with the given view.
Discussion

You can supply the extracted text object as a parameter to many of the MLTE functions that take a text object as a parameter. However, not all MLTE functions that take a text object can operate on an MLTE object that comes from an HITextView. In general, you cannot use MLTE functions that may alter the geometry of the object or explicitly invoke drawing. If you do, the function returns the result code kTXNDisabledFunctionalityErr. See HITextViewCreate for a list of the functions that return an error if you pass a text object that comes from an HITextView.
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacTextEditor.h*/
TXNObject HITextViewGetTXNObject(
   HIViewRef inTextView);

/*TXNSetData

Replaces a range of data (text, graphics, and so forth).

OSStatus TXNSetData (
   TXNObject iTXNObject,
   TXNDataType iDataType,
   const void * iDataPtr,
   ByteCount iDataSize,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document in which you want to replace data.
iDataType

The type of the replacement data. See Supported Data Types for a description of possible values. 
iDataPtr

A pointer to the data that will replace the data that is in the range specified by the iStartOffset and iEndOffset parameters.
iDataSize

The size of the data (in bytes) to which iDataPtr points.
iStartOffset

The beginning of the range of data to replace. You can use the TXNGetSelection function to get the absolute offsets of the current selection. 
iEndOffset

The end of the range to replace. You can use the TXNGetSelection function to get the absolute offsets of the current selection. If you want to insert text, the ending and starting offsets should be the same value.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

If you have a text object that has word wrap disabled, and you want to avoid horizontal scrolling, you can try the following. After you call the function TXNSetData, call TXNSetSelection with the value of the ending offset set to what it was before you called TXNSetData. Then, call the function TXNShowSelection to scroll the text back into view.

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetData (
   TXNObject iTXNObject,
   TXNDataType iDataType,
   const void * iDataPtr,
   ByteCount iDataSize,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);

/*TXNSetDataFromCFURLRef

Replaces a range of data with the contents of a file. (Deprecated in Mac OS X v10.4. Use TXNReadFromCFURL instead.)

Not recommended.

OSStatus TXNSetDataFromCFURLRef (
   TXNObject   iTXNObject,
   CFURLRef    iURL,
   TXNOffset   iStartOffset,
   TXNOffset   iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document in which you want to replace data. You can either call the function TXNCreateObject to allocate a text object or you can call the function HITextViewGetTXNObject to obtain the text object associated with an HITextView. 
iURL

A reference to the Core Foundation URL that specifies the file which contains the data you want to add to the object. 
iStartOffset

The starting position at which to insert the file into the document. If you want to replace the current selection, set the iStartOffset parameter to kTXNCurrentSelection. If you want to replace the entire document, set the iStartOffset parameter to 0. Offsets in MLTE are always character offsets.
iEndOffset

The ending position of the range being replaced by the file. You can use the TXNGetSelection function to get the absolute offsets of the current selection. Offsets in MLTE are always character offsets.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Your application must open the file and set the iStartOffset parameter to the appropriate value before you call the TXNSetDataFromCFURLRef function. If you want to embed MLTE data within private data or other MLTE data, you must set the file position to the appropriate position.

In the (now deprecated) function TXNNewObject your could pass a file reference and MLTE supported functionality to revert back to the original file reference. When you call the function TXNSetDataFromURLRef, MLTE saves the CFURLRef. If you change the contents of the text object and then call the function TXNRevert, the document reverts to the contents specified by the saved CFURLRef.
Availability
Available in Mac OS X v10.3 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacTextEditor.h*/
OSStatus TXNSetDataFromCFURLRef (
   TXNObject   iTXNObject,
   CFURLRef    iURL,
   TXNOffset   iStartOffset,
   TXNOffset   iEndOffset
);

/*TXNShowSelection

Scrolls the current selection into view.

void TXNShowSelection (
   TXNObject iTXNObject,
   Boolean iShowEnd
);
Parameters
iTXNObject

The text object for the current text area. 
iShowEnd

A Boolean value. If you set this to true, the end of the selection is scrolled into view. Otherwise, the beginning of the selection is scrolled into view. 
Discussion

You can use this to scroll text into view after you have called the TXNFind function and the matching text is not in the current view of the text object. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNShowSelection (
   TXNObject iTXNObject,
   Boolean iShowEnd
);

/*TXNSetSelection

Specifies the selection range or the position of the insertion point. 

OSStatus TXNSetSelection (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document for which you want to set the selection range or insertion point position. 
iStartOffset

The new starting offset. Offset values are character offsets. 
iEndOffset

The new ending offset. Offset values are character offsets.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNSetSelection function to highlight an initial default value in a document, such as a data-entry form, or to position the insertion point at the start of the field where you want the user to enter a value. To position the insertion point, specify the same value for the iStartOffset and iEndOffset parameters. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetSelection (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);