//#include <Cocoa/OpenCocoa.h>kAudio
//#include <mach/boolean.h>
//#include <GNUstepBase/GSObjCRuntime.h>
#ifndef COREAUDIO_H
#define COREAUDIO_H
#endif

#ifndef  COREFOUNDATION_H
 #include <CoreFoundation/CoreFoundation.h>
#endif

#ifndef _TYPES_H
 #include <CoreFoundation/Types.h>
#endif

#ifndef OSTYPES_H
 #include <libkern/OSTypes.h>
#endif

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

//#define false 0 //hys
//#define true 1//hys

/*kIOCDMediaClass


kIOCDMediaClass is the name of the IOCDMedia class.
#define kIOCDMediaClass "IOCDMedia" 
Discussion 

kIOCDMediaClass is the name of the IOCDMedia class.*/
#define kIOCDMediaClass "IOCDMedia"

/*AudioBuffer

Holds a buffer of audio data.

struct AudioBuffer
   {
   UInt32  mNumberChannels;
   UInt32  mDataByteSize;
   void*   mData;
};
typedef struct AudioBuffer  AudioBuffer;
Fields
mNumberChannels

The number of interleaved channels in the buffer.
mDataByteSize

The number of bytes in the buffer pointed at by mData.
mData

A pointer to the buffer of audio data.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CoreAudioTypes.h*/
struct AudioBuffer
   {
   UInt32  mNumberChannels;
   UInt32  mDataByteSize;
   void*   mData;
};
typedef struct AudioBuffer  AudioBuffer;
/*AudioObject


AudioObjectPropertySelector values that apply to all AudioObjects. 
enum { 
    kAudioObjectPropertyClass = 'clas', 
    kAudioObjectPropertyOwner = 'stdv', 
    kAudioObjectPropertyCreator = 'oplg', 
    kAudioObjectPropertyName = 'lnam', 
    kAudioObjectPropertyManufacturer = 'lmak', 
    kAudioObjectPropertyElementName = 'lchn', 
    kAudioObjectPropertyElementCategoryName = 'lccn', 
    kAudioObjectPropertyElementNumberName = 'lcnn', 
    kAudioObjectPropertyOwnedObjects = 'ownd', 
    kAudioObjectPropertyListenerAdded = 'lisa', 
    kAudioObjectPropertyListenerRemoved = 'lisr' 
};  
Constants
kAudioObjectPropertyClass
An AudioClassID that identifies the class of the AudioObject.
kAudioObjectPropertyOwner
An AudioObjectID that identifies the the AudioObject that owns the given AudioObject. Note that all AudioObjects are owned by some other AudioObject. The only exception is the AudioSystemObject, for which the value of this property is kAudioObjectUnknown.
kAudioObjectPropertyCreator
A CFString that contains the bundle ID of the plug-in that instantiated the object.
kAudioObjectPropertyObjectName
A CFString that contains the human readable name of the object. The caller is responsible for releasing the returned CFObject.
kAudioObjectPropertyManufacturer
A CFString that contains the human readable name of the manufacturer of the hardware the AudioObject is a part of. The caller is responsible for releasing the returned CFObject.
kAudioObjectPropertyElementName
A CFString that contains a human readable name for the given element in the given scope. The caller is responsible for releasing the returned CFObject.
kAudioObjectPropertyElementCategoryName
A CFString that contains a human readable name for the category of the given element in the given scope. The caller is responsible for releasing the returned CFObject.
kAudioObjectPropertyElementNumberName
A CFString that contains a human readable name for the number of the given element in the given scope. The caller is responsible for releasing the returned CFObject.
kAudioObjectPropertyOwnedObjects
An array of AudioObjectIDs that represent all the AudioObjects owned by the given object. The qualifier is an array of AudioClassIDs. If it is non-empty, the returned array of AudioObjectIDs will only refer to objects whose class is in the qualifier array or whose is a subclass of one in the qualifier array.
kAudioObjectPropertyListenerAdded
An AudioObjectPropertyAddress indicating the address to which a new listener was added. Note that this property is not for applications to use. Rather, this property is for the HAL shell to notify AudioObjects implemented by an AudioPlugIn when a listener is added.
kAudioObjectPropertyListenerRemoved
An AudioObjectPropertyAddress indicating the address to which a listener was removed. Note that this property is not for applications to use. Rather, this property is for the HAL shell to notify AudioObjects implemented by an AudioPlugIn when a listener is removed.
Discussion 

Property Selectors*/

enum { 
    kAudioObjectPropertyClass = 'clas', 
    kAudioObjectPropertyOwner = 'stdv', 
    kAudioObjectPropertyCreator = 'oplg', 
    kAudioObjectPropertyName = 'lnam', 
    kAudioObjectPropertyManufacturer = 'lmak', 
    kAudioObjectPropertyElementName = 'lchn', 
    kAudioObjectPropertyElementCategoryName = 'lccn', 
    kAudioObjectPropertyElementNumberName = 'lcnn', 
    kAudioObjectPropertyOwnedObjects = 'ownd', 
    kAudioObjectPropertyListenerAdded = 'lisa', 
    kAudioObjectPropertyListenerRemoved = 'lisr' 
};  

/*AudioDevice Properties That Ought To Some Day Be Deprecated


AudioObjectPropertySelector values whose functionality is better provided by other selectors. 
enum { 
    kAudioDevicePropertyDeviceName = 'name',
    kAudioDevicePropertyDeviceNameCFString = kAudioObjectPropertyName, 
    kAudioDevicePropertyDeviceManufacturer = 'makr', 
    kAudioDevicePropertyDeviceManufacturerCFString = kAudioObjectPropertyManufacturer, 
    kAudioDevicePropertyRegisterBufferList = 'rbuf', 
    kAudioDevicePropertyBufferSize = 'bsiz', 
    kAudioDevicePropertyBufferSizeRange = 'bsz#', 
    kAudioDevicePropertyChannelName = 'chnm', 
    kAudioDevicePropertyChannelNameCFString = kAudioObjectPropertyElementName, 
    kAudioDevicePropertyChannelCategoryName = 'ccnm', 
    kAudioDevicePropertyChannelCategoryNameCFString = kAudioObjectPropertyElementCategoryName, 
    kAudioDevicePropertyChannelNumberName = 'cnnm', 
    kAudioDevicePropertyChannelNumberNameCFString = kAudioObjectPropertyElementNumberName, 
    kAudioDevicePropertySupportsMixing = 'mix?', 
    kAudioDevicePropertyStreamFormat = 'sfmt', 
    kAudioDevicePropertyStreamFormats = 'sfm#', 
    kAudioDevicePropertyStreamFormatSupported = 'sfm?', 
    kAudioDevicePropertyStreamFormatMatch = 'sfmm', 
    kAudioDevicePropertyDataSourceNameForID = 'sscn', 
    kAudioDevicePropertyClockSourceNameForID = 'cscn', 
    kAudioDevicePropertyPlayThruDestinationNameForID = 'mddn', 
    kAudioDevicePropertyChannelNominalLineLevelNameForID = 'cnlv' 
};  
Constants
kAudioDevicePropertyDeviceName
A C-string that contains the human readable name of the AudioDevice. (kAudioObjectPropertyName: CFStrings are better for localization.)
kAudioDevicePropertyDeviceNameCFString
A CFStringRef that contains the human readable name of the AudioDevice. The caller is responsible for releasing the returned CFObject. (kAudioObjectPropertyName: This is just another name for the inherited selector.)
kAudioDevicePropertyDeviceManufacturer
A C-string that contains the human readable name of the manufacturer of the AudioDevice. (kAudioObjectPropertyManufacturer: CFStrings are better for localization.)
kAudioDevicePropertyDeviceManufacturerCFString
A CFString that contains the human readable name of the manufacturer of the AudioDevice. The caller is responsible for releasing the returned CFObject. (kAudioObjectPropertyManufacturer: This is just another name for the inherited selector.)
kAudioDevicePropertyRegisterBufferList
This property allows clients to register a fully populated AudioBufferList that matches the topology described by kAudioDevicePropertyStreamConfiguration for doing input using AudioDeviceRead(). The AudioBufferList will be registered with the call the AudioDeviceSetProperty() and will be unregistered with the call to AudioDeviceGetProperty(). If this property isn't implemented by the AudioDevice, it implies that the AudioDevice also doesn't support AudioDeviceRead(). (Aggregate devices make AudioDeviceRead() obsolete for the most part.)
kAudioDevicePropertyBufferSize
A UInt32 containing the size in bytes of the IO buffer for the AudioStream containing the element. (kAudioDevicePropertyBufferFrameSize: with multiple AudioStreams and the requirement that all streams' buffers represent the same amount of time, it doesn't make sense to set the buffer size in bytes since it will be different for each stream.)
kAudioDevicePropertyBufferSizeRange
An AudioValueRange specifying the minimum and maximum bytes size for the IO buffer for the AudioStream containing the given element. (kAudioDevicePropertyBufferFrameSizeRange: see kAudioDevicePropertyBufferSize.)
kAudioDevicePropertyChannelName
A CFString that contains a human readable name for the given element in the given scope. The caller is responsible for releasing the returned CFObject. (kAudioObjectPropertyElementName: CFStrings are better for localization.)
kAudioDevicePropertyChannelNameCFString
A CFString that contains a human readable name for the given element in the given scope. The caller is responsible for releasing the returned CFObject. (kAudioObjectPropertyElementName: This is just another name for the inherited selector.)
kAudioDevicePropertyChannelCategoryName
A CFString that contains a human readable name for the category of the given element in the given scope. The caller is responsible for releasing the returned CFObject. (kAudioObjectPropertyElementCategoryName: CFStrings are better for localization.)
kAudioDevicePropertyChannelCategoryNameCFString
A CFString that contains a human readable name for the category of the given element in the given scope. The caller is responsible for releasing the returned CFObject. (kAudioObjectPropertyElementCategoryName: This is just another name for the inherited selector.)
kAudioDevicePropertyChannelNumberName
A CFString that contains a human readable name for the number of the given element in the given scope. The caller is responsible for releasing the returned CFObject. (kAudioObjectPropertyElementNumberName: CFStrings are better for localization.)
kAudioDevicePropertyChannelNumberNameCFString
A CFString that contains a human readable name for the number of the given element in the given scope. The caller is responsible for releasing the returned CFObject. (kAudioObjectPropertyElementNumberName: This is just another name for the inherited selector.)
kAudioDevicePropertySupportsMixing
A UInt32 where a value of 1 means the AudioDevice supports mixing and a value of 0 means that it doesn't and that all IO is performed in each AudioStream's current physical format. This property is changed indirectly by changing to a format that doesn't support mixing, such as AC-3. (The HAL now vends it's format information with a flag indicating the mixability in order to better support devices with streams that are both mixable and non- mixable.)
kAudioDevicePropertyStreamFormat
An AudioStreamBasicDescription that describes the current data format for the AudioStream that contains the channel referred to by the element number. (kAudioStreamPropertyVirtualFormat: Managing format information is inherently an operation on AudioStreams, rather than AudioDevices. It is confusing for the client to work with formats at the AudioDevice level and has been shown to lead to programming mistakes by clients when working with devices that have multiple streams.)
kAudioDevicePropertyStreamFormats
An array of AudioStreamBasicDescriptions that describe the available data formats for the AudioStream that contains the channel referred to by the element number. (kAudioStreamPropertyAvailableVirtualFormats: Managing format information is inherently an operation on AudioStreams, rather than AudioDevices. It is confusing for the client to work with formats at the AudioDevice level and has been shown to lead to programming mistakes by clients when working with devices that have multiple streams.)
kAudioDevicePropertyStreamFormatSupported
An AudioStreamBasicDescription is passed in to query whether or not the format is supported. A kAudioDeviceUnsupportedFormatError will be returned if the format is not supported and kAudioHardwareNoError will be returned if it is supported. AudioStreamBasicDescription fields set to 0 will be ignored in the query, but otherwise values must match exactly. (kAudioStreamPropertyAvailableVirtualFormats: The proper and most robust way to find a format that the AudioStream can support is to get the list of available formats and look through that rather than using this property.)
kAudioDevicePropertyStreamFormatMatch
An AudioStreamBasicDescription is passed in and the AudioStream will modify it to describe the best match, in the AudioDevice's opinion, for the given format. (kAudioStreamPropertyAvailableVirtualFormats: The proper and most robust way to find a format that the AudioStream can support is to get the list of available formats and look through that rather than using this property.)
kAudioDevicePropertyDataSourceNameForID
This property translates the given data source item ID into a human readable name using an AudioValueTranslation structure. The input data is the UInt32 holding the item ID to be translated and the output data is a buffer to hold the name as a null terminated c-string. (kAudioDevicePropertyDataSourceNameForIDCFString: CFStrings are better for localization.)
kAudioDevicePropertyClockSourceNameForID
This property translates the given clock source item ID into a human readable name using an AudioValueTranslation structure. The input data is the UInt32 holding the item ID to be translated and the output data is a buffer to hold the name as a null terminated c-string. (kAudioDevicePropertyClockSourceNameForIDCFString: CFStrings are better for localization.)
kAudioDevicePropertyPlayThruDestinationNameForID
This property translates the given play through destination item ID into a human readable name using an AudioValueTranslation structure. The input data is the UInt32 holding the item ID to be translated and the output data is a buffer to hold the name as a null terminated c-string. (kAudioDevicePropertyPlayThruDestinationNameForIDCFString: CFStrings are better for localization.)
kAudioDevicePropertyChannelNominalLineLevelNameForID
This property translates the given nominal line level item ID into a human readable name using an AudioValueTranslation structure. The input data is the UInt32 holding the item ID to be translated and the output data is a buffer to hold the name as a null terminated c-string. (kAudioDevicePropertyChannelNominalLineLevelNameForIDCFString: CFStrings are better for localization.)
Discussion 

These selectors are still provided for backward compatibility. The description of the property will indicate in parentheses the better selectors to use and why.*/
enum {
    //kAudioDevicePropertyDeviceName = 'name', 
    kAudioDevicePropertyDeviceNameCFString = kAudioObjectPropertyName, 
    kAudioDevicePropertyDeviceManufacturer = 'makr', 
    kAudioDevicePropertyDeviceManufacturerCFString = kAudioObjectPropertyManufacturer, 
    kAudioDevicePropertyRegisterBufferList = 'rbuf', 
    kAudioDevicePropertyBufferSize = 'bsiz', 
    kAudioDevicePropertyBufferSizeRange = 'bsz#', 
    kAudioDevicePropertyChannelName = 'chnm', 
    kAudioDevicePropertyChannelNameCFString = kAudioObjectPropertyElementName, 
    kAudioDevicePropertyChannelCategoryName = 'ccnm', 
    kAudioDevicePropertyChannelCategoryNameCFString = kAudioObjectPropertyElementCategoryName, 
    kAudioDevicePropertyChannelNumberName = 'cnnm', 
    kAudioDevicePropertyChannelNumberNameCFString = kAudioObjectPropertyElementNumberName, 
    kAudioDevicePropertySupportsMixing = 'mix?', 
    kAudioDevicePropertyStreamFormat = 'sfmt', 
    kAudioDevicePropertyStreamFormats = 'sfm#', 
    kAudioDevicePropertyStreamFormatSupported = 'sfm?', 
    kAudioDevicePropertyStreamFormatMatch = 'sfmm', 
    kAudioDevicePropertyDataSourceNameForID = 'sscn', 
    kAudioDevicePropertyClockSourceNameForID = 'cscn', 
    kAudioDevicePropertyPlayThruDestinationNameForID = 'mddn', 
    kAudioDevicePropertyChannelNominalLineLevelNameForID = 'cnlv' 
};  
#define kAudioDevicePropertyDeviceName  'name' 
/*AudioObject



Various constants related to AudioObjects. 
enum { 
    kAudioObjectPropertyScopeGlobal = 'glob', 
    kAudioObjectPropertyElementMaster = 0UL, 
    kAudioObjectClassID = 'aobj', 
    kAudioObjectClassIDWildcard = '****', 
    kAudioObjectUnknown = 0UL 
};  
Constants
kAudioObjectPropertyScopeGlobal
The AudioObjectPropertyScope for properties that apply to the object as a whole. All AudioObjects have a global scope and for some it is their only scope.
kAudioObjectPropertyElementMaster
The AudioObjectPropertyElement value for properties that apply to the master element or to the entire scope.
kAudioObjectClassID
The AudioClassID that identifies the AudioObject class.
kAudioObjectClassIDWildcard
The wildcard value for AudioClassIDs.
kAudioObjectUnknown
The AudioObjectID for a non-existant AudioObject.
Discussion 

Class Constants*/
enum { 
    kAudioObjectPropertyScopeGlobal = 'glob', 
    kAudioObjectPropertyElementMaster = 0UL, 
    kAudioObjectClassID = 'aobj', 
    kAudioObjectClassIDWildcard = '****', 
    kAudioObjectUnknown = 0UL 
};  

/*AudioDevice


Various constants related to AudioDevices. 
enum { 
    kAudioDevicePropertyScopeInput = 'inpt', 
    kAudioDevicePropertyScopeOutput = 'outp', 
    kAudioDevicePropertyScopePlayThrough = 'ptru', 
    kAudioDeviceClassID = 'adev', 
    kAudioDeviceUnknown = kAudioObjectUnknown 
};  
Constants
kAudioDevicePropertyScopeInput
The AudioObjectPropertyScope for properties that apply to the input signal paths of the AudioDevice.
kAudioDevicePropertyScopeOutput
The AudioObjectPropertyScope for properties that apply to the output signal paths of the AudioDevice.
kAudioDevicePropertyScopePlayThrough
The AudioObjectPropertyScope for properties that apply to the play through signal paths of the AudioDevice.
kAudioDeviceClassID
The AudioClassID that identifies the AudioDevice class.
kAudioDeviceUnknown
The AudioObjectID for a nonexistent AudioObject.
Discussion 

Class Constants*/
enum { 
    kAudioDevicePropertyScopeInput = 'inpt', 
    kAudioDevicePropertyScopeOutput = 'outp', 
    kAudioDevicePropertyScopePlayThrough = 'ptru', 
    kAudioDeviceClassID = 'adev', 
    kAudioDeviceUnknown = kAudioObjectUnknown 
};  

/*AudioSystemObject Properties


AudioObjectPropertySelector values that apply to the AudioSystemObject. 
enum { 
    kAudioHardwarePropertyProcessIsMaster = 'mast', 
    kAudioHardwarePropertyIsInitingOrExiting = 'inot', 
    kAudioHardwarePropertyDevices = 'dev#', 
    kAudioHardwarePropertyDefaultInputDevice = 'dIn ', 
    kAudioHardwarePropertyDefaultOutputDevice = 'dOut', 
    kAudioHardwarePropertyDefaultSystemOutputDevice = 'sOut', 
    kAudioHardwarePropertyDeviceForUID = 'duid', 
    kAudioHardwarePropertySleepingIsAllowed = 'slep', 
    kAudioHardwarePropertyUnloadingIsAllowed = 'unld', 
    kAudioHardwarePropertyHogModeIsAllowed = 'hogr', 
    kAudioHardwarePropertyRunLoop = 'rnlp', 
    kAudioHardwarePropertyPlugInForBundleID = 'pibi' 
};  
Constants
kAudioHardwarePropertyProcessIsMaster
A UInt32 where 1 means that the current process contains the master instance of the HAL. The master instance of the HAL is the only instance in which plug-ins should save/restore their devices' settings.
kAudioHardwarePropertyIsInitingOrExiting
A UInt32 whose value will be non-zero if the HAL is either in the midst of initializing or in the midst of exiting the process.
kAudioHardwarePropertyDevices
An array of the AudioDeviceIDs that represent all the devices currently available to the system.
kAudioHardwarePropertyDefaultInputDevice
The AudioDeviceID of the default input AudioDevice.
kAudioHardwarePropertyDefaultOutputDevice
The AudioDeviceID of the default output AudioDevice.
kAudioHardwarePropertyDefaultOutputDevice
The AudioDeviceID of the output AudioDevice to use for system related sound from the alert sound to digital call progress.
kAudioHardwarePropertyDeviceForUID
Using an AudioValueTranslation structure, this property translates the input CFStringRef containing a UID into the AudioDeviceID that refers to the AudioDevice with that UID. This property will return kAudioDeviceUnknown if the given UID does not match any currently available AudioDevice.
kAudioHardwarePropertySleepingIsAllowed
A UInt32 where 1 means that the process will allow the CPU to idle sleep even if there is audio IO in progress. A 0 means that the CPU will not be allowed to idle sleep. Note that this property won't affect when the CPU is forced to sleep.
kAudioHardwarePropertyUnloadingIsAllowed
A UInt32 where 1 means that this process wants the HAL to unload itself after a period of inactivity where there are no IOProcs and no listeners registered with any AudioObject.
kAudioHardwarePropertyHogModeIsAllowed
A UInt32 where 1 means that this process wants the HAL to automatically take hog mode and 0 means that the HAL should not automatically take hog mode on behalf of the process. Processes that only ever use the default device are the sort of that should set this property's value to 0.
kAudioHardwarePropertyRunLoop
The CFRunLoopRef the HAL is currently attaching all of it's system notification handlers to. By default, the HAL will create and manage it's own thread for this job. Clients can set this property to tell the HAL to use a thread of the client's choosing. The caller is responsible for releasing the returned CFObject.
kAudioHardwarePropertyPlugInForBundleID
Using an AudioValueTranslation structure, this property translates the input CFString containing a bundle ID into the AudioObjectID of the AudioPlugIn that corresponds to it. This property will return kAudioObjectUnkown if the given bundle ID doesn't match any AudioPlugIns.
Discussion 

The AudioSystemObject has one scope, kAudioObjectPropertyScopeGlobal, and only a master element.*/

enum { 
    kAudioHardwarePropertyProcessIsMaster = 'mast', 
    kAudioHardwarePropertyIsInitingOrExiting = 'inot', 
    kAudioHardwarePropertyDevices = 'dev#', 
    kAudioHardwarePropertyDefaultInputDevice = 'dIn ', 
    kAudioHardwarePropertyDefaultOutputDevice = 'dOut', 
    kAudioHardwarePropertyDefaultSystemOutputDevice = 'sOut', 
    kAudioHardwarePropertyDeviceForUID = 'duid', 
    kAudioHardwarePropertySleepingIsAllowed = 'slep', 
    kAudioHardwarePropertyUnloadingIsAllowed = 'unld', 
    kAudioHardwarePropertyHogModeIsAllowed = 'hogr', 
    kAudioHardwarePropertyRunLoop = 'rnlp', 
    kAudioHardwarePropertyPlugInForBundleID = 'pibi' 
};  



/* Error Constants


The error constants unique to the HAL. 
enum { 
    kAudioHardwareNoError = 0, 
    kAudioHardwareNotRunningError = 'stop', 
    kAudioHardwareUnspecifiedError = 'what', 
    kAudioHardwareUnknownPropertyError = 'who?', 
    kAudioHardwareBadPropertySizeError = '!siz', 
    kAudioHardwareIllegalOperationError = 'nope', 
    kAudioHardwareBadObjectError = '!obj', 
    kAudioHardwareBadDeviceError = '!dev', 
    kAudioHardwareBadStreamError = '!str', 
    kAudioHardwareUnsupportedOperationError = 'unop', 
    kAudioDeviceUnsupportedFormatError = '!dat', 
    kAudioDevicePermissionsError = '!hog' 
};  
Constants
kAudioHardwareNoError
The function call completed successfully.
kAudioHardwareNotRunningError
The function call requires that the hardware be running but it isn't.
kAudioHardwareUnspecifiedError
The function call failed while doing something that doesn't provide any error messages.
kAudioHardwareUnknownPropertyError
The AudioObject doesn't know about the property at the given address.
kAudioHardwareBadPropertySizeError
An improperly sized buffer was provided when accessing the data of a property.
kAudioHardwareIllegalOperationError
The requested operation couldn't be completed.
kAudioHardwareBadObjectError
The AudioObjectID passed to the function doesn't map to a valid AudioObject.
kAudioHardwareBadDeviceError
The AudioDeviceID passed to the function doesn't map to a valid AudioDevice.
kAudioHardwareBadStreamError
The AudioStreamID passed to the function doesn't map to a valid AudioStream.
kAudioHardwareUnsupportedOperationError
The AudioObject doesn't support the requested operation.
kAudioDeviceUnsupportedFormatError
The AudioStream doesn't support the requested format.
kAudioDevicePermissionsError
The requested operation can't be completed because the process doesn't have permission.
Discussion 

These are the error constants that are unique to the HAL. Note that the HAL's functions can and will return other codes that are not listed here. While these constants give a general idea of what might have gone wrong during the execution of an API call, if an API call returns anything other than kAudioHardwareNoError it is to be viewed as the same failure regardless of what constant is actually returned.*/

enum {
    kAudioHardwareNoError = 0, 
    kAudioHardwareNotRunningError = 'stop', 
    kAudioHardwareUnspecifiedError = 'what', 
    kAudioHardwareUnknownPropertyError = 'who?', 
    kAudioHardwareBadPropertySizeError = '!siz', 
    kAudioHardwareIllegalOperationError = 'nope', 
    kAudioHardwareBadObjectError = '!obj', 
    kAudioHardwareBadDeviceError = '!dev', 
    kAudioHardwareBadStreamError = '!str', 
    kAudioHardwareUnsupportedOperationError = 'unop', 
    kAudioDeviceUnsupportedFormatError = '!dat', 
    kAudioDevicePermissionsError = '!hog' 
};

/* AudioDevice Properties


AudioObjectPropertySelector values that apply to AudioDevice objects. 
enum { 
    kAudioDevicePropertyPlugIn = 'plug', 
    kAudioDevicePropertyConfigurationApplication = 'capp', 
    kAudioDevicePropertyDeviceUID = 'uid ', 
    kAudioDevicePropertyModelUID = 'muid', 
    kAudioDevicePropertyTransportType = 'tran', 
    kAudioDevicePropertyRelatedDevices = 'akin', 
    kAudioDevicePropertyClockDomain = 'clkd', 
    kAudioDevicePropertyDeviceIsAlive = 'livn', 
    kAudioDevicePropertyDeviceHasChanged = 'diff', 
    kAudioDevicePropertyDeviceIsRunning = 'goin', 
    kAudioDevicePropertyDeviceIsRunningSomewhere = 'gone', 
    kAudioDevicePropertyDeviceCanBeDefaultDevice = 'dflt', 
    kAudioDevicePropertyDeviceCanBeDefaultSystemDevice = 'sflt', 
    kAudioDeviceProcessorOverload = 'over', 
    kAudioDevicePropertyHogMode = 'oink', 
    kAudioDevicePropertyLatency = 'ltnc', 
    kAudioDevicePropertyBufferFrameSize = 'fsiz', 
    kAudioDevicePropertyBufferFrameSizeRange = 'fsz#', 
    kAudioDevicePropertyUsesVariableBufferFrameSizes = 'vfsz', 
    kAudioDevicePropertyStreams = 'stm#', 
    kAudioDevicePropertySafetyOffset = 'saft', 
    kAudioDevicePropertyIOCycleUsage = 'ncyc', 
    kAudioDevicePropertyStreamConfiguration = 'slay', 
    kAudioDevicePropertyIOProcStreamUsage = 'suse', 
    kAudioDevicePropertyPreferredChannelsForStereo = 'dch2', 
    kAudioDevicePropertyPreferredChannelLayout = 'srnd', 
    kAudioDevicePropertyNominalSampleRate = 'nsrt', 
    kAudioDevicePropertyAvailableNominalSampleRates = 'nsr#', 
    kAudioDevicePropertyActualSampleRate = 'asrt' 
};  
Constants
kAudioDevicePropertyPlugIn
An OSStatus that contains any error codes generated by loading the IOAudio driver plug-in for the AudioDevice or kAudioHardwareNoError if the plug-in loaded successfully. This property only exists for IOAudio-based AudioDevices whose driver has specified a plug-in to load.
kAudioDevicePropertyConfigurationApplication
A CFString that contains the bundle ID for an application that provides a GUI for configuring the AudioDevice. By default, the value of this property is the bundle ID for Audio MIDI Setup. The caller is responsible for releasing the returned CFObject.
kAudioDevicePropertyDeviceUID
A CFString that contains a persistent identifier for the AudioDevice. An AudioDevice's UID is persistent across boots. The content of the UID string is a black box and may contain information that is unique to a particular instance of an AudioDevice's hardware or unique to the CPU. Therefore they are not suitable for passing between CPUs or for identifying similar models of hardware.
kAudioDevicePropertyModelUID
A CFString that contains a persistent identifier for the model of an AudioDevice. The identifier is unique such that the identifier from two AudioDevices are equal if and only if the two AudioDevices are the exact same model from the same manufacturer. Further, the identifier has to be the same no matter on what machine the AudioDevice appears.
kAudioDevicePropertyTransportType
A UInt32 whose value indicates how the AudioDevice is connected to the CPU. Constants for some of the values for this property can be found in .
kAudioDevicePropertyRelatedDevices
An array of AudioDeviceIDs for devices related to the AudioDevice. For IOAudio-based devices, a AudioDevices are related if they share the same IOAudioDevice object.
kAudioDevicePropertyClockDomain
A UInt32 whose value indicates the clock domain to which this AudioDevice belongs. AudioDevices that have the same value for this property are able to be synchronized in hardware. However, a value of 0 indicates that the clock domain for the device is unspecified and should be assumed to be separate from every other device's clock domain, even if they have the value of 0 as their clock domain as well.
kAudioDevicePropertyDeviceIsAlive
A UInt32 where a value of 1 means the device is ready and available and 0 means the device is usable and will most likely go away shortly.
kAudioDevicePropertyDeviceHasChanged
The type of this property is a UInt32, but it's value has no meaning. This property exists so that clients can listen to it and be told when the configuration of the AudioDevice has changed in ways that cannot otherwise be conveyed through other notifications. In response to this notification, clients should re-evaluate everything they need to know about the device, particularly the layout and values of the controls.
kAudioDevicePropertyDeviceIsRunning
A UInt32 where a value of 0 means the AudioDevice is not performing IO and a value of 1 means that it is. Note that the device can be running even if there are no active IOProcs such as by calling AudioDeviceStart() and passing a NULL IOProc. Note that the notification for this property is usually sent from the AudioDevice's IO thread.
kAudioDevicePropertyDeviceIsRunningSomewhere
A UInt32 where 1 means that the AudioDevice is running in at least one process on the system and 0 means that it isn't running at all.
kAudioDevicePropertyDeviceCanBeDefaultDevice
A UInt32 where 1 means that the AudioDevice is a possible selection for kAudioHardwarePropertyDefaultInputDevice or kAudioHardwarePropertyDefaultOutputDevice depending on the scope.
kAudioDevicePropertyDeviceCanBeDefaultSystemDevice
A UInt32 where 1 means that the AudioDevice is a possible selection for kAudioHardwarePropertyDefaultSystemOutputDevice.
kAudioDeviceProcessorOverload
A UInt32 where the value has no meaning. This property exists so that clients can be notified when the AudioDevice detects that an IO cycle has run past it's deadline. Note that the notification for this property is usually sent from the AudioDevice's IO thread.
kAudioDevicePropertyHogMode
A pid_t indicating the process that currently owns exclusive access to the AudioDevice or a value of -1 indicating that the device is currently available to all processes. If the AudioDevice is in a non-mixable mode, the HAL will automatically take hog mode on behalf of the first process to start an IOProc.
kAudioDevicePropertyLatency
A UInt32 containing the number of frames of latency in the AudioDevice. Note that input and output latency may differ. Further, the AudioDevice's AudioStreams may have additional latency so they should be queried as well. If both the device and the stream say they have latency, then the total latency for the stream is the device latency summed with the stream latency.
kAudioDevicePropertyBufferFrameSize
A UInt32 whose value indicates the number of frames in the IO buffers.
kAudioDevicePropertyBufferFrameSizeRange
An AudioValueRange indicating the minimum and maximum values, inclusive, for kAudioDevicePropertyBufferFrameSize.
kAudioDevicePropertyUsesVariableBufferFrameSizes
A UInt32 that, if implemented by a device, indicates that the sizes of the buffers passed to an IOProc will vary by a small amount. The value of this property will indicate the largest buffer that will be passed and kAudioDevicePropertyBufferFrameSize will indicate the smallest buffer that will get passed to the IOProc. The usage of this property is narrowed to only allow for devices whose buffer sizes vary by small amounts greater than kAudioDevicePropertyBufferFrameSize. It is not intended to be a license for devices to be able to send buffers however they please. Rather, it is intended to allow for hardware whose natural rhythms lead to this necessity.
kAudioDevicePropertyStreams
An array of AudioStreamIDs that represent the AudioStreams of the AudioDevice. Note that if a notification is received for this property, any cached AudioStreamIDs for the device become invalid and need to be re-fetched.
kAudioDevicePropertySafetyOffset
A UInt32 whose value indicates the number for frames in ahead (for output) or behind (for input the current hardware position that is safe to do IO.
kAudioDevicePropertyIOCycleUsage
A Float32 whose range is from 0 to 1. This value indicates how much of the client portion of the IO cycle the process will use. The client portion of the IO cycle is the portion of the cycle in which the device calls the IOProcs so this property does not the apply to the duration of the entire cycle.
kAudioDevicePropertyStreamConfiguration
This property returns the stream configuration of the device in an AudioBufferList (with the buffer pointers set to NULL) which describes the list of streams and the number of channels in each stream. This corresponds to what will be passed into the IOProc.
kAudioDevicePropertyIOProcStreamUsage
An AudioHardwareIOProcStreamUsage structure which details the stream usage of a given IO proc. If a stream is marked as not being used, the given IOProc will see a corresponding NULL buffer pointer in the AudioBufferList passed to it's IO proc. Note that the number of streams detailed in the AudioHardwareIOProcStreamUsage must include all the streams of that direction on the device. Also, when getting the value of the property, one must fill out the mIOProc field of the AudioHardwareIOProcStreamUsage with the address of the of the IOProc whose stream usage is to be retrieved.
kAudioDevicePropertyPreferredChannelsForStereo
An array of two UInt32s, the first for the left channel, the second for the right channel, that indicate the channel numbers to use for stereo IO on the device. The value of this property can be different for input and output and there are no restrictions on the channel numbers that can be used.
kAudioDevicePropertyPreferredChannelLayout
An AudioChannelLayout that indicates how each channel of the AudioDevice should be used.
kAudioDevicePropertyNominalSampleRate
A Float64 that indicates the current nominal sample rate of the AudioDevice.
kAudioDevicePropertyAvailableNominalSampleRates
An array of AudioValueRange structs that indicates the valid ranges for the nominal sample rate of the AudioDevice.
kAudioDevicePropertyActualSampleRate
A Float64 that indicates the current actual sample rate of the AudioDevice as measured by it's time stamps.
Discussion 

AudioDevices have four scopes: kAudioDevicePropertyScopeGlobal, kAudioDevicePropertyScopeInput, kAudioDevicePropertyScopeOutput, and kAudioDevicePropertyScopePlayThrough. They have a master element and an element for each channel in each stream numbered according to the starting channel number of each stream.*/

enum { 
    kAudioDevicePropertyPlugIn = 'plug', 
    kAudioDevicePropertyConfigurationApplication = 'capp', 
    kAudioDevicePropertyDeviceUID = 'uid ', 
    kAudioDevicePropertyModelUID = 'muid', 
    kAudioDevicePropertyTransportType = 'tran', 
    kAudioDevicePropertyRelatedDevices = 'akin', 
    kAudioDevicePropertyClockDomain = 'clkd', 
    kAudioDevicePropertyDeviceIsAlive = 'livn', 
    kAudioDevicePropertyDeviceHasChanged = 'diff', 
    kAudioDevicePropertyDeviceIsRunning = 'goin', 
    kAudioDevicePropertyDeviceIsRunningSomewhere = 'gone', 
    kAudioDevicePropertyDeviceCanBeDefaultDevice = 'dflt', 
    kAudioDevicePropertyDeviceCanBeDefaultSystemDevice = 'sflt', 
    kAudioDeviceProcessorOverload = 'over', 
    kAudioDevicePropertyHogMode = 'oink', 
    kAudioDevicePropertyLatency = 'ltnc', 
    kAudioDevicePropertyBufferFrameSize = 'fsiz', 
    kAudioDevicePropertyBufferFrameSizeRange = 'fsz#', 
    kAudioDevicePropertyUsesVariableBufferFrameSizes = 'vfsz', 
    kAudioDevicePropertyStreams = 'stm#', 
    kAudioDevicePropertySafetyOffset = 'saft', 
    kAudioDevicePropertyIOCycleUsage = 'ncyc', 
    kAudioDevicePropertyStreamConfiguration = 'slay', 
    kAudioDevicePropertyIOProcStreamUsage = 'suse', 
    kAudioDevicePropertyPreferredChannelsForStereo = 'dch2', 
    kAudioDevicePropertyPreferredChannelLayout = 'srnd', 
    kAudioDevicePropertyNominalSampleRate = 'nsrt', 
    kAudioDevicePropertyAvailableNominalSampleRates = 'nsr#', 
    kAudioDevicePropertyActualSampleRate = 'asrt' 
};  


/* AudioObjectID


AudioObject is the base class for all the objects in the HAL. 
typedef UInt32 AudioObjectID;  
Discussion 

AudioObjects have properties and can contain other AudioObjects.*/

typedef UInt32 AudioObjectID; 


/*AudioDeviceID


AudioDevice is the base class for all objects that represent an audio device. 
typedef AudioObjectID AudioDeviceID;  
Discussion 

AudioDevice is a subclass of AudioObject. AudioDevices normally contain AudioStreams and AudioControls, but may contain other things depending on the kind of AudioDevice (e.g. aggregate devices contain other AudioDevices).*/
typedef AudioObjectID AudioDeviceID;  



/*AudioObjectPropertySelector


An AudioObjectPropertySelector is a four char code that identifies, along with the AudioObjectPropertyScope and AudioObjectPropertyElement, a specific piece of information about an AudioObject. 
typedef UInt32 AudioObjectPropertySelector;  
Discussion 

The property selector specifies the general classification of the property such as volume, stream format, latency, etc. Note that each class has a different set of selectors. A subclass inherits it's super class's set of selectors, although it may not implement them all.*/
typedef UInt32 AudioObjectPropertySelector;

/*AudioDevicePropertyID


An AudioDevicePropertyID is an integer that identifies a specific piece of information about the object. 
typedef AudioObjectPropertySelector AudioDevicePropertyID;  */
typedef AudioObjectPropertySelector AudioDevicePropertyID;

/* AudioHardwarePropertyID


An AudioHardwarePropertyID is a integer that identifies a specific piece of information about the AudioSystemObject. 
typedef AudioObjectPropertySelector AudioHardwarePropertyID;  */
typedef AudioObjectPropertySelector AudioHardwarePropertyID;

/*SMPTETime

SMPTE time is a format used to sync audio and video streams, based on video framing.

typedef struct SMPTETime {
UInt64 mCounter;
UInt32 mType;
UInt32 mFlags;
SInt16 mHours;
SInt16 mMinutes;
SInt16 mSeconds;
SInt16 mFrames;
} SMPTETime;
Availability
Available in Mac OS X v10.0 and later.*/

typedef struct SMPTETime {
UInt64 mCounter;
UInt32 mType;
UInt32 mFlags;
SInt16 mHours;
SInt16 mMinutes;
SInt16 mSeconds;
SInt16 mFrames;
} SMPTETime;

/* AudioTimeStamp

Holds different representations of the same time.

struct AudioTimeStamp
   {
   Float64         mSampleTime;
   UInt64          mHostTime;
   Float64         mRateScalar;
   UInt64          mWordClockTime;
   SMPTETime       mSMPTETime;
   UInt32          mFlags;
   UInt32          mReserved;
};
typedef struct AudioTimeStamp   AudioTimeStamp;
Fields
mSampleTime

The absolute sample frame time. 
mHostTime

The host machine's time base (see CoreAudio/HostTime.h). 
mRateScalar

The ratio of actual host ticks per sample frame to the nominal host ticks per sample frame. 
mWordClockTime

The word clock time.
mSMPTETime

The SMPTE time (see SMPTETime).
mFlags

A set of flags indicating which representations of the time are valid; see Audio Time Stamp Flags and Audio Time Stamp Flag Combination Constant.
mReserved

Pads the structure out to force an even 8-byte alignment.
Availability
Available in Mac OS X v10.0 and later.*/
struct AudioTimeStamp
   {
   Float64         mSampleTime;
   UInt64          mHostTime;
   Float64         mRateScalar;
   UInt64          mWordClockTime;
   SMPTETime       mSMPTETime;
   UInt32          mFlags;
   UInt32          mReserved;
};
typedef struct AudioTimeStamp   AudioTimeStamp;

/*(AudioBufferList

Holds a variable length array of AudioBuffer structures.

struct AudioBufferList
   {
   UInt32      mNumberBuffers;
   AudioBuffer mBuffers[kVariableLengthArray];
};
typedef struct AudioBufferList  AudioBufferList;
Fields
mNumberBuffers

The number of AudioBuffer structures in the mBuffers array.
mBuffers

A variable length array of AudioBuffer structures.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CoreAudioTypes.h*/
#define kVariableLengthArray 0
struct AudioBufferList
   {
   UInt32      mNumberBuffers;
   AudioBuffer mBuffers[kVariableLengthArray];
};
typedef struct AudioBufferList  AudioBufferList;

/*AudioDeviceIOProc


An AudioDeviceIOProc is called by an AudioDevice to provide input data read from the device and collect output data to be written to the device for the current IO cycle. 
typedef OSStatus (*AudioDeviceIOProc)(
    AudioDeviceID inDevice, 
    const AudioTimeStamp*inNow, 
    const AudioBufferList*inInputData, 
    const AudioTimeStamp*inInputTime, 
    AudioBufferList*outOutputData, 
    const AudioTimeStamp*inOutputTime, 
    void*inClientData);  
Parameters
inDevice
The AudioDevice doing the IO.
inNow
An AudioTimeStamp that indicates the IO cycle started. Note that this time includes any scheduling latency that may have been incurred waking the thread on which IO is being done.
inInputData
An AudioBufferList containing the input data for the current IO cycle. For streams that are disabled, the AudioBuffer's mData field will be NULL but the mDataByteSize field will still say how much data would have been there if it was enabled. Note that the contents of this structure should never be modified.
inInputTime
An AudioTimeStamp that indicates the time at which the first frame in the data was acquired from the hardware. If the device has no input streams, the time stamp will be zeroed out.
outOutputData
An AudioBufferList in which the output data for the current IO cycle is to be placed. On entry, each AudioBuffer's mDataByteSize field indicates the maximum amount of data that can be placed in the buffer and the buffer's memory has been zeroed out. For formats where the number of bytes per packet can vary (as with AC-3, for example), the client has to fill out on exit each mDataByteSize field in each AudioBuffer with the amount of data that was put in the buffer. Otherwise, the mDataByteSize field should not be changed. For streams that are disabled, the AudioBuffer's mData field will be NULL but the mDataByteSize field will still say how much data would have been there if it was enabled. Except as noted above, the contents of this structure should not other wise be modified.
inOutputTime
An AudioTimeStamp that indicates the time at which the first frame in the data will be passed to the hardware. If the device has no output streams, the time stamp will be zeroed out.
inClientData
A pointer to client data established when the AudioDeviceIOProc was registered with the AudioDevice.
Return Value

The return value is currently unused and should always be 0.*/
typedef OSStatus (*AudioDeviceIOProc)(
    AudioDeviceID inDevice, 
    const AudioTimeStamp *inNow, 
    const AudioBufferList *inInputData, 
    const AudioTimeStamp *inInputTime, 
    AudioBufferList *outOutputData, 
    const AudioTimeStamp *inOutputTime, 
    void*inClientData);  






/* AudioValueRange

Holds a pair of numbers that represent a continuous range of values.

struct AudioValueRange
   {
   Float64 mMinimum;
   Float64 mMaximum;
};
typedef struct AudioValueRange AudioValueRange;
Fields
mMinimum

The minimum value.
mMaximum

The maximum value.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreAudioTypes.h*/
struct AudioValueRange
   {
   Float64 mMinimum;
   Float64 mMaximum;
};
typedef struct AudioValueRange AudioValueRange;





/*AudioStreamBasicDescription

Encapsulates all the information for describing the basic format properties of a stream of audio data.

struct AudioStreamBasicDescription
   {
   Float64 mSampleRate;
   UInt32  mFormatID;
   UInt32  mFormatFlags;
   UInt32  mBytesPerPacket;
   UInt32  mFramesPerPacket;
   UInt32  mBytesPerFrame;
   UInt32  mChannelsPerFrame;
   UInt32  mBitsPerChannel;
   UInt32  mReserved;
};
typedef struct AudioStreamBasicDescription  AudioStreamBasicDescription;
Fields
mSampleRate

The number of sample frames per second of the data in the stream. For compressed formats, this field indicates the number of sample frames per second of decompressed data. You can combine this value with the frames per packet to determine the amount of time represented by a packet. This value must be nonzero, except when this structure is used in a listing of supported formats (see AudioStreamBasicDescription Constant).
mFormatID

A four character code indicating the general kind of data in the stream. See Audio Data Format IDs. This value must be nonzero.
mFormatFlags

Flags specific to each format, if any. My be set to 0 to indicate no format flags. See Audio Data Format IDs for the types of flags used with each data type.
mBytesPerPacket

The number of bytes in a packet of data. For formats with a variable packet size, this field is set to 0. In that case, the size of each packet is specified by an AudioStreamPacketDescription structure. 
mFramesPerPacket

The number of sample frames in each packet of data. For compressed formats, this field indicates the number of frames encoded in each packet. For formats with a variable number of frames per packet, this field is set to 0 and the packet is described by an AudioStreamPacketDescription structure. 
mBytesPerFrame

The number of bytes in a single sample frame of data. This field is set to 0 if the data format (for instance any compressed format) does not contain separate samples for each channel. 
mChannelsPerFrame

The number of channels in each frame of data. This value must be nonzero.
mBitsPerChannel

The number of bits of sample data for each channel in a frame of data. This field is set to 0 if the data format (for instance any compressed format) does not contain separate samples for each channel.
mReserved

Pads the structure out to force an even 8-byte alignment.
Discussion

This structure is sufficient to describe any constant bit rate format that has channels that are the same size. For variable bit rate data and for constant bit rate data where the channels have unequal sizes, each packet must additionally be described by an AudioStreamPacketDescription structure. In all fields, a value of 0 indicates that the field is either unknown, not applicable, or otherwise is inappropriate for the format and should be ignored. 

For the purposes of this data structure, the following definitions apply: 
A sample is one data value (that is, one number) for one channel of digitized audio data. 
A frame is a set of samples that includes one sample for each channel. The samples in a frame are intended to be played together (that is, simultaneously). (Note that this definition might be different from the use of the term frame by codecs, video files, and audio or video processing applications.) In non-interleaved audio, the per-frame fields in the structure apply to one channel. In interleaved audio, the per-frame fields apply to the set of n channels. 
A packet is the smallest, indivisible block of data. In uncompressed audio, each packet contains exactly one frame. In compressed audio, the number of frames in a packet depends on the encoding. For example, an AAC packet contains 1024 sample frames. In some formats, the number of frames per packet varies. 
The sample rate is the number of complete frames of samples per second of noncompressed or decompressed data.

Typically, the fields of an AudioStreamBasicDescription structure describe the complete layout of the sample data in data buffers represented by AudioBuffer structures that are contained in an AudioBufferList structure.

When an AudioStreamBasicDescription structure has the kAudioFormatFlagIsNonInterleaved flag set, however, the AudioBufferList structure is used in a different way. In this case, each AudioBuffer structure in the list contains a single (mono) channel of audio data and the AudioStreamBasicDescription structure fields describe the format of one AudioBuffer structure. The exception to this rule is the AudioStreamBasicDescription structures mChannelsPerFrame field, which indicates the total number of AudioBuffer structures that are contained in the AudioBufferList. This data format is used primarily by audio units and audio converters. It is not used by audio hardware.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CoreAudioTypes.h*/
struct AudioStreamBasicDescription
   {
   Float64 mSampleRate;
   UInt32  mFormatID;
   UInt32  mFormatFlags;
   UInt32  mBytesPerPacket;
   UInt32  mFramesPerPacket;
   UInt32  mBytesPerFrame;
   UInt32  mChannelsPerFrame;
   UInt32  mBitsPerChannel;
   UInt32  mReserved;
};
typedef struct AudioStreamBasicDescription  AudioStreamBasicDescription;
    
///////////////////
#define kAudioFormatLinearPCM 1 // hys
#define kLinearPCMFormatFlagIsPacked 1 // hys
#define kLinearPCMFormatFlagIsSignedInteger 1 // hys
