#ifndef MACMEMORY_H
#define MACMEMORY_H
#endif

/*DisposeHandle

Releases memory occupied by a relocatable block.

void DisposeHandle (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The DisposeHandle function releases the memory occupied by the relocatable block whose handle is h. It also frees the handles master pointer for other uses.

Do not use DisposeHandle to dispose of a handle obtained from the Resource Manager (for example, by a previous call to GetResource), use ReleaseResource instead. If, however, you have called DetachResource on a resource handle, you should dispose of the storage by calling DisposeHandle.

Call the function MemError to get the result code. See Memory Manager Result Codes.
Special Considerations

After a call to DisposeHandle, all handles to the released block become invalid and should not be used again. Any subsequent calls to DisposeHandle using an invalid handle might crash your application.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void DisposeHandle (
   Handle h
);

/*BlockZero


void BlockZero (
   void * destPtr,
   Size byteCount
);
Parameters
destPtr
byteCount
Special Considerations

Beginning in Mac OS X v10.4, the BlockZero function is inlined to a direct call to the POSIX bzero function. For more information, see the header file MacMemory.h.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void BlockZero (
   void * destPtr,
   Size byteCount
);

/*NewHandle

Allocates a new relocatable memory block of a specified size in the current heap zone.

Handle NewHandle (
   Size byteCount
);
Parameters
byteCount

The requested size, in bytes, of the relocatable block. Maximum size is 2 GB, the maximum size for variables of type Size.
Return Value

A handle to the new block. If NewHandle cannot allocate a block of the requested size, it returns NULL. 
Discussion

The NewHandle function pursues all available avenues to create a block of the requested size, including compacting the heap zone, increasing its size, and purging blocks from it. If all of these techniques fail and the heap zone has a grow-zone function installed, NewHandle calls the function. Then NewHandle tries again to free the necessary amount of memory, once more compacting and purging the heap zone if necessary. If NewHandle still cannot allocate memory, NewHandle calls the grow-zone function again, unless that function had returned 0, in which case NewHandle gives up and returns NULL.

If the NewHandle function succeeds in creating the requested block, this new block is unlocked and unpurgeable.

If you allocate a relocatable block that you plan to lock for long periods of time, you can prevent heap fragmentation by allocating the block as low as possible in the heap zone. To do this, see the description of the function ReserveMem.

If you plan to lock a relocatable block for short periods of time, you might want to move it to the top of the heap zone to prevent heap fragmentation. For more information, see the description of the function MoveHHi.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because NewHandle allocates memory, you should not call it at interrupt time.

Do not try to manufacture your own handles without this function by simply assigning the address of a variable of type Ptr to a variable of type Handle. The resulting “fake handle” would not reference a relocatable block and could cause a system crash. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Handle NewHandle (
   Size byteCount
);

/*GetHandleSize

Returns the logical size of the relocatable block corresponding to a handle.

Size GetHandleSize (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Return Value

The logical size, in bytes, of the relocatable block whose handle is h. In case of error, the function return 0. 
Discussion

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

You should not call GetHandleSize at interrupt time because the heap might be in an inconsistent state. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Size GetHandleSize (
   Handle h
);