// RecogMain.h: interface for the CRecogMain class.
//
//////////////////////////////////////////////////////////////////////


#include "RecogCore.h"
#include "JamoBTWBNCore.h"
#include "JamoBoundBNCore.h"
#include "PreProcess.h"
class CRecogMain 
{

//Attributes
private:
	WORD				*m_Code;
	int					m_CodeNum;
	
	CJamoBNCore			m_JamoBNCore;
	CJamoBTWBNCore		m_BTWBNCore;
	CJamoBoundBNCore	m_BoundBNCore;
	
	int					CJZBNNum[3];
	JAMOBN				*m_JamoBN[3];
	JamoBTWBN			*m_JamoBTWBN[2];
	JamoBoundBN			*m_JamoBoundBN;
	
	int					SymBNNum;
	JAMOBN				*m_SymbolBN;
	
	HuboPath			m_CJZPath[MAXSAMNUM];
	REC_POINT			m_pNRtPts[H1*W1];
	
	int					m_pSelNo[H1*W1];
	int					m_pSamProp[H1*W1];
	
public:
	HuboAry				m_Hubo;
	CPreProcess			m_PreProcess;

//Methods
private:
	RECT	GetBoundingBox(REC_POINT *pPt, int PtNum,int RealSt,int RealEd);
	void	SortingHuboAry();

	WORD	RecogKorean(REC_POINT* pPts,int* pSamProp,int* pSamNo,int SamNum);
	void	RecogChoSung(REC_POINT* pPts,int* pSamProp,int* pSamNo,int CurNo);
	void	RecogJungSung(REC_POINT* pPts,int* pSamProp,int* pSamNo,int st,int ed);
	void	RecogCho2Jung(REC_POINT* pPts,int *pSamProp,int* pSamNo,int st,int ed);
	void	RecogJung2Zong(REC_POINT* pPts,int *pSamProp,int* pSamNo,int st,int ed);
	void	FinalRecogJungSung(REC_POINT* pPts,int* pSamProp,int* pSamNo,int st,int ed);
	void	FinalRecogZongSung(REC_POINT* pPts,int* pSamProp,int* pSamNo,int st,int ed);

	void	RecogSymbolCho(REC_POINT* pPts,int* pSamProp,int* pSamNo,int SamNum);
	void	RecogSymbolJung(REC_POINT* pPts,int* pSamProp,int* pSamNo,int SamNum);
	void	RecogSymbolZong(REC_POINT* pPts,int* pSamProp,int* pSamNo,int SamNum);
	void	RecogSymbolDigitAndEng(REC_POINT* pPts,int* pSamProp,int* pSamNo,int SamNum);

	void	EndDIC();

public:
	BOOL	LoadDic(char* szDicPath);
	WORD	Recog(OVR_POINT *pOrgPt, int OrgPtNum,STROKE* pOrgStroke,int nOrgStrkNum);


public:
	CRecogMain();
	virtual ~CRecogMain();


};

