// PreProcess.cpp: implementation of the CPreProcess class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PreProcess.h"
#include <math.h>
#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
#define PI 3.141592f
CPreProcess::CPreProcess()
{

}

CPreProcess::~CPreProcess()
{

}
/*
_____________________________________________________________
  
Լ̸:   GetAngle  -  tangent 

 :  
		
ȯ:	  Ȱ ȯ
		  
Restrictions:   'pGI' must have pixel type unsigned char.
________________________________________________________________
			  
*/
float CPreProcess::GetAngle(OVR_POINT StPt,OVR_POINT EdPt)
{
	int dx = EdPt.nX - StPt.nX;
	int dy = EdPt.nY - StPt.nY;
	if(dx==0){ 
		if(dy>0)
			return PI/2;
		else
			return -PI/2;
	}
	else {
		return (float)atan2((float)dy,(float)dx);
	}

}
//#define GetAngle(s,e) atan2((float)(e.nY-e.nY),(float)(e.nX-s.nX));

/*
_____________________________________________________________
  
Լ̸:   GetPointAryBetweenTwoPoints  -     Ʈ . 

 :  
		
ȯ:	 
		  
Restrictions:   'pGI' must have pixel type unsigned char.
________________________________________________________________
			  
*/

int CPreProcess::GetPointAryBetweenTwoPoints(OVR_POINT P1,OVR_POINT P2,OVR_POINT* PtAry)
{
	int PtNum=0; 

	int i;
	if(P1.nX == P2.nX && P1.nY == P2.nY){
		return PtNum;
	}
	else if(P1.nY==P2.nY){
		if(P1.nX<P2.nX){
			for(i=P1.nX;i<P2.nX;i++){
				PtAry[PtNum].nX = i;PtAry[PtNum++].nY = P1.nY;
			}
		}
		else{
			for(i=P1.nX;i>P2.nX;i--){
				PtAry[PtNum].nX = i;PtAry[PtNum++].nY = P1.nY;
			}
		}
	}
	else if(P1.nX==P2.nX){
		if(P1.nY<P2.nY){
			for(i=P1.nY;i<P2.nY;i++){
				PtAry[PtNum].nX = P1.nX;PtAry[PtNum++].nY = i;
			}
		}
		else{
			for(i=P1.nY;i>P2.nY;i--){
				PtAry[PtNum].nX = P1.nX;PtAry[PtNum++].nY = i;
			}
		}
	}
	else{
		double ta;
		int y,x;
		int dx = abs(P1.nX-P2.nX);
		int dy = abs(P1.nY-P2.nY);
		if(dx>=dy){
			if(P1.nX<P2.nX){
				ta = (double)(P2.nY-P1.nY)/(double)(P2.nX-P1.nX);
				for(i=P1.nX;i<P2.nX;i++){
					y = (int)(P1.nY+(i-P1.nX)*ta);
					PtAry[PtNum].nX = i;PtAry[PtNum++].nY = y;
				}
			}
			else{
				ta = (double)(P2.nY-P1.nY)/(double)(P1.nX-P2.nX);
				for(i=P1.nX;i>P2.nX;i--){
					y = (int)(P1.nY+(P1.nX-i)*ta);
					PtAry[PtNum].nX = i;PtAry[PtNum++].nY = y;
				}
			}
		}
		else{
			if(P1.nY<P2.nY){
				ta = (double)(P2.nX-P1.nX)/(double)(P2.nY-P1.nY);
				for(i=P1.nY;i<P2.nY;i++){
					x = (int)(P1.nX+(i-P1.nY)*ta);
					PtAry[PtNum].nX = x;PtAry[PtNum++].nY = i;
				}
			}
			else{
				ta = (double)(P2.nX-P1.nX)/(double)(P1.nY-P2.nY);
				for(i=P1.nY;i>P2.nY;i--){
					x = (int)(P1.nX+(P1.nY-i)*ta);
					PtAry[PtNum].nX = x;PtAry[PtNum++].nY = i;
				}
			}
		}
	}
	return PtNum;
}

/*
_____________________________________________________________
  
Լ̸:   GetAllPtArryAndResample  - Էµ Ʈ  Ʈ   ǥȭ

 :  
		
ȯ:	Ʈ 
		  
Restrictions:   'pGI' must have pixel type unsigned char.
______________________________________________________________
			  
*/
OVR_POINT* CPreProcess::GetAllPtArryAndResample(OVR_POINT *pPt, int PtNum,
			STROKE* pStroke,int nStrokeNum,int* pSamPtNo, int& SamPtNum,int& NewPtNum)
{

	OVR_POINT* pNewPt = (OVR_POINT*)malloc(sizeof(OVR_POINT)*H1*W1);
	OVR_POINT* pTempPt = (OVR_POINT*)malloc(sizeof(OVR_POINT)*max(H1,W1));

/////////////// ߰/////////////
	int i,j,l,k,st,ed;
	int gap = 4;
	float ang1,ang2,ang,th = PI/2.0f;
	int pre,n,len;
	SamPtNum = 0;
	NewPtNum = 0;
	for (i=0;i<nStrokeNum;i++) {
		st = pStroke[i].stPtNo;
		ed = pStroke[i].edPtNo;
		pSamPtNo[SamPtNum++] = NewPtNum;
		for(j=st+1;j<=ed;j++){
			l = GetPointAryBetweenTwoPoints(pPt[j-1],pPt[j],pTempPt);
			for(k=0;k<l;k++){
				pNewPt[NewPtNum].nX = pTempPt[k].nX;
				pNewPt[NewPtNum++].nY = pTempPt[k].nY;
			}
	///////////   Ž  ///////////////////////
			if(j==ed)break;
			ang1 = GetAngle(pPt[j-1],pPt[j]);
			ang2 = GetAngle(pPt[j],pPt[j+1]);
			ang1 = (float)fabs(ang1-ang2);
			ang2 = PI*2-ang1;
			ang = min(ang2,ang1);
			if(ang>=PI*0.5f ){
				pre = pSamPtNo[SamPtNum-1];
				len = NewPtNum-pre;
				if(len<=1)continue;
				n = len/gap;
				if(len%gap < gap/2) n--;
				for(k=1;k<=n;k++)	pSamPtNo[SamPtNum++] = pre+gap*k;
				pSamPtNo[SamPtNum++] = NewPtNum;
			}
		}
		pNewPt[NewPtNum].nX = pPt[ed].nX;
		pNewPt[NewPtNum++].nY = pPt[ed].nY;
		pre = pSamPtNo[SamPtNum-1];
		len = NewPtNum-pre-1;
		n = len/gap;
		if(len%gap < gap/2) n--;
		for(k=1;k<=n;k++)	pSamPtNo[SamPtNum++] = pre+gap*k;
		pSamPtNo[SamPtNum++] = NewPtNum-1;

		if(i != nStrokeNum-1){
			st = pStroke[i+1].stPtNo;
			l = GetPointAryBetweenTwoPoints(pPt[ed],pPt[st],pTempPt);
			for(k=1;k<l;k++){
				pNewPt[NewPtNum].nX = pTempPt[k].nX;
				pNewPt[NewPtNum++].nY = pTempPt[k].nY;
			}
		}
	}
	free(pTempPt);
	return pNewPt;
}
/*
_____________________________________________________________
  
Լ̸:   RemoveHookFromOrg  - Էµ Ʈ   

 :  
		
ȯ:	 ŵ Ʈ 
		  
Restrictions:   'pGI' must have pixel type unsigned char.
________________________________________________________________
			  
*/
OVR_POINT* CPreProcess::RemoveHookFromOrg(OVR_POINT *pPt, int PtNum,
			STROKE* pStroke,STROKE* pNewStroke,int nStrokeNum,int& NewPtNum)
{
	OVR_POINT* pNewPt = (OVR_POINT*)malloc(sizeof(OVR_POINT)*PtNum);

/////////////// Hook Remove /////////////
	int i,j,st,ed,newed,newst;
	float ang1,ang2,ang,angB1,angB2;
	int len;
	NewPtNum = 0;
	for (i=0;i<nStrokeNum;i++) {
		st = pStroke[i].stPtNo;
		ed = pStroke[i].edPtNo;
		newed = ed;
		len = (int)((float)(ed-st)*0.8f);
		for(j=ed-1;j>=st+len;j--){
			if(j<=st+2)break;
			ang1 = GetAngle(pPt[j-1],pPt[j]);
			ang2 = GetAngle(pPt[j],pPt[j+1]);
			ang1 = (float)fabs(ang1-ang2);
			ang2 = PI*2-ang1;
			ang = min(ang2,ang1);
			if(ang>=PI*0.4f ){
				ang1 = GetAngle(pPt[j-2],pPt[j-1]);
				ang2 = GetAngle(pPt[j-1],pPt[j]);
				ang1 = (float)fabs(ang1-ang2);
				ang2 = PI*2-ang1;
				angB1 = min(ang2,ang1);
				ang1 = GetAngle(pPt[j-3],pPt[j-2]);
				ang2 = GetAngle(pPt[j-2],pPt[j-1]);
				ang1 = (float)fabs(ang1-ang2);
				ang2 = PI*2-ang1;
				angB2 = min(ang2,ang1);
				angB1 = (angB1+angB2);
				
				if(ang>angB1){
					newed = j;
					break;
				}
			}
		}
		newst = st;
		len = (int)((float)(newed-st)*0.25f);
		for(j=st+1;j<=st+len;j++){
			if(j>=newed-2)break;
			ang1 = GetAngle(pPt[j-1],pPt[j]);
			ang2 = GetAngle(pPt[j],pPt[j+1]);
			ang1 = (float)fabs(ang1-ang2);
			ang2 = PI*2-ang1;
			ang = min(ang2,ang1);
			if(ang>=PI*0.4f ){
				ang1 = GetAngle(pPt[j+2],pPt[j+1]);
				ang2 = GetAngle(pPt[j+1],pPt[j]);
				ang1 = (float)fabs(ang1-ang2);
				ang2 = PI*2-ang1;
				angB1 = min(ang2,ang1);
				ang1 = GetAngle(pPt[j+3],pPt[j+2]);
				ang2 = GetAngle(pPt[j+2],pPt[j+1]);
				ang1 = (float)fabs(ang1-ang2);
				ang2 = PI*2-ang1;
				angB2 = min(ang2,ang1);
				angB1 = (angB1+angB2);
				
				if(ang>angB1){
					newst = j;
					break;
				}
			}
		}
		pNewStroke[i].stPtNo = NewPtNum;
		for(j=newst;j<=newed;j++){
			pNewPt[NewPtNum].nX = pPt[j].nX;
			pNewPt[NewPtNum++].nY = pPt[j].nY;
		}
		pNewStroke[i].edPtNo = NewPtNum-1;
	}
/////////////////////Resampling /////////////
	return pNewPt;
}
/*
_____________________________________________________________
  
Լ̸:   LinearNormalize  - Էµ Ʈ  (H1*W1)ũ ȭ

 :  
		
ȯ: ȭ Ʈ 
		  
Restrictions:   'pGI' must have pixel type unsigned char.
________________________________________________________________
			  
*/
OVR_POINT* CPreProcess::LinearNormalize(OVR_POINT *pOrgPt, int OrgPtNum,
			STROKE* pOrgStroke,STROKE* pNorStroke,int nStrokeNum, int& NorPtNum)
{
	RECT rect = GetBoundingBox(pOrgPt, OrgPtNum);
	int i,j,l,t,x,y,OrgW,OrgH,st,ed;
	OrgW = rect.right - rect.left;
	OrgH = rect.bottom - rect.top;
	l = rect.left;
	t = rect.top;
	float rateW = (float)W1/(float)OrgW;
	float rateH = (float)H1/(float)OrgH;
	
//	OVR_POINT* pNewPt = new OVR_POINT[OrgPtNum];
	OVR_POINT* pNewPt = (OVR_POINT*)malloc(sizeof(OVR_POINT)*OrgPtNum);

	NorPtNum = 0;
	for (i=0;i<nStrokeNum;i++) {
		st = pOrgStroke[i].stPtNo;
		ed = pOrgStroke[i].edPtNo;
		pNorStroke[i].stPtNo = NorPtNum;
		x = (int)(((float)(pOrgPt[st].nX - l) + 0.5f) * rateW);
		y = (int)(((float)(pOrgPt[st].nY - t) + 0.5f) * rateH);
		pNewPt[NorPtNum].nX = x;
		pNewPt[NorPtNum].nY = y;
		NorPtNum++;
		for(j=st+1;j<=ed;j++){
			x = (int)(((float)(pOrgPt[j].nX - l) + 0.5f) * rateW);
			y = (int)(((float)(pOrgPt[j].nY - t) + 0.5f) * rateH);
			if(pNewPt[NorPtNum-1].nX == x && pNewPt[NorPtNum-1].nY == y)continue;
			pNewPt[NorPtNum].nX = x;
			pNewPt[NorPtNum].nY = y;
			NorPtNum++;
		}
		pNorStroke[i].edPtNo = NorPtNum-1;
	}

	return pNewPt;
}
/*
_____________________________________________________________
  
Լ̸:   LinearNormalizeOnlyHorW  - Էµ Ʈ  ʺ ؼ ȭ

 :  
		
ȯ: ȭ Ʈ 
		  
Restrictions:   'pGI' must have pixel type unsigned char.
________________________________________________________________
			  
*/
OVR_POINT*	CPreProcess::LinearNormalizeOnlyHorW(OVR_POINT* pOrgPt,int OrgPtNum,STROKE* pOrgStroke,
			STROKE* pNorStroke,int nStrokeNum, int& NorPtNum)
{
	RECT rect = GetBoundingBox(pOrgPt, OrgPtNum);
	int i,j,l,t,x,y,OrgW,OrgH,st,ed;
	OrgW = rect.right - rect.left;
	OrgH = rect.bottom - rect.top;
	l = rect.left;
	t = rect.top;
	float rate;
	float rateW = (float)W1/(float)OrgW;
	float rateH = (float)H1/(float)OrgH;

	int offx=0,offy=0;
	if(rateH>rateW){
		rate = rateW;
		offy = (int)(((float)H1 - (float)OrgH*rate)/2.0f);
	}else{
		rate = rateH;
		offx = (int)(((float)W1 - (float)OrgW*rate)/2.0f);
	}
	rate = min(rateH,rateW);
	
	OVR_POINT* pNewPt = (OVR_POINT*)malloc(sizeof(OVR_POINT)*OrgPtNum);

	NorPtNum = 0;
	for (i=0;i<nStrokeNum;i++) {
		st = pOrgStroke[i].stPtNo;
		ed = pOrgStroke[i].edPtNo;
		pNorStroke[i].stPtNo = NorPtNum;
		x = (int)(((float)(pOrgPt[st].nX - l) + 0.5f) * rate)+offx;
		y = (int)(((float)(pOrgPt[st].nY - t) + 0.5f) * rate)+offy;
		pNewPt[NorPtNum].nX = x;
		pNewPt[NorPtNum].nY = y;
		NorPtNum++;
		for(j=st+1;j<=ed;j++){
			x = (int)(((float)(pOrgPt[j].nX - l) + 0.5f) * rate)+offx;
			y = (int)(((float)(pOrgPt[j].nY - t) + 0.5f) * rate)+offy;
			if(pNewPt[NorPtNum-1].nX == x && pNewPt[NorPtNum-1].nY == y)continue;
			pNewPt[NorPtNum].nX = x;
			pNewPt[NorPtNum].nY = y;
			NorPtNum++;
		}
		pNorStroke[i].edPtNo = NorPtNum-1;
	}

	return pNewPt;
}
/*
_____________________________________________________________
  
Լ̸:   GetBoundingBox  - Էµ Ʈ  4

 :  
		
ȯ: 4
		  
Restrictions:   'pGI' must have pixel type unsigned char.
________________________________________________________________
			  
*/
RECT CPreProcess::GetBoundingBox(OVR_POINT *pPt, int PtNum)
{
	int i;
	RECT r;
	r.left=10000;r.top=10000;r.right=0;r.bottom=0;
	int x,y;
	for(i=0;i<PtNum;i++){
		x = max(0,pPt[i].nX);
		y = max(0,pPt[i].nY);
		r.left = min(r.left,x);
		r.top = min(r.top,y);
		r.right = max(r.right,x);
		r.bottom = max(r.bottom,y);
	}
	r.right++;
	r.bottom++;
	return r;
}
