#pragma once

#include <vector>

// forward declaration
namespace Ogre
{
	class SceneNode;
	class Entity;
};

using namespace std;

class CToolMeshManager
{
public:
	CToolMeshManager(void);
	virtual ~CToolMeshManager(void);

	void					LoadMeshFile(const char* szFileName);
	void					AddMeshFile(const char* szFileName);
	const Ogre::Entity*		GetMainEntity();
	const Ogre::SceneNode*	GetMainNode();
	bool					HasSkeletonAnimation();

private:
	Ogre::SceneNode*			m_pMainNode;
	Ogre::Entity*				m_pMainEntity;
	vector<Ogre::SceneNode*>	m_pvecNodeList;
	int							m_nLoadedMeshCount;
};
