#pragma once

#include <string>
#include <vector>

#define MAX_ANIMATION_LIST	256

// forward declaration
namespace Ogre
{
	class SceneNode;
	class Entity;
	class AnimationState;
};


class CToolAnimationManager
{
public:
	CToolAnimationManager(void);
	virtual ~CToolAnimationManager(void);

	void SetMainEntity(const Ogre::Entity* pEntity);
	void CreateAnimationList();
	void GetAnimationNameList(std::wstring* pAnimationNames, int* pNameListCount);
	bool FrameProc(float fTimeSinceLastFrame);
	float GetAnimationTimeLength(const char* szAnimationName);
	float GetCurrentPlayingAnimationTime();
	void Deactive();
	bool IsActive();

	void SetAnimationName(const char* szName);
	void Play();
	void Pause();
	void Stop();
	void SetTimeSpeedFactor(float fFactor);
	void SetCurrentAnimationTimePosition(float fTimePosition);
	bool AddSkeletonFile(const char* szSkeletonFile);

private:
	Ogre::AnimationState*	m_pAnimationState;
	std::wstring			m_strAnimationName[MAX_ANIMATION_LIST];
	bool					m_bPlaying;
	const Ogre::Entity*		m_pMainEntity;
	bool					m_bActive;
	float					m_fTimeSpeedFactor;
};
