// LittleMeshViewrDoc.cpp : implementation of the CLittleMeshViewrDoc class
//

#include "stdafx.h"
#include "LittleMeshViewr.h"

#include "LittleMeshViewrDoc.h"
#include "ToolMeshManager.h"
#include "ToolAnimationManager.h"
#include "AnimationControlDlg.h"

//#ifdef _DEBUG
//#define new DEBUG_NEW
//#endif


// CLittleMeshViewrDoc

IMPLEMENT_DYNCREATE(CLittleMeshViewrDoc, CDocument)

BEGIN_MESSAGE_MAP(CLittleMeshViewrDoc, CDocument)
END_MESSAGE_MAP()


// CLittleMeshViewrDoc construction/destruction

CLittleMeshViewrDoc::CLittleMeshViewrDoc()
{
	// TODO: add one-time construction code here
	m_pMeshUtil = NULL;
	m_pAnimationUtil = NULL;
	m_pAnimationControlDlg = NULL;

	m_pMeshUtil = new CToolMeshManager();
	m_pAnimationUtil = new CToolAnimationManager();
}

CLittleMeshViewrDoc::~CLittleMeshViewrDoc()
{
	if(m_pAnimationUtil)
	{
		delete m_pAnimationUtil;
		m_pAnimationUtil = NULL;
	}

	if(m_pMeshUtil)
	{
		delete m_pMeshUtil;
		m_pMeshUtil = NULL;
	}

	if(m_pAnimationControlDlg)
	{
		delete m_pAnimationControlDlg;
		m_pAnimationControlDlg = NULL;
	}
}

BOOL CLittleMeshViewrDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}




// CLittleMeshViewrDoc serialization

void CLittleMeshViewrDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}


// CLittleMeshViewrDoc diagnostics

#ifdef _DEBUG
void CLittleMeshViewrDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CLittleMeshViewrDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG


// CLittleMeshViewrDoc commands

void CLittleMeshViewrDoc::FrameProc(DWORD dwTimeSinceLastFrame)
{
	float fFrameTime = dwTimeSinceLastFrame / 1000.0f;

	if(m_pAnimationUtil->IsActive())
	{
		bool bFinishAnimation = m_pAnimationUtil->FrameProc(fFrameTime);
		float fAnimationPlayingTime = m_pAnimationUtil->GetCurrentPlayingAnimationTime();
		m_pAnimationControlDlg->SetCurrentAnimationTime(fAnimationPlayingTime);

		if(bFinishAnimation)
		{
			bool bHasNextAnimation = 0;
			char cLoopState = m_pAnimationControlDlg->GetLoopState();
			switch(cLoopState)
			{
			case STATE_PLAYONCE:
				m_pAnimationControlDlg->OnPlayingAnimationState(true);
				break;
			case STATE_LOOP_ONEANIMATION:
				m_pAnimationUtil->Play();
				break;
			case STATE_ALLANIMATION:
				/*bHasNextAnimation = m_pAnimationUtil->SelectNextAnimation();
				if(bHasNextAnimation)
				{
					m_pAnimationUtil->Play();
				}
				else
				{
					m_pAnimationControlDlg->OnPlayingAnimationState(true);
				}*/
				break;
			case STATE_LOOP_ALLANIMATION:
				break;
			}
		}
	}
}

void CLittleMeshViewrDoc::LoadMesh(const char* szFileName)
{
	assert(m_pMeshUtil && "[LoadMesh] CToolMeshManager is Not Created.");

	m_pMeshUtil->LoadMeshFile(szFileName);

	if(NULL == m_pAnimationControlDlg)
	{
		m_pAnimationControlDlg = new CAnimationControlDlg(theApp.GetMainWnd());
		m_pAnimationControlDlg->Create(IDD_ANIMATION_DIALOG,theApp.GetMainWnd());
	}

	m_pAnimationControlDlg->ResetAnimationList();

	const Ogre::Entity* pEntity = m_pMeshUtil->GetMainEntity();
	m_pAnimationUtil->SetMainEntity(pEntity);
	if(m_pMeshUtil->HasSkeletonAnimation())
	{
		m_pAnimationUtil->CreateAnimationList();

		std::wstring strAnimationNames[MAX_ANIMATION_LIST];
		int nAnimationNameCount = 0;
		m_pAnimationUtil->GetAnimationNameList(strAnimationNames,&nAnimationNameCount);
		m_pAnimationControlDlg->InitAnimationList(strAnimationNames,nAnimationNameCount);

		m_pAnimationUtil->Stop();
		m_pAnimationControlDlg->ShowWindow(SW_SHOW);
		m_pAnimationControlDlg->SetDialogControlsEnable(TRUE);
	}
	else
	{
		m_pAnimationUtil->Deactive();
		m_pAnimationControlDlg->ShowWindow(SW_HIDE);
		m_pAnimationControlDlg->SetDialogControlsEnable(FALSE);
	}
}

void CLittleMeshViewrDoc::AddMesh(const char* szFileName)
{
	assert(m_pMeshUtil && "[AddMesh] CToolMeshManager is Not Created.");

	m_pMeshUtil->AddMeshFile(szFileName);
}

bool CLittleMeshViewrDoc::IsMainMeshLoaded()
{
	if(m_pMeshUtil->GetMainNode())
	{
		return true;
	}
	else
	{
		return false;
	}
}


/***************************************************
	animation functions
****************************************************/
void CLittleMeshViewrDoc::SelectAnimation(const char* szAnimationName)
{
	m_pAnimationUtil->Stop();
	m_pAnimationUtil->SetAnimationName(szAnimationName);

	float fTimeLength = m_pAnimationUtil->GetAnimationTimeLength(szAnimationName);
	m_pAnimationControlDlg->SetAnimationTimeLength(fTimeLength);
}

void CLittleMeshViewrDoc::PlayAnimation()
{
	m_pAnimationUtil->Play();
}

void CLittleMeshViewrDoc::PauseAnimation()
{
	m_pAnimationUtil->Pause();
}

void CLittleMeshViewrDoc::StopAnimation()
{
	m_pAnimationUtil->Stop();
}

void CLittleMeshViewrDoc::ChangeAnimationSpeedFactor(float fFactor)
{
	m_pAnimationUtil->SetTimeSpeedFactor(fFactor);
}

void CLittleMeshViewrDoc::SetAnimationTimePosition(float fTimePosition)
{
	m_pAnimationUtil->SetCurrentAnimationTimePosition(fTimePosition);
}

void CLittleMeshViewrDoc::AddSkeletonFile(const char* szSkeletonFile)
{
	bool bSuccess = m_pAnimationUtil->AddSkeletonFile(szSkeletonFile);

	if(bSuccess)
	{
		m_pAnimationUtil->CreateAnimationList();

		std::wstring strAnimationNames[MAX_ANIMATION_LIST];
		int nAnimationNameCount = 0;
		m_pAnimationControlDlg->ResetAnimationList();
		m_pAnimationUtil->GetAnimationNameList(strAnimationNames,&nAnimationNameCount);
		m_pAnimationControlDlg->InitAnimationList(strAnimationNames,nAnimationNameCount);

		m_pAnimationUtil->Stop();
	}
}
