{

   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit Ufrmworkbase;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Ufrmworkselect, StdCtrls, ExtCtrls, ComCtrls, Buttons, Udialog;

type
  tworkselect = (wslistselect,wslistall);

  Tfrmworkbase = class(TForm)
    PanelBottom: TPanel;
    labelprogress: TLabel;
    ProgressBar1: TProgressBar;
    btnok: TBitBtn;
    btncancel: TBitBtn;
    Memo1: TMemo;
    PanelTop: TPanel;
    procedure btnokClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure WndProc(var Message: TMessage); override;
  protected
    procedure OkSeleted; virtual;
    function CancelSeleted:boolean; virtual;
  public
    { Public declarations }
    list:tlist;
    lastfilename:string;
  end;

  function makefilename(name,prefix:string):string;

var
  frmworkbase: Tfrmworkbase;
  selectsaveflag:integer;
  existnoanswer:boolean;

implementation

uses Uconfig, UBrowserListView;

{$R *.dfm}

function makefilename(name,prefix:string):string;
var
  s,s1:string;
begin
  s:=sysutils.ExtractFileName(name);
  s1:=sysutils.ExtractFileExt(name);
  s:=sysutils.StringReplace(s,s1,'',[rfReplaceAll]);
  result:=s+prefix+s1;
end;

procedure Tfrmworkbase.WndProc(var Message: TMessage);
var
  i:integer;
begin
  with Message do
    case Msg of
      wm_user+1001:begin
        ProgressBar1.Max:=wparam;
        ProgressBar1.Position:=lparam;
      end;
      wm_user+1002:begin
        labelprogress.Caption:=pchar(wparam);
      end;
      wm_user+1003:begin
        memo1.Lines.BeginUpdate;
        try
          if memo1.Lines.Count>300 then
            for i:=memo1.Lines.Count downto 300 do
              memo1.Lines.Delete(0);
          memo1.Lines.Add('>>'+pchar(wparam));
          SendMessage(memo1.Handle, WM_VSCROLL, SB_BOTTOM,0);
        finally
          memo1.Lines.EndUpdate;
        end
      end;
    end;
  inherited;
end;

procedure Tfrmworkbase.btnokClick(Sender: TObject);
begin
  OkSeleted;
end;

procedure Tfrmworkbase.OkSeleted;
begin
end;

function Tfrmworkbase.CancelSeleted:boolean;
begin
end;

procedure Tfrmworkbase.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  CanClose:=CancelSeleted;
end;

procedure Tfrmworkbase.FormShow(Sender: TObject);
var
  s:string;
begin
  PanelBottom.Align:=albottom;
  PanelTop.Align:=albottom;
  ProgressBar1.Left:=(PanelBottom.Width-ProgressBar1.Width) div 2;
  labelprogress.Left:=ProgressBar1.Left;

  s:=ExtractFileName(PThumbImage(list.items[0]).name);
  if list.Count=1 then
    PanelTop.Caption:=format('"%s" ',[s])
  else
    PanelTop.Caption:=format('"%s"  %d ',[s, list.Count]);
end;

procedure Tfrmworkbase.FormCreate(Sender: TObject);
begin
  Height:=Height+PanelBottom.Height+PanelTop.Height;
  lastfilename:='';
end;

end.
