{
   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit Ufrmoption;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin, Buttons;

type
  Tfrmoption = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label1: TLabel;
    SpinEdit1: TSpinEdit;
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
    parenthandle:thandle;
    procedure CreateParams(var Params: TCreateParams); override;
  public
    { Public declarations }
    constructor Create(AOwner:TComponent;parenthandle:thandle);
  end;

implementation
uses Uregistry, Umain;
{$R *.dfm}

constructor Tfrmoption.Create(AOwner:TComponent;parenthandle:thandle);
begin
  self.parenthandle:=parenthandle;
  inherited Create(AOwner);
end;

procedure Tfrmoption.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params do begin
//    ExStyle := ExStyle or WS_EX_APPWINDOW;
    WndParent := parenthandle;
  end;
end;

procedure Tfrmoption.FormCreate(Sender: TObject);
var
  v:cardinal;
begin
  if RegGetDWORD(HKEY_CURRENT_USER, 'software\'+thisregname+'\shellmenu\thumbsize', v)=false then
    v:=125;
  self.SpinEdit1.Value:=v;
end;

procedure Tfrmoption.BitBtn1Click(Sender: TObject);
begin
  RegSetDWORD(HKEY_CURRENT_USER, 'software\'+thisregname+'\shellmenu\thumbsize', self.SpinEdit1.Value);
end;

end.
