unit UfrmEffect_font;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UfrmEffectBase, StdCtrls, Spin, ComCtrls, ExtCtrls, gr32,
  Buttons, Udialog, UnViewColorBox;

type
  TfrmEffect_font = class(TfrmEffectBase)
    FontDialog1: TFontDialog;
    Panel1: TPanel;
    Panel2: TPanel;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label8: TLabel;
    Label7: TLabel;
    ComboBox1: TComboBox;
    Edit1: TEdit;
    ColorBox1: TnViewColorBox;
    TrackBar1: TTrackBar;
    CheckBox1: TCheckBox;
    Button2: TButton;
    ColorBox2: TnViewColorBox;
    SpinEdit1: TSpinEdit;
    marginleft: TSpinEdit;
    margintop: TSpinEdit;
    TabSheet2: TTabSheet;
    Label1: TLabel;
    ScaleCombo: TComboBox;
    Button1: TBitBtn;
    CheckBox2: TCheckBox;
    Edit2: TEdit;
    Button3: TButton;
    CheckBox3: TCheckBox;
    Label9: TLabel;
    TrackBar2: TTrackBar;
    SpinEdit2: TSpinEdit;
    Label10: TLabel;
    ColorBox3: TnViewColorBox;
    ComboBox2: TComboBox;
    ComboBox3: TComboBox;
    ComboBox4: TComboBox;
    Label11: TLabel;
    ComboBox5: TComboBox;
    Label12: TLabel;
    SpinEdit3: TSpinEdit;
    SpinEdit4: TSpinEdit;
    Label13: TLabel;
    TabSheet3: TTabSheet;
    SpinEdit5: TSpinEdit;
    Label14: TLabel;
    Label15: TLabel;
    SpinEdit6: TSpinEdit;
    CheckBox4: TCheckBox;
    Label16: TLabel;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure FormShortCut(var Msg: TWMKey; var Handled: Boolean);
    procedure Button3Click(Sender: TObject);
    procedure SpinEdit5Change(Sender: TObject);
    procedure SpinEdit6Change(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure CheckBox5Click(Sender: TObject);
    procedure TrackBar2Change(Sender: TObject);
    procedure SpinEdit2Change(Sender: TObject);
    procedure CheckBox6Click(Sender: TObject);
  private
    { Private declarations }
    watermarkimg,watermarkimg2:tbitmap32;

    procedure ok_select; override;
    procedure imageprocess(var src:tbitmap);
    procedure set_effectapply(src,dest:tbitmap32);
    procedure set_effectapply2(src,dest:tbitmap32);
    procedure loadwatermarkimg(filename:string);
  public
    { Public declarations }
  end;

var
  frmEffect_font: TfrmEffect_font;

implementation
uses Uconfig, Ufrmmain, FreeBitmap, FreeImage, FreeUtils, Ufunction;
{$R *.dfm}

procedure TfrmEffect_font.FormCreate(Sender: TObject);
begin
  inherited;
  PanelPreView.Align:=alClient;
//  imagepreview1.PopupMenu:=pMlayer;
  imagepreview1.ScrollBars.Size:=0;

  self.BorderStyle:=bsSizeable;
  self.BorderIcons:=[biSystemMenu,biMaximize];
  if config.effect_width>=0 then self.Width:=config.effect_width
  else self.Width:=750;
  if config.effect_height>=0 then self.Height:=config.effect_height
  else self.Height:=500;
  if config.effect_max then WindowState:=wsMaximized;

  frmmain.ImageList2.GetBitmap(9, Button1.Glyph);
  watermarkimg:=tbitmap32.Create;
  watermarkimg2:=tbitmap32.Create;
end;

procedure TfrmEffect_font.FormDestroy(Sender: TObject);
begin
  inherited;

  config.effect_max:=WindowState=wsMaximized;
  config.setvaluebyinteger('scaleindex',ScaleCombo.ItemIndex);

  config.setvaluebyinteger('font_lastpageindex',self.PageControl1.ActivePageIndex);

  config.setvaluebyinteger('font_enable',integer(self.CheckBox2.Checked));
  config.setvaluebystring('font_fontname',FontDialog1.Font.Name);
  config.setvaluebyinteger('font_fontsize',FontDialog1.Font.Size);
  config.setvaluebyinteger('font_fontcolor',self.ColorBox1.Selected);
  if fsbold in FontDialog1.Font.Style then
    config.setvaluebyinteger('font_fontbold',1)
  else
    config.setvaluebyinteger('font_fontbold',0);
  config.setvaluebyinteger('font_position',self.ComboBox1.ItemIndex);
  config.setvaluebyinteger('font_trans',self.TrackBar1.Position);
  config.setvaluebyinteger('font_usebackcolor',integer(self.CheckBox1.Checked));
  config.setvaluebyinteger('font_disabletrans',integer(self.CheckBox6.Checked));
  config.setvaluebyinteger('font_useantialias',integer(self.CheckBox7.Checked));

  config.setvaluebyinteger('font_backcolor',self.ColorBox2.Selected);
  config.setvaluebystring('font_text',self.Edit1.Text);
  config.setvaluebyinteger('font_marginleft',marginleft.Value);
  config.setvaluebyinteger('font_margintop',margintop.Value);

  config.setvaluebyinteger('font_img_enable',integer(self.CheckBox3.Checked));
  config.setvaluebyinteger('font_img_position',ComboBox5.ItemIndex);
  config.setvaluebyinteger('font_img_trans',self.TrackBar2.Position);
  config.setvaluebyinteger('font_img_transcolor',self.ColorBox3.Selected);
  config.setvaluebyinteger('font_img_transtype',self.ComboBox2.ItemIndex);
  config.setvaluebyinteger('font_img_fliptype',self.ComboBox3.ItemIndex);
  config.setvaluebyinteger('font_img_rotatetype',self.ComboBox4.ItemIndex);
  config.setvaluebyinteger('font_img_marginleft',self.SpinEdit3.Value);
  config.setvaluebyinteger('font_img_margintop',self.SpinEdit4.Value);
  config.setvaluebystring('font_img_filename',edit2.Text);

  config.setvaluebyinteger('font_resize_enable',integer(self.CheckBox5.Checked));
  config.setvaluebyinteger('font_resize_width',self.SpinEdit5.Value);
  config.setvaluebyinteger('font_resize_height',self.SpinEdit6.Value);
  config.setvaluebyinteger('font_resize_keepratio',integer(self.CheckBox4.Checked));

  if WindowState=wsnormal then begin
    config.effect_width:=self.Width;
    config.effect_height:=self.Height;
  end;

  watermarkimg.Free;
  watermarkimg2.Free;
end;

procedure TfrmEffect_font.FormShow(Sender: TObject);
begin
  inherited;
  self.setScaleCombo(ScaleCombo);

  PageControl1.ActivePageIndex:=0;
  PageControl1.ActivePageIndex:=1;
  self.PageControl1.ActivePageIndex:=config.getvaluebyinteger('font_lastpageindex',0);

  self.CheckBox2.Checked:=boolean(config.getvaluebyinteger('font_enable',1));
  FontDialog1.Font.Name:=config.getvaluebystring('font_fontname','');
  FontDialog1.Font.Size:=config.getvaluebyinteger('font_fontsize',30);
  self.ColorBox1.Selected:=config.getvaluebyinteger('font_fontcolor',clwhite);
  if config.getvaluebyinteger('font_fontbold',0)=1 then
    FontDialog1.Font.Style:=FontDialog1.Font.Style+[fsbold];
  self.ComboBox1.ItemIndex:=config.getvaluebyinteger('font_position',0);
  self.TrackBar1.Position:=config.getvaluebyinteger('font_trans',200);
  self.CheckBox1.Checked:=boolean(config.getvaluebyinteger('font_usebackcolor',1));
  self.CheckBox6.Checked:=boolean(config.getvaluebyinteger('font_disabletrans',0));
  CheckBox6Click(nil);
  self.CheckBox7.Checked:=boolean(config.getvaluebyinteger('font_useantialias',1));

  self.ColorBox2.Selected:=config.getvaluebyinteger('font_backcolor',clblack);
  self.Edit1.Text:=config.getvaluebystring('font_text','ڸ Էϼ.');
  marginleft.Value:=config.getvaluebyinteger('font_marginleft',0);
  margintop.Value:=config.getvaluebyinteger('font_margintop',0);

  self.CheckBox3.Checked:=boolean(config.getvaluebyinteger('font_img_enable',0));
  ComboBox5.ItemIndex:=config.getvaluebyinteger('font_img_position',0);
  self.TrackBar2.Position:=config.getvaluebyinteger('font_img_trans',200);
  self.ColorBox3.Selected:=config.getvaluebyinteger('font_img_transcolor',clblack);
  self.ComboBox2.ItemIndex:=config.getvaluebyinteger('font_img_transtype',0);
  self.ComboBox3.ItemIndex:=config.getvaluebyinteger('font_img_fliptype',0);
  self.ComboBox4.ItemIndex:=config.getvaluebyinteger('font_img_rotatetype',0);
  self.SpinEdit3.Value:=config.getvaluebyinteger('font_img_marginleft',0);
  self.SpinEdit4.Value:=config.getvaluebyinteger('font_img_margintop',0);
  edit2.Text:=config.getvaluebystring('font_img_filename','');

  self.CheckBox5.Checked:=boolean(config.getvaluebyinteger('font_resize_enable',0));
  self.SpinEdit5.Value:=config.getvaluebyinteger('font_resize_width',50);
  self.SpinEdit6.Value:=config.getvaluebyinteger('font_resize_height',50);
  self.CheckBox4.Checked:=boolean(config.getvaluebyinteger('font_resize_keepratio',1));

  loadwatermarkimg(edit2.Text);

  applyselect.Visible:=not frmmain.is_layerselected;
end;

procedure CromaKey(ABitmap: TBitmap32; TrColor: TColor32);
var
  P: PColor32;
  C: TColor32;
  I: Integer;
begin
  TrColor := TrColor and $00FFFFFF; // erase alpha, (just in case it has some)
  with ABitmap do
  begin
    P := PixelPtr[0, 0];
    for I := 0 to Width * Height - 1 do
    begin
      C := P^ and $00FFFFFF; // get RGB without alpha
      if C = TrColor then // is this pixel "transparent"?
        P^ := C; // write RGB with "transparent" alpha back into the SrcBitmap
      Inc(P); // proceed to the next pixel
    end;
  end;
end;

procedure TfrmEffect_font.Button1Click(Sender: TObject);
begin
  set_effectapply(org_bitmap32,imagepreview1.Bitmap);
  if watermarkimg.Empty then
    loadwatermarkimg(edit2.Text);
  if (watermarkimg.Empty=false) then
    if self.CheckBox3.Checked and self.CheckBox5.Checked then
      Resample(watermarkimg,watermarkimg2,self.SpinEdit5.Value,self.SpinEdit6.Value,sfLanczos)
    else
      watermarkimg2.Assign(watermarkimg);
  set_effectapply2(imagepreview1.Bitmap,imagepreview1.Bitmap);
  imagepreview1.Changed;
end;

procedure TfrmEffect_font.Button2Click(Sender: TObject);
begin
  FontDialog1.Execute;
end;

procedure WriteAntiAlias(Canvas: TCanvas; X, Y: Integer; Text: String);
const
  Sampling = 2;
var
  Width, Height: Integer;
  VirtualCanvas: TBitmap;
  RenderCanvas: TBitmap;
  DrawCanvas: TCanvas;

  x2,y2: Integer;
  i0, i1, o0: pbytearray;
  oldcolor:tcolor;
begin
  Width := Canvas.TextWidth(Text) + 20;
  Height := Canvas.TextHeight(Text);

  VirtualCanvas := TBitmap.Create;
  RenderCanvas := TBitmap.Create;
  try
    VirtualCanvas.Width := Width * Sampling;
    VirtualCanvas.Height := Height * Sampling;
    VirtualCanvas.PixelFormat := pf24bit;

    RenderCanvas.Width := Width;
    RenderCanvas.Height := Height;
    RenderCanvas.PixelFormat := pf24bit;

    RenderCanvas.Canvas.CopyRect(Rect(0,0, Width, Height), Canvas, Rect(X, Y, X + Width, Y + Height));

    DrawCanvas := VirtualCanvas.Canvas;
    DrawCanvas.StretchDraw(Rect(0,0, Width *2, Height *2), RenderCanvas);

    DrawCanvas.Brush.Style:=bsClear;
    DrawCanvas.Font.Color := Canvas.Font.Color;
    DrawCanvas.Font.Name := Canvas.Font.Name;
    DrawCanvas.Font.Size := Canvas.Font.Size * Sampling;
    DrawCanvas.Font.Style := Canvas.Font.Style;

    DrawCanvas.TextOut(-Sampling, 0, Text);

    for y2 := 0 to Height-1 do
    begin
      i0 := VirtualCanvas.ScanLine[(y2 * 2)];
      i1 := VirtualCanvas.Scanline[(y2 * 2) + 1];
      o0 := RenderCanvas.Scanline[y2];

      for x2 := 0 to Width-1 do
      begin
        o0[x2 * 3] := (i0[x2 * 2 * 3] + i1[x2 * 2 * 3] + i0[(x2 * 2 * 3) + 3] + i1[(x2 * 2 * 3) + 3]) div 4;
        o0[(x2 * 3) + 1] := (i0[(x2 * 2 * 3) + 1] + i1[(x2 * 2 * 3) + 1] + i0[(x2 * 2 * 3) + 4] + i1[(x2 * 2 * 3) + 4]) div 4;
        o0[(x2 * 3) + 2] := (i0[(x2 * 2 * 3) + 2] + i1[(x2 * 2 * 3) + 2] + i0[(x2 * 2 * 3) + 5] + i1[(x2 * 2 * 3) + 5]) div 4;
      end;
    end;
    Canvas.CopyRect(Rect(X, Y, X + Width, Y + Height), RenderCanvas.Canvas, Rect(0,0, Width, Height));

  finally
    VirtualCanvas.Free;
    RenderCanvas.Free;
  end;
end;

procedure TfrmEffect_font.set_effectapply(src,dest:tbitmap32);
var
  bmp:tbitmap32;
  bmp3:tbitmap;
  x,y,w,h,diff:integer;
  x1,y1:integer;
  s:string;
begin
  dest.Assign(src);
  if self.CheckBox2.Checked=false then exit;

  bmp:=tbitmap32.Create;
  bmp3:=tbitmap.Create;
  bmp.DrawMode:=dmBlend;
  try
    if CheckBox6.Checked then begin
     dest.Canvas.Font.Assign(FontDialog1.Font);
     dest.Canvas.Font.Color:=self.ColorBox1.Selected;
     s:=edit1.Text;
     w:=dest.Canvas.TextWidth(s);
     h:=dest.Canvas.TextHeight(s);
     diff:=h div 9;
     if diff<2 then diff:=2;
     w:=w+(diff*3);
     h:=h+diff;
     x1:=(diff*3) div 2;
     y1:=diff div 2;
     diff:=diff*2;

    end else begin

     bmp3.Canvas.Font.Assign(FontDialog1.Font);
     bmp3.Canvas.Font.Color:=self.ColorBox1.Selected;
     s:=edit1.Text;
     w:=bmp3.Canvas.TextWidth(s);
     h:=bmp3.Canvas.TextHeight(s);
     diff:=h div 9;
     if diff<2 then diff:=2;
     w:=w+(diff*3);
     h:=h+diff;
     bmp3.Width:=w;
     bmp3.Height:=h;
     bmp3.Canvas.Brush.Color:=self.ColorBox2.Selected;
     bmp3.Canvas.FillRect(rect(0,0,w,h));
     if CheckBox7.Checked then
       WriteAntiAlias(bmp3.Canvas,(diff*3) div 2,diff div 2,s)
     else
       bmp3.Canvas.TextOut((diff*3) div 2,diff div 2,s);

     bmp.Assign(bmp3);
     bmp.MasterAlpha:=self.TrackBar1.Position;
     if self.CheckBox1.Checked=false then
       CromaKey(bmp,bmp.Pixel[0,0]);
     diff:=diff*2;
     w:=bmp.Width;
     h:=bmp.Height;
    end;

    case self.ComboBox1.ItemIndex of
      0:begin
        x:=org_bitmap32.Width-w-diff;
        y:=org_bitmap32.Height-h-diff;
      end;
      1:begin
        x:=diff;
        y:=org_bitmap32.Height-h-diff;
      end;
      2:begin
        x:=org_bitmap32.Width-w-diff;
        y:=diff;
      end;
      3:begin
        x:=diff;
        y:=diff;
      end;
      4:begin
        x:=(org_bitmap32.Width div 2)-(w div 2);
        y:=(org_bitmap32.Height div 2)-(h div 2)
      end;
      5:begin
        x:=org_bitmap32.Width-w-diff;
        y:=(org_bitmap32.Height div 2)-(h div 2);
      end;
      6:begin
        x:=diff;
        y:=(org_bitmap32.Height div 2)-(h div 2);
      end;
      7:begin
        x:=(org_bitmap32.Width div 2)-(w div 2);
        y:=diff;
      end;
      8:begin
        x:=(org_bitmap32.Width div 2)-(w div 2);
        y:=org_bitmap32.Height-h-diff;
      end;
    end;

    x:=x+self.marginleft.Value;
    y:=y+self.margintop.Value;

    if CheckBox6.Checked then begin
      dest.Canvas.Brush.Style:=bsClear;
      if CheckBox7.Checked then
        WriteAntiAlias(dest.Canvas,x+x1,y+y1,s)
      else
        dest.Canvas.TextOut(x+x1,y+y1,s);
    end else begin
      dest.Draw(x,y,bmp);
    end;

  finally
    bmp.Free;
    bmp3.Free;
  end;
end;

procedure TfrmEffect_font.set_effectapply2(src,dest:tbitmap32);
var
  bmp:tbitmap32;
  x,y,w,h,diff:integer;
  s:string;
begin
  dest.Assign(src);
  if self.CheckBox3.Checked=false then exit;

  bmp:=tbitmap32.Create;
  try
    bmp.Assign(watermarkimg2);
    bmp.MasterAlpha:=self.TrackBar2.Position;
    case ComboBox2.ItemIndex of
      1:CromaKey(bmp,color32(ColorBox3.Selected));
      2:CromaKey(bmp,bmp.Pixel[0,0]);
    end;
    case ComboBox3.ItemIndex of
      1:bmp.FlipHorz;
      2:bmp.FlipVert();
    end;
    case ComboBox4.ItemIndex of
      1:bmp.Rotate90;
      2:bmp.Rotate180();
      3:bmp.Rotate270();
    end;

    diff:=10;
    case self.ComboBox5.ItemIndex of
      0:begin
        x:=org_bitmap32.Width-bmp.Width-diff;
        y:=org_bitmap32.Height-bmp.Height-diff;
      end;
      1:begin
        x:=diff;
        y:=org_bitmap32.Height-bmp.Height-diff;
      end;
      2:begin
        x:=org_bitmap32.Width-bmp.Width-diff;
        y:=diff;
      end;
      3:begin
        x:=diff;
        y:=diff;
      end;
      4:begin
        x:=(org_bitmap32.Width div 2)-(bmp.Width div 2);
        y:=(org_bitmap32.Height div 2)-(bmp.Height div 2)
      end;
      5:begin
        x:=org_bitmap32.Width-bmp.Width-diff;
        y:=(org_bitmap32.Height div 2)-(bmp.Height div 2);
      end;
      6:begin
        x:=diff;
        y:=(org_bitmap32.Height div 2)-(bmp.Height div 2);
      end;
      7:begin
        x:=(org_bitmap32.Width div 2)-(bmp.Width div 2);
        y:=diff;
      end;
      8:begin
        x:=(org_bitmap32.Width div 2)-(bmp.Width div 2);
        y:=org_bitmap32.Height-bmp.Height-diff;
      end;
    end;

    x:=x+self.SpinEdit3.Value;
    y:=y+self.SpinEdit4.Value;

    dest.Draw(x,y,bmp);
  finally
    bmp.Free;
  end;
end;

procedure TfrmEffect_font.ok_select;
begin
  if applyselect.ItemIndex=0 then begin
    exit;
  end;
  if watermarkimg.Empty then
    loadwatermarkimg(edit2.Text);
  if (watermarkimg.Empty=false) then
    if self.CheckBox3.Checked and self.CheckBox5.Checked then
      Resample(watermarkimg,watermarkimg2,self.SpinEdit5.Value,self.SpinEdit6.Value,sfLanczos)
    else
      watermarkimg2.Assign(watermarkimg);
  frmmain.apply_listimages(applyselect.ItemIndex=1,imageprocess,etfont,self.Caption);
  self.ModalResult:=mrcancel;
end;

procedure TfrmEffect_font.imageprocess(var src:tbitmap);
var
  bitmap:tbitmap32;
begin
  bitmap:=tbitmap32.Create;
  try
    org_bitmap32.Assign(src);
    set_effectapply(org_bitmap32,bitmap);
    set_effectapply2(bitmap,bitmap);
    bitmap.AssignTo24(src);
  finally
    bitmap.Free;
  end;
end;

procedure TfrmEffect_font.TrackBar1Change(Sender: TObject);
begin
  self.SpinEdit1.Value:=TrackBar1.Position;
end;

procedure TfrmEffect_font.SpinEdit1Change(Sender: TObject);
begin
  if isvalidinteger(SpinEdit1.Text) then TrackBar1.Position:=SpinEdit1.Value;
end;

procedure TfrmEffect_font.CheckBox1Click(Sender: TObject);
begin
  if CheckBox1.Checked=false then begin
    frmmain.showballoon('',
      ' ڻ   ؾ ׵θ ܻ پϴ.',
      self.ColorBox2,mtInformation);
  end;
end;

procedure TfrmEffect_font.FormShortCut(var Msg: TWMKey;
  var Handled: Boolean);
begin
  inherited FormShortCut(msg, handled);
  if handled then exit;

  Handled:=true;
  case Msg.CharCode of
    vk_f2: Button1Click(nil);
    else
      Handled:=false;
  end;
end;

procedure TfrmEffect_font.Button3Click(Sender: TObject);
begin
  OpenPictureDialog1.Filter := FIU_GetAllFilters;
  OpenPictureDialog1.InitialDir:=config.lastpath;

  if OpenPictureDialog1.Execute=false then exit;

  config.lastpath:=ExtractFilePath(OpenPictureDialog1.FileName);
  config.c_dialogpreview:=OpenPictureDialog1.ExtraCheckbox.Checked;
  edit2.Text:=OpenPictureDialog1.FileName;
  loadwatermarkimg(edit2.Text);
end;

procedure TfrmEffect_font.loadwatermarkimg(filename:string);
var
  FBitmap:TFreeWinBitmap;
  FreeMemoryIO1:TFreeMemoryIO;
  data:Pbyte;
  SizeInBytes:DWord;
  stream:tmemorystream;
begin
  if sysutils.FileExists(filename)=false then exit;
  FBitmap:=TFreeWinBitmap.Create;
  try
    watermarkimg.DrawMode:=dmBlend;
    watermarkimg2.DrawMode:=dmBlend;
    FBitmap.Load(filename);
    FreeMemoryIO1:=TFreeMemoryIO.Create();
    try
      FBitmap.SaveToMemory(FIF_BMP,FreeMemoryIO1);
      FreeMemoryIO1.Acquire(data,SizeInBytes);
      stream:=tmemorystream.Create;
      try
        stream.Write(data^,SizeInBytes);
        stream.Position:=0;
        watermarkimg.LoadFromStream(stream);
        self.Label16.Caption:=format('ũ %d X %d',[watermarkimg.Width, watermarkimg.Height]);
        self.CheckBox5.Enabled:=true;
        self.SpinEdit5.Enabled:=true;
        self.SpinEdit6.Enabled:=true;
        self.CheckBox4.Enabled:=true;
        SpinEdit5Change(nil);
      finally
        stream.Free;
      end;
    finally
      FreeMemoryIO1.Free;
    end;
  finally
    FBitmap.Free;
  end;
end;

procedure TfrmEffect_font.SpinEdit5Change(Sender: TObject);
begin
  if watermarkimg.Empty then exit;
  if self.CheckBox4.Checked then
    SpinEdit6.Value:=round(SpinEdit5.Value*watermarkimg.height / watermarkimg.width);
end;

procedure TfrmEffect_font.SpinEdit6Change(Sender: TObject);
begin
  if watermarkimg.Empty then exit;
  if self.CheckBox4.Checked then
    SpinEdit5.Value:=round(SpinEdit6.Value*watermarkimg.width / watermarkimg.height);
end;

procedure TfrmEffect_font.CheckBox4Click(Sender: TObject);
begin
  SpinEdit5Change(nil);
end;

procedure TfrmEffect_font.CheckBox5Click(Sender: TObject);
begin
  SpinEdit5Change(nil);
end;

procedure TfrmEffect_font.TrackBar2Change(Sender: TObject);
begin
  self.SpinEdit2.Value:=TrackBar2.Position;
end;

procedure TfrmEffect_font.SpinEdit2Change(Sender: TObject);
begin
  if isvalidinteger(SpinEdit2.Text) then TrackBar2.Position:=self.SpinEdit2.Value;
end;

procedure TfrmEffect_font.CheckBox6Click(Sender: TObject);
begin
  self.TrackBar1.Enabled:=not CheckBox6.Checked;
  self.SpinEdit1.Enabled:=not CheckBox6.Checked;
  self.ColorBox2.Enabled:=not CheckBox6.Checked;
  self.CheckBox1.Enabled:=not CheckBox6.Checked;
end;

end.
