{

   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit Ufrmoption;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, FreeUtils, registry, StdCtrls, CheckLst, ExtCtrls,
  Spin, Buttons;

const
  ExtName = 'nView.Ext';

type
  Tfrmoption = class(TForm)
    bsSkinPanel1: TPanel;
    PageControl1: TPageControl;
    bsSkinTabSheet1: TTabSheet;
    bsSkinButton3: TButton;
    bsSkinCheckListBox1: TCheckListBox;
    TabSheet1: TTabSheet;
    Button1: TButton;
    c_pixelcolorview: TCheckBox;
    Label1: TLabel;
    Label8: TLabel;
    c_viewcolor: TColorBox;
    Button2: TBitBtn;
    Button3: TBitBtn;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    TabSheet2: TTabSheet;
    ComboBox1: TComboBox;
    Label12: TLabel;
    c_vieweffectspeed: TSpinEdit;
    Label15: TLabel;
    c_defaultviewcolor: TColorBox;
    BitBtn3: TBitBtn;
    c_keepratio: TCheckBox;
    TabSheet3: TTabSheet;
    c_cachetype: TComboBox;
    c_cacheenable2: TCheckBox;
    c_cachelimitcount: TSpinEdit;
    Label16: TLabel;
    Label17: TLabel;
    c_cachelimitsize2: TSpinEdit;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    TabSheet4: TTabSheet;
    Label3: TLabel;
    c_thumblistarrange: TComboBox;
    Label4: TLabel;
    c_thumbmaxfilesize: TSpinEdit;
    Label6: TLabel;
    c_thumbbitmapmaxsize: TSpinEdit;
    Label7: TLabel;
    Label5: TLabel;
    Label13: TLabel;
    c_filehintdelay: TSpinEdit;
    Label14: TLabel;
    GroupBox1: TGroupBox;
    c_existnoanswer: TCheckBox;
    Label2: TLabel;
    c_existmethod: TComboBox;
    c_uselastdir: TCheckBox;
    c_showhidden: TCheckBox;
    GroupBox2: TGroupBox;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    c_thumbpreview: TCheckBox;
    c_thumbpreviewcolor: TColorBox;
    c_thumbpreviewsize: TSpinEdit;
    c_thumbpreviewalpha: TSpinEdit;
    c_enablerenameclick: TCheckBox;
    Label21: TLabel;
    c_multipagebaralpha: TSpinEdit;
    BitBtn4: TBitBtn;
    Label22: TLabel;
    c_hintpathmaxlen: TSpinEdit;
    procedure FormCreate(Sender: TObject);
    procedure bsSkinButton3Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure c_cachetypeChange(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmoption: Tfrmoption;

implementation

uses Uconfig, Ufunction, Uregistry, shlobj, Ufrmmain;

{$R *.dfm}

procedure Tfrmoption.FormCreate(Sender: TObject);
var
  s,v:string;
  strlist:tstringlist;
  i,j:integer;
  flag:boolean;
begin
  s:=FIU_GetFullExtList;
  strlist:=tstringlist.Create;
  SplitString(s,strlist,';');
  for i:=0 to strlist.Count-1 do begin
    s:=lowercase(strlist.Strings[i]);
    if pos('ico',s)>0 then continue;
    j:=bsSkinCheckListBox1.Items.Add(s);
    delete(s,1,2);
    v:='';
    RegGetString(HKEY_CLASSES_ROOT,'.'+s+'\',v);
    flag:=pos(ExtName+'.',v)=1;
    bsSkinCheckListBox1.Checked[j]:=flag;
  end;
  strlist.Free;

  c_existnoanswer.Checked:=config.c_existnoanswer;
  c_existmethod.ItemIndex:=config.c_existmethod;
  c_pixelcolorview.Checked:=config.c_pixelcolorview;
  c_thumblistarrange.ItemIndex:=config.c_thumblistarrange;
  c_thumbmaxfilesize.Value:=config.c_thumbmaxfilesize;
  c_thumbbitmapmaxsize.Value:=config.c_thumbbitmapmaxsize;
  c_viewcolor.Selected:=config.c_viewcolor;
  c_uselastdir.Checked:=config.c_uselastdir;
  c_thumbpreviewcolor.Selected:=config.c_thumbpreviewcolor;
  c_thumbpreview.Checked:=config.c_thumbpreview;
  c_thumbpreviewalpha.Value:=config.c_thumbpreviewalpha;
  c_thumbpreviewsize.Value:=config.c_thumbpreviewsize;
  c_vieweffectspeed.Value:=config.c_vieweffectspeed;
  c_filehintdelay.Value:=config.c_filehintdelay;
  c_defaultviewcolor.Selected:=config.c_defaultviewcolor;
  c_showhidden.Checked:=config.c_showhidden;
  c_keepratio.Checked:=config.c_keepratio;

  c_cachetype.ItemIndex:=config.c_cachetype;
  c_cachetypeChange(nil);
  c_cachelimitsize2.Value:=config.c_cachelimitsize2;
  c_cachelimitcount.Value:=config.c_cachelimitcount;
  c_cacheenable2.Checked:=config.c_cacheenable2;
  c_enablerenameclick.Checked:=config.c_enablerenameclick;
  c_multipagebaralpha.Value:=config.c_multipagebaralpha;
  c_hintpathmaxlen.Value:=config.c_hintpathmaxlen;

  PageControl1.Align:=alclient;
  if (config.c_lastoptactiveindex<0) or (config.c_lastoptactiveindex>PageControl1.PageCount-1) then
    config.c_lastoptactiveindex:=0;
  PageControl1.ActivePageIndex:=config.c_lastoptactiveindex;

  frmmain.ImageList1.GetBitmap(4,self.Button2.Glyph);
end;

procedure RegistFileType(ft, key, prg, icon: string);
var Reg: TRegistry;
begin
  if Copy(ft, 1, 1) <> '.' then ft := '.' + ft;
  Reg := TRegistry.Create;
  Reg.RootKey := HKEY_CLASSES_ROOT;
  if Reg.OpenKey('' + ft, True) then Reg.WriteString('', key);
  if Reg.OpenKey('' + key + 'ShellOpenCommand', True) then Reg.WriteString('', prg+' "%1"');
  if Reg.OpenKey('' + key + 'DefaultIcon', True) then Reg.WriteString('', icon);
  Reg.Free;

  SHChangeNotify(SHCNE_ASSOCCHANGED, SHCNF_FLUSH, pchar(''), pchar(''));
end;

procedure Tfrmoption.bsSkinButton3Click(Sender: TObject);
var
  i:integer;
begin
  for i:=0 to bsSkinCheckListBox1.Items.Count-1 do
    bsSkinCheckListBox1.Checked[i]:=true;
end;

procedure Tfrmoption.Button1Click(Sender: TObject);
var
  i:integer;
begin
  for i:=0 to bsSkinCheckListBox1.Items.Count-1 do
    bsSkinCheckListBox1.Checked[i]:=false;
end;

procedure Tfrmoption.Button2Click(Sender: TObject);
const
  extarray: array[0..2] of string = ('bmp','gif','jpg');
var
  i,k:integer;
  s,s1,s2,v,extname2,extnamebak:string;
  param:String;
  flag:boolean;
begin
  if (GetOperatingSystem>=cOsWin95) and (GetOperatingSystem<=cOsWin2003) then begin
    screen.Cursor:=crHourGlass;
    try
     for i:=0 to high(extarray) do begin
       extname2:=ExtName+'.'+extarray[i];
       RegSetString(HKEY_CLASSES_ROOT,extname2+'\','nView-,̹');
       RegSetString(HKEY_CLASSES_ROOT,extname2+'\DefaultIcon\', Application.ExeName + ','+inttostr(i));
       RegSetString(HKEY_CLASSES_ROOT,extname2+'\Shell\Open\command\',format('"%s" "%s"',[Application.ExeName,'%1']));
     end;

     k:=0;
     for i:=0 to bsSkinCheckListBox1.Items.Count-1 do begin
       s:=bsSkinCheckListBox1.Items.Strings[i];
       delete(s,1,2);
       s:=lowercase(s);
       if bsSkinCheckListBox1.Checked[i] then begin
         inc(k);
         s1:='';
         RegGetString(HKEY_CLASSES_ROOT,'.'+s+'\',s1);
         if (s1<>'') and (pos(trim(ExtName),trim(s1))<>1) then begin
           RegSetString(HKEY_LOCAL_MACHINE,'software\'+thisregname+'\ext\'+s,s1);
         end;
         if (s='jpg') or (s='jpeg') then
           extname2:=ExtName+'.'+extarray[2]
         else if (s='gif') then
           extname2:=ExtName+'.'+extarray[1]
         else
           extname2:=ExtName+'.'+extarray[0];
         RegSetString(HKEY_CLASSES_ROOT,'.'+s+'\',extname2);
         RegSetString(HKEY_CURRENT_USER,
           'Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.'+s+'\Progid', extname2);
         RegDelKey(HKEY_CURRENT_USER,'Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.'+s+'\UserChoice');
         RegDelKey(HKEY_CURRENT_USER,'Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.'+s+'\UserChoice\');         
         RegSetString(HKEY_CURRENT_USER,
           'Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.'+s+'\UserChoice\Progid',
           extname2);
       end else begin
         v:='';
         RegGetString(HKEY_CLASSES_ROOT,'.'+s+'\',v);
         flag:=pos(ExtName+'.',v)=1;
         if flag then begin
           extnamebak:='';
           RegGetString(HKEY_LOCAL_MACHINE,'software\'+thisregname+'\ext\'+s,extnamebak);
           RegSetString(HKEY_CLASSES_ROOT,'.'+s+'\',extnamebak);
           RegSetString(HKEY_CURRENT_USER,
               'Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.'+s+'\Progid',extnamebak);
         end;
       end;
     end;
   
     if (k=0) then begin
       for i:=0 to high(extarray) do begin
         extname2:=ExtName+'.'+extarray[i];
         deletesubregkey(HKEY_CLASSES_ROOT,extname2+'\');
       end;
     end;
   
     SHChangeNotify(SHCNE_ASSOCCHANGED, SHCNF_IDLIST+SHCNF_FLUSH, nil,nil);
    finally
      screen.Cursor:=crDefault;
    end;
    MessageDlg('Ͽϴ.',mtInformation, [mbOk], 0);

  end else begin

    k:=0;
    for i:=0 to bsSkinCheckListBox1.Items.Count-1 do begin
      s:=bsSkinCheckListBox1.Items.Strings[i];
      delete(s,1,2);
      s:=lowercase(s);
      if bsSkinCheckListBox1.Checked[i] then begin
        inc(k);
        if s1<>'' then s1:=s1+'|';
        s1:=s1+s;
      end else begin
        if s2<>'' then s2:=s2+'|';
        s2:=s2+s;
      end;
    end;
  
    param:=format('"extsetting" "%s" "%S"',[s1,s2]);
    if (k=0) then begin
      param:=param+' "deletesubregkey"';
    end;

    s:=GetAppDirectory2+'admin.exe';
    if sysutils.FileExists(s) then begin
      if RunAsAdmin(self.Handle, s, param, true) then begin
        MessageDlg(' Ͽϴ.',mtInformation, [mbOk], 0);
      end;
    end else
      MessageDlg('   ϴ.',mterror, [mbOk], 0);

  end;
end;

function StringListCompareStrings(List: TStringList; Index1, Index2: Integer): Integer;
begin
  Result := comparetext(List.Strings[Index1],
                                List.Strings[Index2]);
  Result:=Result*-1;
end;

function getlastshellfile():string;
var
  dir,s:string;
  SR: TSearchRec;
  strlist:tstringlist;
  i:integer;
begin
  result:='';
  strlist:=tstringlist.Create;
  try
    dir:=GetAppDirectory2;
    if FindFirst(dir+'shell_*.dll', faAnyFile, SR) = 0 then
     repeat
       if (SR.Attr <> faDirectory) and (SR.Name[1] <> '.') then begin
         strlist.Add(SR.Name);
       end;
     Until (FindNext(SR)<>0);
    FindClose(SR);
    if strlist.Count=0 then begin
      result:=dir+'shellmenu.dll';
      exit;
    end;
    strlist.CustomSort(StringListCompareStrings);
    result:=dir+strlist.Strings[0];
  finally
    strlist.Free;
  end;
end;

procedure Tfrmoption.Button3Click(Sender: TObject);
var
  s,param:string;
begin
  s:=getlastshellfile();
    param:='"shellsetting"';
    if self.ComboBox1.ItemIndex=0 then begin
      param:=param+' "0"';
      if sysutils.FileExists(s)=false then begin
        MessageDlg('Ž ޴  ϴ.',mtInformation, [mbOk], 0);
        exit;
      end;
    end else begin
      param:=param+' "1"';
    end;

    s:=GetAppDirectory2+'admin.exe';
    if sysutils.FileExists(s) then begin
      if RunAsAdmin(self.Handle, s, param, true) then begin
        if self.ComboBox1.ItemIndex=0 then begin
          MessageDlg(' Ͽϴ.',mtInformation, [mbOk], 0);
        end else begin
          MessageDlg(' Ͽϴ.',mtInformation, [mbOk], 0);
        end;
      end;
    end else
      MessageDlg('   ϴ.',mterror, [mbOk], 0);
end;

procedure Tfrmoption.BitBtn1Click(Sender: TObject);
begin
  config.c_existnoanswer:=c_existnoanswer.Checked;
  config.c_existmethod:=c_existmethod.ItemIndex;
  config.c_pixelcolorview:=c_pixelcolorview.Checked;
  config.c_thumblistarrange:=c_thumblistarrange.ItemIndex;
  config.c_thumbmaxfilesize:=c_thumbmaxfilesize.Value;
  config.c_thumbbitmapmaxsize:=c_thumbbitmapmaxsize.Value;
  config.c_viewcolor:=c_viewcolor.Selected;
  config.c_uselastdir:=c_uselastdir.Checked;

  config.c_thumbpreviewcolor:=c_thumbpreviewcolor.Selected;
  config.c_thumbpreview:=c_thumbpreview.Checked;
  config.c_thumbpreviewalpha:=c_thumbpreviewalpha.Value;
  config.c_thumbpreviewsize:=c_thumbpreviewsize.Value;
  config.c_vieweffectspeed:=c_vieweffectspeed.Value;
  config.c_filehintdelay:=c_filehintdelay.Value;
  config.c_defaultviewcolor:=c_defaultviewcolor.Selected;
  config.c_showhidden:=c_showhidden.Checked;
  config.c_keepratio:=c_keepratio.Checked;

  config.c_cachetype:=c_cachetype.ItemIndex;
  config.c_cachelimitsize2:=c_cachelimitsize2.Value;
  config.c_cachelimitcount:=c_cachelimitcount.Value;
  config.c_cacheenable2:=c_cacheenable2.Checked;
  config.c_enablerenameclick:=c_enablerenameclick.Checked;
  config.c_multipagebaralpha:=c_multipagebaralpha.Value;
  config.c_hintpathmaxlen:=c_hintpathmaxlen.Value;
end;

procedure Tfrmoption.BitBtn3Click(Sender: TObject);
begin
  c_existnoanswer.Checked:=false;
  c_existmethod.ItemIndex:=0;
  c_pixelcolorview.Checked:=true;
  c_thumblistarrange.ItemIndex:=0;
  c_thumbmaxfilesize.Value:=6;
  c_thumbbitmapmaxsize.Value:=40;
  c_viewcolor.Selected:=$000000;
  c_uselastdir.Checked:=false;
  c_thumbpreviewcolor.Selected:=clred;
  c_thumbpreview.Checked:=true;
  c_thumbpreviewalpha.Value:=150;
  c_thumbpreviewsize.Value:=150;
  c_vieweffectspeed.Value:=25;
  c_filehintdelay.Value:=350;
  c_defaultviewcolor.Selected:=clBtnFace;
  c_showhidden.Checked:=true;
  c_keepratio.Checked:=false;
  c_cachetype.ItemIndex:=0;
  c_cachelimitsize2.Value:=40;
  c_cachelimitcount.Value:=12;
  c_cacheenable2.Checked:=true;
  c_enablerenameclick.Checked:=true;
  c_multipagebaralpha.Value:=190;
  c_hintpathmaxlen.Value:=60;
end;

procedure Tfrmoption.c_cachetypeChange(Sender: TObject);
begin
  c_cachelimitsize2.Enabled:=c_cachetype.ItemIndex=0;
  c_cachelimitcount.Enabled:=not c_cachelimitsize2.Enabled;
end;

procedure Tfrmoption.FormDestroy(Sender: TObject);
begin
  config.c_lastoptactiveindex:=PageControl1.ActivePageIndex;
end;

procedure Tfrmoption.BitBtn4Click(Sender: TObject);
begin
  BitBtn1Click(nil);
  frmmain.set_config;
end;

end.
