{
   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit Ufrmmerge;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin, Buttons, ExtCtrls, UnViewColorBox;

type
  Tfrmmerge = class(TForm)
    BitBtn2: TBitBtn;
    BitBtn1: TBitBtn;
    SpinEdit1: TSpinEdit;
    Label1: TLabel;
    ComboBox1: TComboBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    SpinEdit2: TSpinEdit;
    Label5: TLabel;
    SpinEdit3: TSpinEdit;
    ComboBox2: TComboBox;
    Label6: TLabel;
    bsSkinStdLabel2: TLabel;
    ColorBox1: TnViewColorBox;
    CheckBox1: TCheckBox;
    Label7: TLabel;
    procedure ComboBox1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
    sizelist:tlist;
  end;

var
  frmmerge: Tfrmmerge;

implementation
uses Ufrmmain, Uconfig;
{$R *.dfm}

procedure Tfrmmerge.FormCreate(Sender: TObject);
begin
  sizelist:=tlist.Create;

  self.SpinEdit1.Value:=config.getvaluebyinteger('merge_gaps',10);
  self.ComboBox1.ItemIndex:=config.getvaluebyinteger('merge_direction',0);
  self.ComboBox2.ItemIndex:=config.getvaluebyinteger('merge_fit',0);
  self.CheckBox1.Checked:=boolean(config.getvaluebyinteger('merge_center',1));
  self.ColorBox1.Selected:=config.getvaluebyinteger('merge_color',clwhite);
end;

procedure Tfrmmerge.FormDestroy(Sender: TObject);
begin
  sizelist.Free;
end;

procedure Tfrmmerge.ComboBox1Change(Sender: TObject);
var
  i:integer;
  data:PWorkImage;
  w,h:integer;
begin
  w:=0;
  h:=0;
  if ComboBox1.ItemIndex=0 then begin
    for i:=0 to sizelist.Count-1 do begin
      data:=PWorkImage(sizelist.Items[i]);
      if h>0 then h:=h+SpinEdit1.Value;
      h:=h+data.bitmap.Height;
      if ComboBox2.ItemIndex=0 then begin
        if data.bitmap.width>w then w:=data.bitmap.width;
      end else begin
        if (w=0) or (data.bitmap.width<w) then w:=data.bitmap.width;
      end;
    end;
    self.SpinEdit2.Value:=w;
    self.SpinEdit3.Value:=h;

  end else begin
    for i:=0 to sizelist.Count-1 do begin
      data:=PWorkImage(sizelist.Items[i]);
      if w>0 then w:=w+SpinEdit1.Value;
      w:=w+data.bitmap.width;
      if ComboBox2.ItemIndex=0 then begin
        if data.bitmap.height>h then h:=data.bitmap.height;
      end else begin
        if (h=0) or (data.bitmap.height<h) then h:=data.bitmap.height;
      end;
    end;
    self.SpinEdit2.Value:=w;
    self.SpinEdit3.Value:=h;

  end;
end;

procedure Tfrmmerge.FormShow(Sender: TObject);
begin
  self.Label3.Caption:=format('%d ̹ ġ',[sizelist.Count]);
  ComboBox1Change(nil);
end;

procedure Tfrmmerge.BitBtn2Click(Sender: TObject);
begin
  ComboBox1Change(nil);
  if (SpinEdit2.Value*SpinEdit3.Value)>(6000*6000) then begin
    MessageDlg(' ̹  ʹ Ůϴ.',mterror, [mbOk], 0);
    exit;
  end;
  self.ModalResult:=mrok;
end;

procedure Tfrmmerge.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  config.setvaluebyinteger('merge_gaps',self.SpinEdit1.Value);
  config.setvaluebyinteger('merge_direction',self.ComboBox1.ItemIndex);
  config.setvaluebyinteger('merge_fit',self.ComboBox2.ItemIndex);
  config.setvaluebyinteger('merge_center',integer(self.CheckBox1.Checked));
  config.setvaluebyinteger('merge_color',self.ColorBox1.Selected);
end;

end.
