{

   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit UfrmEffect_Mosaic;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UfrmEffectBase, StdCtrls, Spin, ComCtrls, ExtCtrls;

type
  TfrmEffect_Mosaic = class(TfrmEffectBase)
    Panel1: TPanel;
    TrackBar4: TTrackBar;
    SpinEdit1: TSpinEdit;
    procedure FormCreate(Sender: TObject);
    procedure TrackBar4Change(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    procedure ok_select; override;
    procedure set_effectapply;
    procedure imageprocess(var src:tbitmap);
  public
    { Public declarations }
  end;

var
  frmEffect_Mosaic: TfrmEffect_Mosaic;

implementation

uses im_Effects, Uconfig, Ufunction, UfrmMain;
{$R *.dfm}

procedure TfrmEffect_Mosaic.FormCreate(Sender: TObject);
begin
  inherited;
  Panel1.Align:=alclient;

  PanelPreView.Width:=250;
  PanelPreView.Align:=alLeft;
end;

procedure TfrmEffect_Mosaic.TrackBar4Change(Sender: TObject);
begin
  imagepreview1.Bitmap.Assign(thumb_bitmap32);
  Effect_Mosaic(imagepreview1.bitmap,round(trackbar4.Position*thumbratio));
  if SpinEdit1.Value<>trackbar4.Position then
    SpinEdit1.Value:=trackbar4.Position;
end;

procedure TfrmEffect_Mosaic.SpinEdit1Change(Sender: TObject);
begin
  if isvalidinteger(SpinEdit1.Text) then trackbar4.Position:=round(SpinEdit1.Value);
end;

procedure TfrmEffect_Mosaic.FormShow(Sender: TObject);
begin
  make_thumbimage;
  imagepreview1.Bitmap.Assign(thumb_bitmap32);

  config.getvaluebyinteger('mosaic_value');
  if config.lastvalue_integer>0 then
    TrackBar4.Position:=config.lastvalue_integer;

  applyselect.Visible:=not frmmain.is_layerselected;
end;

procedure TfrmEffect_Mosaic.set_effectapply;
begin
  Effect_Mosaic(org_bitmap32,trackbar4.Position);
end;

procedure TfrmEffect_Mosaic.ok_select;
begin
  inherited;
  
  config.setvaluebyinteger('mosaic_value',TrackBar4.Position);
  if applyselect.ItemIndex=0 then begin
    Screen.Cursor:=crHourglass;
    try
      set_effectapply;
      imagepreview1.Bitmap.Assign(org_bitmap32);
    finally
      screen.Cursor:=crdefault;
    end;
    exit;
  end;

  frmmain.apply_listimages(applyselect.ItemIndex=1,imageprocess,etMosaic,self.Caption);
  self.ModalResult:=mrcancel;
end;

procedure TfrmEffect_Mosaic.imageprocess(var src:tbitmap);
begin
  org_bitmap32.Assign(src);
  set_effectapply;
  org_bitmap32.AssignTo24(src);
end;

end.
