program admin;

uses
  windows,
  sysutils,
  vistaman,
  dialogs,
  shlobj,
  forms,
  classes,
  Uregistry in 'Uregistry.pas',
  Ufunction in 'Ufunction.pas';

{$R *.res}

const
  ExtName = 'nView.Ext';
  thisregname = 'nSeries\nView';

procedure set_extension();
const
  extarray: array[0..2] of string = ('bmp','gif','jpg');
var
  i,k:integer;
  s,s1,v,extname2,extnamebak:string;
  flag:boolean;
  strlist:tstringlist;
begin
  for i:=0 to high(extarray) do begin
    extname2:=ExtName+'.'+extarray[i];
    s:=GetAppDirectory+'nView.exe';
    RegSetString(HKEY_CLASSES_ROOT,extname2+'\','nView-,̹');
    RegSetString(HKEY_CLASSES_ROOT,extname2+'\DefaultIcon\', format('"%s",%d',[s,i]));
    RegSetString(HKEY_CLASSES_ROOT,extname2+'\Shell\Open\command\',format('"%s" "%s"',[s,'%1']));
  end;

  strlist:=tstringlist.Create;
  try
   SplitString(paramstr(2),strlist,'|');
   for i:=0 to strlist.Count-1 do begin
     s:=trim(strlist.Strings[i]);
     if s='' then continue;
     s1:='';
     RegGetString(HKEY_CLASSES_ROOT,'.'+s+'\',s1);
     if (s1<>'') and (pos(trim(ExtName),trim(s1))<>1) then begin
       RegSetString(HKEY_LOCAL_MACHINE,'software\'+thisregname+'\ext\'+s,s1);
     end;
     if (s='jpg') or (s='jpeg') then
       extname2:=ExtName+'.'+extarray[2]
     else if (s='gif') then
       extname2:=ExtName+'.'+extarray[1]
     else
       extname2:=ExtName+'.'+extarray[0];
     RegSetString(HKEY_CLASSES_ROOT,'.'+s+'\',extname2);
     RegSetString(HKEY_CURRENT_USER,
      'Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.'+s+'\Progid',
       extname2);
     RegDelKey(HKEY_CURRENT_USER,'Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.'+s+'\UserChoice');
     RegDelKey(HKEY_CURRENT_USER,'Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.'+s+'\UserChoice\');
     RegSetString(HKEY_CURRENT_USER,
      'Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.'+s+'\UserChoice\Progid',
       extname2);
   end;

   strlist.Clear;
   SplitString(paramstr(3),strlist,'|');
   for i:=0 to strlist.Count-1 do begin
     s:=trim(strlist.Strings[i]);
     if s='' then continue;
     v:='';
     RegGetString(HKEY_CLASSES_ROOT,'.'+s+'\',v);
     flag:=pos(ExtName+'.',v)=1;
     if flag then begin
       extnamebak:='';
       RegGetString(HKEY_LOCAL_MACHINE,'software\'+thisregname+'\ext\'+s,extnamebak);
       RegSetString(HKEY_CLASSES_ROOT,'.'+s+'\',extnamebak);
       RegSetString(HKEY_CURRENT_USER,
            'Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.'+s+'\Progid',extnamebak);
     end;
   end;
  finally
   strlist.Free;
  end;

  if paramstr(3)='deletesubregkey' then begin
    deletesubregkey(HKEY_CLASSES_ROOT,extname2+'\');
  end;

  SHChangeNotify(SHCNE_ASSOCCHANGED, SHCNF_IDLIST+SHCNF_FLUSH, nil,nil);
end;

function StringListCompareStrings(List: TStringList; Index1, Index2: Integer): Integer;
begin
  Result := comparetext(List.Strings[Index1],
                                List.Strings[Index2]);
  Result:=Result*-1;
end;

function getlastshellfile(delete:boolean):string;
var
  dir,s:string;
  SR: TSearchRec;
  strlist:tstringlist;
  i:integer;
begin
  result:='';
  strlist:=tstringlist.Create;
  try
    dir:=GetAppDirectory;
    if FindFirst(dir+'shell_*.dll', faAnyFile, SR) = 0 then
     repeat
       if (SR.Attr <> faDirectory) and (SR.Name[1] <> '.') then begin
         strlist.Add(SR.Name);
       end;
     Until (FindNext(SR)<>0);
    FindClose(SR);
    if strlist.Count=0 then begin
      result:=dir+'shellmenu.dll';
      exit;
    end;
    strlist.CustomSort(StringListCompareStrings);
    result:=dir+strlist.Strings[0];
    if delete then begin
      for i:=1 to strlist.Count-1 do begin
        s:=dir+strlist.Strings[i];
        if deletefile(s)=false then
          rebootdelete(s);
      end;
      s:=dir+'shellmenu.dll';
      if sysutils.FileExists(s) then
        if deletefile(s)=false then
          rebootdelete(s);
    end;
  finally
    strlist.Free;
  end;
end; 

procedure set_shellextension();
var
  s:string;
begin
  if paramstr(3)='1' then
    s:=getlastshellfile(true)
  else
    s:=getlastshellfile(false);
     if paramstr(2)='0' then begin
       if sysutils.FileExists(s)=false then begin
         exit;
       end;
       RegisterOCX(s);
       RegDelKey(HKEY_CLASSES_ROOT,'*\shellex\ContextMenuHandlers\nView Shellmenu\');
       RegSetString(HKEY_CLASSES_ROOT,'*\shellex\ContextMenuHandlers\1,nView Shellmenu\',
        '{1EC8B7CE-BB7B-4108-B74C-6DB37FF99274}');
       RegSetString(HKEY_CLASSES_ROOT,'Directory\shellex\ContextMenuHandlers\1,nView Shellmenu\',
        '{1EC8B7CE-BB7B-4108-B74C-6DB37FF99274}');
     end else begin
       RegDelKey(HKEY_CLASSES_ROOT,'*\shellex\ContextMenuHandlers\nView Shellmenu\');
       RegDelKey(HKEY_CLASSES_ROOT,'*\shellex\ContextMenuHandlers\1,nView Shellmenu\');
       RegDelKey(HKEY_CLASSES_ROOT,'Directory\shellex\ContextMenuHandlers\1,nView Shellmenu\');
       if sysutils.FileExists(s) then begin
         UnRegisterOCX(s);
       end;
     end;
end;

function proc_uninstall:boolean;
var
  s,v,extnamebak:string;
  strlist:tstringlist;
  i:integer;
  flag:boolean;
begin
  RegDelKey(HKEY_CLASSES_ROOT,'*\shellex\ContextMenuHandlers\nView Shellmenu\');
  RegDelKey(HKEY_CLASSES_ROOT,'*\shellex\ContextMenuHandlers\1,nView Shellmenu\');
  RegDelKey(HKEY_CLASSES_ROOT,'Directory\shellex\ContextMenuHandlers\1,nView Shellmenu\');
  s:=getlastshellfile(false);
  if sysutils.FileExists(s) then begin
    UnRegisterOCX(s);
  end;

  s:='*.bmp;*.jpg;*.jif;*.jpeg;*.jpe;*.jng;*.koa;*.iff;*.lbm;*.mng;*.pbm;*.pbm;*.pcd;'
     +'*.pcx;*.pgm;*.pgm;*.png;*.ppm;*.ppm;*.ras;*.tga;*.targa;*.tif;*.tiff;*.wap;*.wbmp;*.wbm;*.psd;*.cut;*.xbm;*.xpm;*.dds;*.gif';
  strlist:=tstringlist.Create;
  SplitString(s,strlist,';');
  for i:=0 to strlist.Count-1 do begin
    s:=strlist.Strings[i];
    delete(s,1,2);
      v:='';
      RegGetString(HKEY_CLASSES_ROOT,'.'+s+'\',v);
      flag:=pos(ExtName+'.',v)=1;
      if flag then begin
        extnamebak:='';
        RegGetString(HKEY_LOCAL_MACHINE,'software\'+thisregname+'\ext\'+s,extnamebak);
        RegSetString(HKEY_CLASSES_ROOT,'.'+s+'\',extnamebak);
        RegSetString(HKEY_CURRENT_USER,
            'Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\.'+s+'\Progid',extnamebak);
      end;
  end;
  strlist.Free;
  SHChangeNotify(SHCNE_ASSOCCHANGED, SHCNF_FLUSH, nil, nil);
end;

var
  s,s1:string;
begin
  application.Title:='α׷ ';
  if (paramstr(1)='') then exit;

  if (paramstr(1)='extsetting') then
    set_extension()
  else if (paramstr(1)='shellsetting') then
    set_shellextension()
  else if (paramstr(1)='uninstall') then
    proc_uninstall();

{  else if (paramstr(1)='install') then begin
    s:=GetAppDirectory+'shellmenu.dll.replace';
    if sysutils.FileExists(s) then begin
      s1:=GetAppDirectory+'shellmenu.dll';
      if sysutils.FileExists(s1) then begin
        if GetVersion(s)=GetVersion(s1) then begin
          deletefile(s);
          exit;
        end;
        if deletefile(s1)=false then begin
          rebootrename(s,s1);
          MessageBox(0,'"Ž޴ ̸"  ̶ Ŀ ġ  ˴ϴ.','˸',MB_OK or MB_ICONINFORMATION or MB_SYSTEMMODAL);
          exit;
        end;
      end;
      windows.MoveFile(pchar(s),pchar(s1));
    end;
  end;}

//  MessageDlg(' Ͽϴ.', mtInformation, [mbOk], 0);
end.
