{

   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
{$D-}
unit Ufunction;

interface

uses
  Windows, Forms, sysutils, ShellAPI, Graphics, messages,
  ShlObj, CommCtrl, Classes, ActiveX,
  StdCtrls, Buttons, controls, Psapi, tlhelp32;

  function GetAppDirectory:string;
  function GetAppDirectory2:string;
  function GetWindowsDir:string;
  function GetSystemImageList(Large: boolean): HImageList;
  function GetSystemPath(Folder: Integer): string;
  function GetIconIndex(const APath: string; Attrs: DWORD): integer;
  function GetIconIndex2(const APath: string; Attrs: DWORD): integer;
  procedure SplitString(str:string;var returnStr:TStringList;splitchar:char);
  function Get_File_Size2(const S: string): Int64;
  function DateConvert(s:string):string;
  function AdvSelectDirectory(hOwn: HWND; const Caption: string; const Root: WideString;
    var Directory: string; EditBox: Boolean = False; ShowFiles: Boolean = False;
    AllowCreateDirs: Boolean = True): Boolean;
  function ConvertSize(value:int64):string;
  function MyInputBox(owner:TComponent;
    caption,msg:string;ispassword:boolean;var value:string):boolean;

  function HexToTColor(S : string): TColor;
  function ColorToHTML(AColor:TColor):string;
  function compactstring(s:widestring;size:integer):string;
  function makeuniqfilename(s:string):string;
  function ExecuteFile(filename:string; visible:boolean): Boolean;
  function GetVersion(filename:string): string;
  function difftime(timestamp:tdatetime):integer;
  function RegisterOCX(FileName: string): Boolean;
  function UnRegisterOCX(FileName: string): Boolean;
  function findupdir(s:string):string;
  function GetOperatingSystem: Integer;
  function RunAsAdmin(hWnd: HWND; filename: string; Parameters: string;waiting:boolean): Boolean;
  procedure lockcontrol(c: THandle; lock: boolean);
  function InputQuery2(owner:tform; const ACaption, APrompt: string;var Value: string): Boolean;
  function InputQuery3(owner:tform; x,y:integer; const ACaption, APrompt: string; var Value: string): Boolean;
  Procedure PostKeyEx( hWindow: HWnd; key: Word; Const shift: TShiftState;
                     specialkey:Boolean; restorekey:boolean=true);
  function GetShellPath(nfolder:integer):string;
  function SystemErrorMessage: string;
  function deletebadfilenamechar(s:string):string;
  function issystemfolder(s:string):boolean;
  function cutstring(s:string;len:integer):string;

const
  { operating system (OS)constants }
  cOsUnknown = -1;
  cOsWin95 = 0;
  cOsWin98 = 1;
  cOsWinME = 2;
  cOsWin98SE = 3;
  cOsWinNT = 4;
  cOsWin2000 = 5;
  cOsXP = 6;
  cOsWin2003 = 7;
  cOsVista = 8;
  cOsWin2008 = 9;

implementation

function GetAppDirectory:string;
begin
  result:=ExtractFilePath(Application.ExeName);
  result:=result+'view\';
end;

function GetAppDirectory2:string;
begin
  result:=ExtractFilePath(Application.ExeName);
end;

function GetWindowsDir:string;
var
  Buf: array[0..MAX_PATH] of char;
begin
  windows.GetWindowsDirectory(Buf, MAX_PATH);
  result:=string(buf)+'\';
end;

function ConvertSize(value:int64):string;
var
  d:double;
begin
try
  if value > (1024*1024) then begin
     d := (value / (1024*1024));
     result:=formatfloat('##.#', d) + ' M';
  end else if value > 1024 then begin
     d := (value / 1024);
     result:=formatfloat('##.#', d) + ' Kb';
  end else begin
     result:=floattostr(value) + ' b';
  end;
except
  result:= '0 b';
end;
end;

function GetSystemPath(Folder: Integer): string;
var
  PIDL: PItemIDList;
  Path: LPSTR;
  AMalloc: IMalloc;
begin
  Path := StrAlloc(MAX_PATH);
  SHGetSpecialFolderLocation(Application.Handle, Folder, PIDL);
  if SHGetPathFromIDList(PIDL, Path) then
    Result := Path;
  SHGetMalloc(AMalloc);
  AMalloc.Free(PIDL);
  StrDispose(Path);
  if Result[length(Result)]<>'\' then Result:=Result+'\';
end;

procedure SplitString(str:string;var returnStr:TStringList;splitchar:char);
var
 p1:integer;
 y:string;
begin

 p1:=pos(splitchar,str);
 while p1>0 do
 begin
    y:=copy(str,1,p1-1);
    returnStr.Add(y);
    delete(str,1,p1);
    p1:=pos(splitchar,str);
 end;
 if str <> '' then returnStr.Add(str);

end;

function GetSystemImageList(Large: boolean): HImageList;
var
  SFI: TSHFileInfo;
begin
  // SHGetFileInfo puts the requested information in the SFI variable, but it
  // also can return the handle of the system image list.  We just pass an
  // empty file because we aren't interested in it, only the returned handle.
  if Large then
    Result := SHGetFileInfo('', 0, SFI, SizeOf(SFI),
      SHGFI_SYSICONINDEX or SHGFI_LARGEICON)
  else
    Result := SHGetFileInfo('', 0, SFI, SizeOf(SFI),
      SHGFI_SYSICONINDEX or SHGFI_SMALLICON);
end;

function GetIconIndex(const APath: string; Attrs: DWORD): integer;
var
  SFI: TSHFileInfo;
begin
  if FileExists(APath) or DirectoryExists(APath) then
    // If the file or directory exists, just let Windows figure out it's attrs.
    SHGetFileInfo(PChar(APath), 0, SFI, SizeOf(TSHFileInfo),
      SHGFI_SYSICONINDEX)
  else
    // File doesn't exist, so Windows doesn't know what to do with it.  We have
    // to tell it by passing the attributes we want, and specifying the
    // SHGFI_USEFILEATTRIBUTES flag so that the function knows to use them.
    SHGetFileInfo(PChar(APath), Attrs, SFI, SizeOf(TSHFileInfo),
      SHGFI_SYSICONINDEX or SHGFI_USEFILEATTRIBUTES);
  Result := SFI.iIcon;
end;

function GetIconIndex2(const APath: string; Attrs: DWORD): integer;
var
  SFI: TSHFileInfo;
begin
    SHGetFileInfo(PChar(APath), Attrs, SFI, SizeOf(TSHFileInfo),
      SHGFI_SYSICONINDEX or SHGFI_USEFILEATTRIBUTES);
  Result := SFI.iIcon;
end;

function Get_File_Size2(const S: string): Int64;
var
  FD: TWin32FindData;
  FH: THandle;
begin
  FH := FindFirstFile(PChar(S), FD);
  if FH = INVALID_HANDLE_VALUE then Result := 0
  else begin
    try
      Result := FD.nFileSizeHigh;
      Result := Result shl 32;
      Result := Result + FD.nFileSizeLow;
    finally
      windows.FindClose(FH);
    end;
  end;
end;

function DateConvert(s:string):string;
var
 s2:string;
 DateTime :TDatetime;
// FormatSettings:TFormatSettings;
begin

  s2:=copy(s,6,3);
  delete(s,6,3);
  delete(s2,1,1);
  if strtoint(s2)>80 then s2:='19'+s2
  else s2:='20'+s2;
  s:=s2+'-'+s;

//  GetLocaleFormatSettings(LOCALE_USER_DEFAULT, FormatSettings);
  DateTime:=StrToDateTime(s); //,FormatSettings);
  result:=sysutils.FormatDateTime('yyyy-mm-dd ampm h:nn',DateTime);

end;

function AdvSelectDirectory(hOwn: HWND; const Caption: string; const Root: WideString;
  var Directory: string; EditBox: Boolean = False; ShowFiles: Boolean = False;
  AllowCreateDirs: Boolean = True): Boolean;
  // callback function that is called when the dialog has been initialized
  //or a new directory has been selected 

  // Callback-Funktion, die aufgerufen wird, wenn der Dialog initialisiert oder
  //ein neues Verzeichnis selektiert wurde 
  function SelectDirCB(Wnd: HWND; uMsg: UINT; lParam, lpData: lParam): Integer; 
    stdcall; 
  var 
    PathName: array[0..MAX_PATH] of Char; 
  begin 
    case uMsg of 
      BFFM_INITIALIZED: SendMessage(Wnd, BFFM_SETSELECTION, Ord(True), Integer(lpData));
      // include the following comment into your code if you want to react on the 
      //event that is called when a new directory has been selected 
      // binde den folgenden Kommentar in deinen Code ein, wenn du auf das Ereignis 
      //reagieren willst, das aufgerufen wird, wenn ein neues Verzeichnis selektiert wurde 
      {BFFM_SELCHANGED: 
      begin 
        SHGetPathFromIDList(PItemIDList(lParam), @PathName); 
        // the directory "PathName" has been selected
        // das Verzeichnis "PathName" wurde selektiert
      end;} 
    end; 
    Result := 0; 
  end;
var
  WindowList: Pointer; 
  BrowseInfo: TBrowseInfo; 
  Buffer: PChar; 
  RootItemIDList, ItemIDList: PItemIDList; 
  ShellMalloc: IMalloc;
  IDesktopFolder: IShellFolder; 
  Eaten, Flags: LongWord; 
const 
  // necessary for some of the additional expansions
  // notwendig fur einige der zusatzlichen Erweiterungen 
  BIF_USENEWUI = $0040; 
  BIF_NOCREATEDIRS = $0200; 
begin 
  Result := False; 
  if not DirectoryExists(Directory) then
    Directory := ''; 
  FillChar(BrowseInfo, SizeOf(BrowseInfo), 0); 
  if (ShGetMalloc(ShellMalloc) = S_OK) and (ShellMalloc <> nil) then
  begin 
    Buffer := ShellMalloc.Alloc(MAX_PATH); 
    try 
      RootItemIDList := nil; 
      if Root <> '' then 
      begin
        SHGetDesktopFolder(IDesktopFolder);
        IDesktopFolder.ParseDisplayName(hOwn, nil,
          POleStr(Root), Eaten, RootItemIDList, Flags);
      end; 
      OleInitialize(nil); 
      with BrowseInfo do 
      begin
        hwndOwner := hOwn;
        pidlRoot := RootItemIDList; 
        pszDisplayName := Buffer; 
        lpszTitle := PChar(Caption); 
        // defines how the dialog will appear:
        // legt fest, wie der Dialog erscheint: 
        ulFlags := BIF_RETURNONLYFSDIRS or BIF_USENEWUI or 
          BIF_EDITBOX * Ord(EditBox) or BIF_BROWSEINCLUDEFILES * Ord(ShowFiles) or 
          BIF_NOCREATEDIRS * Ord(not AllowCreateDirs); 
        lpfn    := @SelectDirCB;
        if Directory <> '' then 
          lParam := Integer(PChar(Directory)); 
      end; 
      WindowList := DisableTaskWindows(0); 
      try 
        ItemIDList := ShBrowseForFolder(BrowseInfo); 
      finally 
        EnableTaskWindows(WindowList); 
      end; 
      Result := ItemIDList <> nil; 
      if Result then 
      begin 
        ShGetPathFromIDList(ItemIDList, Buffer);
        ShellMalloc.Free(ItemIDList);
        Directory := Buffer;
      end;
    finally
      ShellMalloc.Free(Buffer);
    end;
  end;
end;

function MyInputBox(owner:TComponent;
   caption,msg:string;ispassword:boolean;var value:string):boolean;
var
  frm1:TForm;
  label1:TLabel;
  edit1:TEdit;
  BitBtn1,BitBtn2:TBitBtn;
begin
  frm1:=TForm.Create(owner);
  frm1.Font:=Application.MainForm.Font;
  frm1.BorderStyle:=bsDialog;
  frm1.Position:=poMainFormCenter;
  frm1.Width:=300;
  frm1.Height:=132;
  frm1.Caption:=caption;
  label1:=TLabel.Create(frm1);
  label1.Parent:=frm1;
  label1.Left:=16;
  label1.Top:=8;
  label1.Caption:=msg;
  edit1:=TEdit.Create(frm1);
  edit1.Parent:=frm1;
  edit1.Left:=16;
  edit1.Top:=32;
  edit1.Width:=257;
  edit1.Text:=value;
  if ispassword then
    edit1.PasswordChar:='*'
  else
    edit1.PasswordChar:=#0;
  BitBtn1:=TBitBtn.Create(frm1);
  BitBtn1.Parent:=frm1;
  BitBtn1.Left:=70;
  BitBtn1.Top:=72;
  BitBtn1.Width:=75;
  BitBtn1.Height:=25;
  BitBtn1.Kind:=bkOK;
  BitBtn1.Caption:='Ȯ';
  BitBtn2:=TBitBtn.Create(frm1);
  BitBtn2.Parent:=frm1;
  BitBtn2.Left:=150;
  BitBtn2.Top:=72;
  BitBtn2.Width:=75;
  BitBtn2.Height:=25;
  BitBtn2.Kind:=bkCancel;
  BitBtn2.Caption:='';

  if frm1.ShowModal=1 then result:=true
  else result:=false;
  value:=edit1.Text;

  label1.Free;
  edit1.Free;
  BitBtn1.Free;
  BitBtn2.Free;
  frm1.Free;
end;

function StringToTColor(S : string) : TColor;
var
 I:Integer;
 List:TStringList;
begin
  List := TStringList.Create;
  TRY
    List.CommaText := S;
    if List.Count < 3 then
       Result := clBlack
    else
    begin
       Result:=StrToInt(List[2]) Shl 16 Or
       StrToInt(List[1]) Shl 8 Or
       StrToInt(List[0]);
    end;
  FINALLY
    List.Free;
  END;
end;

function ColorToHTML(AColor:TColor):string;
begin

  AColor:=ColorToRGB(AColor);
  Result:=Format('#%.2x%.2x%.2x',[(AColor) and $FF,
                                  (AColor shr  8) and $FF,
                                  (AColor shr 16) and $FF]);
end;

function HexToInt(HexStr: String): Int64;
var
  RetVar: Int64;
  I: byte;
begin
  HexStr := UpperCase(HexStr);
  if HexStr[length(HexStr)] = 'H' then Delete(HexStr,length(HexStr),1);
  RetVar := 0;

  for I := 1 to length(HexStr) do
  begin
    RetVar := RetVar shl 4;
    if HexStr[i] in ['0'..'9'] then
      RetVar := RetVar + (byte(HexStr[i]) - 48)
    else if HexStr[i] in ['A'..'F'] then
      RetVar := RetVar + (byte(HexStr[i]) - 55)
    else
    begin
      Retvar := 0;
      Break;
    end;
  end;

  Result := RetVar;
end;

function HexToTColor(S : string): TColor;
var
 a:string;
begin
  result:=clBlack;
  if S[1] <> '#' then exit;
  delete(S,1,1);
  if length(S) <> 6 then exit;
  a := inttostr(HexToInt(copy(S,1,2))) + ',' +
  inttostr(HexToInt(copy(S,3,2))) + ',' +
  inttostr(HexToInt(copy(S,5,2)));
  result:=StringToTColor(a);
end;

function compactstring(s:widestring;size:integer):string;
var
  len:integer;
  s1,s2:string;
begin
  len:=length(s);
  if len<=size then begin
    result:=s;
    exit;
  end;
  s1:=copy(s,1,size div 2);
  s2:=copy(s,len-(size div 2),(size div 2)+1);
  result:=s1+'...'+s2;
end;


function makeuniqfilename(s:string):string;
var
  s1,s2,s3:string;
  k:integer;
begin
  s1:=sysutils.ExtractFilePath(s);
  s2:=sysutils.ExtractFileName(s);
  s2:=sysutils.ChangeFileExt(s2,'');
  s3:=sysutils.ExtractFileExt(s);

  k:=1;
  while sysutils.FileExists(s) do begin
    s:=s1+format('%s[%d]%s',[s2,k,s3]);
    inc(k);
  end;
  result:=s;
end;

function GetVersion(filename:string): string;
var
  VerInfoSize: DWORD;
  VerInfo: Pointer;
  VerValueSize: DWORD;
  VerValue: PVSFixedFileInfo;
  Dummy: DWORD;
begin
  Result := '';
  VerInfoSize := GetFileVersionInfoSize(PChar(filename), Dummy);
  if VerInfoSize = 0 then Exit;
  GetMem(VerInfo, VerInfoSize);
  GetFileVersionInfo(PChar(filename), 0, VerInfoSize, VerInfo);
  VerQueryValue(VerInfo, '\', Pointer(VerValue), VerValueSize);
  with VerValue^ do
  begin
    Result := IntToStr(dwFileVersionMS shr 16);
    Result := Result + '.' + IntToStr(dwFileVersionMS and $FFFF);
    Result := Result + '.' + IntToStr(dwFileVersionLS shr 16);
    Result := Result + '.' + IntToStr(dwFileVersionLS and $FFFF);
  end;
  FreeMem(VerInfo, VerInfoSize);
end;

function difftime(timestamp:tdatetime):integer;
var
  diff:TDateTime;
  Hour, Min, Sec, MSec: Word;
begin
  diff:=now-timestamp;
  DecodeTime(diff, Hour, Min, Sec, MSec);
  result:=(trunc(diff)*24*60)+(hour*60)+min;
end;

function RegisterOCX(FileName: string): Boolean;
var
  OCXHand: THandle;
  RegFunc: TDllRegisterServer;
begin
  OCXHand := LoadLibrary(PChar(FileName));
  RegFunc := GetProcAddress(OCXHand, 'DllRegisterServer');
  if @RegFunc <> nil then
    Result := RegFunc = S_OK
  else
    Result := False;
  FreeLibrary(OCXHand);
end;

function UnRegisterOCX(FileName: string): Boolean;
var
  OCXHand: THandle;
  RegFunc: TDllRegisterServer;
begin
  OCXHand := LoadLibrary(PChar(FileName));
  RegFunc := GetProcAddress(OCXHand, 'DllUnregisterServer');
  if @RegFunc <> nil then
    Result := RegFunc = S_OK
  else
    Result := False;
  FreeLibrary(OCXHand);
end;

function findupdir(s:string):string;
var
  i,k:integer;
begin
  k:=0;
  for i:=length(s) downto 1 do begin
   if s[i]='\' then inc(k);
   if k=1 then begin
     result:=copy(s,1,i-1);
     break;
   end;
  end;
end;

{$IFDEF CONDITIONALEXPRESSIONS}
  {$IF Defined(TOSVersionInfoEx)}
    {$DEFINE TOSVERSIONINFOEX_DEFINED}
  {$IFEND}
{$ENDIF}
{$IFNDEF TOSVERSIONINFOEX_DEFINED}

type
  POSVersionInfoEx = ^TOSVersionInfoEx;
  TOSVersionInfoEx = packed record
    dwOSVersionInfoSize: DWORD;
    dwMajorVersion     : DWORD;
    dwMinorVersion     : DWORD;
    dwBuildNumber      : DWORD;
    dwPlatformId       : DWORD;
    szCSDVersion       : array [0..127] of AnsiChar;
    wServicePackMajor  : Word;
    wServicePackMinor  : Word;
    wSuiteMask         : Word;
    wProductType       : Byte;
    wReserved          : Byte;
  end;

const
  VER_SERVER_NT                       = $80000000;
  {$EXTERNALSYM VER_SERVER_NT}
  VER_WORKSTATION_NT                  = $40000000;
  {$EXTERNALSYM VER_WORKSTATION_NT}
  VER_SUITE_SMALLBUSINESS             = $00000001;
  {$EXTERNALSYM VER_SUITE_SMALLBUSINESS}
  VER_SUITE_ENTERPRISE                = $00000002;
  {$EXTERNALSYM VER_SUITE_ENTERPRISE}
  VER_SUITE_BACKOFFICE                = $00000004;
  {$EXTERNALSYM VER_SUITE_BACKOFFICE}
  VER_SUITE_COMMUNICATIONS            = $00000008;
  {$EXTERNALSYM VER_SUITE_COMMUNICATIONS}
  VER_SUITE_TERMINAL                  = $00000010;
  {$EXTERNALSYM VER_SUITE_TERMINAL}
  VER_SUITE_SMALLBUSINESS_RESTRICTED  = $00000020;
  {$EXTERNALSYM VER_SUITE_SMALLBUSINESS_RESTRICTED}
  VER_SUITE_EMBEDDEDNT                = $00000040;
  {$EXTERNALSYM VER_SUITE_EMBEDDEDNT}
  VER_SUITE_DATACENTER                = $00000080;
  {$EXTERNALSYM VER_SUITE_DATACENTER}
  VER_SUITE_SINGLEUSERTS              = $00000100;
  {$EXTERNALSYM VER_SUITE_SINGLEUSERTS}
  VER_SUITE_PERSONAL                  = $00000200;
  {$EXTERNALSYM VER_SUITE_PERSONAL}
  VER_SUITE_BLADE                     = $00000400;
  {$EXTERNALSYM VER_SUITE_BLADE}
  VER_SUITE_EMBEDDED_RESTRICTED       = $00000800;
  {$EXTERNALSYM VER_SUITE_EMBEDDED_RESTRICTED}
  VER_SUITE_SECURITY_APPLIANCE        = $00001000;
  {$EXTERNALSYM VER_SUITE_SECURITY_APPLIANCE}

const
  VER_NT_WORKSTATION              = $0000001;
  {$EXTERNALSYM VER_NT_WORKSTATION}
  VER_NT_DOMAIN_CONTROLLER        = $0000002;
  {$EXTERNALSYM VER_NT_DOMAIN_CONTROLLER}
  VER_NT_SERVER                   = $0000003;
  {$EXTERNALSYM VER_NT_SERVER}

{$ENDIF}  // TOSVERSIONINFOEX_DEFINED


function GetOSVersionInfo(var Info: TOSVersionInfoEx): Boolean;
begin
  FillChar(Info, SizeOf(TOSVersionInfoEx), 0);
  Info.dwOSVersionInfoSize := SizeOf(TOSVersionInfoEx);
  Result := GetVersionEx(TOSVersionInfo(Addr(Info)^));
  if (not Result) then
  begin
    FillChar(Info, SizeOf(TOSVersionInfoEx), 0);
    Info.dwOSVersionInfoSize := SizeOf(TOSVersionInfoEx);
    Result := GetVersionEx(TOSVersionInfo(Addr(Info)^));
    if (not Result) then
      Info.dwOSVersionInfoSize := 0;
  end;
end;

function GetOperatingSystem: Integer;
var
  Info: TOSVersionInfoEx;
  Key: HKEY;
begin
  Result:=cOsUnknown;
  if (not GetOSVersionInfo(Info)) then begin
    Exit;
  end;
  case Info.dwPlatformId of
    { Win32s }
    VER_PLATFORM_WIN32s: ;
    { Windows 9x }
    VER_PLATFORM_WIN32_WINDOWS:
      if (Info.dwMajorVersion = 4) and (Info.dwMinorVersion = 0) then
      begin
        Result:=cOsWin95;
      end
      else if (Info.dwMajorVersion = 4) and (Info.dwMinorVersion = 10) then
      begin
        Result:=cOsWin98;
      end
      else if (Info.dwMajorVersion = 4) and (Info.dwMinorVersion = 90) then begin
        Result:=cOsWinME;
      end;
    { Windows NT }
    VER_PLATFORM_WIN32_NT:
      begin
        { Version }
        if (Info.dwMajorVersion<= 4) then begin
          Result:=cOsWinNT;
        end else if (Info.dwMajorVersion = 5) and (Info.dwMinorVersion = 2) then begin
          Result:=cOsWin2003;
        end else if (Info.dwMajorVersion = 5) and (Info.dwMinorVersion = 1) then begin
          Result:=cOsXP;
        end else if (Info.dwMajorVersion = 5) and (Info.dwMinorVersion = 0) then begin
          Result:=cOsWin2000;
        end else if (Info.dwMajorVersion = 6) and (Info.dwMinorVersion = 0) then begin
          if (Info.wProductType=VER_NT_WORKSTATION) then begin
            Result:=cOsVista;
          end else begin
            Result:=cOsWin2008;
          end;
        end;

      end;
  end;
end;

function ExecuteFile(filename:string; visible:boolean): Boolean;
var
  SUInfo: TStartupInfo;
  ProcInfo: TProcessInformation;
  s:string;
begin
  FillChar(SUInfo, SizeOf(SUInfo), #0);
  with SUInfo do begin
     cb := SizeOf(SUInfo);
     dwFlags := STARTF_USESHOWWINDOW;
     if visible then
        wShowWindow := SW_NORMAL
     else
        wShowWindow := SW_HIDE;
//     s:=sysutils.ExtractFilePath(filename);
     result:=createprocess(nil, PChar(filename), nil, nil, False,
        CREATE_NEW_CONSOLE or NORMAL_PRIORITY_CLASS, nil, nil,
        SUInfo, ProcInfo);
  end;
end;

function WinExecAndWait32(FileName: string; Visibility: Integer): boolean;
var { by Pat Ritchey }
  zAppName: array[0..512] of Char;
  zCurDir: array[0..255] of Char;
  WorkDir: string;
  StartupInfo: TStartupInfo;
  ProcessInfo: TProcessInformation;
  exitcode:longword;
begin
  StrPCopy(zAppName, FileName);
  GetDir(0, WorkDir);
  StrPCopy(zCurDir, WorkDir);
  FillChar(StartupInfo, SizeOf(StartupInfo), #0);
  StartupInfo.cb          := SizeOf(StartupInfo);
  StartupInfo.dwFlags     := STARTF_USESHOWWINDOW;
  StartupInfo.wShowWindow := Visibility;
  if not CreateProcess(nil,
    zAppName, // pointer to command line string
    nil, // pointer to process security attributes
    nil, // pointer to thread security attributes
    False, // handle inheritance flag
    CREATE_NEW_CONSOLE or // creation flags
    NORMAL_PRIORITY_CLASS,
    nil, //pointer to new environment block
    nil, // pointer to current directory name
    StartupInfo, // pointer to STARTUPINFO
    ProcessInfo) // pointer to PROCESS_INF
    then Result := false
  else
  begin
    WaitForSingleObject(ProcessInfo.hProcess, INFINITE);
    GetExitCodeProcess(ProcessInfo.hProcess, exitcode);
    CloseHandle(ProcessInfo.hProcess);
    CloseHandle(ProcessInfo.hThread);
    result:=true;
  end;
end; { WinExecAndWait32 }


function RunAsAdmin(hWnd: HWND; filename: string; Parameters: string;waiting:boolean): Boolean;
{    See Step 3: Redesign for UAC Compatibility (UAC)    http://msdn.microsoft.com/en-us/library/bb756922.aspx}
var
  sei: TShellExecuteInfo;
  ExitCode: DWORD;
  s:string;
begin
  if (GetOperatingSystem>=cOsWin95) and (GetOperatingSystem<=cOsWin2003) then begin
     s:=format('"%s" %s',[filename, Parameters]);
     if waiting then
       result:=WinExecAndWait32(s, sw_show)
     else
       result:=ExecuteFile(s, true);
     exit;
  end;

  ZeroMemory(@sei, SizeOf(sei));
  sei.cbSize := SizeOf(TShellExecuteInfo);
  sei.Wnd := hwnd;
  sei.fMask := SEE_MASK_FLAG_DDEWAIT or SEE_MASK_FLAG_NO_UI or SEE_MASK_NOCLOSEPROCESS;
  sei.lpVerb := PChar('runas');
  sei.lpFile := PChar(Filename); // PAnsiChar;
  if parameters <> '' then
    sei.lpParameters := PChar(parameters); // PAnsiChar;
  sei.nShow := SW_SHOWNORMAL; //Integer;
  Result := ShellExecuteEx(@sei);

  if waiting=false then exit;
   if Result then begin
     repeat
       Application.ProcessMessages;
       GetExitCodeProcess(sei.hProcess, ExitCode) ;
     until (ExitCode <> STILL_ACTIVE) or  Application.Terminated;
   end;
end;

procedure lockcontrol(c: THandle; lock: boolean);
begin
    if (c=0) then exit;

    if lock then SendMessage(c,WM_SETREDRAW,0,0)
    else begin
      SendMessage(c,WM_SETREDRAW,1,0);
      RedrawWindow(c,nil,0,
        RDW_ERASE or RDW_FRAME or RDW_INVALIDATE or RDW_ALLCHILDREN);
    end;
end;

function GetAveCharSize(Canvas: TCanvas): TPoint;
var
  I: Integer;
  Buffer: array[0..51] of Char;
begin
  for I := 0 to 25 do Buffer[I] := Chr(I + Ord('A'));
  for I := 0 to 25 do Buffer[I + 26] := Chr(I + Ord('a'));
  GetTextExtentPoint(Canvas.Handle, Buffer, 52, TSize(Result));
  Result.X := Result.X div 52;
end;

function InputQuery2(owner:tform; const ACaption, APrompt: string;
  var Value: string): Boolean;
var
  Form: TForm;
  Prompt: TLabel;
  Edit: TEdit;
  DialogUnits: TPoint;
  ButtonTop, ButtonWidth, ButtonHeight: Integer;
begin
  Result := False;
  Form := TForm.Create(owner);
  with Form do
    try
      Font:=Application.MainForm.Font;
      Canvas.Font := Font;
      DialogUnits := GetAveCharSize(Canvas);
      BorderStyle := bsDialog;
      Caption := ACaption;
      ClientWidth := MulDiv(180, DialogUnits.X, 4);
      Position := poOwnerFormCenter;
      Prompt := TLabel.Create(Form);
      with Prompt do
      begin
        Parent := Form;
        Caption := APrompt;
        Left := MulDiv(8, DialogUnits.X, 4);
        Top := MulDiv(8, DialogUnits.Y, 8);
        Constraints.MaxWidth := MulDiv(164, DialogUnits.X, 4);
        WordWrap := True;
      end;
      Edit := TEdit.Create(Form);
      with Edit do
      begin
        Parent := Form;
        Left := Prompt.Left;
        Top := Prompt.Top + Prompt.Height + 5;
        Width := MulDiv(164, DialogUnits.X, 4);
        MaxLength := 255;
        Text := Value;
        SelectAll;
      end;
      ButtonTop := Edit.Top + Edit.Height + 15;
      ButtonWidth := MulDiv(50, DialogUnits.X, 4);
      ButtonHeight := MulDiv(14, DialogUnits.Y, 8);
      with TButton.Create(Form) do
      begin
        Parent := Form;
        Caption := 'OK';
        ModalResult := mrOk;
        Default := True;
        SetBounds(MulDiv(38, DialogUnits.X, 4), ButtonTop, ButtonWidth,
          ButtonHeight);
      end;
      with TButton.Create(Form) do
      begin
        Parent := Form;
        Caption := 'Cancel';
        ModalResult := mrCancel;
        Cancel := True;
        SetBounds(MulDiv(92, DialogUnits.X, 4), Edit.Top + Edit.Height + 15,
          ButtonWidth, ButtonHeight);
        Form.ClientHeight := Top + Height + 13;          
      end;
      if ShowModal = mrOk then
      begin
        Value := Edit.Text;
        Result := True;
      end;
    finally
      Form.Free;
    end;
end;

function InputQuery3(owner:tform; x,y:integer; const ACaption, APrompt: string; var Value: string): Boolean;
var
  Form: TForm;
  Prompt: TLabel;
  Edit: TEdit;
  DialogUnits: TPoint;
  ButtonTop, ButtonWidth, ButtonHeight: Integer;
begin
  Result := False;
  Form := TForm.Create(owner);
  with Form do
    try
      Font:=Application.MainForm.Font;
      Canvas.Font := Font;
      DialogUnits := GetAveCharSize(Canvas);
      BorderStyle := bsDialog;
      Caption := ACaption;
      ClientWidth := MulDiv(180, DialogUnits.X, 4);
      Prompt := TLabel.Create(Form);
      with Prompt do
      begin
        Parent := Form;
        Caption := APrompt;
        Left := MulDiv(8, DialogUnits.X, 4);
        Top := MulDiv(8, DialogUnits.Y, 8);
        Constraints.MaxWidth := MulDiv(164, DialogUnits.X, 4);
        WordWrap := True;
      end;
      Edit := TEdit.Create(Form);
      with Edit do
      begin
        Parent := Form;
        Left := Prompt.Left;
        Top := Prompt.Top + Prompt.Height + 5;
        Width := MulDiv(164, DialogUnits.X, 4);
        MaxLength := 255;
        Text := Value;
        SelectAll;
      end;
      ButtonTop := Edit.Top + Edit.Height + 15;
      ButtonWidth := MulDiv(50, DialogUnits.X, 4);
      ButtonHeight := MulDiv(14, DialogUnits.Y, 8);
      with TButton.Create(Form) do
      begin
        Parent := Form;
        Caption := 'OK';
        ModalResult := mrOk;
        Default := True;
        SetBounds(MulDiv(38, DialogUnits.X, 4), ButtonTop, ButtonWidth,
          ButtonHeight);
      end;
      with TButton.Create(Form) do
      begin
        Parent := Form;
        Caption := 'Cancel';
        ModalResult := mrCancel;
        Cancel := True;
        SetBounds(MulDiv(92, DialogUnits.X, 4), Edit.Top + Edit.Height + 15,
          ButtonWidth, ButtonHeight);
        Form.ClientHeight := Top + Height + 13;          
      end;
      Left:=x;
      Top:=y;
      if left<screen.WorkAreaRect.Left then left:=screen.WorkAreaRect.Left;
      if Top<screen.WorkAreaRect.Top then Top:=screen.WorkAreaRect.Top;
      if left+width>screen.WorkAreaRect.Right then left:=screen.WorkAreaRect.Right-width;
      if Top+Height>screen.WorkAreaRect.Bottom then Top:=screen.WorkAreaRect.Bottom-Height;
      if ShowModal = mrOk then
      begin
        Value := Edit.Text;
        Result := True;
      end;
    finally
      Form.Free;
    end;
end;

Procedure PostKeyEx( hWindow: HWnd; key: Word; Const shift: TShiftState;
                     specialkey:Boolean; restorekey:boolean=true);
Type
  TBuffers = Array [0..1] of TKeyboardState;
Var
  pKeyBuffers : ^TBuffers;
  lparam: LongInt;
  Msg:TMsg;
Begin
  (* check if the target window exists *)
  If IsWindow(hWindow) Then Begin
    (* set local variables to default values *)
    pKeyBuffers := Nil;
    lparam := MakeLong(0, MapVirtualKey(key, 0));


    (* modify lparam if special key requested *)
    If specialkey Then
      lparam := lparam or $1000000;

    (* allocate space for the key state buffers *)
    New(pKeyBuffers);
    try
      (* Fill buffer 1 with current state so we can later restore it.
         Null out buffer 0 to get a "no key pressed" state. *)
      if restorekey then
        GetKeyboardState( pKeyBuffers^[1] );
      FillChar(pKeyBuffers^[0], Sizeof(TKeyboardState), 0);


      (* set the requested modifier keys to "down" state in the buffer *)
      If ssShift In shift Then
        pKeyBuffers^[0][VK_SHIFT] := $80;
      If ssAlt In shift Then Begin
        (* Alt needs special treatment since a bit in lparam needs also be
set *)
        pKeyBuffers^[0][VK_MENU] := $80;
        lparam := lparam or $20000000;
      End; 
      If ssCtrl In shift Then
        pKeyBuffers^[0][VK_CONTROL] := $80;
      If ssLeft In shift Then
        pKeyBuffers^[0][VK_LBUTTON] := $80;
      If ssRight In shift Then 
        pKeyBuffers^[0][VK_RBUTTON] := $80;
      If ssMiddle In shift Then
        pKeyBuffers^[0][VK_MBUTTON] := $80;


      (* make out new key state array the active key state map *)
      SetKeyboardState( pKeyBuffers^[0] );

      (* post the key messages *)
      If ssAlt In Shift Then Begin 
        PostMessage( hWindow, WM_SYSKEYDOWN, key, lparam);
        PostMessage( hWindow, WM_SYSKEYUP, key, lparam or $C0000000);
      End
      Else Begin
        PostMessage( hWindow, WM_KEYDOWN, key, lparam);
        PostMessage( hWindow, WM_KEYUP, key, lparam or $C0000000);
      End;
      (* process the messages *)
      Application.ProcessMessages;

      (* restore the old key state map *)
      if restorekey then
        SetKeyboardState( pKeyBuffers^[1] );
    finally
      (* free the memory for the key state buffers *)
      If pKeyBuffers <> Nil Then
        Dispose( pKeyBuffers );
    End; { If }
  End;
End; { PostKeyEx }

function GetSpecialPath(handle:thandle; nfolder:integer):string;
var
  shellMalloc: IMalloc;
  ppidl: PItemIdList;
  PerDir: string;
begin
  ppidl := nil;
  try
    if SHGetMalloc(shellMalloc) = NOERROR then
    begin
      SHGetSpecialFolderLocation(handle, nfolder, ppidl);
      SetLength(Result, MAX_PATH);
      if not SHGetPathFromIDList(ppidl, PChar(Result)) then
        raise exception.create('SHGetPathFromIDList failed : invalid pidl');
      SetLength(Result, lStrLen(PChar(Result)));
    end;
  finally
   if ppidl <> nil then
         shellMalloc.free(ppidl);
  end;
end;

function GetShellPath(nfolder:integer):string;
var
  s:string;
begin
  s:=GetSpecialPath(0,nfolder);
  if (length(s)>0) and (s[length(s)]<>'\') then
    s:=s+'\';
  result:=s;
end;

function SystemErrorMessage: string;
var
  P: PChar;
begin
try
  if FormatMessage(Format_Message_Allocate_Buffer + Format_Message_From_System,
                   nil,
                   GetLastError,
                   0,
                   @P,
                   0,
                   nil) <> 0 then
  begin
    Result := P;
    LocalFree(Integer(P))
  end
  else
    Result := '';
except
end;
end;

function deletebadfilenamechar(s:string):string;
const
  badchar: array[0..8] of string =
  ('\','/',':','*','?','"','<','>','|');
var
  i:integer;
begin
  for i:=0 to high(badchar) do begin
    if pos(badchar[i],s)>0 then
      s:=sysutils.StringReplace(s,badchar[i],'',[rfReplaceAll]);
  end;
  result:=s;
end;

function issystemfolder(s:string):boolean;
var
  FHandle:THandle;
  fd:WIN32_FIND_DATA;
begin
    result:=false;
    if (length(s)>0) and (s[length(s)]='\') then delete(s,length(s),1);
    FHandle:= Windows.FindFirstFile(PChar(s), FD);
     if FHandle <> INVALID_HANDLE_VALUE then begin
       if (fd.dwFileAttributes and FILE_ATTRIBUTE_SYSTEM)>0 then begin
         result:=true;
       end;
     end;
    Windows.FindClose(FHandle);
end;

function cutstring(s:string;len:integer):string;
var
  s1:string;
begin
  if length(s)>len then begin
    s1:=copy(s,1,len);
    if ByteType(s1,length(s1))=mbLeadByte then
      s1:=copy(s,1,len-1);
    s1:=s1+'...';
  end else
    s1:=s;
  result:=s1;
end;

end.
