library fetch;

{ Important note about DLL memory management: ShareMem must be the
  first unit in your library's USES clause AND your project's (select
  Project-View Source) USES clause if your DLL exports any procedures or
  functions that pass strings as parameters or function results. This
  applies to all strings passed to and from your DLL--even those that
  are nested in records and classes. ShareMem is the interface unit to
  the BORLNDMM.DLL shared memory manager, which must be deployed along
  with your DLL. To avoid using BORLNDMM.DLL, pass string information
  using PChar or ShortString parameters. }

uses
  windows,
  SysUtils,
  Classes,
  dialogs,
  httpsend,
  Ufunction in 'Ufunction.pas',
  Umain in 'Umain.pas',
  DLLSynchronizer in 'DLLSynchronizer.pas';

{$R *.res}


var
  fetchimg:Tfetchimg;

procedure start_fetch(formhandle:thandle;keyword,targetfolder:pchar;maxfetch,startcount,fetchsite:integer); export; stdcall;
begin
  fetchimg:=Tfetchimg.CreateThread;
  fetchimg.formhandle:=formhandle;
  fetchimg.keyword:=keyword;
  fetchimg.targetfolder:=targetfolder;
  fetchimg.maxfetch:=maxfetch;
  fetchimg.startcount:=startcount;
  fetchimg.fetchsite:=Tfetchsite(fetchsite);
//  fetchimg.OnTerminate:=fetchimgOnTerminate;
  fetchimg.Resume;
end;

procedure stop_fetch(); export; stdcall;
begin
  if assigned(fetchimg) then begin
    fetchimg.stop;
    fetchimg.WaitFor;
    freeandnil(fetchimg);
  end;
end;

procedure MyDLLProc(Reason: Integer); register;
begin
  case Reason of
    DLL_PROCESS_DETACH:begin
      stop_fetch();
    end;
  end;
end;

exports
   start_fetch,
   stop_fetch;

begin
  DLLProc := @MyDLLProc;
end.
