{

   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit Ufrmworkselect;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons;

type
  tworkmethod = (wmthumb, wmsaveas);

  Tfrmworkselect = class(TForm)
    RadioButton3: TRadioButton;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    button1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    workmethod:tworkmethod;
  end;

var
  frmworkselect: Tfrmworkselect;

implementation

uses Ufrmworkbase, Ufrmwork_thumb, Ufrmwork_saveas, UfrmMain, Uconfig;
{$R *.dfm}

procedure Tfrmworkselect.Button1Click(Sender: TObject);
begin
  case workmethod of
    wmthumb:
      frmworkbase:=Tfrmwork_thumb.Create(self);
    wmsaveas:
      frmworkbase:=Tfrmwork_saveas.Create(self);    
  end;
  if RadioButton3.Checked then
    frmworkbase.workselect:=wscurrent
  else if RadioButton1.Checked then
    frmworkbase.workselect:=wslistselect
  else if RadioButton2.Checked then
    frmworkbase.workselect:=wslistall;

  config.c_lastworkselect:=ord(frmworkbase.workselect);

  frmworkbase.ShowModal;
  frmworkbase.Free;
  self.ModalResult:=mrok;
end;

procedure Tfrmworkselect.FormCreate(Sender: TObject);
begin
  case config.c_lastworkselect of
    0:RadioButton3.Checked:=true;
    1:RadioButton1.Checked:=true;
    else
      RadioButton2.Checked:=true;
  end;
end;

end.
