{

   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit Ufrmworkbase;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Ufrmworkselect, StdCtrls, ExtCtrls, ComCtrls, Buttons, Udialog;

type
  tworkselect = (wscurrent,wslistselect,wslistall);

  TOnprogress = procedure(Sender:TObject; totcount,currentcount:integer; msg:string; iserror:boolean) of object;
    
  Tfrmworkbase = class(TForm)
    PanelBottom: TPanel;
    Label3: TLabel;
    ProgressBar1: TProgressBar;
    btnok: TBitBtn;
    btncancel: TBitBtn;
    labelcomplete: TLabel;
    procedure btnokClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  protected
    SaveDialog1:TmySavePictureDialog;

    procedure OkSeleted; virtual;
    procedure CancelSeleted; virtual;
  public
    { Public declarations }
    workselect:tworkselect;
  end;

var
  frmworkbase: Tfrmworkbase;
  selectsaveflag:integer;
  existnoanswer:boolean;

implementation

uses UfrmMain, Uconfig;

{$R *.dfm}

procedure Tfrmworkbase.btnokClick(Sender: TObject);
begin
  btnok.Enabled:=false;
  OkSeleted;
end;

procedure Tfrmworkbase.OkSeleted;
begin
end;

procedure Tfrmworkbase.CancelSeleted;
begin
end;

procedure Tfrmworkbase.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  CancelSeleted;
end;

procedure Tfrmworkbase.FormShow(Sender: TObject);
begin
  PanelBottom.Align:=albottom;
  ProgressBar1.Left:=(PanelBottom.Width-ProgressBar1.Width) div 2;
  label3.Left:=ProgressBar1.Left;
  labelcomplete.Left:=ProgressBar1.Left;
end;

procedure Tfrmworkbase.FormCreate(Sender: TObject);
begin
  SaveDialog1:=TmySavePictureDialog.Create(self);
  SaveDialog1.ExtraCheckbox.Checked:=config.c_dialogpreview;
  selectsaveflag:=0;
  existnoanswer:=false;
end;

procedure Tfrmworkbase.FormDestroy(Sender: TObject);
begin
  config.c_dialogpreview:=SaveDialog1.ExtraCheckbox.Checked;
  SaveDialog1.Free;
end;

end.
