unit UAdobeFrame2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Couleur, StdCtrls, Spin;

const
  RectBigAdobe: TRect = (Left:0;Top:0;right:255;bottom:255);
  RectLittleAdobe: TRect = (Left:0;Top:0;Right:19;Bottom:255);
  RectCoul: TRect = (Left:0;Top:0;Right:40;Bottom:40);
  EspaceEntre : Integer = 10;
type
  TLigne = array of byte;
  TClicZoneAdobe2 = (CZAdobe2None,CZAdobe2Carre,CZAdobe2Barre);

  TFrameAdobe2 = class(TFrame)
    ImgAdobe2: TImage;
    Panel1: TPanel;
    SpRAdobe: TSpinEdit;
    SpVAdobe: TSpinEdit;
    SpBAdobe: TSpinEdit;
    SpLAdobe: TSpinEdit;
    SpSAdobe: TSpinEdit;
    SpTAdobe: TSpinEdit;
    RBR: TRadioButton;
    RBV: TRadioButton;
    RBB: TRadioButton;
    RBT: TRadioButton;
    RBS: TRadioButton;
    RBL: TRadioButton;
    ImgCoul: TImage;
    procedure SpAdobe2KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SpAdobe2KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SpAdobeKeyPress(Sender: TObject; var Key: Char);
    procedure ImgAdobe2MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ImgAdobe2MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ImgAdobe2MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure SpRVBAdobeChange(Sender: TObject);
    procedure SpTSLAdobeChange(Sender: TObject);
    procedure RBRClick(Sender: TObject);
    procedure RBMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Dclarations prives }
    ClickImg : TClicZoneAdobe2;
    PasBigRect : TPoint;
    PasLittleRect : TPoint;
    PasCoulRect : TPoint;
//    TabCol : array[0..255,0..100,0..100]of TRVB;

    function ClickDans(const R : TRect;X,Y : Integer) : Boolean;
    procedure DrawCoul;
    procedure DrawCoul2;
    procedure GestionSouris(X,Y : Integer);
    procedure DesactiveOnChange;
    procedure ActiveOnChange;
    procedure MAJValeur;
    procedure GestionBigCarre(const X,Y : Integer);
    procedure GestionLittleCarre(const X,Y : Integer);
  public
    { Dclarations publiques }
    Couleur : TCouleur;
    procedure DrawCur;
    procedure InitAdobe2;
    procedure CreateFrame;
    procedure FreeFrame;
    procedure MAJCoul;
    procedure DrawColor;
  end;

implementation

{$R *.dfm}

{ TFrameAdobe2 }

procedure TFrameAdobe2.CreateFrame;
var
  Temp : TRVB;
begin
  Couleur := TCouleur.Create;
  Temp.R := 0;
  Temp.V := 0;
  Temp.B := 0;
  Couleur.RVB := Temp;
  Brush.Style := bsClear;
end;

procedure TFrameAdobe2.DrawColor;
begin
  ImgCoul.Canvas.Pen.Color := Couleur.Color;
  ImgCoul.Canvas.Brush.Color := Couleur.Color;
  Rectangle(ImgCoul.Canvas.Handle,PasCoulRect.X+RectCoul.Left,PasCoulRect.Y+RectCoul.Top,PasCoulRect.X+1+RectCoul.Right,PasCoulRect.Y+1+RectCoul.Bottom);
  ImgCoul.Repaint;
end;

procedure TFrameAdobe2.DrawCoul2;
var
  I, J, J_ : Integer;
  PLigne : pointer;
  T1 :TLigne;
  Coul : TCouleur;
  RVB : TRVB;
  I1,I2 : integer;
begin
  T1 := nil;
  Coul := TCouleur.Create;
  if RBT.Checked then
  begin
    for J := RectLittleAdobe.Top to RectLittleAdobe.Bottom do
    begin
      PLigne := ImgAdobe2.Picture.Bitmap.ScanLine[J+ PasLittleRect.Y];
      T1 := TLigne(PLigne);
      for I := RectLittleAdobe.Left to RectLittleAdobe.Right do
      begin
        J_ := 255-J;
//        RVB := TabCol[J_,100,100];
        T1[3*(I+PasLittleRect.X)] := RVB.B;
        T1[3*(I+PasLittleRect.X)+1] := RVB.V;
        T1[3*(I+PasLittleRect.X)+2] := RVB.R;
      end;
    end;
  end
  else
  if RBS.Checked then
  begin
    I1 := round(255*Couleur.TSV.T/359);
    I2 := round(Couleur.TSV.V);
    for J := RectLittleAdobe.Top to RectLittleAdobe.Bottom do
    begin
      PLigne := ImgAdobe2.Picture.Bitmap.ScanLine[J+PasLittleRect.Y];
      T1 := TLigne(PLigne);
      for I := RectLittleAdobe.Left to RectLittleAdobe.Right do
      begin
        J_ := 100-round(100*J/255);
//        RVB := TabCol[I1,J_,I2];
        T1[3*(I+PasLittleRect.X)] := RVB.B;
        T1[3*(I+PasLittleRect.X)+1] := RVB.V;
        T1[3*(I+PasLittleRect.X)+2] := RVB.R;
      end;
    end;
  end
  else
  if RBL.Checked then
  begin
    I1 := round(Couleur.TSV.S);
    I2 := round(255*Couleur.TSV.T/359);
    for J := RectLittleAdobe.Top to RectLittleAdobe.Bottom do
    begin
      PLigne := ImgAdobe2.Picture.Bitmap.ScanLine[J+PasLittleRect.Y];
      T1 := TLigne(PLigne);
      for I := RectLittleAdobe.Left to RectLittleAdobe.Right do
      begin
        J_ := round(100-(100*J/255));
//        RVB := TabCol[I2,I1,J_];
        T1[3*(I+PasLittleRect.X)] := RVB.B;
        T1[3*(I+PasLittleRect.X)+1] := RVB.V;
        T1[3*(I+PasLittleRect.X)+2] := RVB.R;
      end;
    end;
  end;
  Coul.Free;
end;

procedure TFrameAdobe2.DrawCoul;
var
  I, J, I_,J_ : Integer;
  PLigne : pointer;
  T1 :TLigne;
  Coul : TCouleur;
  RVB : TRVB;
//  TSV1 : TTSV;
  S,V : INteger;
  inte,I1 : integer;
begin
  T1 := nil;
  Coul := TCouleur.Create;
  if RBR.Checked then
  begin
    for J := RectBigAdobe.Top to RectBigAdobe.Bottom do
    begin
      PLigne := ImgAdobe2.Picture.Bitmap.ScanLine[J+PasBigRect.Y];
      T1 := TLigne(PLigne);
      for I := RectBigAdobe.Left to RectBigAdobe.Right do
      begin
        RVB := Couleur.RVB;
        RVB.V := 255-J;
        RVB.B := I;
        T1[3*(I+PasBigRect.X)] := RVB.B;
        T1[3*(I+PasBigRect.X)+1] := RVB.V;
        T1[3*(I+PasBigRect.X)+2] := RVB.R;

        if I<=RectLittleAdobe.Right then
        begin
          RVB := Couleur.RVB;
          T1[3*(I+PasLittleRect.X)] := RVB.B;
          T1[3*(I+PasLittleRect.X)+1] := RVB.V;
          T1[3*(I+PasLittleRect.X)+2] := 255-J;
        end;
      end;
    end;
  end
  else
  if RBV.Checked then
  begin
    for J := RectBigAdobe.Top to RectBigAdobe.Bottom do
    begin
      PLigne := ImgAdobe2.Picture.Bitmap.ScanLine[J+PasBigRect.Y];
      T1 := TLigne(PLigne);
      for I := RectBigAdobe.Left to RectBigAdobe.Right do
      begin
        RVB := Couleur.RVB;
        RVB.R:= 255-J;
        RVB.B := I;
        T1[3*(I+PasBigRect.X)] := RVB.B;
        T1[3*(I+PasBigRect.X)+1] := RVB.V;
        T1[3*(I+PasBigRect.X)+2] := RVB.R;

        if I<=RectLittleAdobe.Right then
        begin
          RVB := Couleur.RVB;
          T1[3*(I+PasLittleRect.X)] := RVB.B;
          T1[3*(I+PasLittleRect.X)+1] := 255-J;
          T1[3*(I+PasLittleRect.X)+2] := RVB.R;
        end;
      end;
    end;
  end
  else
  if RBB.Checked then
  begin
    for J := RectBigAdobe.Top to RectBigAdobe.Bottom do
    begin
      PLigne := ImgAdobe2.Picture.Bitmap.ScanLine[J+PasBigRect.Y];
      T1 := TLigne(PLigne);
      for I := RectBigAdobe.Left to RectBigAdobe.Right do
      begin
        RVB := Couleur.RVB;
        RVB.V:= 255-J;
        RVB.R := I;
        T1[3*(I+PasBigRect.X)] := RVB.B;
        T1[3*(I+PasBigRect.X)+1] := RVB.V;
        T1[3*(I+PasBigRect.X)+2] := RVB.R;

        if I<=RectLittleAdobe.Right then
        begin
          RVB := Couleur.RVB;
          T1[3*(I+PasLittleRect.X)] := 255-J;
          T1[3*(I+PasLittleRect.X)+1] := RVB.V;
          T1[3*(I+PasLittleRect.X)+2] := RVB.R;
        end;
      end;
    end;
  end
  else
  if RBT.Checked then
  begin
    J_ := round(255*Couleur.TSV.T/359);
    for J := RectBigAdobe.Top to RectBigAdobe.Bottom do
    begin
      PLigne := ImgAdobe2.Picture.Bitmap.ScanLine[J+PasBigRect.Y];
      T1 := TLigne(PLigne);
      for I := RectBigAdobe.Left to RectBigAdobe.Right do
      begin
        S:= round(100*I/255);
        V := round(100-(100*J/255));
//        RVB := TabCol[J_,S,V];
        I_ := 3*(I+PasBigRect.X);
        T1[I_]   := RVB.B;
        T1[I_+1] := RVB.V;
        T1[I_+2] := RVB.R;
      end;
    end;
  end
  else
  if RBS.Checked then
  begin
    inte := round(Couleur.TSV.S);
    for J := RectBigAdobe.Top to RectBigAdobe.Bottom do
    begin
      PLigne := ImgAdobe2.Picture.Bitmap.ScanLine[J+PasBigRect.Y];
      T1 := TLigne(PLigne);
      for I := RectBigAdobe.Left to RectBigAdobe.Right do
      begin
        J_ := 100-round(100*J/255);
//        RVB := TabCol[I,inte,J_];
        I_ := 3*(I+PasBigRect.X);
        T1[I_  ] := RVB.B;
        T1[I_+1] := RVB.V;
        T1[I_+2] := RVB.R;
      end;
    end;
  end
  else
  if RBL.Checked then
  begin
    J_ := round(Couleur.TSV.V);
    for J := RectBigAdobe.Top to RectBigAdobe.Bottom do
    begin
      PLigne := ImgAdobe2.Picture.Bitmap.ScanLine[J+PasBigRect.Y];
      T1 := TLigne(PLigne);
      for I := RectBigAdobe.Left to RectBigAdobe.Right do
      begin
        I1 := 100-round(100*J/255);
//        RVB := TabCol[I,I1,J_];
        I_ := 3*(I+PasBigRect.X);
        T1[I_  ] := RVB.B;
        T1[I_+1] := RVB.V;
        T1[I_+2] := RVB.R;
      end;
    end;
  end;
  Coul.Free;
  DrawCur;
  DrawColor;
  ImgAdobe2.Picture.Bitmap.Modified := true;
end;

procedure TFrameAdobe2.FreeFrame;
begin
  Couleur.Free;
end;

procedure TFrameAdobe2.InitAdobe2;
  procedure drawContour(R : TRect;C : TCanvas);
  begin
    C.Brush.Style := bsClear;
    C.Pen.Color := $FFFFFF;
    Rectangle(C.Handle,R.Left-2,R.Top-2,R.Right+3,R.Bottom+3);
    C.Pen.Color := $808080;
    Rectangle(C.Handle,R.Left-2,R.Top-2,R.Right+2,R.Bottom+2);
    C.Pen.Color := $FFFFFF;
    Rectangle(C.Handle,R.Left-1,R.Top-1,R.Right+3,R.Bottom+3);
    C.Pen.Color := $0;
    Rectangle(C.Handle,R.Left-1,R.Top-1,R.Right+2,R.Bottom+2);
  end;
var
  Coul : TCouleur;
  F : file;
begin
  Coul := TCouleur.Create;
  ImgAdobe2.Picture.Bitmap.PixelFormat := pf24bit;
  ImgAdobe2.Picture.Bitmap.Width := ImgAdobe2.Width;
  ImgAdobe2.Picture.Bitmap.Height := ImgAdobe2.Height;
  ImgAdobe2.Canvas.Brush.Color := ColorToRGB(clBtnFace);
  ImgAdobe2.Canvas.Pen.Color := ColorToRGB(clBtnFace);
  Rectangle(ImgAdobe2.Canvas.Handle,0,0,ImgAdobe2.Width,ImgAdobe2.Height);
  ImgCoul.Canvas.Brush.Color := ColorToRGB(clBtnFace);
  ImgCoul.Canvas.Pen.Color := ColorToRGB(clBtnFace);
  Rectangle(ImgCoul.Canvas.Handle,0,0,ImgCoul.Width,ImgCoul.Height);
//  RectCoul
  PasBigRect.X := Round((ImgAdobe2.Width-(RectBigAdobe.Right+1+RectLittleAdobe.Right+1+EspaceEntre{+RectCoul.Right+10}))/2);
  PasBigRect.Y := Round((ImgAdobe2.Height-(RectBigAdobe.Bottom+1))/2);
  PasLittleRect.X := PasBigRect.X+RectBigAdobe.Right+1+EspaceEntre;
  PasLittleRect.Y := PasBigRect.Y;

  PasCoulRect.X := Round((ImgCoul.Width-RectCoul.Right)/ 2);
  PasCoulRect.Y := Round((ImgCoul.Height-RectCoul.Bottom)/ 2);

  DrawContour(Rect(PasBigRect.X+RectBigAdobe.Left,PasBigRect.Y+RectBigAdobe.Top,PasBigRect.X+RectBigAdobe.Right,PasBigRect.Y+RectBigAdobe.Bottom),ImgAdobe2.Canvas);
  DrawContour(Rect(PasLittleRect.X+RectLittleAdobe.Left,PasLittleRect.Y+RectLittleAdobe.Top,PasLittleRect.X+RectLittleAdobe.Right,PasLittleRect.Y+RectLittleAdobe.Bottom),ImgAdobe2.Canvas);
  DrawContour(Rect(PasCoulRect.X+RectCoul.Left,PasCoulRect.Y+RectCoul.Top,PasCoulRect.X+RectCoul.Right,PasCoulRect.Y+RectCoul.Bottom),ImgCoul.Canvas);
  ImgAdobe2.Canvas.Pen.Color := $FFFFFF;//ColorToRGB(clBtnFace);
  ImgAdobe2.Canvas.Pen.Mode := pmXor;
  DrawCoul2;
  DrawCoul;
  Coul.Free;
{ for T := 0 to 255 do
  begin
    TSV.T := round(359*T/255);
    for S := 0 to 100 do
    begin
      TSV.S := S;
      for V :=  0 to 100 do
      begin
        TSV.V := V;
        Coul.TSV := TSV;
        TabCol[T,S,V] := Coul.RVB;
      end;
    end;
  end;}
  if not ( csDesigning in ComponentState) then
    if FileExists(ExtractFilePath(Application.ExeName)+'TSV.DAT') then
    begin
      AssignFile(F,ExtractFilePath(Application.ExeName)+'TSV.DAT');
      Reset(F,1);
//      BlockRead(F,TabCol,Sizeof(TabCol));
      CloseFile(F);
      RBT.Enabled := True;
      RBL.Enabled := True;
      RBS.Enabled := True;
    end;
end;

procedure TFrameAdobe2.SpAdobe2KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_SUBTRACT then
    Key := 0;
end;

procedure TFrameAdobe2.SpAdobe2KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_SUBTRACT then
    Key := 0;
end;

procedure TFrameAdobe2.SpAdobeKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key='-')or(Key='+') then
    Key := #0;
end;

procedure TFrameAdobe2.ImgAdobe2MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if ClickDans(Rect(PasBigRect.X+RectBigAdobe.Left,PasBigRect.Y+RectBigAdobe.Top,PasBigRect.X+RectBigAdobe.Right,PasBigRect.Y+RectBigAdobe.Bottom),X,Y) then
    ClickImg := CZAdobe2Carre
  else if ClickDans(Rect(PasLittleRect.X+RectLittleAdobe.Left,PasLittleRect.Y+RectLittleAdobe.Top,PasLittleRect.X+RectLittleAdobe.Right,PasLittleRect.Y+RectLittleAdobe.Bottom),X,Y) then
    ClickImg := CZAdobe2Barre
  else
    ClickImg := CZAdobe2None;
  GestionSouris(X,Y);
end;

function TFrameAdobe2.ClickDans(const R: TRect; X, Y: Integer): Boolean;
begin
  Result := ((X>=R.Left)and(X<=R.Right))and((Y>=R.Top)and(Y<=R.Bottom));
end;

procedure TFrameAdobe2.ImgAdobe2MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  GestionSouris(X,Y);
  ClickImg := CZAdobe2None;
end;

procedure TFrameAdobe2.ImgAdobe2MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  GestionSouris(X,Y);
end;

procedure TFrameAdobe2.GestionSouris(X, Y: Integer);
begin
  case ClickImg of
    CZAdobe2Carre : begin
      GestionBigCarre(X,Y);
    end;
    CZAdobe2Barre : begin
      GestionLittleCarre(X,Y);
    end;
  end;
end;

procedure TFrameAdobe2.ActiveOnChange;
begin
  SpRAdobe.Modified := true;
  SpVAdobe.Modified := true;
  SpBAdobe.Modified := true;
  SpTAdobe.Modified := true;
  SpSAdobe.Modified := true;
  SpLAdobe.Modified := true;
  SpRAdobe.OnChange := SpRVBAdobeChange;
  SpVAdobe.OnChange := SpRVBAdobeChange;
  SpBAdobe.OnChange := SpRVBAdobeChange;
  SpTAdobe.OnChange := SpTSLAdobeChange;
  SpSAdobe.OnChange := SpTSLAdobeChange;
  SpLAdobe.OnChange := SpTSLAdobeChange;
end;

procedure TFrameAdobe2.DesactiveOnChange;
begin
  SpRAdobe.OnChange := nil;
  SpVAdobe.OnChange := nil;
  SpBAdobe.OnChange := nil;
  SpTAdobe.OnChange := nil;
  SpSAdobe.OnChange := nil;
  SpLAdobe.OnChange := nil;
end;

procedure TFrameAdobe2.MAJValeur;
begin
  SpRAdobe.Value := Couleur.RVB.R;
  SpVAdobe.Value := Couleur.RVB.V;
  SpBAdobe.Value:= Couleur.RVB.B;
  SpTAdobe.Value:= Couleur.TSV.T;
  SpSAdobe.Value:= Round(Couleur.TSV.S);
  SpLAdobe.Value:= Round(Couleur.TSV.V);
end;

procedure TFrameAdobe2.SpRVBAdobeChange(Sender: TObject);
var
  RVB : TRVB;
begin
  if TSpinEdit(Sender).Text<>'' then
  begin
///    HideTriAngle;
    if TSpinEdit(Sender).Value > TSpinEdit(Sender).MaxValue then
      TSpinEdit(Sender).Value := TSpinEdit(Sender).MaxValue;
    DrawCur;
    RVB.R := SpRAdobe.Value;
    RVB.V:= SpVAdobe.Value;
    RVB.B:= SpBAdobe.Value;
    Couleur.RVB := RVB;
    DesactiveOnChange ;
    SpTAdobe.Value:= Couleur.TSV.T;
    SpSAdobe.Value:= Round(Couleur.TSV.S);
    SpLAdobe.Value:= Round(Couleur.TSV.V);
    ActiveOnChange;
    DrawCoul2;
    DrawCoul;
  end;
end;

procedure TFrameAdobe2.SpTSLAdobeChange(Sender: TObject);
var
  TSV : TTSV;
begin
  if TSpinEdit(Sender).Text<>'' then
  begin
    DrawCur;
    if TSpinEdit(Sender).Value >TSpinEdit(Sender).MaxValue  then
      TSpinEdit(Sender).Value := TSpinEdit(Sender).MaxValue;
    TSV.T := SpTAdobe.Value;
    TSV.S := SpSAdobe.Value;
    TSV.V := SpLAdobe.Value;
    Couleur.TSV:= TSV;
    DesactiveOnChange ;
    SpRAdobe.Value := Couleur.RVB.R;
    SpVAdobe.Value := Couleur.RVB.V;
    SpBAdobe.Value:= Couleur.RVB.B;
    ActiveOnChange;
    DrawCoul2;
    DrawCoul;
  end;
end;

procedure TFrameAdobe2.GestionBigCarre(const X, Y: Integer);
var
  RVB : TRVB;
  TSV : TTSV;
  C_X,C_Y : Integer;
begin
  if RBR.Checked then
  begin
    C_X := X-PasBigRect.X;
    C_Y := Y-PasBigRect.Y;

    if C_X < RectBigAdobe.Left then
      C_X := RectBigAdobe.Left
    else
    if C_X > RectBigAdobe.Right then
      C_X := RectBigAdobe.Right;

    if C_Y < RectBigAdobe.Top then
      C_Y := RectBigAdobe.Top
    else
    if C_Y > RectBigAdobe.Bottom then
      C_Y := RectBigAdobe.Bottom;
    DrawCur;
    RVB.R := Couleur.RVB.R ;
    RVB.V := 255-C_Y;
    RVB.B := C_X;
    Couleur.RVB := RVB;
    MAJCoul;
  end
  else
  if RBV.Checked then
  begin
    C_X := X-PasBigRect.X;
    C_Y := Y-PasBigRect.Y;

    if C_X < RectBigAdobe.Left then
      C_X := RectBigAdobe.Left
    else
    if C_X > RectBigAdobe.Right then
      C_X := RectBigAdobe.Right;

    if C_Y < RectBigAdobe.Top then
      C_Y := RectBigAdobe.Top
    else
    if C_Y > RectBigAdobe.Bottom then
      C_Y := RectBigAdobe.Bottom;
    DrawCur;
    RVB.V := Couleur.RVB.V ;
    RVB.R := 255-C_Y;
    RVB.B := C_X;
    Couleur.RVB := RVB;
    MAJCoul;
  end
  else
  if RBB.Checked then
  begin
    C_X := X-PasBigRect.X;
    C_Y := Y-PasBigRect.Y;

    if C_X < RectBigAdobe.Left then
      C_X := RectBigAdobe.Left
    else
    if C_X > RectBigAdobe.Right then
      C_X := RectBigAdobe.Right;

    if C_Y < RectBigAdobe.Top then
      C_Y := RectBigAdobe.Top
    else
    if C_Y > RectBigAdobe.Bottom then
      C_Y := RectBigAdobe.Bottom;
    DrawCur;
    RVB.B := Couleur.RVB.B ;
    RVB.V := 255-C_Y;
    RVB.R := C_X;
    Couleur.RVB := RVB;
    MAJCoul;
  end
  else
  if RBT.Checked then
  begin
    C_X := X-PasBigRect.X;
    C_Y := Y-PasBigRect.Y;

    if C_X < RectBigAdobe.Left then
      C_X := RectBigAdobe.Left
    else
    if C_X > RectBigAdobe.Right then
      C_X := RectBigAdobe.Right;

    if C_Y < RectBigAdobe.Top then
      C_Y := RectBigAdobe.Top
    else
    if C_Y > RectBigAdobe.Bottom then
      C_Y := RectBigAdobe.Bottom;

    DrawCur;
    TSV.T := Couleur.TSV.T;
    TSV.S := (100*C_X/255);
    TSV.V := 100-(0.3921*C_Y);
    Couleur.TSV := TSV;
    DesactiveOnChange ;
    MAJValeur;
    ActiveOnChange;
    DrawCoul2;
    DrawCur;
    DrawColor;
    ImgAdobe2.Picture.Bitmap.Modified:= true;
    //DrawCoul;
    //MAJCoul;
   // Application.ProcessMessages;
  end
  else
  if RBS.Checked then
  begin
    C_X := X-PasBigRect.X;
    C_Y := Y-PasBigRect.Y;

    if C_X < RectBigAdobe.Left then
      C_X := RectBigAdobe.Left
    else
    if C_X > RectBigAdobe.Right then
      C_X := RectBigAdobe.Right;

    if C_Y < RectBigAdobe.Top then
      C_Y := RectBigAdobe.Top
    else
    if C_Y > RectBigAdobe.Bottom then
      C_Y := RectBigAdobe.Bottom;
    DrawCur;
   TSV := Couleur.TSV;
    TSV.V := 100-(100*C_Y/255);
    TSV.T := round(359*C_X/255);
    Couleur.TSV := TSV;
    DesactiveOnChange ;
    MAJValeur;
    ActiveOnChange;
    DrawCoul2;
    DrawCur;
    DrawColor;
    ImgAdobe2.Picture.Bitmap.Modified:= true;
//    MAJCoul;
  end
  else
  if RBL.Checked then
  begin
    C_X := X-PasBigRect.X;
    C_Y := Y-PasBigRect.Y;

    if C_X < RectBigAdobe.Left then
      C_X := RectBigAdobe.Left
    else
    if C_X > RectBigAdobe.Right then
      C_X := RectBigAdobe.Right;

    if C_Y < RectBigAdobe.Top then
      C_Y := RectBigAdobe.Top
    else
    if C_Y > RectBigAdobe.Bottom then
      C_Y := RectBigAdobe.Bottom;
    DrawCur;
    TSV.V := Couleur.TSV.V;
    TSV.S := 100-(100*C_Y/255);
    TSV.T := round(359*C_X/255);
    Couleur.TSV := TSV;
    DesactiveOnChange ;
    MAJValeur;
    ActiveOnChange;
    DrawCoul2;
    DrawCur;
    DrawColor;
    ImgAdobe2.Picture.Bitmap.Modified:= true;
//    MAJCoul;
  end;
end;

procedure TFrameAdobe2.GestionLittleCarre(const X, Y: Integer);
var
  RVB : TRVB;
  TSV : TTSV;
  C_Y : Integer;
begin
  if RBR.Checked then
  begin
    C_Y := Y-PasLittleRect.Y;

    if C_Y < RectLittleAdobe.Top then
      C_Y := RectLittleAdobe.Top
    else
    if C_Y > RectLittleAdobe.Bottom then
      C_Y := RectLittleAdobe.Bottom;
    DrawCur;
    RVB.R := 255-C_Y ;
    RVB.V := Couleur.RVB.V;
    RVB.B := Couleur.RVB.B;
    Couleur.RVB := RVB;
    MAJCoul;
  end
  else
  if RBV.Checked then
  begin
    C_Y := Y-PasLittleRect.Y;
    if C_Y < RectLittleAdobe.Top then
      C_Y := RectLittleAdobe.Top
    else
    if C_Y > RectLittleAdobe.Bottom then
      C_Y := RectLittleAdobe.Bottom;
    DrawCur;
    RVB.V := 255-C_Y ;
    RVB.R := Couleur.RVB.R;
    RVB.B := Couleur.RVB.B;
    Couleur.RVB := RVB;
    MAJCoul;
  end
  else
  if RBB.Checked then
  begin
    C_Y := Y-PasLittleRect.Y;

    if C_Y < RectLittleAdobe.Top then
      C_Y := RectLittleAdobe.Top
    else
    if C_Y > RectLittleAdobe.Bottom then
      C_Y := RectLittleAdobe.Bottom;
    DrawCur;
    RVB.B := 255-C_Y ;
    RVB.V := Couleur.RVB.V;
    RVB.R := Couleur.RVB.R;
    Couleur.RVB := RVB;
    MAJCoul;
  end
  else
  if RBT.Checked then
  begin
    C_Y := Y-PasLittleRect.Y;

    if C_Y < RectLittleAdobe.Top then
      C_Y := RectLittleAdobe.Top
    else
    if C_Y > RectLittleAdobe.Bottom then
      C_Y := RectLittleAdobe.Bottom;
    DrawCur;
    TSV.T := round(359-(359*C_Y/255)) ;
    TSV.S := Couleur.TSV.S;
    TSV.V := Couleur.TSV.V;
    Couleur.TSV := TSV;
    MAJCoul;
  end
  else
  if RBL.Checked then
  begin
    C_Y := Y-PasLittleRect.Y;
    if C_Y < RectLittleAdobe.Top then
      C_Y := RectLittleAdobe.Top
    else
    if C_Y > RectLittleAdobe.Bottom then
      C_Y := RectLittleAdobe.Bottom;
    DrawCur;
    TSV.T := Couleur.TSV.T ;
    TSV.S := Couleur.TSV.S;
    TSV.V := 100-(100*C_Y/255);
    Couleur.TSV := TSV;
//    ImgAdobe2.Picture.Bitmap.Modified := true;
    MAJCoul;
  end
  else
  if RBS.Checked then
  begin
    C_Y := Y-PasLittleRect.Y;
    if C_Y < RectLittleAdobe.Top then
      C_Y := RectLittleAdobe.Top
    else
    if C_Y > RectLittleAdobe.Bottom then
      C_Y := RectLittleAdobe.Bottom;
    DrawCur;
    TSV.T := Couleur.TSV.T ;
    TSV.S := 100-(100*C_Y/255);
    TSV.V := Couleur.TSV.V;
    Couleur.TSV := TSV;
    MAJCoul;

  end;
end;

procedure TFrameAdobe2.DrawCur;
  procedure DrawCircle(X,Y,R:Integer);
  begin
    Ellipse(ImgAdobe2.Canvas.Handle,X-R,Y-R,X+R,Y+R);
  end;
  procedure DrawTriangle(Y : Integer);
  begin
    MoveToEx(ImgAdobe2.Canvas.Handle,PasLittleRect.X-3,Y,nil);
    LineTo(ImgAdobe2.Canvas.Handle,PasLittleRect.X-8,Y-5);
    LineTo(ImgAdobe2.Canvas.Handle,PasLittleRect.X-8,Y+5);
    LineTo(ImgAdobe2.Canvas.Handle,PasLittleRect.X-3,Y);
    MoveToEx(ImgAdobe2.Canvas.Handle,PasLittleRect.X+RectLittleAdobe.Right+3,Y,nil);
    LineTo(ImgAdobe2.Canvas.Handle,PasLittleRect.X+RectLittleAdobe.Right+8,Y-5);
    LineTo(ImgAdobe2.Canvas.Handle,PasLittleRect.X+RectLittleAdobe.Right+8,Y+5);
    LineTo(ImgAdobe2.Canvas.Handle,PasLittleRect.X+RectLittleAdobe.Right+3,Y);
  end;
begin
  if RBR.Checked then
  begin
    DrawCircle(PasBigRect.X+Couleur.RVB.B,PasBigRect.Y+255-Couleur.RVB.V,5);
    DrawTriangle(PasBigRect.Y+255-Couleur.RVB.R);
  end
  else
  if RBV.Checked then
  begin
    DrawCircle(PasBigRect.X+Couleur.RVB.B,PasBigRect.Y+255-Couleur.RVB.R,5);
    DrawTriangle(PasBigRect.Y+255-Couleur.RVB.V);
  end
  else
  if RBB.Checked then
  begin
    DrawCircle(PasBigRect.X+Couleur.RVB.R,PasBigRect.Y+255-Couleur.RVB.V,5);
    DrawTriangle(PasBigRect.Y+255-Couleur.RVB.B);
  end
  else
  if RBT.Checked then
  begin
    DrawCircle(PasBigRect.X+round(255*Couleur.TSV.S/100),PasBigRect.Y+255-round(255*Couleur.TSV.V/100),5);
    DrawTriangle(PasBigRect.Y+255-round(255*Couleur.TSV.T/359));
  end
  else
  if RBS.Checked then
  begin
    DrawCircle(PasBigRect.X+round(255*Couleur.TSV.T/359),PasBigRect.Y+255-round(255*Couleur.TSV.V/100),5);
    DrawTriangle(PasBigRect.Y+255-round(255*Couleur.TSV.S/100));
  end
  else
  if RBL.Checked then
  begin
    DrawCircle(PasBigRect.X+round(255*Couleur.TSV.T/359),PasBigRect.Y+255-round(255*Couleur.TSV.S/100),5);
    DrawTriangle(PasBigRect.Y+255-round(255*Couleur.TSV.V/100));
  end;

end;

procedure TFrameAdobe2.RBRClick(Sender: TObject);
begin
  DrawCoul2;
  DrawCoul;
end;

procedure TFrameAdobe2.RBMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  DrawCur;
end;

procedure TFrameAdobe2.MAJCoul;
begin
  DesactiveOnChange ;
  MAJValeur;
  ActiveOnChange;
  DrawCoul;
end;

end.
