{$D-}
unit Ufunction;

interface

uses Windows, Messages, SysUtils, Variants, Forms, Classes,
  Registry, Psapi, tlhelp32, shellapi, shlobj, activex,
  StdCtrls, buttons, graphics, controls, dialogs, Consts, ExtCtrls, math;

  function GetMyDocuments : string;
  function getcurrentfilename:string;
  function GetAppDirectory:string;
  function GetConfigDir:string;
  function GetSystemDir: string;
  function GetWindowsDir: string;
  function GetModuleDir: string;
  function RegisterOCX(FileName: string): Boolean;
  function UnRegisterOCX(FileName: string): Boolean;
  function GetProgramFilesDir: string;
  function ExecuteFile(filename:string; visible:boolean): Boolean;
  procedure deletefiles(dir,namespace:string);
  function GetOperatingSystem: Integer;
  procedure SplitString(str:string;var returnStr:TStringList;splitchar:char);

  function EXE_Running(FileName:string):THandle;
  function UrlDecode(const EncodedStr: String): String;
  function URLEncode(const S: string; const InQueryString: Boolean): string;

  function find_WinNTProcessID(FileName:string):integer;
  function ExtractRes(ResType, ResName, ResNewName: string): Boolean;
  function ConvertSize(value:integer):string;
  function ConvertSize2(value:integer):string;
  function timestamptodatetime(s:string):tdatetime;

  function getvalue(s1,s_w,e_w:string):string;
  function Get_File_Size2(sFileToExamine: string): integer;
  function getredirecturl(s1:string):string;
  function striphtmltag(s:string):string;
  function GetIconIndex(const APath: string; Attrs: DWORD): integer;
  procedure lockcontrol(c: THandle; lock: boolean);
  function validmemberid(s:string):boolean;
  function copy_paragraph(s1,s_w,e_w:string):string;
  function getvalue_back(s1,s_w,e_w:string):string;

  function makeuniqfilename(s:string):string;
  function getfilenamefromlink(s:string):string;

  function convertquote(s:string):string;
  function convertquote2(s:string):string;
  function randomchar(len:integer):string;
  function deletebadfilenamechar(s:string):string;
  function Sto_GetFmtFileVersion(const FileName: String;
     const Fmt: String = '%d.%d.%d.%d'): String;
  function makecaption(s:string;len:integer=25):string;
  function IsNum(Num: String): Boolean;
  function get_paramvalue(s:string;name:string):string;
  function GetVersion(filename:string): string;
  function sectostring(sec:integer):string;
  function Getsite(s:string):string;
  function ConvertTime(sec:integer):string;
  function getupdir(s:string):string;

  function _messagedlg(owner:tcontrol;text:string;dlgtype:TMsgDlgType;selbutton:TMsgDlgBtn=mbOK):integer;
  function InputQuery2(owner:tform; const ACaption, APrompt: string;
    var Value: string): Boolean;
  procedure formtocenter2(targetform:tform;ownerform:tform=nil);
  function speialcharhtml(s:string):string;
  procedure rebootrename(src,target:string);

const
  { operating system (OS)constants }
  cOsUnknown = -1;
  cOsWin95 = 0;
  cOsWin98 = 1;
  cOsWin98SE = 2;
  cOsWinME = 3;
  cOsWinNT = 4;
  cOsWin2000 = 5;
  cOsXP = 6;

implementation

type
  TDllRegisterServer = function: HResult; stdcall;

function getcurrentfilename:string;
var
  szFileName: array[0..MAX_PATH] of Char;
begin
  FillChar(szFileName, SizeOf(szFileName), #0);
  GetModuleFileName(hInstance, szFileName, MAX_PATH);
  Result := szFileName;
end;

function GetAppDirectory:string;
begin
  result:=ExtractFilePath(Application.ExeName);
  if (length(result)>0) and (result[length(result)]<>'\') then
    result:=result+'\';
end;

function GetConfigDir:string;
begin
  result:=GetAppDirectory+'config\recorder\';
  if sysutils.DirectoryExists(result)=false then
    sysutils.ForceDirectories(result);
end;

function GetSystemDir: string;
var
  dir: array [0..MAX_PATH] of Char;
begin
  GetSystemDirectory(dir, MAX_PATH);
  Result := StrPas(dir);
  if (length(result)>0) and (result[length(result)]<>'\') then
    result:=result+'\';
end;

function GetWindowsDir: string;
var
  dir: array [0..MAX_PATH] of Char;
begin
  GetWindowsDirectory(dir, MAX_PATH);
  Result := StrPas(dir);
  if (length(result)>0) and (result[length(result)]<>'\') then
    result:=result+'\';
end;

function GetModuleDir: string;
var
  szFileName: array[0..MAX_PATH] of Char;
begin
  FillChar(szFileName, SizeOf(szFileName), #0);
  GetModuleFileName(hInstance, szFileName, MAX_PATH);
  Result := szFileName;
  Result:= sysutils.ExtractFilePath(result);  
  if (length(result)>0) and (result[length(result)]<>'\') then
    result:=result+'\';
end;

function GetProgramFilesDir: string;
var
  reg: TRegistry;
begin
  reg := TRegistry.Create;
  try
    reg.RootKey := HKEY_LOCAL_MACHINE;
    reg.OpenKey('SOFTWARE\Microsoft\Windows\CurrentVersion', False);
    Result := reg.ReadString('ProgramFilesDir');
  finally
    reg.Free;
  end;
  if (length(result)>0) and (result[length(result)]<>'\') then
    result:=result+'\';
end;

procedure SplitString(str:string;var returnStr:TStringList;splitchar:char);
var
 p1:integer;
 y:string;
begin

 p1:=pos(splitchar,str);
 while p1>0 do
 begin
    y:=copy(str,1,p1-1);
    returnStr.Add(y);
    delete(str,1,p1);
    p1:=pos(splitchar,str);
 end;
 if str <> '' then returnStr.Add(str);

end;

function RegisterOCX(FileName: string): Boolean;
var
  OCXHand: THandle;
  RegFunc: TDllRegisterServer;
begin
  OCXHand := LoadLibrary(PChar(FileName));
  RegFunc := GetProcAddress(OCXHand, 'DllRegisterServer');
  if @RegFunc <> nil then
    Result := RegFunc = S_OK
  else
    Result := False;
  FreeLibrary(OCXHand);
end;

function UnRegisterOCX(FileName: string): Boolean;
var
  OCXHand: THandle;
  RegFunc: TDllRegisterServer;
begin
  OCXHand := LoadLibrary(PChar(FileName));
  RegFunc := GetProcAddress(OCXHand, 'DllUnregisterServer');
  if @RegFunc <> nil then
    Result := RegFunc = S_OK
  else
    Result := False;
  FreeLibrary(OCXHand);
end;

function ExecuteFile(filename:string; visible:boolean): Boolean;
var
  SUInfo: TStartupInfo;
  ProcInfo: TProcessInformation;
  s:string;
begin
  FillChar(SUInfo, SizeOf(SUInfo), #0);
  with SUInfo do begin
     cb := SizeOf(SUInfo);
     dwFlags := STARTF_USESHOWWINDOW;
     if visible then
        wShowWindow := SW_NORMAL
     else
        wShowWindow := SW_HIDE;
//     s:=sysutils.ExtractFilePath(filename);
     createprocess(nil, PChar(filename), nil, nil, False,
        CREATE_NEW_CONSOLE or NORMAL_PRIORITY_CLASS, nil, nil,
        SUInfo, ProcInfo);
  end;
end;

procedure deletefiles(dir,namespace:string);
var
  SR: TSearchRec;
  a:string;
begin
  namespace:=lowercase(namespace);
  if FindFirst(dir+'*.*', faAnyFile, SR) = 0 then
   repeat
     if (SR.Attr <> faDirectory) and (SR.Name[1] <> '.') then begin
       a:=lowercase(sysutils.ExtractFileExt(SR.Name));
       if (namespace='*.*') or (a = namespace) then begin
          DeleteFile(dir+SR.Name);
       end;
     end;
   Until (FindNext(SR)<>0);
  FindClose(SR);
end;

function GetOperatingSystem: Integer;
var
  osVerInfo: TOSVersionInfo;
  majorVer, minorVer: Integer;
begin
  Result := cOsUnknown;
  { set operating system type flag }
  osVerInfo.dwOSVersionInfoSize := SizeOf(TOSVersionInfo);
  if GetVersionEx(osVerInfo) then
  begin
    majorVer := osVerInfo.dwMajorVersion;
    minorVer := osVerInfo.dwMinorVersion;
    case osVerInfo.dwPlatformId of
      VER_PLATFORM_WIN32_NT: { Windows NT/2000 }
        begin
          if majorVer <= 4 then
            Result := cOsWinNT
          else if (majorVer = 5) and (minorVer = 0) then
            Result := cOsWin2000
          else if (majorVer = 5) and (minorVer = 1) then
            Result := cOsXP
          else
            Result := cOsUnknown;
        end;
      VER_PLATFORM_WIN32_WINDOWS:  { Windows 9x/ME }
        begin
          if (majorVer = 4) and (minorVer = 0) then
            Result := cOsWin95
          else if (majorVer = 4) and (minorVer = 10) then
          begin
            if osVerInfo.szCSDVersion[1] = 'A' then
              Result := cOsWin98SE
            else
              Result := cOsWin98;
          end
          else if (majorVer = 4) and (minorVer = 90) then
            Result := cOsWinME
          else
            Result := cOsUnknown;
        end;
      else
        Result := cOsUnknown;
    end;
  end
  else
    Result := cOsUnknown;
end;

///process check////
//Psapi, tlhelp32;
function CreateWin9xProcessList(FileName:string):THandle;
var
  hSnapShot: THandle;
  ProcInfo: TProcessEntry32;
  h:THandle;
begin
  result:=0;
  hSnapShot := CreateToolHelp32Snapshot(TH32CS_SNAPPROCESS, 0);
  if (hSnapShot <> THandle(-1)) then 
  begin 
    ProcInfo.dwSize := SizeOf(ProcInfo);
    if (Process32First(hSnapshot, ProcInfo)) then
    begin
      if CompareText(ExtractFileName(ProcInfo.szExeFile), ExtractFileName(FileName)) = 0 then begin
         h:=OpenProcess(PROCESS_TERMINATE, False, ProcInfo.th32ProcessID);
         result:=h;
         CloseHandle(h);
         exit;
      end;

      while (Process32Next(hSnapShot, ProcInfo)) do
      if CompareText(ExtractFileName(ProcInfo.szExeFile), ExtractFileName(FileName)) = 0 then begin
         h:=OpenProcess(PROCESS_TERMINATE, False, ProcInfo.th32ProcessID);
         result:=h;
         CloseHandle(h);
         CloseHandle(hSnapShot);
         break;
      end;
    end;
    CloseHandle(hSnapShot);
  end;
end;

function CreateWinNTProcessList(FileName:string):THandle;
var
  PIDArray: array [0..1023] of DWORD;
  cb: DWORD;
  I: Integer; 
  ProcCount: Integer; 
  hMod: HMODULE; 
  hProcess: THandle;
  ModuleName: array [0..300] of Char;
  h:THandle;
begin
  result:=0;
  EnumProcesses(@PIDArray, SizeOf(PIDArray), cb);
  ProcCount := cb div SizeOf(DWORD);
  for I := 0 to ProcCount - 1 do
  begin
    hProcess := OpenProcess(PROCESS_QUERY_INFORMATION or
      PROCESS_VM_READ,
      False,
      PIDArray[I]);
    if (hProcess <> 0) then
    begin
      EnumProcessModules(hProcess, @hMod, SizeOf(hMod), cb);
      GetModuleFilenameEx(hProcess, hMod, ModuleName, SizeOf(ModuleName));
      if CompareText(ModuleName, FileName) = 0 then begin
         h:=OpenProcess(PROCESS_TERMINATE, false, PIDArray[I]);
         result:=h;
         CloseHandle(h);
         CloseHandle(hProcess);
         break;
      end;
      CloseHandle(hProcess);
    end;
  end;
end;

function GetProcessList(FileName:string):THandle;
var
  ovi: TOSVersionInfo;
begin
//  if List = nil then Exit;
  result:=0;
  ovi.dwOSVersionInfoSize := SizeOf(TOSVersionInfo);
  GetVersionEx(ovi);
  case ovi.dwPlatformId of
    VER_PLATFORM_WIN32_WINDOWS: result:=CreateWin9xProcessList(FileName);
    VER_PLATFORM_WIN32_NT: result:=CreateWinNTProcessList(FileName);
  end
end;

function EXE_Running(FileName:string):THandle;
begin
  result:=GetProcessList(FileName);
end;

function HexToInt(HexStr: String): Int64;
var RetVar : Int64;
    i : byte;
begin
  HexStr := UpperCase(HexStr);
  if HexStr[length(HexStr)] = 'H' then
     Delete(HexStr,length(HexStr),1);
  RetVar := 0;

  for i := 1 to length(HexStr) do begin
      RetVar := RetVar shl 4;
      if HexStr[i] in ['0'..'9'] then
         RetVar := RetVar + (byte(HexStr[i]) - 48)
      else
         if HexStr[i] in ['A'..'F'] then
            RetVar := RetVar + (byte(HexStr[i]) - 55)
         else begin
            Retvar := 0;
            break;
         end;
  end;

  Result := RetVar;
end;

function UrlDecode(const EncodedStr: String): String;
var
  I: Integer;
  c: char;
begin
  Result := '';
  if Length(EncodedStr) > 0 then
  begin
    I := 1;
    while I <= Length(EncodedStr) do
    begin
      if EncodedStr[I] = '%' then begin
        c:=Chr(HexToInt(EncodedStr[I+1] + EncodedStr[I+2]));
        if c=#0 then
          Result := Result + EncodedStr[I]
        else begin
          Result := Result + c;
          I := Succ(Succ(I));
        end;
      end else if EncodedStr[I] = '+' then
        Result := Result + ' '
      else
        Result := Result + EncodedStr[I];
      I := Succ(I);
    end;
  end;
end;

function URLEncode(const S: string; const InQueryString: Boolean): string;
var
  Idx: Integer; // loops thru characters in string
begin
  Result := '';
  for Idx := 1 to Length(S) do
  begin
    case S[Idx] of
      'A'..'Z', 'a'..'z', '0'..'9', '-', '_', '.':
        Result := Result + S[Idx];
      ' ':
        if InQueryString then
          Result := Result + '+'
        else
          Result := Result + '%20';
      else
        Result := Result + '%' + SysUtils.IntToHex(Ord(S[Idx]), 2);
    end;
  end;
end;

function find_WinNTProcessID(FileName:string):integer;
var
  PIDArray: array [0..1023] of DWORD;
  cb: DWORD;
  I: Integer;
  ProcCount: Integer; 
  hMod: HMODULE; 
  hProcess: THandle;
  ModuleName: array [0..300] of Char;
begin
  result:=0;
  EnumProcesses(@PIDArray, SizeOf(PIDArray), cb);
  ProcCount := cb div SizeOf(DWORD);
  for I := 0 to ProcCount - 1 do
  begin
    hProcess := OpenProcess(PROCESS_QUERY_INFORMATION or
      PROCESS_VM_READ,
      False,
      PIDArray[I]);
    if (hProcess <> 0) then
    begin
      EnumProcessModules(hProcess, @hMod, SizeOf(hMod), cb);
      GetModuleFilenameEx(hProcess, hMod, ModuleName, SizeOf(ModuleName));
      if CompareText(ModuleName, FileName) = 0 then begin
         result:=PIDArray[I];
         CloseHandle(hProcess);
         break;
      end;
      CloseHandle(hProcess);
    end;
  end;
end;

function ExtractRes(ResType, ResName, ResNewName: string): Boolean;
var
  Res: TResourceStream;
begin
  Result := False;
  Res := TResourceStream.Create(Hinstance, Resname, PChar(ResType));
  try
    Res.SavetoFile(ResNewName);
    Result := True;
  finally
    Res.Free;
  end;
end;

function ConvertSize(value:integer):string;
var
 s,d:double;
begin
try
  s:=value;
  if s > 1000000 then begin
     d := (s / 1000000);
     result:=formatfloat('##.#', d) + ' M';
  end else if s > 1000 then begin
     d := (s / 1000);
     result:=formatfloat('##.#', d) + ' Kb';
  end else begin
     result:=floattostr(s) + ' b';
  end;
except
  result:= '0 b';
end;
end;

function ConvertSize2(value:integer):string;
var
 s,d:double;
begin
try
  s:=value;
  if s > 1000 then begin
     d := (s / 1000);
     result:=formatfloat('##.#', d) + ' Kb';
  end else begin
     result:=floattostr(s) + ' b';
  end;
except
  result:= '0 b';
end;
end;

function timestamptodatetime(s:string):tdatetime;
begin
  s:=format('%s-%s-%s %s:%s',[
    copy(s,1,4),copy(s,5,2),copy(s,7,2),
    copy(s,9,2),copy(s,11,2)
    ]);
  result:=sysutils.StrToDateTime(s);
end;


 function getvalue(s1,s_w,e_w:string):string;
 var s2:string;
  p1:integer;
 begin
    result:='';
    p1:=pos(s_w,s1);
    if p1=0 then
       exit;
    s2:=copy(s1,p1+length(s_w),length(s1));
    p1:=pos(e_w,s2);
    result:=copy(s2,1,p1-1);
 end;

function Get_File_Size2(sFileToExamine: string): integer;
var
  SearchRec: TSearchRec;
  inRetval, I1: Integer;
begin
  try
    inRetval := FindFirst(ExpandFileName(sFileToExamine), faAnyFile, SearchRec);
    if inRetval = 0 then
      I1 := SearchRec.Size
    else
      I1 := -1;
  finally
    SysUtils.FindClose(SearchRec);
  end;
  Result := I1;
end;

 function getredirecturl(s1:string):string;
 var s2:string;
  p1:integer;
 begin
    result:='';
    p1:=pos('location: http',lowercase(s1));
    if p1=0 then
       exit;
    s2:=copy(s1,p1+14,length(s1));
    p1:=pos(#13,s2);
    result:='http' + copy(s2,1,p1-1);
 end;

function striphtmltag(s:string):string;
var
  p1,p2:integer;
begin
  p1:=pos('<',s);
  while p1>0 do begin
    p2:=pos('>',s);
    if p2>0 then
      delete(s,p1,p2-p1+1);
    p1:=pos('<',s);
  end;
  result:=trim(s);
end;

function GetIconIndex(const APath: string; Attrs: DWORD): integer;
var
  SFI: TSHFileInfo;
begin
  if FileExists(APath) or DirectoryExists(APath) then
    SHGetFileInfo(PChar(APath), 0, SFI, SizeOf(TSHFileInfo),
      SHGFI_SYSICONINDEX)
  else
    SHGetFileInfo(PChar(APath), Attrs, SFI, SizeOf(TSHFileInfo),
      SHGFI_SYSICONINDEX or SHGFI_USEFILEATTRIBUTES);
  Result := SFI.iIcon;
end;

procedure lockcontrol(c: THandle; lock: boolean);
begin
    if (c=0) then exit;
    if lock then SendMessage(c,WM_SETREDRAW,0,0)
    else begin
      SendMessage(c,WM_SETREDRAW,1,0);
      RedrawWindow(c,nil,0,
        RDW_ERASE or RDW_FRAME or RDW_INVALIDATE or RDW_ALLCHILDREN);
    end;
end;


function validmemberid(s:string):boolean;
var
  i:integer;
  c:char;
begin
  for i:=1 to length(s) do begin
    c:=s[i];
    if ((c>='0') and (c<='9')) or
      ((c>='a') and (c<='z')) or
      ((c>='A') and (c<='Z'))  then
      result:=true
    else begin
      result:=false;
      break;
    end;
  end;
end;

function GetMyDocuments : string;
var
  buffer: array[0..255 - 1] of Char;
begin
  if (ShGetSpecialFolderPath(0, @buffer, csidl_Personal, False)) then begin
    Result := buffer;
    if (length(result)>0) and (result[length(result)]<>'\') then
      result:=result+'\';
  end;
end;

function copy_paragraph(s1,s_w,e_w:string):string;
var
  p1:integer;
  s:string;
begin
  result:='';
  p1:=pos(s_w,s1);
  if p1>0 then begin
    delete(s1,1,p1+length(s_w)-1);
    p1:=pos(e_w,s1);
    if p1>0 then begin
      s:=copy(s1,1,p1-1);
      result:=s;
    end;
  end;
end;


function getvalue_back(s1,s_w,e_w:string):string;
var
  p1,p2,p3:integer;
  s2:string;
begin
  s2:='';
  p1:=pos(s_w,s1);
  while p1>0 do begin
    s2:=copy(s1,p1+length(s_w),length(s1));
    delete(s1,1,p1+length(s_w));
    p1:=pos(s_w,s1);
  end;
  if s2<>'' then begin
    p3:=pos(e_w,s2);
    if p3>0 then begin
      result:=copy(s2,1,p3-1);
    end;
  end;
end;

function makeuniqfilename(s:string):string;
var
  s1,s2,s3:string;
  k:integer;
begin
  s1:=sysutils.ExtractFilePath(s);
  s2:=sysutils.ExtractFileName(s);
  s2:=sysutils.ChangeFileExt(s2,'');
  s3:=sysutils.ExtractFileExt(s);

  k:=1;
  while sysutils.FileExists(s) do begin
    s:=s1+format('%s[%d]%s',[s2,k,s3]);
    inc(k);
  end;
  result:=s;
end;

function getfilenamefromlink(s:string):string;
var
  i:integer;
begin
  for i:=length(s) downto 1 do
    if s[i]='/' then begin
      result:=copy(s,i+1,length(s));
      break;
    end;
end;

function Sto_GetFmtFileVersion(const FileName: String;
  const Fmt: String = '%d.%d.%d.%d'): String;
var
  iBufferSize: DWORD;
  iDummy: DWORD;
  pBuffer: Pointer;
  pFileInfo: Pointer;
  iVer: Array[1..4] of Word;
begin
  // set default value
  Result := '';
  // get size of version info (0 if no version info exists)
  iBufferSize := GetFileVersionInfoSize(PChar(FileName), iDummy);
  if (iBufferSize > 0) then
  begin
    GetMem(pBuffer, iBufferSize);
    try
    // get fixed file info
    GetFileVersionInfo(PChar(FileName), 0, iBufferSize, pBuffer);
    VerQueryValue(pBuffer, '\', pFileInfo, iDummy);
    // read version blocks
    iVer[1] := HiWord(PVSFixedFileInfo(pFileInfo)^.dwFileVersionMS);
    iVer[2] := LoWord(PVSFixedFileInfo(pFileInfo)^.dwFileVersionMS);
    iVer[3] := HiWord(PVSFixedFileInfo(pFileInfo)^.dwFileVersionLS);
    iVer[4] := LoWord(PVSFixedFileInfo(pFileInfo)^.dwFileVersionLS);
    finally
      FreeMem(pBuffer);
    end;
    // format result string
    Result := Format(Fmt, [iVer[1], iVer[2], iVer[3], iVer[4]]);
  end;
end;

function deletebadfilenamechar(s:string):string;
const
  badchar: array[0..8] of string =
  ('\','/',':','*','?','"','<','>','|');
var
  i:integer;
begin
  for i:=0 to high(badchar) do begin
    if pos(badchar[i],s)>0 then
      s:=sysutils.StringReplace(s,badchar[i],'',[rfReplaceAll]);
  end;
  result:=s;
end;

function convertquote(s:string):string;
begin
  result:=StringReplace(s,'"',#39,[rfReplaceAll]);
end;


function convertquote2(s:string):string;
begin
  result:=StringReplace(s,#39,'"',[rfReplaceAll]);
end;

function randomchar(len:integer):string;
var
  i,k:integer;
begin
  for i:=1 to len do begin
    k:=random(25);
    k:=k+97; //97-122
    result:=result+char(k);
  end;
end;

function makecaption(s:string;len:integer=25):string;
var
  ws:widestring;
begin
  ws:=widestring(s);
  if length(ws)>len then
   result:=copy(ws,1,len)+'...'
  else
   result:=ws;
end;

function IsNum(Num: String): Boolean;
var
   I, Err : Integer;
begin
   Val(Num,I,Err);
   Result := (Err=0);
end;

function get_paramvalue(s:string;name:string):string;
var
  p1,p2:integer;
begin
  p1:=pos(name+'=',s);
  if p1>0 then begin
    s:=copy(s,p1+length(name)+1,length(s));
    p2:=pos('&',s);
    if p2>0 then s:=copy(s,1,p2-1);
    result:=s;
  end;
end;

function GetVersion(filename:string): string;
var
  VerInfoSize: DWORD;
  VerInfo: Pointer;
  VerValueSize: DWORD;
  VerValue: PVSFixedFileInfo;
  Dummy: DWORD;
begin
  Result := '';
  VerInfoSize := GetFileVersionInfoSize(PChar(filename), Dummy);
  if VerInfoSize = 0 then Exit;
  GetMem(VerInfo, VerInfoSize);
  GetFileVersionInfo(PChar(filename), 0, VerInfoSize, VerInfo);
  VerQueryValue(VerInfo, '\', Pointer(VerValue), VerValueSize);
  with VerValue^ do
  begin
    Result := IntToStr(dwFileVersionMS shr 16);
    Result := Result + '.' + IntToStr(dwFileVersionMS and $FFFF);
    Result := Result + '.' + IntToStr(dwFileVersionLS shr 16);
    Result := Result + '.' + IntToStr(dwFileVersionLS and $FFFF);
  end;
  FreeMem(VerInfo, VerInfoSize);
end;

function sectostring(sec:integer):string;
var
  i:integer;
begin
  result:='';
  i:=sec div 60;
  if i>0 then
    result:=format('%d ',[i]);
  i:=sec mod 60;
  result:=result+format('%d',[i]);
end;

function Getsite(s:string):string;
var
 s2:string;
 p1:integer;
begin
  s:=lowercase(s);
  p1:=pos('://',s);
  if p1<=0 then exit;
  s:=copy(s,p1+3,length(s));
  p1:=pos('/',s);
  if p1 > 0 then begin
    s2:=copy(s,1,p1-1);
  end else
    s2:=s;
  result:=s2;
end;

function ConvertTime(sec:integer):string;
begin
  if sec>3600 then begin
    result:=inttostr(sec div 3600)+'ð ';
    sec:=sec mod 3600;
  end;
  if sec>60 then begin
    result:=result+inttostr(sec div 60)+' ';
    sec:=sec mod 30;
  end;
  result:=result+inttostr(sec)+'';
end;

function getupdir(s:string):string;
var
  i:integer;
begin
  result:='';
  if (length(s)>0) and (s[length(s)]='\') then
    delete(s,length(s),1);
  for i:=length(s) downto 1 do
    if s[i]='\' then begin
      result:=copy(s,1,i);
      break;
    end;
end;


var
  ModalResults: array[TMsgDlgBtn] of Integer = (
    mrYes, mrNo, mrOk, mrCancel, mrAbort, mrRetry, mrIgnore, mrAll, mrNoToAll,
    mrYesToAll, 0);
  ButtonNames: array[TMsgDlgBtn] of string = (
    'Yes', 'No', 'OK', 'Cancel', 'Abort', 'Retry', 'Ignore', 'All', 'NoToAll',
    'YesToAll', 'Help');
  Captions: array[TMsgDlgType] of string = (SMsgDlgWarning, SMsgDlgError,
    SMsgDlgInformation, SMsgDlgConfirm, '');
  IconIDs: array[TMsgDlgType] of PChar = (IDI_EXCLAMATION, IDI_HAND,
    IDI_ASTERISK, IDI_QUESTION, nil);
  ButtonWidths : array[TMsgDlgBtn] of integer;  // initialized to zero
  ButtonCaptions: array[TMsgDlgBtn] of string = (
    SMsgDlgYes, SMsgDlgNo, SMsgDlgOK, SMsgDlgCancel, SMsgDlgAbort,
    SMsgDlgRetry, SMsgDlgIgnore, SMsgDlgAll, SMsgDlgNoToAll, SMsgDlgYesToAll,
    SMsgDlgHelp);

type
  TMessageForm = class(TForm)
  private
    Message: TLabel;
    parenthandle:thandle;

    procedure HelpButtonClick(Sender: TObject);
  protected
    procedure CustomKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure WriteToClipBoard(Text: String);
    function GetFormText: String;
    procedure CreateParams(var Params: TCreateParams); override;
  public
//    constructor Create(AOwner:TComponent;parenthandle:thandle); reintroduce;
    constructor CreateNew(AOwner: TComponent;phandle:thandle); reintroduce;
  end;

 {
constructor TMessageForm.Create(AOwner:TComponent;parenthandle:thandle);
begin
  self.parenthandle:=parenthandle;
  inherited Create(AOwner);
end;
}
procedure TMessageForm.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params do begin
    WndParent := parenthandle;
  end;
end;

constructor TMessageForm.CreateNew(AOwner: TComponent;phandle:thandle);
var
  NonClientMetrics: TNonClientMetrics;
begin
  parenthandle:=phandle;
  inherited CreateNew(AOwner);
  NonClientMetrics.cbSize := sizeof(NonClientMetrics);
  if SystemParametersInfo(SPI_GETNONCLIENTMETRICS, 0, @NonClientMetrics, 0) then
    Font.Handle := CreateFontIndirect(NonClientMetrics.lfMessageFont);
end;

procedure TMessageForm.HelpButtonClick(Sender: TObject);
begin
  Application.HelpContext(HelpContext);
end;

procedure TMessageForm.CustomKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if (Shift = [ssCtrl]) and (Key = Word('C')) then
  begin
    Beep;
    WriteToClipBoard(GetFormText);
  end;
end;

procedure TMessageForm.WriteToClipBoard(Text: String);
var
  Data: THandle;
  DataPtr: Pointer;
begin
  if OpenClipBoard(0) then
  begin
    try
      Data := GlobalAlloc(GMEM_MOVEABLE+GMEM_DDESHARE, Length(Text) + 1);
      try
        DataPtr := GlobalLock(Data);
        try
          Move(PChar(Text)^, DataPtr^, Length(Text) + 1);
          EmptyClipBoard;
          SetClipboardData(CF_TEXT, Data);
        finally
          GlobalUnlock(Data);
        end;
      except
        GlobalFree(Data);
        raise;
      end;
    finally
      CloseClipBoard;
    end;
  end
  else
    raise Exception.CreateRes(@SCannotOpenClipboard);
end;

function TMessageForm.GetFormText: String;
var
  DividerLine, ButtonCaptions: string;
  I: integer;
begin
  DividerLine := StringOfChar('-', 27) + sLineBreak;
  for I := 0 to ComponentCount - 1 do
    if Components[I] is TButton then
      ButtonCaptions := ButtonCaptions + TButton(Components[I]).Caption +
        StringOfChar(' ', 3);
  ButtonCaptions := StringReplace(ButtonCaptions,'&','', [rfReplaceAll]);
  Result := Format('%s%s%s%s%s%s%s%s%s%s', [DividerLine, Caption, sLineBreak,
    DividerLine, Message.Caption, sLineBreak, DividerLine, ButtonCaptions,
    sLineBreak, DividerLine]);
end;

function GetAveCharSize(Canvas: TCanvas): TPoint;
var
  I: Integer;
  Buffer: array[0..51] of Char;
begin
  for I := 0 to 25 do Buffer[I] := Chr(I + Ord('A'));
  for I := 0 to 25 do Buffer[I + 26] := Chr(I + Ord('a'));
  GetTextExtentPoint(Canvas.Handle, Buffer, 52, TSize(Result));
  Result.X := Result.X div 52;
end;

function CreateMessageDialog(owner:tform; const Msg: string; DlgType: TMsgDlgType;
  Buttons: TMsgDlgButtons; SelButton:TMsgDlgBtn): TForm;
const
  mcHorzMargin = 8;
  mcVertMargin = 8;
  mcHorzSpacing = 10;
  mcVertSpacing = 10;
  mcButtonWidth = 50;
  mcButtonHeight = 14;
  mcButtonSpacing = 4;
var
  DialogUnits: TPoint;
  HorzMargin, VertMargin, HorzSpacing, VertSpacing, ButtonWidth,
  ButtonHeight, ButtonSpacing, ButtonCount, ButtonGroupWidth,
  IconTextWidth, IconTextHeight, X, ALeft: Integer;
  B, DefaultButton, CancelButton: TMsgDlgBtn;
  IconID: PChar;
  TextRect: TRect;
begin
  Result := TMessageForm.CreateNew(owner,owner.Handle);
  with Result do
  begin
    BiDiMode := Application.BiDiMode;
    BorderStyle := bsDialog;
    Canvas.Font := Font;
    KeyPreview := True;
    OnKeyDown := TMessageForm(Result).CustomKeyDown;
    DialogUnits := GetAveCharSize(Canvas);
    HorzMargin := MulDiv(mcHorzMargin, DialogUnits.X, 4);
    VertMargin := MulDiv(mcVertMargin, DialogUnits.Y, 8);
    HorzSpacing := MulDiv(mcHorzSpacing, DialogUnits.X, 4);
    VertSpacing := MulDiv(mcVertSpacing, DialogUnits.Y, 8);
    ButtonWidth := MulDiv(mcButtonWidth, DialogUnits.X, 4);
    for B := Low(TMsgDlgBtn) to High(TMsgDlgBtn) do
    begin
      if B in Buttons then
      begin
        if ButtonWidths[B] = 0 then
        begin
          TextRect := Rect(0,0,0,0);
          Windows.DrawText( canvas.handle,
            PChar(ButtonCaptions[B]), -1,
            TextRect, DT_CALCRECT or DT_LEFT or DT_SINGLELINE or
            DrawTextBiDiModeFlagsReadingOnly);
          with TextRect do ButtonWidths[B] := Right - Left + 8;
        end;
        if ButtonWidths[B] > ButtonWidth then
          ButtonWidth := ButtonWidths[B];
      end;
    end;
    ButtonHeight := MulDiv(mcButtonHeight, DialogUnits.Y, 8);
    ButtonSpacing := MulDiv(mcButtonSpacing, DialogUnits.X, 4);
    SetRect(TextRect, 0, 0, Screen.Width div 2, 0);
    DrawText(Canvas.Handle, PChar(Msg), Length(Msg)+1, TextRect,
      DT_EXPANDTABS or DT_CALCRECT or DT_WORDBREAK or
      DrawTextBiDiModeFlagsReadingOnly);
    IconID := IconIDs[DlgType];
    IconTextWidth := TextRect.Right;
    IconTextHeight := TextRect.Bottom;
    if IconID <> nil then
    begin
      Inc(IconTextWidth, 32 + HorzSpacing);
      if IconTextHeight < 32 then IconTextHeight := 32;
    end;
    ButtonCount := 0;
    for B := Low(TMsgDlgBtn) to High(TMsgDlgBtn) do
      if B in Buttons then Inc(ButtonCount);
    ButtonGroupWidth := 0;
    if ButtonCount <> 0 then
      ButtonGroupWidth := ButtonWidth * ButtonCount +
        ButtonSpacing * (ButtonCount - 1);
    ClientWidth := Max(IconTextWidth, ButtonGroupWidth) + HorzMargin * 2;
    ClientHeight := IconTextHeight + ButtonHeight + VertSpacing +
      VertMargin * 2;
    Left := (Screen.Width div 2) - (Width div 2);
    Top := (Screen.Height div 2) - (Height div 2);
    if DlgType <> mtCustom then
      Caption := Captions[DlgType] else
      Caption := Application.Title;
    if IconID <> nil then
      with TImage.Create(Result) do
      begin
        Name := 'Image';
        Parent := Result;
        Picture.Icon.Handle := LoadIcon(0, IconID);
        SetBounds(HorzMargin, VertMargin, 32, 32);
      end;
    TMessageForm(Result).Message := TLabel.Create(Result);
    with TMessageForm(Result).Message do
    begin
      Name := 'Message';
      Parent := Result;
      WordWrap := True;
      Caption := Msg;
      BoundsRect := TextRect;
      BiDiMode := Result.BiDiMode;
      ALeft := IconTextWidth - TextRect.Right + HorzMargin;
      if UseRightToLeftAlignment then
        ALeft := Result.ClientWidth - ALeft - Width;
      SetBounds(ALeft, VertMargin,
        TextRect.Right, TextRect.Bottom);
    end;
    DefaultButton:=SelButton;
{    if mbOk in Buttons then DefaultButton := mbOk else
      if mbYes in Buttons then DefaultButton := mbYes else
        DefaultButton := mbRetry;}
    if mbCancel in Buttons then CancelButton := mbCancel else
      if mbNo in Buttons then CancelButton := mbNo else
        CancelButton := mbOk;
    X := (ClientWidth - ButtonGroupWidth) div 2;
    for B := Low(TMsgDlgBtn) to High(TMsgDlgBtn) do
      if B in Buttons then
        with TButton.Create(Result) do
        begin
          Name := ButtonNames[B];
          Parent := Result;
          Caption := ButtonCaptions[B];
          ModalResult := ModalResults[B];
          if B = DefaultButton then begin
            Default := True;
            TabOrder:=0;
          end;
          if B = CancelButton then Cancel := True;
          SetBounds(X, IconTextHeight + VertMargin + VertSpacing,
            ButtonWidth, ButtonHeight);
          Inc(X, ButtonWidth + ButtonSpacing);
          if B = mbHelp then
            OnClick := TMessageForm(Result).HelpButtonClick;
        end;
  end;
end;

function MessageDlgPosHelp(owner:tform; const Msg: string; DlgType: TMsgDlgType;
  Buttons: TMsgDlgButtons; HelpCtx: Longint; X, Y: Integer;
  const HelpFileName: string; SelButton:TMsgDlgBtn): Integer;
begin
  with CreateMessageDialog(owner, Msg, DlgType, Buttons, SelButton) do
    try
      HelpContext := HelpCtx;
      HelpFile := HelpFileName;
      if X >= 0 then Left := X;
      if Y >= 0 then Top := Y;
      if (Y < 0) and (X < 0) then Position := poOwnerFormCenter;//poScreenCenter;
      Result := ShowModal;
    finally
      Free;
    end;
end;

function _messagedlg(owner:tcontrol;text:string;dlgtype:TMsgDlgType;selbutton:TMsgDlgBtn=mbOK):integer;
begin
  while not (owner is tform) do
    owner:=owner.Parent;
  if dlgtype=mtinformation then begin
    Result := MessageDlgPosHelp(owner as tform, text, mtinformation, [mbok], 0, -1, -1, '', selbutton);
  end else if dlgtype=mtConfirmation then begin
    Result := MessageDlgPosHelp(owner as tform, text, mtConfirmation, [mbYes, mbNo], 0, -1, -1, '', selbutton);
  end else if dlgtype=mtError then begin
    Result := MessageDlgPosHelp(owner as tform, text, mtError, [mbok], 0, -1, -1, '', selbutton);
  end else if dlgtype=mtWarning then begin
    Result := MessageDlgPosHelp(owner as tform, text, mtWarning, [mbok], 0, -1, -1, '', selbutton);
  end else if dlgtype=mtCustom then begin
    Result := MessageDlgPosHelp(owner as tform, text, mtConfirmation, [mbYes, mbNo, mbCancel], 0, -1, -1, '', selbutton);
  end;
end;

function InputQuery2(owner:tform; const ACaption, APrompt: string;
  var Value: string): Boolean;
var
  Form: TForm;
  Prompt: TLabel;
  Edit: TEdit;
  DialogUnits: TPoint;
  ButtonTop, ButtonWidth, ButtonHeight: Integer;
begin
  Result := False;
  Form := TForm.Create(owner);
  with Form do
    try
      Font:=Application.MainForm.Font;
      Canvas.Font := Font;
      DialogUnits := GetAveCharSize(Canvas);
      BorderStyle := bsDialog;
      Caption := ACaption;
      ClientWidth := MulDiv(180, DialogUnits.X, 4);
      Position := poOwnerFormCenter;
      Prompt := TLabel.Create(Form);
      with Prompt do
      begin
        Parent := Form;
        Caption := APrompt;
        Left := MulDiv(8, DialogUnits.X, 4);
        Top := MulDiv(8, DialogUnits.Y, 8);
        Constraints.MaxWidth := MulDiv(164, DialogUnits.X, 4);
        WordWrap := True;
      end;
      Edit := TEdit.Create(Form);
      with Edit do
      begin
        Parent := Form;
        Left := Prompt.Left;
        Top := Prompt.Top + Prompt.Height + 5;
        Width := MulDiv(164, DialogUnits.X, 4);
        MaxLength := 255;
        Text := Value;
        SelectAll;
      end;
      ButtonTop := Edit.Top + Edit.Height + 15;
      ButtonWidth := MulDiv(50, DialogUnits.X, 4);
      ButtonHeight := MulDiv(14, DialogUnits.Y, 8);
      with TButton.Create(Form) do
      begin
        Parent := Form;
        Caption := 'OK';
        ModalResult := mrOk;
        Default := True;
        SetBounds(MulDiv(38, DialogUnits.X, 4), ButtonTop, ButtonWidth,
          ButtonHeight);
      end;
      with TButton.Create(Form) do
      begin
        Parent := Form;
        Caption := 'Cancel';
        ModalResult := mrCancel;
        Cancel := True;
        SetBounds(MulDiv(92, DialogUnits.X, 4), Edit.Top + Edit.Height + 15,
          ButtonWidth, ButtonHeight);
        Form.ClientHeight := Top + Height + 13;          
      end;
      if ShowModal = mrOk then
      begin
        Value := Edit.Text;
        Result := True;
      end;
    finally
      Form.Free;
    end;
end;

procedure formtocenter2(targetform:tform;ownerform:tform=nil);
var
  x,y:integer;
begin
  if ownerform=nil then
    ownerform:=targetform.owner as tform;
  x:=ownerform.Left+(ownerform.Width div 2)-(targetform.Width div 2);
  if x<0 then x:=0;
  if (x+targetform.Width)>screen.Width then x:=screen.Width-targetform.Width;
  y:=ownerform.Top+(ownerform.Height div 2)-(targetform.Height div 2);
  if y<0 then y:=0;
  if (y+targetform.Height)>screen.Height then y:=screen.Height-targetform.Height;

  targetform.Left:=x;
  targetform.Top:=y;
end;

function speialcharhtml(s:string):string;
const
  special: array[0..10,0..1] of string =
   (('&','&amp;'), ('<','&lt;'), ('>','&gt;'), ('"','&quot;'), (#39,'&#39;'),
    ('%','&#37;'),
    ('(','&#40;'), (')','&#41;'), ('+','&#43;'), ('-','&#45;'),
    ('''','&#039;')
   );
var
  i:integer;
begin
  for i:=0 to high(special) do begin
    s:=sysutils.StringReplace(s,special[i][1],special[i][0],[rfIgnoreCase,rfReplaceAll]);
  end;
  result:=s;
end;

procedure rebootrename(src,target:string);
begin
  if (GetOperatingSystem>=0) and (GetOperatingSystem<4) then begin
    WritePrivateProfileString('Rename',nil,pchar(target),pchar(GetWindowsDir+'WININIT.INI'));
    WritePrivateProfileString('Rename',pchar(target),pchar(src),pchar(GetWindowsDir+'WININIT.INI'));
  end else begin
//    MoveFileEx(pchar(target), nil, MOVEFILE_DELAY_UNTIL_REBOOT);
    MoveFileEx(pchar(src), pchar(target),
      MOVEFILE_DELAY_UNTIL_REBOOT or MOVEFILE_REPLACE_EXISTING);
  end;
end;

end.
