{
   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit Ufrmfav;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, ComCtrls, StdCtrls, Buttons, ExtCtrls;

type
  Tfrmfav = class(TForm)
    ListView1: TListView;
    PopupMenu1: TPopupMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    N5: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure N1Click(Sender: TObject);
    procedure N4Click(Sender: TObject);
    procedure ListView1Deletion(Sender: TObject; Item: TListItem);
    procedure N2Click(Sender: TObject);
    procedure N3Click(Sender: TObject);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure N5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmfav: Tfrmfav;

implementation
uses Umainhelper, Ufrmmain, Ufrmfavadd;

{$R *.dfm}

procedure Tfrmfav.FormCreate(Sender: TObject);
var
  listitem:tlistitem;
  i:integer;
  data,data2:Pfavoritedata;
begin
  ListView1.Align:=alclient;

  ListView1.Items.BeginUpdate;
  try
    for i:=0 to favorite.list.Count-1 do begin
      data:=Pfavoritedata(favorite.list.Items[i]);
      listitem:=self.ListView1.Items.Add;
      listitem.Caption:=data.title;
      listitem.SubItems.Add(data.path);
      new(data2);
      data2^:=data^;
      listitem.Data:=data2;
      listitem.ImageIndex:=12;
    end;
  finally
    ListView1.Items.EndUpdate;
  end;
end;

procedure Tfrmfav.N1Click(Sender: TObject);
begin
  if MessageDlg(' Ͻðڽϱ?', mtConfirmation, [mbYes, mbNo], 0) = mrYes then
    listview1.DeleteSelected;
end;

procedure Tfrmfav.N4Click(Sender: TObject);
begin
  listview1.SelectAll;
end;

procedure Tfrmfav.ListView1Deletion(Sender: TObject; Item: TListItem);
begin
  dispose(Pfavoritedata(item.Data));
end;

function MoveListViewItem(listView: TListView; ItemFrom, ItemTo: Word): Boolean;
var
  Source, Target: TListItem;
  data,data2:Pfavoritedata;
begin
  Result := False;
  listview.Items.BeginUpdate;
  try
    Source := listview.Items[ItemFrom];
    data:=Pfavoritedata(Source.Data);
    new(data2);
    data2^:=data^;
    Target := listview.Items.Insert(ItemTo);
    Target.Assign(Source);
    Target.Data:=data2;
    Target.Selected:=true;
    Target.Focused:=true;
    Target.MakeVisible(false);
    Source.Free;
    Result := True;
  finally
    listview.Items.EndUpdate;
  end;
end;

procedure Tfrmfav.N2Click(Sender: TObject);
var
  i:integer;
begin
  if ListView1.Selected=nil then exit;
  i:=ListView1.Selected.Index-1;
  if i<0 then exit;
  MoveListViewItem(ListView1,ListView1.Selected.Index,i);
end;

procedure Tfrmfav.N3Click(Sender: TObject);
var
  i:integer;
begin
  if ListView1.Selected=nil then exit;
  i:=ListView1.Selected.Index+2;
  if i>ListView1.Items.Count then exit;
  MoveListViewItem(ListView1,ListView1.Selected.Index,i);
end;

procedure Tfrmfav.PopupMenu1Popup(Sender: TObject);
var
  c:integer;
begin
  c:=ListView1.SelCount;
  n1.Enabled:=c>0;
  n2.Enabled:=c=1;
  n3.Enabled:=c=1;
  N5.Enabled:=c=1;
end;

procedure Tfrmfav.BitBtn2Click(Sender: TObject);
var
  i:integer;
  data,data2:Pfavoritedata;
begin
  favorite.clearlist;
  for i:=0 to ListView1.Items.Count-1 do begin
    data:=Pfavoritedata(ListView1.Items[i].Data);
    new(data2);
    data2^:=data^;
    favorite.list.Add(data2);
  end;
  favorite.save;
end;

procedure Tfrmfav.N5Click(Sender: TObject);
var
  data:Pfavoritedata;
begin
  if ListView1.Selected=nil then exit;
  data:=Pfavoritedata(self.ListView1.Selected.Data);
  frmfavadd:=Tfrmfavadd.Create(self);
  try
    frmfavadd.Caption:='ã ';
    frmfavadd.Edit1.Text:=data.title;
    frmfavadd.Edit2.Text:=data.path;
    if frmfavadd.ShowModal=mrok then begin
      data.title:=frmfavadd.Edit1.Text;
      data.path:=frmfavadd.Edit2.Text;
      ListView1.Selected.Caption:=data.title;
      ListView1.Selected.SubItems.Strings[0]:=data.path;
    end;
  finally
    frmfavadd.Free;
  end;
end;

end.
