<?php

/**
 * 검색관련기능 API 클래스
 * 검색관련기능 API를 사용하기 위한 기본 클래스로써 단일 클래스로도 사용이 가능합니다.
 *
 * @category	OpenAPI
 * @package		SearchExtra
 * @author		Open Technology Team
 * @copyright	Copyright (c) 2008 NHN Corporation. (http://www.nhncorp.com)
 * @license		new BSD License
 *
 * $Id:$
 */

class SearchAPI_Extra
{
	/**
	 * HTTP 요청을 보낼 URL
	 *
	 * @var string
	 */
	var $url;

	/**
	 * HTTP 요청을 보낼 때 들어가게 되는 인자의 배열
	 *
	 * @var array
	 */
	var $params;
	
	/**
	 * 생성자
	 * HTTP 요청시 사용되는 인자값 기본 설정 및 옵션값 기본 설정
	 *
	 * @return void
	 */
	function SearchAPI_Extra()
	{
		global $__API__;

		$this->url = $__API__['url'];
		$this->params = array( 'key' => $__API__['apikey'],
								'target' => null,
								'query' => null );
	}

	/**
	 * 검색 키워드 설정 및 검색 URL 생성
	 *
	 * @param	string $query
	 * @return	string
	 */
	function search($query)
	{
		$this->setQuery($query);
		$url = $this->getUrl();

		return $url;
	}

	/**
	 * 검색 URL을 반환
	 *
	 * @return	string
	 */
	function getUrl() 
	{
		$rvalue = http_build_query($this->params, '', '&');
		return $this->url . '?' . $rvalue;
	}

	/**
	 * 검색 키워드를 설정
	 *
	 * @param	string $query
	 * @return	void
	 */
	function setQuery($query)
	{
		$this->params['query'] = $query;
	}

	/**
	 * 검색 키워드를 반환
	 *
	 * @return	string
	 */
	function getQuery()
	{
		return $this->params['query'];
	}

}

?>
