<?php

/**
 * 검색결과 API 클래스
 * 검색결과 API를 사용하기 위한 기본 클래스로써 단일 클래스로도 사용이 가능합니다.
 *
 * @category	OpenAPI
 * @package		Search
 * @author 		Open Technology T/F
 * @copyright	Copyright (c) 2008 NHN Corporation. (http://www.nhncorp.com)
 * @version		0.1
 * @license		new BSD License
 */

class SearchAPI
{
	/**
	 * HTTP 요청을 보낼 URL
	 *
	 * @var string
	 */
	var $url;

	/**
	 * HTTP 요청을 보낼 때 들어가게 되는 인자의 배열
	 *
	 * @var array
	 */
	var $params;
	
	/**
	 * 생성자
	 * HTTP 요청시 사용되는 인자값 기본 설정 및 옵션값 기본 설정
	 *
	 * @return void
	 */
	function SearchAPI()
	{
		global $__API__;

		$this->url = 'http://openapi.naver.com/search';
		$this->params = array( 'key' => $__API__['apikey'],
								'target' => null,
								'query' => null,
								'display' => $__API__['display'],
								'start' => $__API__['start'] );
		if (isset($this->sortable) && is_array($this->sortable))
			$this->params['sort'] = $this->sortable[0];
		if (isset($this->filter) && is_array($this->filter))
			$this->params['filter'] = $this->filter[0];
		if (isset($this->payment) && is_array($this->payment))
			$this->params['payment'] = $this->payment[0];
	}

	/**
	 * 검색 키워드 설정 및 검색 URL 생성
	 *
	 * @param	string $query
	 * @return	string
	 */
	function search($query)
	{
		$this->setQuery($query);
		$url = $this->getUrl();

		return $url;
	}

	/**
	 * 검색 URL을 반환
	 *
	 * @return	string
	 */
	function getUrl() 
	{
		$rvalue = http_build_query($this->params);
		return $this->url . '?' . $rvalue;
	}

	/**
	 * 검색결과 출력건수를 설정
	 *
	 * @param	int $display
	 * @return	void
	 */
	function setDisplay($display)
	{
		if (is_int($display))
			$this->params['display'] = $display;
	}

	/**
	 * 현재 설정된 검색결과 출력건수를 반환
	 *
	 * @return	int
	 */
	function getDisplay()
	{
		return $this->params['display'];
	}

	/**
	 * 검색의 시작위치를 설정
	 *
	 * @param	int $start
	 * @return	void
	 */
	function setStart($start)
	{
		if (is_int($start))
			$this->params['start'] = $start;
	}

	/**
	 * 현재 설정된 검색의 시작위치를 반환
	 *
	 * @return	int
	 */
	function getStart()
	{
		return $this->params['start'];
	}

	/**
	 * 검색 키워드를 설정
	 *
	 * @param	string $query
	 * @return	void
	 */
	function setQuery($query)
	{
		$this->params['query'] = $query;
	}

	/**
	 * 하나 이상의 인자를 설정
	 *
	 * @param	array $params
	 * @return	void
	 */
	function setParams($params = null)
	{
		if (is_array($params))
		{
			$class_method = get_class_methods($this);
			foreach($params as $k => $v)
			{
				$method = 'set' . ucfirst($k);
				if ($v != 'params' && in_array($method, $class_method))
				{
					$this->$method($v);
				}
			}
		}
	}
}

?>
