unit main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ExtCtrls, XPStyleActnCtrls, ActnList, IdFTP,
  ActnMan, Menus, ToolWin, ActnCtrls, StdCtrls, Buttons, Mask, IdIntercept,
  IdLogBase, IdLogEvent, IdAntiFreezeBase, IdAntiFreeze, IdBaseComponent,
  IdComponent, IdTCPConnection, IdTCPClient, IdFTPList, ShlObj,
  CommCtrl, ShellAPI, IdFTPCommon, ShellCtrls, QFileCtrls ;

type
  TMainForm = class(TForm)
    StatusBar1: TStatusBar;
    Panel_Client_Base: TPanel;
    Panel_Main_ToolBar: TPanel;
    Splitter_UpDown: TSplitter;
    Panel_Server_Base: TPanel;
    Panel_Client_Tree: TPanel;
    Splitter_Client: TSplitter;
    Panel_Client_List: TPanel;
    Panel_UpDown_ToolBar: TPanel;
    Panel_Server_Tree: TPanel;
    Splitter_Server: TSplitter;
    Panel_Server_List: TPanel;
    ShellTreeView: TShellTreeView;
    ShellListView: TShellListView;
    ListView: TListView;
    TreeView: TTreeView;
    BitBtn_Upload: TBitBtn;
    BitBtn_Download: TBitBtn;
    BitBtn_Exit: TBitBtn;
    StaticText_hostname: TStaticText;
    Edit_hostname: TEdit;
    StaticText_id: TStaticText;
    Edit_id: TEdit;
    StaticText_password: TStaticText;
    Edit_password: TEdit;
    BitBtn_Connect: TBitBtn;
    IdFTP: TIdFTP;
    IdAntiFreeze: TIdAntiFreeze;
    IdLogEvent: TIdLogEvent;
    PopupMenu_Server_List: TPopupMenu;
    PMSL_Download: TMenuItem;
    PMSL_View: TMenuItem;
    PopupMenu_Server_Tree: TPopupMenu;
    PMST_Download: TMenuItem;
    PopupMenu_Client_Tree: TPopupMenu;
    PMCT_Upload: TMenuItem;
    PopupMenu_Client_List: TPopupMenu;
    PMCL_Upload: TMenuItem;
    PMCL_View: TMenuItem;
    PMCL_View_Icon: TMenuItem;
    PMCL_View_List: TMenuItem;
    PMCL_View_Detail: TMenuItem;
    PMSL_View_Icon: TMenuItem;
    PMSL_View_List: TMenuItem;
    PMSL_View_Detail: TMenuItem;
    InfoText: TLabel;
    rbBinary: TRadioButton;
    rbASCII: TRadioButton;
    PMSL_Sep1: TMenuItem;
    PMCL_Sep: TMenuItem;
    PMSL_ReName: TMenuItem;
    PMST_Sep1: TMenuItem;
    PMST_ReName: TMenuItem;
    PMSL_MkDir: TMenuItem;
    PMST_MkDir: TMenuItem;
    PMSL_Delete: TMenuItem;
    PMST_RmDir: TMenuItem;
    PMCL_MkDir: TMenuItem;
    PMCL_Delete: TMenuItem;
    PMCL_Rename: TMenuItem;
    PMCT_Sep1: TMenuItem;
    PMCT_MkDir: TMenuItem;
    PMCT_RmDir: TMenuItem;
    PMCT_Rename: TMenuItem;
    PMCL_Sep2: TMenuItem;
    PMCL_Sort: TMenuItem;
    PMCL_Sort_Basic: TMenuItem;
    PMCL_Sort_Name: TMenuItem;
    PMCL_Sort_Size: TMenuItem;
    PMCL_Sort_Modified: TMenuItem;
    PMCL_Sort_Type: TMenuItem;
    PMSL_Sep2: TMenuItem;
    PMSL_Sort: TMenuItem;
    PMSL_Sort_Basic: TMenuItem;
    PMSL_Sort_Name: TMenuItem;
    PMSL_Sort_Size: TMenuItem;
    PMSL_Sort_Type: TMenuItem;
    PMSL_Sort_Modified: TMenuItem;
    PMSL_Sort_Owner: TMenuItem;
    PMSL_Sort_Group: TMenuItem;
    PMSL_Sort_Permission: TMenuItem;
    procedure BitBtn_ExitClick(Sender: TObject);
    procedure BitBtn_ConnectClick(Sender: TObject);
    procedure IdFTPWorkBegin(Sender: TObject; AWorkMode: TWorkMode;
      const AWorkCountMax: Integer);
    procedure IdFTPWorkEnd(Sender: TObject; AWorkMode: TWorkMode);
    procedure FormCreate(Sender: TObject);
    procedure GetSystemImageList;
    procedure BitBtn_DownloadClick(Sender: TObject);
    procedure PMSL_View_IconClick(Sender: TObject);
    procedure PMSL_View_ListClick(Sender: TObject);
    procedure PMSL_View_DetailClick(Sender: TObject);
    procedure PMCL_View_IconClick(Sender: TObject);
    procedure PMCL_View_ListClick(Sender: TObject);
    procedure PMCL_View_DetailClick(Sender: TObject);
    procedure ShellListViewChange(Sender: TObject; Item: TListItem; Change: TItemChange);
    procedure ListViewDblClick(Sender: TObject);
    procedure ListViewColumnClick(Sender: TObject; Column: TListColumn);
    function  GetTreePath(Node: TTreeNode): string;
    procedure TreeViewMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure PMST_DownloadClick(Sender: TObject);
    procedure PMCT_UploadClick(Sender: TObject);
    procedure BitBtn_UploadClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ShellTreeViewEditing(Sender: TObject; Node: TTreeNode;
      var AllowEdit: Boolean);
    procedure ListViewEdited(Sender: TObject; Item: TListItem;
      var S: String);
    procedure PMSL_ReNameClick(Sender: TObject);
    procedure PMST_ReNameClick(Sender: TObject);
    procedure TreeViewEdited(Sender: TObject; Node: TTreeNode;
      var S: String);
    procedure TreeViewEditing(Sender: TObject; Node: TTreeNode;
      var AllowEdit: Boolean);
    procedure PMSL_MkDirClick(Sender: TObject);
    procedure ListViewEditing(Sender: TObject; Item: TListItem;
      var AllowEdit: Boolean);
    procedure PMST_MkDirClick(Sender: TObject);
    procedure PMSL_DeleteClick(Sender: TObject);
    procedure PMST_RmDirClick(Sender: TObject);
    procedure PMCL_MkDirClick(Sender: TObject);
    procedure PMCL_RenameClick(Sender: TObject);
    procedure PMCL_DeleteClick(Sender: TObject);

  private
    { Private declarations }
    TransferrignData: Boolean;
    ServerPath : String;
    ClientPath : String;
    procedure ChangeListDir(DirName: String);
    procedure ChangeTreeDir(DirName: String);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

var
  DirShellInfo :TShFileInfo;
  WinDir :PChar;

{$R *.dfm}

procedure TMainForm.BitBtn_ExitClick(Sender: TObject);
begin
  close;
end;

procedure TMainForm.BitBtn_ConnectClick(Sender: TObject);
begin
  if IdFTP.Connected then try
    if TransferrignData then IdFTP.Abort;
    IdFTP.Quit;
  finally
    ListView.Items.BeginUpdate;
    ListView.Items.Clear;
    ListView.Items.EndUpdate;
    TreeView.Items.Clear;
    BitBtn_Connect.Caption := ' ';
    BitBtn_Connect.Default := true;
  end
  else with IdFTP do try
    Username := Edit_id.Text;
    Password := Edit_password.Text;
    Host := Edit_hostname.Text;
    Connect;
    ServerPath := IdFTP.RetrieveCurrentDir;
    Self.ChangeListDir(ServerPath);
    Self.ChangeTreeDir(ServerPath);

  finally
    BitBtn_Connect.Enabled := true;
    if Connected then begin
      BitBtn_Connect.Caption := ' ';
      BitBtn_Connect.Default := false;
    end;
  end;
end;

procedure TMainForm.IdFTPWorkBegin(Sender: TObject; AWorkMode: TWorkMode;
  const AWorkCountMax: Integer);
begin
  TransferrignData := true;
end;

procedure TMainForm.IdFTPWorkEnd(Sender: TObject; AWorkMode: TWorkMode);
begin
  TransferrignData := false;
end;

procedure TMainForm.GetSystemImageList;
var
  SysImageList :uint;      // temporary handle for System ImageLists
  ShFileInfo :TShFileInfo; // Shell File Info structure
begin
  ListView.LargeImages := TImageList.Create(self);
  SysImageList := ShGetFileInfo('',0,ShFileInfo,SizeOf(ShFileInfo),shgfi_SysIconIndex or shgfi_LargeIcon);
  if SysImageList <> 0 then
  begin
    ListView.LargeImages.Handle := SysImageList;
    ListView.LargeImages.ShareImages := true; // Avoid freeing of System Image List !
  end;
  ListView.SmallImages := TImageList.Create(self);
  SysImageList := ShGetFileInfo('',0,ShFileInfo,SizeOf(ShFileInfo),shgfi_SysIconIndex or shgfi_SmallIcon);
  if SysImageList <> 0 then
  begin
    ListView.SmallImages.Handle := SysImageList;
    ListView.SmallImages.ShareImages := true; // Avoid freeing of System Image List !
  end;
  TreeView.Images := TImageList.Create(self);
  SysImageList := ShGetFileInfo('',0,ShFileInfo,SizeOf(ShFileInfo),shgfi_SysIconIndex or shgfi_SmallIcon);
  if SysImageList <> 0 then
  begin
    TreeView.Images.Handle := SysImageList;
    TreeView.Images.ShareImages := true;
  end;
end;

function SortByColumn1(Item1,Item2:TListItem;ParamSort:Integer):Integer;stdcall;
begin
  // file size
  Result :=ParamSort * lstrcmp(PChar(TListItem(Item1).SubItems[0]),PChar(TListItem(Item2).SubItems[0]));
end;

function SortByColumn2(Item1,Item2:TListItem;ParamSort:Integer):Integer;stdcall;
begin
  // file type
  Result := ParamSort * lstrcmp(PChar(TListItem(Item1).SubItems[1]),PChar(TListItem(Item2).SubItems[1]));
end;

function SortByColumn3(Item1,Item2:TListItem;ParamSort:Integer):Integer;stdcall;
begin
  // file type 2 (DIR or FILE) - Default Sort Type.
  Result := ParamSort * lstrcmp(PChar(TListItem(Item1).SubItems[2]),PChar(TListItem(Item2).SubItems[2]));
end;

function SortByColumn4(Item1,Item2:TListItem;ParamSort:Integer):Integer;stdcall;
begin
   // modified
   Result := ParamSort * lstrcmp(PChar(TListItem(Item1).SubItems[3]),PChar(TListItem(Item2).SubItems[3]));
end;

function SortByColumn5(Item1,Item2:TListItem;ParamSort:Integer):Integer;stdcall;
begin
   // owner
   Result := ParamSort * lstrcmp(PChar(TListItem(Item1).SubItems[4]),PChar(TListItem(Item2).SubItems[4]));
end;

function SortByColumn6(Item1,Item2:TListItem;ParamSort:Integer):Integer;stdcall;
begin
   // group
   Result := ParamSort * lstrcmp(PChar(TListItem(Item1).SubItems[5]),PChar(TListItem(Item2).SubItems[5]));
end;

function SortByColumn7(Item1,Item2:TListItem;ParamSort:Integer):Integer;stdcall;
begin
   // permission
   Result := ParamSort * lstrcmp(PChar(TListItem(Item1).SubItems[6]),PChar(TListItem(Item2).SubItems[6]));
end;

procedure TMainForm.ChangeListDir(DirName: String);
var
  LS : TStringList;
  LI : TListItem;
  i  : Integer;
  ListCount : Integer;
  Permission : String;
  ShFileInfo : TShFileInfo;
  ItemName : String;
begin
  LS := TStringList.Create;
  try
    IdFTP.ChangeDir(DirName);
    IdFTP.TransferType := ftBinary;
    ListView.Items.BeginUpdate;
    ListView.Items.Clear;
    ListView.Items.EndUpdate;

    //  丮 ̵ϱ  ׸ ߰
    if IdFTP.RetrieveCurrentDir <> '/' then
    begin
      LI := ListView.Items.Add;
      LI.Caption := '..';
      LI.SubItems.Add('');
      LI.SubItems.Add(' ');
      LI.SubItems.Add('DIR');
      LI.ImageIndex := DirShellInfo.iIcon;
      LI.SubItems.Add('');
      LI.SubItems.Add('');
    end;

    IdFTP.List(LS);
    if Assigned(IdFTP.DirectoryListing) and (IdFTP.DirectoryListing.Count > 0) then
    begin
      ListCount := IdFTP.DirectoryListing.Count;
      for i := 0 to ListCount - 1 do
      begin
        ItemName := IdFTP.DirectoryListing.Items[i].FileName;
        if ItemName = '.' then continue;
        if ItemName = '..' then continue;
        LI := ListView.Items.Add;
        LI.Caption := ItemName;
        LI.SubItems.Add(IntToStr(IdFTP.DirectoryListing.Items[i].Size));
        if IdFTP.DirectoryListing.Items[i].ItemType = ditDirectory then
        begin
          LI.SubItems.Add(DirShellInfo.szTypeName); //type
          LI.SubItems.Add('DIR');
          LI.ImageIndex := DirShellInfo.iIcon;
        end
        else
        begin
          ShGetFileInfo(PChar(ItemName), 0 ,ShFileInfo,SizeOf(ShFileInfo),
                        SHGFI_TYPENAME or SHGFI_USEFILEATTRIBUTES or SHGFI_SYSICONINDEX);
          LI.SubItems.Add(ShFileInfo.szTypeName); //type
          LI.SubItems.Add('FILE');
          LI.ImageIndex := ShFileInfo.iIcon;
        end;
        LI.SubItems.Add(FormatDateTime('c',IdFTP.DirectoryListing.Items[i].ModifiedDate));
        LI.SubItems.Add(IdFTP.DirectoryListing.Items[i].OwnerName);
        LI.SubItems.Add(IdFTP.DirectoryListing.Items[i].GroupName);
        Permission := IdFTP.DirectoryListing.Items[i].OwnerPermissions
                    + IdFTP.DirectoryListing.Items[i].GroupPermissions
                    + IdFTP.DirectoryListing.Items[i].UserPermissions;
        LI.SubItems.Add(Permission);
      end;
    end;
    ServerPath := IdFTP.RetrieveCurrentDir;
    InfoText.Caption := ServerPath;
    // Default Sorting (type2)
    ListView.CustomSort(@SortByColumn3, 1);
  finally
    LS.Free;
  end;
end;

procedure TMainForm.ChangeTreeDir(DirName: String);
var
  TokenList : TStringList;
  TokenCount : Integer;
  TotalCount : Integer;
  i, j : Integer;
  TN, TNLast : TTreeNode;
  PathExist : Integer;

  TNChild : TTreeNode;
  LS : TStringList;
  ListCount : Integer;
  ItemName : String;
  ChildExist, ChildAdded : Integer;

  CurChildList : TStringList;
  CurChildCount : Integer;
  Child, ChildFirst, ChildLast : String;

begin
  TokenList := TStringList.Create;
  TokenList.Add('/');
  TokenCount := ExtractStrings(['/'], [' '], PChar(DirName), TokenList);
  inc(TokenCount);

  TN := Nil; TNLast := Nil;
  for i:=0 to TokenCount - 1 do     // Level
  begin
    PathExist := 0;
    TotalCount := TreeView.Items.Count;
    for j:=0 to TotalCount - 1 do   // Item Search
    begin
      if(TreeView.Items[j].Text = TokenList[i]) and (TreeView.Items[j].Level = i) then
      begin
        // 丮  
        TreeView.Items[j].Selected;
        PathExist := 1;
        TN := TreeView.Items[j];
      end;
    end;
    if PathExist = 0 then
    begin
      // 丮  Ƿ .
      TN := TreeView.Items.AddChild(TNLast, TokenList[i]);
      TN.ImageIndex := DirShellInfo.iIcon;
      TN.SelectedIndex := DirShellInfo.iIcon;
    end;
    TNLast := TN;
  end;
  TreeView.Select(TN);

  //  õ   Ʈ .
  CurChildList := TStringList.Create;
  if TN.HasChildren then
    begin
    TNChild := TN.getFirstChild;
    ChildFirst := TN.getFirstChild.Text;
    ChildLast := TN.GetLastChild.Text;
    Child := ChildFirst;
    CurChildList.Add(Child);
    while Child <> ChildLast do
    begin
      TNChild := TNChild.getNextSibling;
      Child := TNChild.Text;
      CurChildList.Add(Child);
    end;
    CurChildCount := CurChildList.Count;
    end
  else
    begin
    CurChildList.Clear;
    CurChildCount := 0;
    end;

  // FTP Ʈ ȸؼ   .
  LS := TStringList.Create;
  try
    IdFTP.ChangeDir(DirName);
    IdFTP.List(LS);
    ChildAdded := 0;
    if Assigned(IdFTP.DirectoryListing) and (IdFTP.DirectoryListing.Count > 0) then
    begin
      ListCount := IdFTP.DirectoryListing.Count;
      for i := 0 to ListCount - 1 do
      begin
        ItemName := IdFTP.DirectoryListing.Items[i].FileName;
        if ItemName = '.' then continue;
        if ItemName = '..' then continue;
        if IdFTP.DirectoryListing.Items[i].ItemType = ditDirectory then
        begin
          ChildExist := 0;
          for j:=0 to CurChildCount -1 do
            if CurChildList.Strings[j] = ItemName then ChildExist := 1;
          if ChildExist <> 1 then
          begin
            TNChild := TreeView.Items.AddChild(TN, ItemName);
            TNChild.ImageIndex := DirShellInfo.iIcon;
            TNChild.SelectedIndex := DirShellInfo.iIcon;
            ChildAdded := 1;
          end;
        end
      end;
    end;
    if ChildAdded = 1 then TreeView.Selected.Expand(true);
  finally
    LS.Free;
  end;

end;


procedure TMainForm.FormCreate(Sender: TObject);
begin
  // ȯ漳
  GetSystemImageList;    // get system icon list
  ShellTreeView.Path := 'C:\';
end;

procedure TMainForm.BitBtn_DownloadClick(Sender: TObject);
var
  Source : String;
  SourceCount : Integer;
  SourceType : String;
  Target : String;
  TargetFolder : String;
begin
  try
    SourceCount := ListView.SelCount;
    if SourceCount = 0 then
    begin
      ShowMessage('ٿε  õ ʾҽϴ.');
      exit;
    end;
    if SourceCount > 1 then
    begin
      ShowMessage(' ϳ ϸ ٿε尡 մϴ.' + #13 + '   Դϴ.');
      exit;
    end;
    Source := ListView.Selected.Caption;
    SourceType := ListView.Selected.SubItems.Strings[2];   // Ÿ2
    if SourceType = 'DIR' then
    begin
      ShowMessage('  ٿε  ϴ.' + #13 + '   Դϴ.');
      exit;
    end;

    // ٿε带 Ѵ.
    TargetFolder := ShellTreeView.SelectedFolder.PathName;
    //ShowMessage(TargetFolder);
    if AnsiPos(':', TargetFolder) <> 2 then
    begin
      ShowMessage('Ʒ ǻ 丮 ٿε   丮 ϼ.');
      exit;
    end;
    Target := TargetFolder + '\' + Source;

    if rbBinary.Checked then IdFTP.TransferType := ftBinary
    else IdFTP.TransferType := ftASCII;
    IdFTP.Get(Source, Target, true);
    //ShowMessage(Source + '  ' + Target + '  ٿε Ǿϴ.');
  finally
    //ShowMessage(Source);
  end;
end;

procedure TMainForm.PMSL_View_IconClick(Sender: TObject);
begin
  ListView.ViewStyle := vsIcon;
end;

procedure TMainForm.PMSL_View_ListClick(Sender: TObject);
begin
  ListView.ViewStyle := vsList;
end;

procedure TMainForm.PMSL_View_DetailClick(Sender: TObject);
begin
  ListView.ViewStyle := vsReport;
end;

procedure TMainForm.PMCL_View_IconClick(Sender: TObject);
begin
  ShellListView.ViewStyle := vsIcon;
end;

procedure TMainForm.PMCL_View_ListClick(Sender: TObject);
begin
  ShellListView.ViewStyle := vsList;
end;

procedure TMainForm.PMCL_View_DetailClick(Sender: TObject);
begin
  ShellListView.ViewStyle := vsReport;
end;

procedure TMainForm.ShellListViewChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
var
  Path : String;
begin
  //Path := ShellListView.Selected.Caption;
  //ShowMessage(Path);
end;

procedure TMainForm.ListViewDblClick(Sender: TObject);
var
  Click : String;
  ClickType : String;
begin
  if ListView.SelCount = 0 then exit;
  Click := ListView.Selected.Caption;
  ClickType := ListView.Selected.SubItems.Strings[2];   // type 2
  if ClickType = 'DIR' then
  begin
    ChangeListDir(Click);
    ChangeTreeDir(ServerPath);
  end
  else
    BitBtn_DownLoadClick(Sender);
end;

procedure TMainForm.ListViewColumnClick(Sender: TObject; Column: TListColumn);
begin
  if Column = ListView.Columns[0] then ListView.AlphaSort   // file name
  else if Column = ListView.Columns[1] then ListView.CustomSort(@SortByColumn1, 1)  // file size
  else if Column = ListView.Columns[2] then ListView.CustomSort(@SortByColumn2, 1)  // file type
  else if Column = ListView.Columns[3] then ListView.CustomSort(@SortByColumn3, 1)  // file type 2
  else if Column = ListView.Columns[4] then ListView.CustomSort(@SortByColumn4, 1)  // modified
  else if Column = ListView.Columns[5] then ListView.CustomSort(@SortByColumn5, 1)  // owner
  else if Column = ListView.Columns[6] then ListView.CustomSort(@SortByColumn6, 1)  // group
  else if Column = ListView.Columns[7] then ListView.CustomSort(@SortByColumn7, 1)  // permission
end;


function TMainForm.GetTreePath(Node: TTreeNode): string;
var
  Path : String;
begin
  Path := '';
  if Node <> nil then
  begin
    Path := Node.Text;
    while Node.Parent <> nil do
    begin
      Node := Node.Parent;
      if Node.Text = '/' then Path := '/' + Path
      else Path := Node.Text + '/' + Path;
    end;
  end;
  Result := Path;
end;

procedure TMainForm.TreeViewMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  TN : TTreeNode;
  TreePath : String;
begin
  //  콺ε  ϵ Ѵ.
  if button =  mbRight then
  begin
    TN := TreeView.GetNodeAt(X, Y);
    TN.Focused := true;
    TN.Selected := true;
  end;
  //õ  Path  Ͽ  ȸѴ.
  TreePath := GetTreePath(TreeView.Selected);
  if TreePath <> ServerPath then
  begin
    ChangeListDir(TreePath);
    ChangeTreeDir(TreePath);
  end;
  InfoText.Caption := TreePath;
end;


procedure TMainForm.PMST_DownloadClick(Sender: TObject);
begin
  ShowMessage(' ٿε   ʽϴ.' + #13 + '   Դϴ.');
end;

procedure TMainForm.PMCT_UploadClick(Sender: TObject);
begin
  ShowMessage(' ε   ʽϴ.' + #13 + '   Դϴ.');
end;

procedure TMainForm.BitBtn_UploadClick(Sender: TObject);
var
  Source : String;
  SourceFolder : String;
  SourceFullName : String;
  SourceCount : Integer;
  SourceType : String;
  Target : String;
  TargetFolder : String;
  TargetFullName : String;
begin
  try
    SourceCount := ShellListView.SelCount;
    if SourceCount = 0 then
    begin
      ShowMessage('ε  õ ʾҽϴ.');
      exit;
    end;
    if SourceCount > 1 then
    begin
      ShowMessage(' ϳ ϸ ε尡 մϴ.' + #13 + '   Դϴ.');
      exit;
    end;
    Source := ShellListView.SelectedFolder.DisplayName;
    SourceFolder := ShellTreeView.Path;
    if AnsiPos(':', SourceFolder) <> 2 then
    begin
      ShowMessage('ε  ġ ùٸ ʽϴ.' + #13 + ' ε  ϴ.');
      exit;
    end;
    SourceFullName := SourceFolder + '\' + Source;

    SourceType := ShellListView.Selected.SubItems.Strings[1];   // Ÿ2
    if SourceType = ' ' then
    begin
      ShowMessage('  ε  ϴ.' + #13 + '   Դϴ.');
      exit;
    end;

    // ε带 Ѵ.
    Target := Source;
    TargetFolder := GetTreePath(TreeView.Selected);
    if TargetFolder = '/' then TargetFullName := '/' + Target
    else TargetFullName := TargetFolder + '/' + Target;

    if rbBinary.Checked then IdFTP.TransferType := ftBinary
    else IdFTP.TransferType := ftASCII;
    IdFTP.Put(SourceFullName, TargetFullName, false);
    //ShowMessage(Source + '  ' + Target + '  ε Ǿϴ.');
  finally
    // Refresh
    ChangeListDir(TargetFolder);
  end;
end;

procedure TMainForm.Button1Click(Sender: TObject);
var
  ShellFile : String;
begin
  ShellFile := ShellListView.Selected.Caption;
  ShowMessage(ShellFile);
end;

procedure TMainForm.ShellTreeViewEditing(Sender: TObject; Node: TTreeNode;
  var AllowEdit: Boolean);
begin
  exit;
end;

procedure TMainForm.ListViewEdited(Sender: TObject; Item: TListItem; var S: String);
var
  ListCount, i : Integer;
  FileType : String;
  OldName, NewName : String;
  TN, TNChild : TTreeNode;
  Child, ChildLast : String;
  ChildFind : integer;
begin
  //  ̸ ̹   źѴ.
  ListCount := ListView.Items.Count;
  for i := 0 to ListCount - 1 do
  begin
    if S = ListView.Items.Item[i].Caption then
    begin
      ShowMessage(' ̸  ̹ մϴ.' + #13 + 'ٸ ̸ Էϼ.');
      abort
    end
  end;
  // (丮) Ѵ.
  OldName := ListView.Selected.Caption;
  NewName := S;
  IdFTP.Rename(OldName, NewName);
  // 丮 , Ʈ 뵵 ٲپ ش.
  FileType := ListView.Selected.SubItems.Strings[2];
  if FileType = 'DIR' then
  begin
    TN := TreeView.Selected;
    if TN.HasChildren then
    begin
      TNChild := TN.getFirstChild;
      Child := TNChild.Text;
      while Child <> OldName do
      begin
        TNChild := TNChild.getNextSibling;
        Child := TNChild.Text;
      end;
      TNChild.Text := NewName    // ̸ٲٱ (ϴ )
    end;
  end;
end;

procedure TMainForm.PMSL_ReNameClick(Sender: TObject);
begin
  ListView.Selected.EditCaption;
end;

procedure TMainForm.PMST_ReNameClick(Sender: TObject);
begin
  TreeView.Selected.EditText;
end;

procedure TMainForm.TreeViewEdited(Sender: TObject; Node: TTreeNode; var S: String);
var
  OldName, NewName : String;
  ParentPath : String;
  TN : TTreeNode;
begin
  if TreeView.Selected.Text <> '/' then
  begin
    TN := TreeView.Selected.Parent;
    ParentPath := GetTreePath(TN);
    OldName := ParentPath + '/' + TreeView.Selected.Text;
    NewName := ParentPath + '/' + S;
    IdFTP.Rename(OldName, NewName);
  end;
end;

procedure TMainForm.TreeViewEditing(Sender: TObject; Node: TTreeNode;
  var AllowEdit: Boolean);
begin
  if TreeView.Selected.Text = '/' then AllowEdit := false;
end;

procedure TMainForm.PMSL_MkDirClick(Sender: TObject);
var
  LI : TListItem;
  FileCount : Integer;
  FolderName : String;
  i, j, AlreadyExist : Integer;
  TN, TNChild : TTreeNode;
begin
  FolderName := ' ';
  FileCount := ListView.Items.Count;
  j := 0;
  //  ϸ    ȣ δ.
  repeat
    AlreadyExist := 0;
    for i :=0 to FileCount - 1 do
      if ListView.Items.Item[i].Caption = FolderName then
      begin
        inc(j);
        FolderName := '  (' + IntToStr(j) + ')';
        AlreadyExist := 1;
      end;
  until AlreadyExist = 0;

  //   ϰ Ѵ.
  IdFTP.MakeDir(FolderName);
  ChangeListDir('.');

  // Ʈ信    ߰Ѵ.
  TN := TreeView.Selected;
  TNChild := TreeView.Items.AddChild(TN, FolderName);    // θ
  TNChild.ImageIndex := DirShellInfo.iIcon;
  TNChild.SelectedIndex := DirShellInfo.iIcon;

  // Ʈ () ̸ ٲܼ ֵ Ѵ.
  FileCount := ListView.Items.Count;
  for i := 0 to FileCount - 1 do
  begin
    if ListView.Items.Item[i].Caption = FolderName then break;
  end;
  ShowMessage(IntToStr(i));
  ListView.Items.Item[i].MakeVisible(false);
  ListView.Items.Item[i].EditCaption;
end;

procedure TMainForm.ListViewEditing(Sender: TObject; Item: TListItem;
  var AllowEdit: Boolean);
begin
  //ShowMessage('Editing');
end;

procedure TMainForm.PMST_MkDirClick(Sender: TObject);
begin
  ShowMessage('  ʽϴ.');
end;

procedure TMainForm.PMSL_DeleteClick(Sender: TObject);
var
  DeleteCount : Integer;
  DeleteName, DeleteType : String;
  TN, TNChild : TTreeNode;
  Child : String;
  LS : TStringList;
begin
  //    ȮѴ.
  DeleteCount := ListView.SelCount;
  if DeleteCount = 0 then exit;
  if DeleteCount > 1 then
  begin
    ShowMessage('ϳ ϸ  մϴ.' + #13 + '    Դϴ.');
    exit;
  end;
  //   Ѵ.
  DeleteName := ListView.Selected.Caption;
  DeleteType := ListView.Selected.SubItems.Strings[2];    // type 2
  if DeleteType = 'FILE' then IdFTP.Delete(DeleteName)
  else
  begin
    LS := TStringList.Create;
    IdFTP.ChangeDir(DeleteName);
    IdFTP.List(LS);
    DeleteCount := LS.Count;
    IdFTP.ChangeDirUp;
    if DeleteCount = 0 then IdFTP.RemoveDir(DeleteName)
    else
    begin
      ShowMessage('  Ƿ    ϴ.' + #13 + '   Ͻ  ϼ');
      exit;
    end;
  end;

  // Ʈ󿡼   Ѵ.
  ListView.Selected.Delete;

  // 丮 , Ʈ䵵 Ѵ.
  if DeleteType = 'DIR' then
  begin
    TN := TreeView.Selected;
    if TN.HasChildren then
    begin
      TNChild := TN.getFirstChild;
      Child := TNChild.Text;
      while Child <> DeleteName do
      begin
        TNChild := TNChild.getNextSibling;
        Child := TNChild.Text;
      end;
      TNChild.Delete;
    end;
  end;
end;

procedure TMainForm.PMST_RmDirClick(Sender: TObject);
begin
  ShowMessage('  ʽϴ.');
end;

procedure TMainForm.PMCL_MkDirClick(Sender: TObject);
var
  FolderPath : String;
  FolderName : String;
  FullName : String;
  FileCount : Integer;
  i, j : Integer;
  AlreadyExist : Integer;
  LI : TListItem;
begin
  FolderPath := ShellTreeView.Path;
  FolderName := ' ';
  FileCount := ShellListView.Items.Count;
  j := 0;
  //  ϸ    ȣ δ.
  repeat
    AlreadyExist := 0;
    for i :=0 to FileCount - 1 do
      if ShellListView.Folders[i].DisplayName = FolderName then
      begin
        inc(j);
        FolderName := '  (' + IntToStr(j) + ')';
        AlreadyExist := 1;
      end;
  until AlreadyExist = 0;

  // ýۻ  .
  if AnsiPos(':', FolderPath) <> 2 then exit;
  if (strlen(PAnsiChar(FolderPath)) = 3) and (AnsiLastChar(FolderPath) = '\') then
    FullName := FolderPath + FolderName
  else FullName := FolderPath + '\' + FolderName;
  CreateDirectory(PChar(FullName), Nil);
  ShellListView.Refresh;

  // θ  ̸ ٲܼ ְ Ѵ.
  FileCount := ShellListView.Items.Count;
  for i := 0 to FileCount - 1 do
  begin
    if ShellListView.Folders[i].DisplayName = FolderName then break;
  end;
  ShellListView.Items.Item[i].MakeVisible(true);
  ShellListView.Items.Item[i].EditCaption;
end;

procedure TMainForm.PMCL_RenameClick(Sender: TObject);
begin
  ShellListView.Selected.EditCaption;
end;

procedure TMainForm.PMCL_DeleteClick(Sender: TObject);
begin
  //ShellListView
end;

initialization
  GetWindowsDirectory(@WinDir,SizeOf(WinDir));
  ShGetFileInfo(@WinDir,0,DirShellInfo,SizeOf(DirShellInfo),
                shgfi_SysIconIndex or shgfi_TypeName or shgfi_SmallIcon);

end.
