/*
 * Decompiled with CFR 0.152.
 */
package info.jinwoomin.downloader;

import info.jinwoomin.downloader.AbstractDownloader;
import info.jinwoomin.downloader.DownFile;
import info.jinwoomin.downloader.IDownloader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class SingleDownloader
extends AbstractDownloader
implements IDownloader {
    private void downloadFile(URL url, File file) throws IOException {
        int readBytes;
        String header;
        byte[] buffer = new byte[1024];
        URLConnection conn = url.openConnection();
        int i = 0;
        int retryCount = 0;
        int retryMaxCount = System.getProperty("downloader.retry") != null ? new Integer(System.getProperty("downloader.retry")) : 10;
        this.logger.info("connecting...[" + url + "]");
        conn.setRequestProperty("Host", url.getHost());
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; ko-KR; rv:1.7.8) Gecko/20050511 Firefox/1.0.4");
        conn.setRequestProperty("Accept", "text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5");
        conn.setRequestProperty("Accept-Language", "ko-kr,ko;q=0.8,en-us;q=0.5,en;q=0.3");
        conn.setRequestProperty("Accept-Encoding", "gzip,deflate");
        conn.setRequestProperty("accept-charset", "EUC-KR,utf-8;q=0.7,*;q=0.7");
        conn.setRequestProperty("Keep-Alive", "300");
        conn.setRequestProperty("Connection", "keep-alive");
        conn.setRequestProperty("Referer", url.toString());
        try {
            conn.connect();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return;
        }
        retryCount = 0;
        while ((header = conn.getHeaderField(0)).indexOf("OK") <= -1) {
            if (++retryCount > retryMaxCount) {
                this.logger.error("maximum retried.");
                break;
            }
            this.logger.error("header=" + conn.getHeaderField(0));
            this.logger.info("retry..." + retryCount);
            this.logger.info("disconnecting...[" + url + "]");
            InputStream is = conn.getInputStream();
            is.close();
            this.logger.info("reconnecting...[" + url + "]");
            conn = url.openConnection();
        }
        InputStream is = conn.getInputStream();
        BufferedInputStream bis = new BufferedInputStream(is);
        FileOutputStream fos = new FileOutputStream(file);
        this.logger.info("downloading...[" + file.getName() + "]");
        while ((readBytes = bis.read(buffer, 0, buffer.length)) != -1) {
            fos.write(buffer, 0, readBytes);
            if (i % 10 == 0) {
                System.out.print(".");
            }
            if (++i < 780) continue;
            System.out.println("");
            i = 0;
        }
        System.out.println("");
        fos.close();
        bis.close();
        this.logger.info("downloaded.[" + file.getName() + "]");
    }

    public void download() throws IOException {
        for (int i = 0; i < this.list.size(); ++i) {
            DownFile file = (DownFile)this.list.get(i);
            try {
                this.downloadFile(file.getUrl(), file.getFile());
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

