/**
 * Licensed to LGPL v3.
 */
package com.endofhope.neurasthenia.bootstrap;

import java.lang.management.ManagementFactory;

import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

import com.endofhope.neurasthenia.Server;
import com.endofhope.neurasthenia.ServerImpl;
import com.endofhope.neurasthenia.connection.LogicalConnectionManager;

/**
 * 
 * @author endofhope
 *
 */
public class Bootstrap {
	
	private MBeanServer mbeanServer = null;
	
	public static void main(String[] args){
		
		if("true".equals(System.getProperty("jmxmonitor"))){
			new Bootstrap().action();
		}else{
			new Bootstrap().silent();
		}
	}
	
	private void silent(){
		Server server = new ServerImpl("svr_");
		server.boot();		
	}
	
	private void action(){
		Server server = new ServerImpl("svr_");
		server.boot();
		LogicalConnectionManager logicalConnectionManager = server.getLogicalConnectionManager();
		ObjectName serverImplMBeanName = null;
		ObjectName logicalConnectionManagerMBeanName = null;
		try {
			mbeanServer = ManagementFactory.getPlatformMBeanServer();
			serverImplMBeanName = new ObjectName("ServerImplAgent:type=Server");
			mbeanServer.registerMBean(server, serverImplMBeanName);
			
			logicalConnectionManagerMBeanName = new ObjectName("LogicalConnectionManagerAgent:type=Connection");
			mbeanServer.registerMBean(logicalConnectionManager, logicalConnectionManagerMBeanName);
		} catch (MalformedObjectNameException e) {
			e.printStackTrace();
		} catch (NullPointerException e) {
			e.printStackTrace();
		} catch (InstanceAlreadyExistsException e) {
			e.printStackTrace();
		} catch (MBeanRegistrationException e) {
			e.printStackTrace();
		} catch (NotCompliantMBeanException e) {
			e.printStackTrace();
		}
	}
}
