/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.webcontainer.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageOutputStream
extends OutputStream {
    private static final Logger logger = Logger.getLogger("servlet");
    private ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    public static final int BUFFER_SIZE = 8192;
    private ByteBuffer byteBuffer;
    private int bufferSize = 8192;

    public byte[] getWritten() {
        return this.byteArrayOutputStream.toByteArray();
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    private void initBuffer() {
        if (this.byteBuffer == null) {
            this.byteBuffer = ByteBuffer.allocate(this.bufferSize);
        }
    }

    @Override
    public void write(int b) {
        this.initBuffer();
        if (this.byteBuffer.remaining() < 1) {
            this.flush();
        }
        this.byteBuffer.put((byte)b);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) {
        this.initBuffer();
        int remainingSize = this.byteBuffer.remaining();
        if (remainingSize >= length) {
            this.byteBuffer.put(bytes, offset, length);
        } else {
            this.flush();
            if (length <= this.bufferSize) {
                this.byteBuffer.put(bytes, offset, length);
            } else {
                int quotient = length / this.bufferSize;
                for (int i = 0; i < quotient; ++i) {
                    this.byteBuffer.put(bytes, offset + this.bufferSize * i, this.bufferSize);
                    this.flush();
                }
                int remains = length % this.bufferSize;
                this.byteBuffer.put(bytes, offset + this.bufferSize * quotient, remains);
            }
        }
    }

    @Override
    public void flush() {
        this.initBuffer();
        this.byteBuffer.flip();
        if (this.byteBuffer.hasRemaining()) {
            byte[] dataBytes = new byte[this.byteBuffer.remaining()];
            this.byteBuffer.get(dataBytes);
            try {
                this.byteArrayOutputStream.write(dataBytes);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Fail to write to byteArrayOutputStream", e);
            }
        }
        this.byteBuffer.clear();
    }

    @Override
    public void close() {
        this.initBuffer();
        this.flush();
        this.byteBuffer.clear();
    }
}

