/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.webcontainer.servlet;

import com.endofhope.neurasthenia.webcontainer.servlet.HttpServletInputStreamImpl;
import com.endofhope.neurasthenia.webcontainer.servlet.PanzerRequest;
import com.endofhope.neurasthenia.webcontainer.servlet.ServletContextImpl;
import com.endofhope.neurasthenia.webcontainer.session.DummySession;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class HttpServletRequestImpl
implements HttpServletRequest {
    private static Logger logger = Logger.getLogger("servlet");
    private PanzerRequest panzerRequest;
    private HttpServletInputStreamImpl httpServletInputStreamImpl;
    private Map<String, List<String>> headerMap;
    private ServletContextImpl servletContextImpl;
    private String characterEncoding;
    private InputStreamReader inputStreamReader;
    private Map<String, Object> attributeMap;
    private boolean isGetMethod;
    private boolean isPostMethod;
    private boolean isUrlEncoded;
    private boolean isMultipart;
    private boolean isBodyParsed;
    Map<String, List<String>> parameterMap;
    private String servletPath;

    public HttpServletRequestImpl(PanzerRequest panzerRequest, ServletContextImpl servletContextImpl) {
        this.panzerRequest = panzerRequest;
        this.headerMap = panzerRequest.getHeaderMap();
        this.httpServletInputStreamImpl = new HttpServletInputStreamImpl(panzerRequest);
        this.servletContextImpl = servletContextImpl;
        this.attributeMap = new HashMap<String, Object>();
        this.parameterMap = new HashMap<String, List<String>>();
        this.characterEncoding = panzerRequest.getCharset();
        this.initBodyInfo();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.characterEncoding = env;
    }

    public int getContentLength() {
        return this.panzerRequest.getContentLength();
    }

    public String getContentType() {
        return this.panzerRequest.getContentType();
    }

    public String getLocalAddr() {
        return this.panzerRequest.getLocalAddr();
    }

    public int getLocalPort() {
        return this.panzerRequest.getLocalPort();
    }

    public String getLocalName() {
        return this.panzerRequest.getLocalName();
    }

    public String getRemoteAddr() {
        return this.panzerRequest.getRemoteAddr();
    }

    public int getRemotePort() {
        return this.panzerRequest.getRemotePort();
    }

    public String getRemoteHost() {
        return this.panzerRequest.getRemoteHost();
    }

    public String getProtocol() {
        return this.panzerRequest.getHttpVersion();
    }

    public String getScheme() {
        String scheme = null;
        String httpVersion = this.panzerRequest.getHttpVersion();
        if (httpVersion != null && httpVersion.startsWith("HTTP")) {
            scheme = "HTTP";
        }
        return scheme;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.httpServletInputStreamImpl;
    }

    public BufferedReader getReader() throws IOException {
        if (this.inputStreamReader == null) {
            this.inputStreamReader = new InputStreamReader((InputStream)((Object)this.httpServletInputStreamImpl));
        }
        return new BufferedReader(this.inputStreamReader);
    }

    public Object getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    public Enumeration getAttributeNames() {
        Set<String> keySet = this.attributeMap.keySet();
        Vector<String> attributeVector = new Vector<String>();
        attributeVector.addAll(keySet);
        return attributeVector.elements();
    }

    public void removeAttribute(String name) {
        this.attributeMap.remove(name);
    }

    public void setAttribute(String name, Object o) {
        this.attributeMap.put(name, o);
    }

    private void initBodyInfo() {
        String method = this.panzerRequest.getMethod();
        String contentType = this.getContentType();
        if ("GET".equalsIgnoreCase(method)) {
            this.isGetMethod = true;
        } else if ("POST".equalsIgnoreCase(method)) {
            this.isPostMethod = true;
            if ("application/x-www-form-urlencoded".equalsIgnoreCase(contentType)) {
                this.isUrlEncoded = true;
            } else if ("multipart/form-data".equalsIgnoreCase(contentType)) {
                this.isMultipart = true;
            }
        } else {
            throw new UnsupportedOperationException("Only GET/POST is supported");
        }
    }

    private void parseBody() {
        if (!this.isBodyParsed) {
            String charset = this.panzerRequest.getCharacterEncoding();
            if (this.isGetMethod) {
                String queryString = this.panzerRequest.getQueryString();
                if (queryString != null) {
                    StringTokenizer st = new StringTokenizer(queryString, "&");
                    while (st.hasMoreTokens()) {
                        String param = st.nextToken();
                        int indexOfEqual = param.indexOf("=");
                        if (indexOfEqual <= 0) continue;
                        String key = param.substring(0, indexOfEqual);
                        try {
                            key = URLDecoder.decode(key, charset);
                        }
                        catch (UnsupportedEncodingException e) {
                            logger.log(Level.WARNING, "Can't be possible", e);
                        }
                        List<String> valueList = this.parameterMap.get(key);
                        if (valueList == null) {
                            valueList = new ArrayList<String>();
                        }
                        String value = null;
                        if (indexOfEqual < param.length()) {
                            value = param.substring(indexOfEqual + 1);
                        }
                        try {
                            String decoded = URLDecoder.decode(value, charset);
                            valueList.add(decoded);
                        }
                        catch (UnsupportedEncodingException e) {
                            logger.log(Level.WARNING, "Can't be possible", e);
                        }
                        this.parameterMap.put(key, valueList);
                    }
                }
            } else if (this.isPostMethod) {
                if (this.isUrlEncoded) {
                    int contentLength = this.getContentLength();
                    byte[] bodyBytes = new byte[contentLength];
                    try {
                        this.httpServletInputStreamImpl.read(bodyBytes);
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "parse body error", e);
                    }
                    String bodyString = null;
                    try {
                        bodyString = new String(bodyBytes, charset);
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.log(Level.WARNING, "charset is not valid, try ISO-8859-1", e);
                        try {
                            bodyString = new String(bodyBytes, "ISO-8859-1");
                        }
                        catch (UnsupportedEncodingException e1) {
                            bodyString = new String(bodyBytes);
                        }
                    }
                    StringTokenizer st = new StringTokenizer(bodyString, "&");
                    while (st.hasMoreTokens()) {
                        List<String> valueList;
                        String pair = st.nextToken();
                        int indexOfEqual = pair.indexOf("=");
                        String parameterName = null;
                        String parameterValue = null;
                        if (indexOfEqual <= 0) continue;
                        parameterName = pair.substring(0, indexOfEqual);
                        try {
                            parameterName = URLDecoder.decode(parameterName, charset);
                        }
                        catch (UnsupportedEncodingException e) {
                            logger.log(Level.WARNING, "charset is not valid, try ISO-8859-1", e);
                            try {
                                parameterName = URLDecoder.decode(parameterName, "ISO-8859-1");
                            }
                            catch (UnsupportedEncodingException e1) {
                                logger.log(Level.WARNING, "charset is not valid", e);
                            }
                        }
                        if (indexOfEqual < pair.length()) {
                            parameterValue = pair.substring(indexOfEqual + 1);
                            try {
                                parameterValue = URLDecoder.decode(parameterValue, charset);
                            }
                            catch (UnsupportedEncodingException e) {
                                logger.log(Level.WARNING, "charset is not valid, try ISO-8859-1", e);
                                try {
                                    parameterValue = URLDecoder.decode(parameterValue, "ISO-8859-1");
                                }
                                catch (UnsupportedEncodingException e1) {
                                    logger.log(Level.WARNING, "charset is not valid", e);
                                }
                            }
                        }
                        if ((valueList = this.parameterMap.get(parameterName)) == null) {
                            valueList = new ArrayList<String>();
                        }
                        valueList.add(parameterValue);
                        this.parameterMap.put(parameterName, valueList);
                    }
                } else if (this.isMultipart) {
                    throw new UnsupportedOperationException("Multipart body is not implemented yet");
                }
            }
            this.isBodyParsed = true;
        }
    }

    public String getParameter(String name) {
        this.parseBody();
        String value = null;
        List<String> valueList = this.parameterMap.get(name);
        if (valueList != null && valueList.size() > 0) {
            value = valueList.get(0);
        }
        return value;
    }

    public Map getParameterMap() {
        this.parseBody();
        return this.parameterMap;
    }

    public Enumeration getParameterNames() {
        this.parseBody();
        Set<String> keySet = this.parameterMap.keySet();
        Vector<String> nameVector = new Vector<String>();
        nameVector.addAll(keySet);
        return nameVector.elements();
    }

    public String[] getParameterValues(String name) {
        this.parseBody();
        String[] valueArray = null;
        List<String> valueList = this.parameterMap.get(name);
        if (valueList != null && valueList.size() > 0) {
            valueArray = new String[valueList.size()];
            valueList.toArray(valueArray);
        }
        return valueArray;
    }

    public long getDateHeader(String name) {
        throw new UnsupportedOperationException();
    }

    public String getHeader(String name) {
        String value = null;
        List<String> valueList = this.headerMap.get(name);
        if (valueList != null && valueList.size() > 0) {
            value = valueList.get(0);
        }
        return value;
    }

    public Enumeration getHeaderNames() {
        Set<String> keySet = this.headerMap.keySet();
        Vector<String> nameVector = new Vector<String>();
        nameVector.addAll(keySet);
        return nameVector.elements();
    }

    public Enumeration getHeaders(String name) {
        Vector<String> valueVector = new Vector<String>();
        List<String> valueList = this.headerMap.get(name);
        if (valueList != null) {
            valueVector.addAll(valueList);
        }
        return valueVector.elements();
    }

    public int getIntHeader(String name) {
        int intValue = -1;
        List<String> valueList = this.headerMap.get(name);
        if (valueList != null && valueList.size() > 0) {
            String value = valueList.get(0).trim();
            try {
                intValue = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "value is not integer", e);
            }
        }
        return intValue;
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration getLocales() {
        return null;
    }

    public String getRealPath(String path) {
        return this.servletContextImpl.getRealContextPath() + File.separator + path;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    public boolean isSecure() {
        return false;
    }

    public String getAuthType() {
        return null;
    }

    public String getContextPath() {
        return this.servletContextImpl.getContextPath();
    }

    public Cookie[] getCookies() {
        return null;
    }

    public String getMethod() {
        return this.panzerRequest.getMethod();
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getQueryString() {
        return this.panzerRequest.getQueryString();
    }

    public String getRemoteUser() {
        return null;
    }

    public String getRequestURI() {
        return this.panzerRequest.getRequestUri();
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession(boolean create) {
        return new DummySession();
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isUserInRole(String role) {
        return false;
    }
}

