/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.scatter;

import com.endofhope.neurasthenia.Server;
import com.endofhope.neurasthenia.connection.PhysicalConnection;
import com.endofhope.neurasthenia.connection.PhysicalConnectionKey;
import com.endofhope.neurasthenia.message.Message;
import com.endofhope.neurasthenia.scatter.AbstractScatter;
import com.endofhope.neurasthenia.util.StringUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScatterImpl
extends AbstractScatter {
    private static final Logger logger = Logger.getLogger("scatter");

    public ScatterImpl(Server server, String id, String serviceType, BlockingQueue<Message> messageQueue) {
        super(server, id, serviceType, messageQueue);
    }

    @Override
    public Runnable createWorker(Message message) {
        ScatterWorker worker = new ScatterWorker(message);
        return worker;
    }

    class ScatterWorker
    implements Runnable {
        private Message message;

        private ScatterWorker(Message message) {
            this.message = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block28: {
                PhysicalConnectionKey physicalConnectionKey = this.message.getPhysicalConnectionKey();
                PhysicalConnection physicalConnection = ScatterImpl.this.server.getPhysicalConnectionManager().getConnection(physicalConnectionKey);
                if (physicalConnection == null) {
                    ScatterImpl.this.server.getLogicalConnectionManager().removeLogicalConnectionByPhysicalConnectionKey(physicalConnectionKey);
                    return;
                }
                SocketChannel socketChannel = physicalConnection.getSocketChannel();
                byte[] dataBytes = this.message.getData();
                logger.log(Level.FINER, "scatter scatter id:{0}", this.message.getMessageId());
                ByteBuffer byteBuffer = ByteBuffer.wrap(dataBytes);
                if (socketChannel != null && socketChannel.isOpen()) {
                    Selector writeSelector = ScatterImpl.this.server.getSelectorManager().getSelector();
                    try {
                        SocketChannel socketChannel2 = socketChannel;
                        synchronized (socketChannel2) {
                            if (writeSelector == null) {
                                logger.log(Level.WARNING, "write fail, cause acquire selector fail");
                            } else {
                                socketChannel.register(writeSelector, 4);
                                while (byteBuffer.hasRemaining()) {
                                    writeSelector.select(200L);
                                    Set<SelectionKey> selectionKeySet = writeSelector.selectedKeys();
                                    Iterator<SelectionKey> selectionKeyIter = selectionKeySet.iterator();
                                    while (selectionKeyIter.hasNext()) {
                                        int writtenSize;
                                        SelectionKey selectionKey = selectionKeyIter.next();
                                        selectionKeyIter.remove();
                                        if (!selectionKey.isValid()) {
                                            selectionKey.cancel();
                                            continue;
                                        }
                                        if (!selectionKey.isWritable() || (writtenSize = socketChannel.write(byteBuffer)) <= 0 || !"true".equals(System.getProperty("scatter.log"))) continue;
                                        int orgPosition = byteBuffer.position();
                                        byteBuffer.position(orgPosition - writtenSize);
                                        byte[] writtenBytes = new byte[writtenSize];
                                        byteBuffer.get(writtenBytes);
                                        logger.log(Level.FINEST, "scatter to {0} msg\n{1}", new Object[]{physicalConnectionKey, StringUtil.makeUTF8(writtenBytes)});
                                    }
                                }
                            }
                            break block28;
                        }
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Write error", e);
                        ScatterImpl.this.server.getLogicalConnectionManager().removeLogicalConnectionByPhysicalConnectionKey(physicalConnectionKey);
                        try {
                            writeSelector.close();
                            break block28;
                        }
                        catch (IOException e1) {
                            logger.log(Level.SEVERE, "writeSelector close fail", e1);
                            break block28;
                        }
                        finally {
                            writeSelector = null;
                        }
                    }
                    catch (Throwable t) {
                        logger.log(Level.WARNING, "Unknown error", t);
                        ScatterImpl.this.server.getLogicalConnectionManager().removeLogicalConnectionByPhysicalConnectionKey(physicalConnectionKey);
                        try {
                            writeSelector.close();
                            break block28;
                        }
                        catch (IOException e1) {
                            logger.log(Level.SEVERE, "writeSelector close fail", e1);
                            break block28;
                        }
                        finally {
                            writeSelector = null;
                        }
                    }
                    finally {
                        ScatterImpl.this.server.getSelectorManager().backSelector(writeSelector);
                        if (this.message.getMessageType() == 3 || this.message.getMessageType() == 5) {
                            ScatterImpl.this.server.getPhysicalConnectionManager().closePhysicalConnection(physicalConnectionKey);
                            ScatterImpl.this.server.getLogicalConnectionManager().removeLogicalConnectionByPhysicalConnectionKey(physicalConnectionKey);
                        }
                    }
                }
                logger.log(Level.WARNING, "closed connection");
            }
        }
    }
}

