/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.scatter;

import com.endofhope.neurasthenia.Server;
import com.endofhope.neurasthenia.message.Message;
import com.endofhope.neurasthenia.scatter.Scatter;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractScatter
implements Scatter {
    private static final Logger logger = Logger.getLogger("scatter");
    protected Server server;
    protected String id;
    protected String serviceType;
    protected BlockingQueue<Message> messageQueue;
    private volatile boolean running;
    private ScatterThread scatterThread;

    public AbstractScatter(Server server, String id, String serviceType, BlockingQueue<Message> messageQueue) {
        this.server = server;
        this.id = id;
        this.serviceType = serviceType;
        this.messageQueue = messageQueue;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getServiceType() {
        return this.serviceType;
    }

    @Override
    public BlockingQueue<Message> getMessageQueue() {
        return this.messageQueue;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void boot() {
        this.running = true;
        this.scatterThread = new ScatterThread();
        this.scatterThread.start();
        logger.log(Level.INFO, "scatter {0} {1} booted", new Object[]{this.id, this.serviceType});
    }

    @Override
    public void down() {
        this.running = false;
        this.scatterThread.interrupt();
        this.messageQueue.clear();
        logger.log(Level.INFO, "{0} {1} downed", new Object[]{this.serviceType, this.id});
    }

    @Override
    public abstract Runnable createWorker(Message var1);

    class ScatterThread
    extends Thread {
        ScatterThread() {
        }

        @Override
        public void run() {
            ThreadPoolExecutor threadPoolExecutor = AbstractScatter.this.server.getThreadPoolExecutor();
            while (AbstractScatter.this.running) {
                try {
                    Message message = AbstractScatter.this.messageQueue.take();
                    threadPoolExecutor.execute(AbstractScatter.this.createWorker(message));
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "scatter message queue interrupted", e);
                }
            }
        }
    }
}

