/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.gather;

import com.endofhope.neurasthenia.Constants;
import com.endofhope.neurasthenia.Server;
import com.endofhope.neurasthenia.connection.PhysicalConnectionManager;
import com.endofhope.neurasthenia.gather.AbstractGather;
import com.endofhope.neurasthenia.gather.StompBufferPack;
import com.endofhope.neurasthenia.message.Message;
import com.endofhope.neurasthenia.message.MessageImpl;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StompGather
extends AbstractGather {
    private static final Logger logger = Logger.getLogger("gather.stomp");

    public StompGather(Server server, String id, String serviceType, int port, int readSelectTimeout, int readBufferSize, BlockingQueue<Message> messageQueue) {
        super(server, id, serviceType, port, readSelectTimeout, readBufferSize, messageQueue);
    }

    @Override
    public int onReceive(SelectionKey selectionKey) throws IOException {
        this.readBuffer.clear();
        SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
        int readSize = socketChannel.read(this.readBuffer);
        if (readSize < 0) {
            selectionKey.cancel();
            return readSize;
        }
        this.readBuffer.flip();
        StompBufferPack stompBufferPack = (StompBufferPack)selectionKey.attachment();
        if (stompBufferPack == null) {
            stompBufferPack = new StompBufferPack();
            selectionKey.attach(stompBufferPack);
        }
        StompBufferPack.Status status = stompBufferPack.getStatus();
        while (this.readBuffer.remaining() > 0) {
            StompBufferPack neoStompBufferPack;
            byte oneByte = this.readBuffer.get();
            status = stompBufferPack.getStatus();
            if (status == StompBufferPack.Status.INIT) {
                if (Constants.isLf(oneByte)) continue;
                stompBufferPack.addByte(oneByte);
                stompBufferPack.setStatus(StompBufferPack.Status.METHOD);
            } else if (status == StompBufferPack.Status.METHOD) {
                byte[] packed;
                if (Constants.isLf(oneByte)) {
                    packed = stompBufferPack.getPacked();
                    stompBufferPack.setMethodBytes(packed);
                    stompBufferPack.setStatus(StompBufferPack.Status.HEADER);
                } else if (Constants.isTerminus(oneByte)) {
                    packed = stompBufferPack.getPacked();
                    stompBufferPack.setMethodBytes(packed);
                    stompBufferPack.setStatus(StompBufferPack.Status.TERMINUS);
                } else {
                    stompBufferPack.addByte(oneByte);
                }
            } else if (status == StompBufferPack.Status.HEADER) {
                if (Constants.isLf(oneByte)) {
                    stompBufferPack.addHeaderBytes(stompBufferPack.getPacked());
                    stompBufferPack.setStatus(StompBufferPack.Status.HEADER_LF);
                } else if (Constants.isTerminus(oneByte)) {
                    stompBufferPack.addHeaderBytes(stompBufferPack.getPacked());
                    stompBufferPack.setStatus(StompBufferPack.Status.TERMINUS);
                } else {
                    stompBufferPack.addByte(oneByte);
                }
            } else if (status == StompBufferPack.Status.HEADER_LF) {
                if (Constants.isLf(oneByte)) {
                    stompBufferPack.setStatus(StompBufferPack.Status.BODY);
                } else if (Constants.isTerminus(oneByte)) {
                    stompBufferPack.setStatus(StompBufferPack.Status.TERMINUS);
                } else {
                    stompBufferPack.addByte(oneByte);
                    stompBufferPack.setStatus(StompBufferPack.Status.HEADER);
                }
            } else if (status == StompBufferPack.Status.BODY) {
                stompBufferPack.increateReadBodySize();
                if (Constants.isTerminus(oneByte)) {
                    stompBufferPack.setBodyBytes(stompBufferPack.getPacked());
                    stompBufferPack.setStatus(StompBufferPack.Status.TERMINUS);
                } else {
                    stompBufferPack.addByte(oneByte);
                    if (stompBufferPack.isContentLengthFlag() && stompBufferPack.getContentLength() < stompBufferPack.getReadBodySize()) {
                        stompBufferPack.setBodyBytes(stompBufferPack.getPacked());
                        stompBufferPack.setStatus(StompBufferPack.Status.TERMINUS);
                    }
                }
            }
            if (stompBufferPack.getStatus() != StompBufferPack.Status.TERMINUS) continue;
            selectionKey.attach(null);
            MessageImpl message = new MessageImpl(this.server.getUnique(), 1, PhysicalConnectionManager.createPhysicalConnectionKey((SocketChannel)selectionKey.channel()), stompBufferPack, null);
            logger.log(Level.INFO, "stomp gather put msg {0}", message.getMessageId());
            logger.log(Level.FINEST, ((Object)message).toString());
            try {
                this.messageQueue.put(message);
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "gather fail to put message", e);
            }
            if (this.readBuffer.remaining() <= 0) continue;
            stompBufferPack = neoStompBufferPack = new StompBufferPack();
            selectionKey.attach(stompBufferPack);
        }
        return readSize;
    }
}

