/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.gather;

import com.endofhope.neurasthenia.gather.BufferPack;
import com.endofhope.neurasthenia.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class HttpBufferPack
extends BufferPack {
    private byte[] methodBytes;
    private List<byte[]> headerBytesList;
    private byte[] bodyBytes;
    private boolean contentLengthFlag;
    private int contentLength;
    private int readBodySize = 0;
    private Status status = Status.INIT;

    protected HttpBufferPack() {
        this.headerBytesList = new ArrayList<byte[]>();
    }

    protected void setMethodBytes(byte[] methodBytes) {
        this.methodBytes = methodBytes;
    }

    protected void addHeaderBytes(byte[] headerBytes) {
        String header;
        String lowerCaseHeader;
        this.headerBytesList.add(headerBytes);
        if (!this.contentLengthFlag && (lowerCaseHeader = (header = StringUtil.makeUTF8(headerBytes).trim()).toLowerCase()).startsWith("content-length")) {
            int indexOfColon = header.indexOf(":");
            this.contentLength = Integer.parseInt(header.substring(indexOfColon + 1).trim());
            this.contentLengthFlag = true;
        }
    }

    protected void setBodyBytes(byte[] bodyBytes) {
        this.bodyBytes = bodyBytes;
    }

    public byte[] getMethodBytes() {
        return this.methodBytes;
    }

    public List<byte[]> getHeaderBytesList() {
        return this.headerBytesList;
    }

    public byte[] getBodyBytes() {
        return this.bodyBytes;
    }

    public boolean isContentLengthFlag() {
        return this.contentLengthFlag;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    protected void increateReadBodySize() {
        ++this.readBodySize;
    }

    public int getReadBodySize() {
        return this.readBodySize;
    }

    protected void setStatus(Status status) {
        this.status = status;
    }

    protected Status getStatus() {
        return this.status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP-BUFFERPACK-DETAIL").append('\n');
        sb.append("method : ").append(StringUtil.makeUTF8(this.methodBytes)).append('\n');
        if (this.headerBytesList != null) {
            for (byte[] header : this.headerBytesList) {
                sb.append(StringUtil.makeUTF8(header)).append('\n');
            }
        } else {
            sb.append("no header").append('\n');
        }
        if (this.bodyBytes != null) {
            sb.append(StringUtil.makeUTF8(this.bodyBytes));
        } else {
            sb.append("no body");
        }
        sb.append('\n');
        return sb.toString();
    }

    public static enum Status {
        INIT,
        METHOD,
        METHOD_CR,
        METHOD_CRLF,
        HEADER,
        HEADER_CR,
        HEADER_CRLF,
        HEADER_CRLFCR,
        HEADER_CRLFCRLF,
        BODY,
        TERMINUS;

    }
}

