/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.connection;

import com.endofhope.neurasthenia.connection.PhysicalConnection;
import com.endofhope.neurasthenia.connection.PhysicalConnectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhysicalConnectionManager {
    private static final Logger logger = Logger.getLogger("physical.connection");
    private Map<PhysicalConnectionKey, PhysicalConnection> physicalConnectionMap = new ConcurrentHashMap<PhysicalConnectionKey, PhysicalConnection>();

    protected Map<PhysicalConnectionKey, PhysicalConnection> getPhysicalConnectionMap() {
        return this.physicalConnectionMap;
    }

    public PhysicalConnection register(SocketChannel socketChannel) {
        PhysicalConnection candidate = new PhysicalConnection(socketChannel);
        PhysicalConnectionKey candidateKey = candidate.getPhysicalConnectionKey();
        this.physicalConnectionMap.put(candidateKey, candidate);
        logger.log(Level.FINER, "register physical connection {0}", candidateKey);
        return candidate;
    }

    public PhysicalConnection getConnection(SocketChannel socketChannel) {
        PhysicalConnectionKey physicalConnectionKey = new PhysicalConnectionKey(socketChannel);
        PhysicalConnection physicalConnection = this.physicalConnectionMap.get(physicalConnectionKey);
        if (physicalConnection == null && socketChannel != null) {
            physicalConnection = this.register(socketChannel);
        }
        return physicalConnection;
    }

    public PhysicalConnection getConnection(PhysicalConnectionKey physicalConnectionKey) {
        return this.physicalConnectionMap.get(physicalConnectionKey);
    }

    private void deregister(PhysicalConnectionKey physicalConnectionKey) {
        this.physicalConnectionMap.remove(physicalConnectionKey);
        logger.log(Level.FINER, "deregister physical connection {0}", physicalConnectionKey);
    }

    public void closePhysicalConnection(PhysicalConnectionKey physicalConnectionKey) {
        PhysicalConnection physicalConnection = this.getConnection(physicalConnectionKey);
        if (physicalConnection != null) {
            physicalConnection.close();
            logger.log(Level.FINER, "close physical connection {0}", new Object[]{physicalConnectionKey});
        } else {
            logger.log(Level.FINEST, "already closed physical connection {0}", new Object[]{physicalConnectionKey});
        }
        this.deregister(physicalConnectionKey);
    }

    public static PhysicalConnectionKey createPhysicalConnectionKey(SocketChannel socketChannel) {
        return new PhysicalConnectionKey(socketChannel);
    }

    public void scavenge(long during) {
        long criteria = System.currentTimeMillis() - during * 1000L;
        ArrayList<PhysicalConnectionKey> oldList = new ArrayList<PhysicalConnectionKey>();
        PhysicalConnectionKey[] candidatePhysicalConnectionKeyArray = new PhysicalConnectionKey[this.physicalConnectionMap.size()];
        Set<PhysicalConnectionKey> physicalConnectionKeySet = this.physicalConnectionMap.keySet();
        physicalConnectionKeySet.toArray(candidatePhysicalConnectionKeyArray);
        for (PhysicalConnectionKey onePhysicalConnectionKey : candidatePhysicalConnectionKeyArray) {
            PhysicalConnection onePhysicalConnection = this.physicalConnectionMap.get(onePhysicalConnectionKey);
            if (onePhysicalConnection == null || onePhysicalConnection.getLastAccessTime() >= criteria) continue;
            oldList.add(onePhysicalConnectionKey);
        }
        for (PhysicalConnectionKey physicalConnectionKey : oldList) {
            PhysicalConnection physicalConnection = this.physicalConnectionMap.get(physicalConnectionKey);
            if (physicalConnection.getLastAccessTime() >= criteria) continue;
            this.closePhysicalConnection(physicalConnectionKey);
        }
    }
}

