/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.connection;

import com.endofhope.neurasthenia.connection.ConnectionEventHandler;
import com.endofhope.neurasthenia.connection.LogicalConnection;
import com.endofhope.neurasthenia.connection.LogicalConnectionManagerMBean;
import com.endofhope.neurasthenia.connection.PhysicalConnectionKey;
import com.endofhope.neurasthenia.connection.PhysicalConnectionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogicalConnectionManager
implements LogicalConnectionManagerMBean {
    private static final Logger logger = Logger.getLogger("logical.connection");
    private Map<String, List<LogicalConnection>> logicalConnectionMap;
    private PhysicalConnectionManager physicalConnectionManager;
    private Map<PhysicalConnectionKey, LogicalConnection> physicalKeyMap;

    public LogicalConnectionManager(PhysicalConnectionManager physicalConnectionManager) {
        this.physicalConnectionManager = physicalConnectionManager;
        this.logicalConnectionMap = new ConcurrentHashMap<String, List<LogicalConnection>>();
        this.physicalKeyMap = new ConcurrentHashMap<PhysicalConnectionKey, LogicalConnection>();
    }

    public void removeLogicalConnectionByPhysicalConnectionKey(PhysicalConnectionKey physicalConnectionKey) {
        LogicalConnection target = this.physicalKeyMap.remove(physicalConnectionKey);
        if (target != null) {
            this.removeConnection(target.getUserId(), target.getConnectionType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PhysicalConnectionKey> addLogicalConnection(String userId, int connectionType, PhysicalConnectionKey physicalConnectionKey, ConnectionEventHandler connectionEventHandler) {
        ArrayList<PhysicalConnectionKey> duplicatedPhysicalConnectionKeyList = new ArrayList<PhysicalConnectionKey>();
        List<LogicalConnection> logicalConnectionList = this.logicalConnectionMap.get(userId);
        if (logicalConnectionList == null) {
            logicalConnectionList = new ArrayList<LogicalConnection>();
        }
        ArrayList<LogicalConnection> cleanedLogicalConnectionList = new ArrayList<LogicalConnection>();
        List<LogicalConnection> list = logicalConnectionList;
        synchronized (list) {
            for (LogicalConnection logicalConnection : logicalConnectionList) {
                if (LogicalConnection.isSameCategory(logicalConnection.getConnectionType(), connectionType)) {
                    duplicatedPhysicalConnectionKeyList.add(logicalConnection.getPhysicalConnectionKey());
                    continue;
                }
                cleanedLogicalConnectionList.add(logicalConnection);
            }
            LogicalConnection logicalConnection = new LogicalConnection(userId, connectionType, physicalConnectionKey, connectionEventHandler);
            cleanedLogicalConnectionList.add(logicalConnection);
            this.logicalConnectionMap.put(userId, cleanedLogicalConnectionList);
            this.physicalKeyMap.put(physicalConnectionKey, logicalConnection);
        }
        logger.log(Level.FINER, "add logical connection {0}, {1}, {2}", new Object[]{userId, connectionType, physicalConnectionKey});
        return duplicatedPhysicalConnectionKeyList;
    }

    public List<LogicalConnection> getLogicalConnectionList(String userId) {
        return this.logicalConnectionMap.get(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogicalConnection getLogicalConnection(String userId, int connectionType) {
        LogicalConnection target = null;
        List<LogicalConnection> logicalConnectionList = this.logicalConnectionMap.get(userId);
        if (logicalConnectionList != null) {
            List<LogicalConnection> list = logicalConnectionList;
            synchronized (list) {
                for (LogicalConnection logicalConnection : logicalConnectionList) {
                    if (logicalConnection.getConnectionType() != connectionType) continue;
                    target = logicalConnection;
                    break;
                }
            }
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(String userId, int connectionType) {
        List<LogicalConnection> logicalConnectionList = this.logicalConnectionMap.get(userId);
        if (logicalConnectionList != null) {
            List<LogicalConnection> list = logicalConnectionList;
            synchronized (list) {
                int i;
                ArrayList<LogicalConnection> removeList = new ArrayList<LogicalConnection>();
                for (i = 0; i < logicalConnectionList.size(); ++i) {
                    LogicalConnection logicalConnection = logicalConnectionList.get(i);
                    if (logicalConnection.getConnectionType() != connectionType) continue;
                    removeList.add(logicalConnection);
                }
                for (i = 0; i < removeList.size(); ++i) {
                    LogicalConnection removeLogicalConnection = (LogicalConnection)removeList.get(i);
                    ConnectionEventHandler connectionEventHandler = removeLogicalConnection.getConnectionEventHandler();
                    if (connectionEventHandler != null) {
                        connectionEventHandler.onCloseEvent();
                    }
                    logicalConnectionList.remove(removeLogicalConnection);
                    PhysicalConnectionKey physicalConnectionKey = removeLogicalConnection.getPhysicalConnectionKey();
                    this.physicalKeyMap.remove(physicalConnectionKey);
                    this.physicalConnectionManager.closePhysicalConnection(physicalConnectionKey);
                    logger.log(Level.FINER, "remove logical connection {0}, {1}, {2}", new Object[]{userId, connectionType, physicalConnectionKey});
                }
            }
            if (logicalConnectionList.size() < 1) {
                this.logicalConnectionMap.remove(userId);
            }
        }
    }

    @Override
    public int getLogicalConnectionSize() {
        return this.logicalConnectionMap.size();
    }

    @Override
    public String[] getLogicalConnectionInfoArrayByUserId(String userId) {
        List<LogicalConnection> logicalConnectionList = this.logicalConnectionMap.get(userId);
        String[] logicalConnectionInfoArray = null;
        if (logicalConnectionList != null) {
            int size = logicalConnectionList.size();
            logicalConnectionInfoArray = new String[size];
            for (int i = 0; i < logicalConnectionList.size(); ++i) {
                LogicalConnection logicalConnection = logicalConnectionList.get(i);
                StringBuilder sb = new StringBuilder();
                sb.append(logicalConnection.getUserId()).append(":").append(logicalConnection.getConnectionType()).append(":").append(logicalConnection.getPhysicalConnectionKey().toString());
                logicalConnectionInfoArray[i] = sb.toString();
            }
        } else {
            logicalConnectionInfoArray = new String[]{};
        }
        return logicalConnectionInfoArray;
    }

    @Override
    public int getPhysicalConnectionSize() {
        return this.physicalConnectionManager.getPhysicalConnectionMap().size();
    }

    @Override
    public String[] getPhysicalConnectionKeyArray() {
        Set<PhysicalConnectionKey> keySet = this.physicalConnectionManager.getPhysicalConnectionMap().keySet();
        int size = keySet.size();
        String[] physicalConnectionKeyArray = new String[size];
        Iterator<PhysicalConnectionKey> keyIter = keySet.iterator();
        int i = 0;
        while (keyIter.hasNext()) {
            physicalConnectionKeyArray[i] = keyIter.next().toString();
            ++i;
        }
        return physicalConnectionKeyArray;
    }

    @Override
    public String[] getLogicalConnectionInfoArray() {
        Set<String> idSet = this.logicalConnectionMap.keySet();
        int size = idSet.size();
        String[] logicalConnectionInfoArray = new String[size];
        Iterator<String> idIter = idSet.iterator();
        int i = 0;
        while (idIter.hasNext()) {
            String id = idIter.next();
            StringBuilder sb = new StringBuilder();
            sb.append(id).append(" size [").append(this.logicalConnectionMap.get(id).size()).append("]");
            logicalConnectionInfoArray[i] = sb.toString();
            ++i;
        }
        return logicalConnectionInfoArray;
    }
}

