/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.webcontainer;

import com.endofhope.neurasthenia.LifeCycle;
import com.endofhope.neurasthenia.config.ConfigManager;
import com.endofhope.neurasthenia.webcontainer.WebContainer;
import com.endofhope.neurasthenia.webcontainer.servlet.ServletContextImpl;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class WebContextManager
implements LifeCycle {
    private Map<String, ServletContextImpl> contextPathMap;
    private String contextRootDirectory;
    private String commonClassPath;
    private boolean contextRootDirectoryValidFlag = false;
    private String encoding;
    private WebContainer webContainer;
    private volatile boolean running;

    public String getContextRootDirectory() {
        return this.contextRootDirectory;
    }

    public String getCommonClassPath() {
        return this.commonClassPath;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected WebContextManager(WebContainer webContainer, String contextRootDirectory, String commonClassPath, String encoding) {
        File contextRootDirectoryFile;
        this.webContainer = webContainer;
        if (contextRootDirectory == null) {
            contextRootDirectory = ConfigManager.getInstance().getHomeDir().concat(File.separator).concat("webctx");
        }
        if ((contextRootDirectoryFile = new File(contextRootDirectory)).exists()) {
            this.contextRootDirectory = contextRootDirectoryFile.getAbsolutePath();
            this.contextRootDirectoryValidFlag = true;
        }
        this.commonClassPath = commonClassPath;
        this.contextPathMap = new ConcurrentHashMap<String, ServletContextImpl>();
        this.encoding = encoding;
    }

    public void addWebContext(String directory, String contextName, String contextPath, int version) {
        File directoryFile = new File(directory);
        if (directoryFile.getAbsolutePath().equals(directoryFile.getPath())) {
            directory = directoryFile.getAbsolutePath();
        } else if (this.contextRootDirectoryValidFlag) {
            directory = this.contextRootDirectory + File.separator + directory;
        } else {
            throw new IllegalArgumentException("directory is not valid");
        }
        ServletContextImpl sci = new ServletContextImpl(this, directory, contextName, contextPath, version);
        sci.boot();
        this.contextPathMap.put(contextPath, sci);
    }

    public ServletContextImpl getServletContext(String contextPath) {
        return this.contextPathMap.get(contextPath);
    }

    @Override
    public void boot() {
        this.running = true;
    }

    @Override
    public void down() {
        Set<String> keySet = this.contextPathMap.keySet();
        for (String key : keySet) {
            ServletContextImpl sci = this.contextPathMap.get(key);
            sci.down();
        }
        this.running = false;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public WebContainer getWebContainer() {
        return this.webContainer;
    }
}

