/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.handler;

import com.endofhope.neurasthenia.Server;
import com.endofhope.neurasthenia.comet.TopicManager;
import com.endofhope.neurasthenia.config.ConfigManager;
import com.endofhope.neurasthenia.connection.PhysicalConnection;
import com.endofhope.neurasthenia.connection.PhysicalConnectionKey;
import com.endofhope.neurasthenia.gather.HttpBufferPack;
import com.endofhope.neurasthenia.message.Message;
import com.endofhope.neurasthenia.util.StringUtil;
import com.endofhope.neurasthenia.webcontainer.WebContextManager;
import com.endofhope.neurasthenia.webcontainer.servlet.HttpServletRequestImpl;
import com.endofhope.neurasthenia.webcontainer.servlet.HttpServletResponseImpl;
import com.endofhope.neurasthenia.webcontainer.servlet.PanzerRequest;
import com.endofhope.neurasthenia.webcontainer.servlet.PanzerResponse;
import com.endofhope.neurasthenia.webcontainer.servlet.ServletContextImpl;
import com.endofhope.neurasthenia.webcontainer.servlet.ServletManager;
import com.endofhope.neurasthenia.webcontainer.servlet.SystemSender;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class HttpWorker
implements Runnable {
    private static final Logger logger = Logger.getLogger("http.worker");
    private Message message;
    private Server server;

    protected HttpWorker(Message message, Server server) {
        this.message = message;
        this.server = server;
    }

    @Override
    public void run() {
        logger.log(Level.FINER, "http worker work {0}", this.message.getMessageId());
        this.processHttp(this.message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHttp(Message inMessage) {
        File[] children;
        HttpBufferPack httpBufferPack = (HttpBufferPack)inMessage.getBufferPack();
        PanzerRequest panzerRequest = new PanzerRequest();
        PanzerResponse panzerResponse = new PanzerResponse();
        try {
            this.setupPanzerRequest(httpBufferPack, panzerRequest);
            this.setupPanzerResponse(panzerRequest, panzerResponse);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "setup panzer", t);
            t.printStackTrace();
        }
        HttpServletResponseImpl httpServletResponseImpl = new HttpServletResponseImpl(panzerResponse, this.server.getMessageQueue("scatter_queue"), inMessage);
        WebContextManager webContextManager = this.server.getWebContainer().getWebContextManager();
        ServletContextImpl servletContextImpl = webContextManager.getServletContext(panzerRequest.getContextPath());
        if (servletContextImpl == null) {
            SystemSender.sendError(httpServletResponseImpl, 404, "Not found");
            return;
        }
        TopicManager topicManager = (TopicManager)servletContextImpl.getAttribute("__TOPIC_MANAGER");
        if (topicManager == null) {
            topicManager = this.server.getWebContainer().getTopicManager();
            servletContextImpl.setAttribute("__TOPIC_MANAGER", topicManager);
        }
        HttpServletRequestImpl httpServletRequestImpl = new HttpServletRequestImpl(panzerRequest, servletContextImpl);
        httpServletRequestImpl.setAttribute("__TOPIC_PHYSICAL_CONNECTION_KEY", this.message.getPhysicalConnectionKey());
        ServletManager servletManager = servletContextImpl.getServletManager();
        String servletName = panzerRequest.getServletName();
        if ("".equals(servletName) && (children = new File(servletContextImpl.getRealPath("")).listFiles()) != null) {
            List<String> representFileList = ConfigManager.getInstance().getWebContainerInfo().getRepresentFileList();
            for (File oneFile : children) {
                String oneFileName;
                if (!oneFile.isFile() || !representFileList.contains(oneFileName = oneFile.getName())) continue;
                panzerRequest.setRequestUri("/" + oneFileName);
                break;
            }
        }
        String servletPath = "/" + servletName;
        httpServletRequestImpl.setServletPath(servletPath);
        Servlet targetServlet = servletManager.getServlet(servletPath);
        if (targetServlet == null) {
            try {
                httpServletResponseImpl.sendError(404, "servlet name [" + servletName + "] is not found");
                return;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            targetServlet.service((ServletRequest)httpServletRequestImpl, (ServletResponse)httpServletResponseImpl);
        }
        catch (ServletException e) {
            logger.log(Level.WARNING, "servlet exception error", e);
            try {
                httpServletResponseImpl.getWriter().write(StringUtil.getPrettyErrorHead(e.getMessage()));
                e.printStackTrace(httpServletResponseImpl.getWriter());
                httpServletResponseImpl.getWriter().write(StringUtil.getPrettyErrorTail());
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "servlet io error", e);
            try {
                httpServletResponseImpl.getWriter().write(StringUtil.getPrettyErrorHead(e.getMessage()));
                e.printStackTrace(httpServletResponseImpl.getWriter());
                httpServletResponseImpl.getWriter().write(StringUtil.getPrettyErrorTail());
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "servlet error", t);
            try {
                httpServletResponseImpl.getWriter().write(StringUtil.getPrettyErrorHead(t.getMessage()));
                t.printStackTrace(httpServletResponseImpl.getWriter());
                httpServletResponseImpl.getWriter().write(StringUtil.getPrettyErrorTail());
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        finally {
            try {
                httpServletResponseImpl.postService();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "postService io error", e);
            }
        }
    }

    private void setupPanzerRequest(HttpBufferPack httpBufferPack, PanzerRequest panzerRequest) throws Throwable {
        List<byte[]> headerBytesList = httpBufferPack.getHeaderBytesList();
        String requestLine = new String(httpBufferPack.getMethodBytes());
        int indexOfBlank = requestLine.indexOf(" ");
        String method = requestLine.substring(0, indexOfBlank);
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        for (byte[] headerBytes : headerBytesList) {
            String oneHeaderLine = new String(headerBytes);
            int colonIndex = oneHeaderLine.indexOf(":");
            String head = oneHeaderLine.substring(0, colonIndex).trim();
            String lowerCaseHead = head.toLowerCase();
            String tail = oneHeaderLine.substring(colonIndex + 1).trim();
            StringTokenizer headerST = new StringTokenizer(tail, ";");
            ArrayList<String> valueList = (ArrayList<String>)headerMap.get(lowerCaseHead);
            if (valueList == null) {
                valueList = new ArrayList<String>();
            }
            while (headerST.hasMoreTokens()) {
                valueList.add(headerST.nextToken().trim());
            }
            headerMap.put(lowerCaseHead, valueList);
        }
        List contentLengthList = (List)headerMap.get("content-length");
        if (contentLengthList != null && contentLengthList.size() > 0) {
            try {
                panzerRequest.setContentLength(Integer.parseInt(((String)contentLengthList.get(0)).trim()));
            }
            catch (NumberFormatException e) {
                panzerRequest.setContentLength(0);
            }
        } else {
            panzerRequest.setContentLength(0);
        }
        panzerRequest.setHeaderMap(headerMap);
        int indexOfFirstBlank = requestLine.indexOf(" ");
        int indexOfSecondBlank = requestLine.indexOf(" ", indexOfFirstBlank + 1);
        String requestUri = requestLine.substring(indexOfFirstBlank + 1, indexOfSecondBlank);
        panzerRequest.setMethod(method);
        panzerRequest.setRequestUri(requestUri);
        String httpVersion = requestLine.substring(indexOfSecondBlank + 1);
        panzerRequest.setHttpVersion(httpVersion);
        String contextPath = "/";
        int contextPathLength = 0;
        int indexOfSecondSlash = requestUri.indexOf("/", 1);
        if (indexOfSecondSlash > 0) {
            contextPath = requestUri.substring(0, indexOfSecondSlash);
            contextPathLength = contextPath.length();
        }
        panzerRequest.setContextPath(contextPath);
        String queryString = null;
        String servletName = null;
        int indexOfQuestionMark = requestUri.indexOf("?");
        if (indexOfQuestionMark > 0) {
            servletName = requestUri.substring(contextPathLength + 1, indexOfQuestionMark);
            queryString = requestUri.substring(indexOfQuestionMark + 1);
        } else {
            servletName = requestUri.substring(contextPathLength + 1);
        }
        panzerRequest.setServletName(servletName);
        panzerRequest.setQueryString(queryString);
        String contentType = null;
        String charset = null;
        List contentTypeList = (List)headerMap.get("content-type");
        if (contentTypeList != null && contentTypeList.size() > 0) {
            contentType = ((String)contentTypeList.get(0)).trim();
            Iterator contextTypeIter = contentTypeList.iterator();
            contextTypeIter.next();
            while (contextTypeIter.hasNext()) {
                String charsetCandidate = (String)contextTypeIter.next();
                int indexOfCharsetEqual = charsetCandidate.indexOf("charset=");
                if (indexOfCharsetEqual <= 0) continue;
                charset = charsetCandidate.substring(indexOfCharsetEqual + 8).trim();
            }
        }
        panzerRequest.setContentType(contentType);
        panzerRequest.setCharset(charset);
        panzerRequest.setBlockingMode(false);
        panzerRequest.setBodyBytes(httpBufferPack.getBodyBytes());
        panzerRequest.setContentLength(httpBufferPack.getContentLength());
        PhysicalConnectionKey physicalConnectionKey = this.message.getPhysicalConnectionKey();
        PhysicalConnection physicalConnection = this.server.getPhysicalConnectionManager().getConnection(physicalConnectionKey);
        if (physicalConnection == null) {
            this.server.getLogicalConnectionManager().removeLogicalConnectionByPhysicalConnectionKey(physicalConnectionKey);
            return;
        }
        SocketChannel socketChannel = physicalConnection.getSocketChannel();
        Socket socket = socketChannel.socket();
        InetAddress localAddress = socket.getLocalAddress();
        String localAddr = localAddress.getHostAddress();
        int localPort = socket.getLocalPort();
        String localName = localAddress.getHostName();
        panzerRequest.setLocalAddr(localAddr);
        panzerRequest.setLocalPort(localPort);
        panzerRequest.setLocalName(localName);
        InetAddress remoteAddress = socket.getInetAddress();
        String remoteAddr = remoteAddress.getHostAddress();
        int remotePort = socket.getPort();
        String remoteHost = remoteAddress.getHostAddress();
        panzerRequest.setRemoteAddr(remoteAddr);
        panzerRequest.setRemotePort(remotePort);
        panzerRequest.setRemoteHost(remoteHost);
    }

    private void setupPanzerResponse(PanzerRequest panzerRequest, PanzerResponse panzerResponse) throws Throwable {
        List<String> acceptCharsetList;
        List<String> transferCodingList;
        Map<String, List<String>> headerMap = panzerRequest.getHeaderMap();
        List<String> connectionList = headerMap.get("connection");
        if (connectionList != null && connectionList.size() > 0) {
            String connectionString = connectionList.get(0);
            if ("keep-alive".equalsIgnoreCase(connectionString)) {
                panzerResponse.setAllowKeepAlive(true);
            } else if ("close".equalsIgnoreCase(connectionString)) {
                panzerResponse.setAllowKeepAlive(false);
            }
        }
        if ((transferCodingList = headerMap.get("transfer-coding")) != null && transferCodingList.size() > 0) {
            String transferCodingString = transferCodingList.get(0);
            panzerResponse.setTransferCoding(transferCodingString);
        }
        if ((acceptCharsetList = headerMap.get("accept-charset")) != null && acceptCharsetList.size() > 0) {
            String acceptCharset = acceptCharsetList.get(0);
            int indexOfPause = acceptCharset.indexOf(",");
            if (indexOfPause > 0) {
                acceptCharset = acceptCharset.substring(0, indexOfPause).trim();
            }
            panzerResponse.setAcceptCharset(acceptCharset);
            panzerRequest.setAcceptCharset(acceptCharset);
        }
        String encoding = this.server.getWebContainer().getWebContextManager().getEncoding();
        panzerRequest.setEncoding(encoding);
        panzerResponse.setEncoding(encoding);
        panzerResponse.setHttpVersion(11);
    }
}

