/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.gather;

import com.endofhope.neurasthenia.Server;
import com.endofhope.neurasthenia.connection.PhysicalConnectionManager;
import com.endofhope.neurasthenia.gather.AbstractGather;
import com.endofhope.neurasthenia.gather.BufferPack;
import com.endofhope.neurasthenia.gather.HttpBufferPack;
import com.endofhope.neurasthenia.message.Message;
import com.endofhope.neurasthenia.message.MessageImpl;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EchoGather
extends AbstractGather {
    private static final Logger logger = Logger.getLogger("gather");

    public EchoGather(Server server, String id, String serviceType, int port, int readSelectTimeout, int readBufferSize, BlockingQueue<Message> messageQueue) {
        super(server, id, serviceType, port, readSelectTimeout, readBufferSize, messageQueue);
    }

    @Override
    public int onReceive(SelectionKey selectionKey) throws IOException {
        this.readBuffer.clear();
        SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
        int readSize = socketChannel.read(this.readBuffer);
        if (readSize < 0) {
            selectionKey.cancel();
            return readSize;
        }
        this.readBuffer.flip();
        BufferPack bufferPack = (BufferPack)selectionKey.attachment();
        if (bufferPack == null) {
            bufferPack = new HttpBufferPack();
            selectionKey.attach(bufferPack);
        }
        while (this.readBuffer.remaining() > 0) {
            byte oneByte = this.readBuffer.get();
            if (oneByte == 10) {
                selectionKey.attach(null);
                MessageImpl message = new MessageImpl(this.server.getUnique(), 7, PhysicalConnectionManager.createPhysicalConnectionKey((SocketChannel)selectionKey.channel()), bufferPack, bufferPack.getPacked());
                try {
                    this.messageQueue.put(message);
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "gather fail to put message", e);
                }
                if (this.readBuffer.remaining() <= 0) continue;
                HttpBufferPack neoBufferPack = new HttpBufferPack();
                bufferPack = neoBufferPack;
                selectionKey.attach(bufferPack);
                continue;
            }
            bufferPack.addByte(oneByte);
        }
        return readSize;
    }
}

