/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.gather;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class BufferPack {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    protected int bufferSize = 8192;
    protected List<ByteBuffer> appendedList = new ArrayList<ByteBuffer>();
    protected ByteBuffer currentBuffer = ByteBuffer.allocate(this.bufferSize);

    public void addBytes(byte[] bytes) {
        int remains = this.currentBuffer.remaining();
        if (remains > bytes.length) {
            this.currentBuffer.put(bytes);
        } else {
            this.currentBuffer.flip();
            int tmpSize = this.currentBuffer.remaining();
            byte[] tmpBytes = new byte[tmpSize];
            this.currentBuffer.get(tmpBytes);
            this.appendedList.add(ByteBuffer.wrap(tmpBytes));
            this.appendedList.add(ByteBuffer.wrap(bytes));
            this.currentBuffer.clear();
        }
    }

    public void addByte(byte oneByte) {
        int remains = this.currentBuffer.remaining();
        if (remains > 1) {
            this.currentBuffer.put(oneByte);
        } else if (remains == 1) {
            this.currentBuffer.put(oneByte);
            this.currentBuffer.flip();
            int tmpSize = this.currentBuffer.remaining();
            byte[] tmpBytes = new byte[tmpSize];
            this.currentBuffer.get(tmpBytes);
            this.appendedList.add(ByteBuffer.wrap(tmpBytes));
            this.currentBuffer.clear();
        } else {
            new IllegalStateException("BufferPack.addByte overrun buffer").printStackTrace();
        }
    }

    protected void clear() {
        for (ByteBuffer byteBuffer : this.appendedList) {
            byteBuffer.clear();
        }
        this.appendedList.clear();
        this.currentBuffer.clear();
    }

    public byte[] getPacked() {
        this.currentBuffer.flip();
        int tmpSize = this.currentBuffer.remaining();
        byte[] tmpBytes = new byte[tmpSize];
        this.currentBuffer.get(tmpBytes);
        this.appendedList.add(ByteBuffer.wrap(tmpBytes));
        this.currentBuffer.clear();
        int size = 0;
        for (ByteBuffer appended : this.appendedList) {
            size += appended.remaining();
        }
        byte[] packedBytes = new byte[size];
        int index = 0;
        for (ByteBuffer appended : this.appendedList) {
            int appendedRemaining = appended.remaining();
            appended.get(packedBytes, index, appendedRemaining);
            index += appendedRemaining;
        }
        this.clear();
        return packedBytes;
    }
}

