/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.bayeux;

import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class BayeuxMessage {
    private static Logger logger = Logger.getLogger("bayeux");
    public static final int HANDSHAKE_REQ = 1;
    public static final int HANDSHAKE_RESP = 2;
    public static final int CONNECT_REQ = 3;
    public static final int CONNECT_RESP = 4;
    public static final int DISCONNECT_REQ = 5;
    public static final int DISCONNECT_RESP = 6;
    public static final int SUBSCRIBE_REQ = 7;
    public static final int SUBSCRIBE_RESP = 8;
    public static final int UNSUBSCRIBE_REQ = 9;
    public static final int UNSUBSCRIBE_RESP = 10;
    public static final int PUBLISH_REQ = 11;
    public static final int PUBLISH_RESP = 12;
    public static final int DELIVER_EVENT = 13;
    private int type;
    private String channel;
    private String version;
    private List<String> supportedConnectionTypesList;
    private String clientId;
    private String successful;
    private String error;
    private String connectionType;
    private String subscription;
    private String data;

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setSupportedConnectionTypesList(List<String> supportedConnectionTypesList) {
        this.supportedConnectionTypesList = supportedConnectionTypesList;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setSuccessful(String successful) {
        this.successful = successful;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    public void setData(String data) {
        this.data = data;
    }

    public BayeuxMessage(int type) {
        this.type = type;
    }

    public BayeuxMessage(String jsonMessage) throws JSONException {
        JSONTokener jsont = new JSONTokener(jsonMessage);
        JSONArray jsona = new JSONArray(jsont);
        JSONObject jsono = jsona.getJSONObject(0);
        this.channel = jsono.getString("channel");
        if (this.channel != null && this.channel.startsWith("/meta/")) {
            if ("/meta/handshake".equals(this.channel)) {
                this.type = 1;
                this.version = jsono.getString("version");
                JSONArray jsonaSupportedConnectionTypes = jsono.getJSONArray("supportedConnectionTypes");
                this.supportedConnectionTypesList = new ArrayList<String>();
                for (int i = 0; i < jsonaSupportedConnectionTypes.length(); ++i) {
                    this.supportedConnectionTypesList.add(jsonaSupportedConnectionTypes.getString(i));
                }
            } else if ("/meta/connect".equals(this.channel)) {
                this.type = 3;
                this.clientId = jsono.getString("clientId");
                this.connectionType = jsono.getString("connectionType");
            } else if ("/meta/disconnect".equals(this.channel)) {
                this.type = 5;
                this.clientId = jsono.getString("clientId");
            } else if ("/meta/subscribe".equals(this.channel)) {
                this.type = 7;
                this.clientId = jsono.getString("clientId");
                this.subscription = jsono.getString("subscription");
            } else if ("/meta/unsubscribe".equals(this.channel)) {
                this.type = 9;
                this.clientId = jsono.getString("clientId");
                this.subscription = jsono.getString("subscription");
            }
        } else {
            this.type = 11;
            this.data = jsono.getString("data");
        }
    }

    private JSONObject convertHandshakeReq() throws JSONException {
        JSONObject jsono = new JSONObject();
        jsono.put("channel", (Object)this.channel);
        jsono.put("version", (Object)this.version);
        jsono.put("supportedConnectionTypes", this.supportedConnectionTypesList);
        return jsono;
    }

    private JSONObject convertHandshakeResp() throws JSONException {
        JSONObject jsono = new JSONObject();
        jsono.put("channel", (Object)this.channel);
        jsono.put("version", (Object)this.version);
        jsono.put("supportedConnectionTypes", this.supportedConnectionTypesList);
        jsono.put("clientId", (Object)this.clientId);
        jsono.put("successful", (Object)this.successful);
        jsono.put("error", (Object)this.error);
        return jsono;
    }

    private JSONObject convertConnectReq() throws JSONException {
        JSONObject jsono = new JSONObject();
        jsono.put("channel", (Object)this.channel);
        jsono.put("clientId", (Object)this.clientId);
        jsono.put("connectionType", (Object)this.connectionType);
        return jsono;
    }

    private JSONObject convertConnectResp() throws JSONException {
        JSONObject jsono = new JSONObject();
        jsono.put("channel", (Object)this.channel);
        jsono.put("successful", (Object)this.successful);
        jsono.put("clientId", (Object)this.clientId);
        return jsono;
    }

    private JSONObject convertDisconnectReq() throws JSONException {
        JSONObject jsono = new JSONObject();
        jsono.put("channel", (Object)this.channel);
        jsono.put("clientId", (Object)this.clientId);
        return jsono;
    }

    private JSONObject convertDisconnectResp() throws JSONException {
        JSONObject jsono = new JSONObject();
        jsono.put("channel", (Object)this.channel);
        jsono.put("clientId", (Object)this.clientId);
        jsono.put("successful", (Object)this.successful);
        return jsono;
    }

    private JSONObject convertSubscribeReq() throws JSONException {
        JSONObject jsono = new JSONObject();
        jsono.put("channel", (Object)this.channel);
        jsono.put("clientId", (Object)this.clientId);
        jsono.put("subscription", (Object)this.subscription);
        return jsono;
    }

    private JSONObject convertSubscribeResp() throws JSONException {
        JSONObject jsono = new JSONObject();
        jsono.put("channel", (Object)this.channel);
        jsono.put("successful", (Object)this.successful);
        jsono.put("clientId", (Object)this.clientId);
        jsono.put("subscription", (Object)this.subscription);
        jsono.put("error", (Object)this.error);
        return jsono;
    }

    private JSONObject convertUnsubscribeReq() throws JSONException {
        JSONObject jsono = new JSONObject();
        jsono.put("channel", (Object)this.channel);
        jsono.put("clientId", (Object)this.clientId);
        jsono.put("subscription", (Object)this.subscription);
        return jsono;
    }

    private JSONObject convertUnsubscribeResp() throws JSONException {
        JSONObject jsono = new JSONObject();
        jsono.put("channel", (Object)this.channel);
        jsono.put("successful", (Object)this.successful);
        jsono.put("clientId", (Object)this.clientId);
        jsono.put("subscription", (Object)this.subscription);
        jsono.put("error", (Object)this.error);
        return jsono;
    }

    private JSONObject convertPublishReq() throws JSONException {
        JSONObject jsono = new JSONObject();
        jsono.put("channel", (Object)this.channel);
        jsono.put("data", (Object)this.data);
        return jsono;
    }

    private JSONObject convertPublishResp() throws JSONException {
        JSONObject jsono = new JSONObject();
        jsono.put("channel", (Object)this.channel);
        jsono.put("successful", (Object)this.successful);
        return jsono;
    }

    private JSONObject convertDeliverEvent() throws JSONException {
        JSONObject jsono = new JSONObject();
        jsono.put("channel", (Object)this.channel);
        jsono.put("data", (Object)this.data);
        return jsono;
    }

    public String toString() {
        JSONObject jsonObject;
        block17: {
            jsonObject = null;
            try {
                if (this.type == 1) {
                    jsonObject = this.convertHandshakeReq();
                    break block17;
                }
                if (this.type == 2) {
                    jsonObject = this.convertHandshakeResp();
                    break block17;
                }
                if (this.type == 3) {
                    jsonObject = this.convertConnectReq();
                    break block17;
                }
                if (this.type == 4) {
                    jsonObject = this.convertConnectResp();
                    break block17;
                }
                if (this.type == 5) {
                    jsonObject = this.convertDisconnectReq();
                    break block17;
                }
                if (this.type == 6) {
                    jsonObject = this.convertDisconnectResp();
                    break block17;
                }
                if (this.type == 7) {
                    jsonObject = this.convertSubscribeReq();
                    break block17;
                }
                if (this.type == 8) {
                    jsonObject = this.convertSubscribeResp();
                    break block17;
                }
                if (this.type == 9) {
                    jsonObject = this.convertUnsubscribeReq();
                    break block17;
                }
                if (this.type == 10) {
                    jsonObject = this.convertUnsubscribeResp();
                    break block17;
                }
                if (this.type == 11) {
                    jsonObject = this.convertPublishReq();
                    break block17;
                }
                if (this.type == 12) {
                    jsonObject = this.convertPublishResp();
                    break block17;
                }
                if (this.type == 13) {
                    jsonObject = this.convertDeliverEvent();
                    break block17;
                }
                throw new JSONException("Invalid BayeuxMessageType " + this.type);
            }
            catch (JSONException e) {
                logger.log(Level.WARNING, "Invalid json", e);
            }
        }
        JSONArray jsonArray = new JSONArray();
        jsonArray.put((Object)jsonObject);
        String result = null;
        try {
            result = jsonArray.toString(4);
        }
        catch (JSONException e) {
            logger.log(Level.WARNING, "Invalid json array", e);
        }
        return result;
    }

    private static void test1() throws JSONException, IOException {
        BayeuxMessage bayeuxMessage = new BayeuxMessage(BayeuxMessage.getString("test/handshake_req.txt"));
        System.out.println(bayeuxMessage.toString());
    }

    private static void test2() {
        BayeuxMessage bayeuxMessage = new BayeuxMessage(2);
        bayeuxMessage.setChannel("/meta/handshake");
        bayeuxMessage.setVersion("1.0");
        ArrayList<String> typesList = new ArrayList<String>();
        typesList.add("long-polling");
        typesList.add("callback-polling");
        bayeuxMessage.setSupportedConnectionTypesList(typesList);
        bayeuxMessage.setClientId("Un1q31d3nt1f13r");
        bayeuxMessage.setSuccessful("true");
        System.out.println(bayeuxMessage.toString());
    }

    private static void test3() throws JSONException, IOException {
        BayeuxMessage bayeuxMessage = new BayeuxMessage(BayeuxMessage.getString("test/connect_req.txt"));
        System.out.println(bayeuxMessage.toString());
    }

    private static void test4() throws JSONException, IOException {
        BayeuxMessage bayeuxMessage = new BayeuxMessage(4);
        bayeuxMessage.setChannel("/meta/connect");
        bayeuxMessage.setSuccessful("true");
        bayeuxMessage.setClientId("Un1q31d3nt1f13r");
        System.out.println(bayeuxMessage.toString());
    }

    private static void test5() throws JSONException, IOException {
        BayeuxMessage bayeuxMessage = new BayeuxMessage(BayeuxMessage.getString("test/disconnect_req.txt"));
        System.out.println(bayeuxMessage.toString());
    }

    private static void test6() throws JSONException, IOException {
        BayeuxMessage bayeuxMessage = new BayeuxMessage(6);
        bayeuxMessage.setChannel("/meta/disconnect");
        bayeuxMessage.setClientId("Un1q31d3nt1f13r");
        bayeuxMessage.setSuccessful("true");
        System.out.println(bayeuxMessage.toString());
    }

    private static void test7() throws JSONException, IOException {
        BayeuxMessage bayeuxMessage = new BayeuxMessage(BayeuxMessage.getString("test/subscribe_req.txt"));
        System.out.println(bayeuxMessage.toString());
    }

    private static void test8() throws JSONException, IOException {
        BayeuxMessage bayeuxMessage = new BayeuxMessage(8);
        bayeuxMessage.setChannel("/meta/subscribe");
        bayeuxMessage.setSuccessful("true");
        bayeuxMessage.setClientId("Un1q31d3nt1f13r");
        bayeuxMessage.setSubscription("/foo/**");
        bayeuxMessage.setError("403:/bar/baz:Permission Denied");
        System.out.println(bayeuxMessage.toString());
    }

    private static void test9() throws JSONException, IOException {
        BayeuxMessage bayeuxMessage = new BayeuxMessage(BayeuxMessage.getString("test/unsubscribe_req.txt"));
        System.out.println(bayeuxMessage.toString());
    }

    private static void test10() throws JSONException, IOException {
        BayeuxMessage bayeuxMessage = new BayeuxMessage(10);
        bayeuxMessage.setChannel("/meta/unsubscribe");
        bayeuxMessage.setSuccessful("true");
        bayeuxMessage.setClientId("Un1q31d3nt1f13r");
        bayeuxMessage.setSubscription("/foo/**");
        bayeuxMessage.setError(null);
        System.out.println(bayeuxMessage.toString());
    }

    private static void test11() throws JSONException, IOException {
        BayeuxMessage bayeuxMessage = new BayeuxMessage(BayeuxMessage.getString("test/publish_req.txt"));
        System.out.println(bayeuxMessage.toString());
    }

    private static void test12() throws JSONException, IOException {
        BayeuxMessage bayeuxMessage = new BayeuxMessage(12);
        bayeuxMessage.setChannel("/some/channel");
        bayeuxMessage.setSuccessful("true");
        System.out.println(bayeuxMessage.toString());
    }

    private static void test13() throws JSONException, IOException {
        BayeuxMessage bayeuxMessage = new BayeuxMessage(13);
        bayeuxMessage.setChannel("/some/channel");
        bayeuxMessage.setData("some application string or JSON encoded object");
        System.out.println(bayeuxMessage.toString());
    }

    public static void main(String[] args) throws JSONException, IOException {
        boolean flagF = false;
        if (flagF) {
            BayeuxMessage.test1();
        }
        if (flagF) {
            BayeuxMessage.test2();
        }
        if (flagF) {
            BayeuxMessage.test3();
        }
        if (flagF) {
            BayeuxMessage.test4();
        }
        if (flagF) {
            BayeuxMessage.test5();
        }
        if (flagF) {
            BayeuxMessage.test6();
        }
        if (flagF) {
            BayeuxMessage.test7();
        }
        if (flagF) {
            BayeuxMessage.test8();
        }
        if (flagF) {
            BayeuxMessage.test9();
        }
        if (flagF) {
            BayeuxMessage.test10();
        }
        if (flagF) {
            BayeuxMessage.test11();
        }
        if (flagF) {
            BayeuxMessage.test12();
        }
        if (flagF) {
            BayeuxMessage.test13();
        }
    }

    private static String getString(String location) throws IOException {
        StringBuilder sb = new StringBuilder();
        FileReader fr = new FileReader(location);
        int oneInt = -1;
        while (-1 != (oneInt = fr.read())) {
            sb.append((char)oneInt);
        }
        fr.close();
        return sb.toString();
    }
}

