/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia;

import java.io.IOException;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SelectorManager {
    private static final Logger logger = Logger.getLogger("selector");
    private ConcurrentLinkedQueue<Selector> selectorQueue;
    private int initQueueSize;

    protected SelectorManager(int initQueueSize) {
        this.initQueueSize = initQueueSize;
        ArrayList<Selector> backboneList = new ArrayList<Selector>();
        for (int i = 0; i < initQueueSize; ++i) {
            try {
                backboneList.add(Selector.open());
                continue;
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "selector initialize fail", e);
            }
        }
        this.selectorQueue = new ConcurrentLinkedQueue(backboneList);
    }

    public Selector getSelector() {
        Selector selector = this.selectorQueue.poll();
        if (selector == null) {
            logger.log(Level.SEVERE, "selector poll empty, current size {0}, increase size or check leak selector", this.initQueueSize);
        }
        return selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backSelector(Selector selector) {
        if (selector == null) {
            try {
                selector = Selector.open();
            }
            catch (IOException e) {
                try {
                    logger.log(Level.SEVERE, "selector creation fail", e);
                }
                catch (Throwable throwable) {
                    logger.log(Level.INFO, "selectorQueue.size {0} and add selector {1}", new Object[]{this.selectorQueue.size(), selector});
                    throw throwable;
                }
                logger.log(Level.INFO, "selectorQueue.size {0} and add selector {1}", new Object[]{this.selectorQueue.size(), selector});
            }
            logger.log(Level.INFO, "selectorQueue.size {0} and add selector {1}", new Object[]{this.selectorQueue.size(), selector});
        }
        if (selector != null) {
            this.selectorQueue.offer(selector);
        }
    }

    public int getInitQueueSize() {
        return this.initQueueSize;
    }

    public int getIdleQueueSize() {
        return this.selectorQueue.size();
    }
}

