unit uNemo;

interface

uses
  Windows, Classes, SysUtils, IniFiles;

const
  nbsWhite: char= '.';
  nbsBlack: char= '#';
  nbsGray:  char= 'O';
  nbsCross: char= 'X';

type
  TNemoBlockState = char;
  TNemoLine = array of TNemoBlockState;
  TNemoBoard = array of TNemoLine;

  TNemoDigitsType = array of integer;
  TNemoDigits = class
  private
    FDigits: TNemoDigitsType;
    FCount: Integer;
  protected
  public
    constructor Create(count: Integer); overload;
    constructor Create(str: String); overload;
    destructor Destroy; override;
    function Copy(Digits: TNemoDigits; lo, hi: Integer): TNemoDigits;
    function Sum: Integer;
  published
    property Item: TNemoDigitsType read FDigits;
    property Count: Integer read FCount;
  end;

  function MakeString(st: TNemoBlockState; size: Integer): String;
  procedure NemoMakeLine(List: TStringList; PreString: string; Digits: TNemoDigits; LineCount: Integer);
  function ProcessLine(List: TStringList; InitString: string): String;

type
  TNemoDigitsListType = array of TNemoDigits;
  TNemo = class
  private
    FCol, FRow: Integer;
    FDigitCol, FDigitRow: Integer; // Digits MaxCount
    FColDigits, FRowDigits: TNemoDigitsListType;
    FBoard: TNemoBoard;
  protected
  public
    constructor Create(Col, Row: Integer); overload;
    constructor Create(Ini: TIniFile); overload;
    destructor Destroy; override;
    procedure LoadDigits(ColDigitsString, RowDigitsString: TStringList);
    procedure ProcessCol(nIndex: Integer);
    procedure ProcessRow(nIndex: Integer);
    procedure ProcessAllCol;
    procedure ProcessAllRow;
    function GetScore(var nWhite: Integer; var nBlack: Integer): Integer;
  published
    property Col: Integer read FCol;
    property Row: Integer read FRow;
    property DCol: Integer read FDigitCol;
    property DRow: Integer read FDigitRow;
    property ColDigits: TNemoDigitsListType read FColDigits;
    property RowDigits: TNemoDigitsListType read FRowDigits;
    property Board: TNemoBoard read FBoard;
  end;


implementation

function MakeString(st: TNemoBlockState; size: Integer): String;
begin
  if size = 0 then
  begin
    Result := '';
    Exit;
  end;
  SetLength(Result, size);
  FillChar(Result[1], size, st);
end;

procedure NemoMakeLine(List: TStringList; PreString: string; Digits: TNemoDigits; LineCount: Integer);
var
  TempString: String;
  TempDigits: TNemoDigits;
begin
  if Digits.Count = 0 then
  begin
    List.Add(PreString+MakeString(nbsWhite, LineCount));
    Exit;
  end;
  TempString := MakeString(nbsBlack, Digits.Item[0]);
  if LineCount > Digits.Item[0] then
    TempString := TempString + MakeString(nbsWhite, 1);
  TempDigits := Digits.Copy(TempDigits, Low(Digits.Item) + 1, High(Digits.Item));
  NemoMakeLine(List, PreString+TempString, TempDigits, LineCount - (Digits.Item[0] + 1));
  TempDigits.Free;

  if LineCount - (Digits.Sum + Digits.Count - 1) >= 1 then
  begin
    NemoMakeLine(List, PreString+MakeString(nbsWhite, 1), Digits, LineCount-1);
  end;
end;

function ProcessLine(List: TStringList; InitString: string): String;
var
  i, j: Integer;
  LineCount: Integer;
  Line: String;
begin
  if List.Count = 0 then
    Exit;
  LineCount := Length(List[0]);
//  SetLength(Result, LineCount);
  if InitString = '' then
    InitString := MakeString(nbsGray, LineCount);
  //
  // InitString ǿ  ʴ Line List Ѵ.
  for i := List.Count-1 downto 0 do
  begin
    Line := List[i];
    for j := 1 to LineCount do
    begin
      if (InitString[j] in [ nbsWhite, nbsBlack ]) and (Line[j] <> InitString[j]) then
      begin
        List.Delete(i);
        break;
      end;
    end;
  end;

  if List.Count = 0 then
    //FillChar(Result, LineCount, nbsGray)
    Result := MakeString(nbsGray, LineCount)
  else
  begin
    Result := List[0];
    // List ߺǴ block ãƼ result .
    for i := 1 to LineCount do
    begin
      for j := List.Count-1 downto 1 do
      begin
        if (Result[i] in [nbsWhite, nbsBlack]) and (Result[i] <> List[j][i]) then
        begin
          Result[i] := nbsGray;
          break;
        end;
      end;
    end;
  end;
end;

{ TNemo }

constructor TNemo.Create(Col, Row: Integer);
var
  i, j: Integer;
begin
  FCol := Col;
  FRow := Row;
  FDigitCol := ((Col - 1) div 2) + 1;
  FDigitRow := ((Row - 1) div 2) + 1;
  SetLength(FColDigits, FCol);
  SetLength(FRowDigits, FRow);
  SetLength(FBoard, FRow);
  for i := FRow-1 downto 0 do
  begin
    SetLength(FBoard[i], FCol);
    for j := FCol-1 downto 0 do
      FBoard[i][j] := nbsGray;
  end;
end;

constructor TNemo.Create(Ini: TIniFile);
var
  Cols, Rows: TStringList;
  i: Integer;
begin
  Create(Ini.ReadInteger('Nemo', 'Col', 0), Ini.ReadInteger('Nemo', 'Row', 0));

  Cols := TStringList.Create;
  Rows := TStringList.Create;

  for i := 1 to FCol do
  begin
    Cols.Add(Ini.ReadString('Col', IntToStr(i), ''));
  end;

  for i := 1 to FRow do
  begin
    Rows.Add(Ini.ReadString('Row', IntToStr(i), ''));
  end;
  LoadDigits(Cols, Rows);

  Cols.Free;
  Rows.Free;
end;

destructor TNemo.Destroy;
var
  i: Integer;
begin
  for i := FCol-1 downto 0 do
    FColDigits[i].Free;
  for i := FRow-1 downto 0 do
    FRowDigits[i].Free;

  inherited;
end;

function TNemo.GetScore(var nWhite, nBlack: Integer): Integer;
var
  i, j: Integer;
begin
  nWhite := 0;
  nBlack := 0;
  for i := FCol-1 downto 0 do
    for j := FRow-1 downto 0 do
      if FBoard[j][i] = nbsWhite then
        Inc(nWhite)
      else if FBoard[j][i] = nbsBlack then
        Inc(nBlack);
  Result := nWhite + nBlack;
end;

procedure TNemo.LoadDigits(ColDigitsString, RowDigitsString: TStringList);
var
  i: Integer;
begin
  if (FCol <> ColDigitsString.Count) or (FRow <> RowDigitsString.Count) then
    Exit;
  for i := 0 to FCol-1 do
  begin
    FColDigits[i] := TNemoDigits.Create(ColDigitsString[i]);
  end;
  for i := 0 to FRow-1 do
  begin
    FRowDigits[i] := TNemoDigits.Create(RowDigitsString[i]);
  end;
end;


procedure TNemo.ProcessAllCol;
var
  i: Integer;
begin
  for i := 0 to FCol-1 do
    ProcessCol(i);
end;

procedure TNemo.ProcessAllRow;
var
  i: Integer;
begin
  for i := 0 to FRow-1 do
    ProcessRow(i);
end;


procedure TNemo.ProcessCol(nIndex: Integer);
var
  i: Integer;
  List: TStringList;
  InitString: String;
  ResultString: String;
begin
  List := TStringList.Create;
  NemoMakeLine(List, '', FColDigits[nIndex], FRow);
  InitString := '';
  for i := 0 to FRow-1 do
    InitString := InitString + FBoard[i][nIndex];
  ResultString := ProcessLine(List, InitString);
  for i := 0 to FRow-1 do
    FBoard[i][nIndex] := ResultString[i+1];
  List.Free;
end;

procedure TNemo.ProcessRow(nIndex: Integer);
var
  i: Integer;
  List: TStringList;
  InitString: String;
  ResultString: String;
begin
  List := TStringList.Create;
  NemoMakeLine(List, '', FRowDigits[nIndex], FCol);
  InitString := '';
  for i := 0 to FCol-1 do
    InitString := InitString + FBoard[nIndex][i];
  ResultString := ProcessLine(List, InitString);
  for i := 0 to FCol-1 do
    FBoard[nIndex][i] := ResultString[i+1];
  List.Free;
end;

{ TNemoDigits }

function TNemoDigits.Copy(Digits: TNemoDigits; lo, hi: Integer): TNemoDigits;
var
  i: Integer;
begin
  Result := TNemoDigits.Create(hi-lo+1);
  for i := Low(Result.Item) to High(Result.Item) do
    Result.Item[i] := FDigits[lo+i];
end;

constructor TNemoDigits.Create(count: Integer);
begin
  FCount := count;
  SetLength(FDigits, count);
end;

constructor TNemoDigits.Create(str: String);
var
  List: TStringList;
  i: Integer;
begin
  List := TStringList.Create;
  List.Delimiter := ' ';
  List.DelimitedText := str;
OutputDebugString(PChar(List.Text));
  Create(List.Count);
  for i := 0 to FCount - 1 do
  begin
    FDigits[i] := StrToInt(List[i]);
  end;

  List.Free;
end;

destructor TNemoDigits.Destroy;
begin

  inherited;
end;

function TNemoDigits.Sum: Integer;
var
  i: Integer;
begin
  Result := 0;
  for i := Low(FDigits) to High(FDigits) do
    Inc(Result, FDigits[i]);
end;

end.
